/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.deploy;

import org.apache.catalina.deploy.SecurityCollection;

public final class SecurityConstraint {
    private boolean allRoles = false;
    private boolean authConstraint = false;
    private String[] authRoles = new String[0];
    private SecurityCollection[] collections = new SecurityCollection[0];
    private String displayName = null;
    private String userConstraint = "NONE";

    public void addAuthRole(String authRole) {
        if (authRole == null) {
            return;
        }
        if ("*".equals(authRole)) {
            this.allRoles = true;
            return;
        }
        String[] results = new String[this.authRoles.length + 1];
        int i = 0;
        while (i < this.authRoles.length) {
            results[i] = this.authRoles[i];
            ++i;
        }
        results[this.authRoles.length] = authRole;
        this.authRoles = results;
        this.authConstraint = true;
    }

    public void addCollection(SecurityCollection collection) {
        if (collection == null) {
            return;
        }
        SecurityCollection[] results = new SecurityCollection[this.collections.length + 1];
        int i = 0;
        while (i < this.collections.length) {
            results[i] = this.collections[i];
            ++i;
        }
        results[this.collections.length] = collection;
        this.collections = results;
    }

    public boolean findAuthRole(String role) {
        if (role == null) {
            return false;
        }
        int i = 0;
        while (i < this.authRoles.length) {
            if (role.equals(this.authRoles[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String[] findAuthRoles() {
        return this.authRoles;
    }

    public SecurityCollection findCollection(String name) {
        if (name == null) {
            return null;
        }
        int i = 0;
        while (i < this.collections.length) {
            if (name.equals(this.collections[i].getName())) {
                return this.collections[i];
            }
            ++i;
        }
        return null;
    }

    public SecurityCollection[] findCollections() {
        return this.collections;
    }

    public boolean getAllRoles() {
        return this.allRoles;
    }

    public boolean getAuthConstraint() {
        return this.authConstraint;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getUserConstraint() {
        return this.userConstraint;
    }

    public boolean included(String uri, String method) {
        if (method == null) {
            return false;
        }
        int i = 0;
        while (i < this.collections.length) {
            if (this.collections[i].findMethod(method)) {
                String[] patterns = this.collections[i].findPatterns();
                int j = 0;
                while (j < patterns.length) {
                    if (this.matchPattern(uri, patterns[j])) {
                        return true;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return false;
    }

    private boolean matchPattern(String path, String pattern) {
        if (path == null || path.length() == 0) {
            path = "/";
        }
        if (pattern == null || pattern.length() == 0) {
            pattern = "/";
        }
        if (path.equals(pattern)) {
            return true;
        }
        if (pattern.startsWith("/") && pattern.endsWith("/*")) {
            if ((pattern = pattern.substring(0, pattern.length() - 2)).length() == 0) {
                return true;
            }
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            while (true) {
                if (pattern.equals(path)) {
                    return true;
                }
                int slash = path.lastIndexOf(47);
                if (slash <= 0) break;
                path = path.substring(0, slash);
            }
            return false;
        }
        if (pattern.startsWith("*.")) {
            int slash = path.lastIndexOf(47);
            int period = path.lastIndexOf(46);
            return slash >= 0 && period > slash && path.endsWith(pattern.substring(1));
        }
        return pattern.equals("/");
    }

    public void removeAuthRole(String authRole) {
        if (authRole == null) {
            return;
        }
        int n = -1;
        int i = 0;
        while (i < this.authRoles.length) {
            if (this.authRoles[i].equals(authRole)) {
                n = i;
                break;
            }
            ++i;
        }
        if (n >= 0) {
            int j = 0;
            String[] results = new String[this.authRoles.length - 1];
            int i2 = 0;
            while (i2 < this.authRoles.length) {
                if (i2 != n) {
                    results[j++] = this.authRoles[i2];
                }
                ++i2;
            }
            this.authRoles = results;
        }
    }

    public void removeCollection(SecurityCollection collection) {
        if (collection == null) {
            return;
        }
        int n = -1;
        int i = 0;
        while (i < this.collections.length) {
            if (this.collections[i].equals(collection)) {
                n = i;
                break;
            }
            ++i;
        }
        if (n >= 0) {
            int j = 0;
            SecurityCollection[] results = new SecurityCollection[this.collections.length - 1];
            int i2 = 0;
            while (i2 < this.collections.length) {
                if (i2 != n) {
                    results[j++] = this.collections[i2];
                }
                ++i2;
            }
            this.collections = results;
        }
    }

    public void setAuthConstraint(boolean authConstraint) {
        this.authConstraint = authConstraint;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setUserConstraint(String userConstraint) {
        if (userConstraint != null) {
            this.userConstraint = userConstraint;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("SecurityConstraint[");
        int i = 0;
        while (i < this.collections.length) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.collections[i].getName());
            ++i;
        }
        sb.append("]");
        return sb.toString();
    }
}

