/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.authenticator;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.util.Random;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.catalina.Authenticator;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.HttpRequest;
import org.apache.catalina.HttpResponse;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Logger;
import org.apache.catalina.Manager;
import org.apache.catalina.Pipeline;
import org.apache.catalina.Realm;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.Session;
import org.apache.catalina.Valve;
import org.apache.catalina.ValveContext;
import org.apache.catalina.authenticator.SingleSignOn;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.catalina.deploy.SecurityConstraint;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.util.RequestUtil;
import org.apache.catalina.util.StringManager;
import org.apache.catalina.valves.ValveBase;

public abstract class AuthenticatorBase
extends ValveBase
implements Authenticator,
Lifecycle {
    protected static final String DEFAULT_ALGORITHM = "MD5";
    protected static final int SESSION_ID_BYTES = 16;
    protected String algorithm = "MD5";
    protected boolean cache = true;
    protected Context context = null;
    protected int debug = 0;
    protected MessageDigest digest = null;
    protected String entropy = null;
    protected static final String info = "org.apache.catalina.authenticator.AuthenticatorBase/1.0";
    protected LifecycleSupport lifecycle = new LifecycleSupport(this);
    protected Random random = null;
    protected String randomClass = "java.security.SecureRandom";
    protected static final StringManager sm = StringManager.getManager("org.apache.catalina.authenticator");
    protected SingleSignOn sso = null;
    protected boolean started = false;

    protected boolean accessControl(HttpRequest request, HttpResponse response, SecurityConstraint constraint) throws IOException {
        Principal principal;
        if (constraint == null) {
            return true;
        }
        LoginConfig config = this.context.getLoginConfig();
        if (config != null && "FORM".equals(config.getAuthMethod())) {
            String requestURI = ((HttpServletRequest)request.getRequest()).getRequestURI();
            String loginPage = String.valueOf(this.context.getPath()) + config.getLoginPage();
            if (loginPage.equals(requestURI)) {
                if (this.debug >= 1) {
                    this.log(" Allow access to login page " + loginPage);
                }
                return true;
            }
            String errorPage = String.valueOf(this.context.getPath()) + config.getErrorPage();
            if (errorPage.equals(requestURI)) {
                if (this.debug >= 1) {
                    this.log(" Allow access to error page " + errorPage);
                }
                return true;
            }
            if (requestURI.endsWith("/j_security_check")) {
                if (this.debug >= 1) {
                    this.log(" Allow access to username/password submission");
                }
                return true;
            }
        }
        if ((principal = ((HttpServletRequest)request.getRequest()).getUserPrincipal()) == null) {
            if (this.debug >= 2) {
                this.log("  No user authenticated, cannot grant access");
            }
            ((HttpServletResponse)response.getResponse()).sendError(500, sm.getString("authenticator.notAuthenticated"));
            return false;
        }
        Realm realm = this.context.getRealm();
        String[] roles = constraint.findAuthRoles();
        if (roles == null) {
            roles = new String[]{};
        }
        if (constraint.getAllRoles()) {
            return true;
        }
        if (roles.length == 0 && constraint.getAuthConstraint()) {
            ((HttpServletResponse)response.getResponse()).sendError(403, sm.getString("authenticator.forbidden"));
            return false;
        }
        int i = 0;
        while (i < roles.length) {
            if (realm.hasRole(principal, roles[i])) {
                return true;
            }
            ++i;
        }
        ((HttpServletResponse)response.getResponse()).sendError(403, sm.getString("authenticator.forbidden"));
        return false;
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    protected void associate(String ssoId, Session session) {
        if (this.sso == null) {
            return;
        }
        this.sso.associate(ssoId, session);
    }

    protected abstract boolean authenticate(HttpRequest var1, HttpResponse var2, LoginConfig var3) throws IOException;

    protected boolean checkUserData(HttpRequest request, HttpResponse response, SecurityConstraint constraint) throws IOException {
        String queryString;
        if (constraint == null) {
            if (this.debug >= 2) {
                this.log("  No applicable security constraint defined");
            }
            return true;
        }
        String userConstraint = constraint.getUserConstraint();
        if (userConstraint == null) {
            if (this.debug >= 2) {
                this.log("  No applicable user data constraint defined");
            }
            return true;
        }
        if (userConstraint.equals("NONE")) {
            if (this.debug >= 2) {
                this.log("  User data constraint has no restrictions");
            }
            return true;
        }
        if (request.getRequest().isSecure()) {
            if (this.debug >= 2) {
                this.log("  User data constraint already satisfied");
            }
            return true;
        }
        HttpServletRequest hrequest = (HttpServletRequest)request.getRequest();
        HttpServletResponse hresponse = (HttpServletResponse)response.getResponse();
        int redirectPort = request.getConnector().getRedirectPort();
        if (redirectPort <= 0) {
            if (this.debug >= 2) {
                this.log("  SSL redirect is disabled");
            }
            hresponse.sendError(403, hrequest.getRequestURI());
            return false;
        }
        String protocol = "https";
        String host = hrequest.getServerName();
        StringBuffer file = new StringBuffer(hrequest.getRequestURI());
        String requestedSessionId = hrequest.getRequestedSessionId();
        if (requestedSessionId != null && hrequest.isRequestedSessionIdFromURL()) {
            file.append(";jsessionid=");
            file.append(requestedSessionId);
        }
        if ((queryString = hrequest.getQueryString()) != null) {
            file.append('?');
            file.append(queryString);
        }
        URL url = null;
        try {
            url = new URL(protocol, host, redirectPort, file.toString());
            if (this.debug >= 2) {
                this.log("  Redirecting to " + url.toString());
            }
            hresponse.sendRedirect(url.toString());
            return false;
        }
        catch (MalformedURLException e) {
            if (this.debug >= 2) {
                this.log("  Cannot create new URL", e);
            }
            hresponse.sendError(500, hrequest.getRequestURI());
            return false;
        }
    }

    protected SecurityConstraint findConstraint(HttpRequest request) {
        SecurityConstraint[] constraints = this.context.findConstraints();
        if (constraints == null || constraints.length == 0) {
            if (this.debug >= 2) {
                this.log("  No applicable constraints defined");
            }
            return null;
        }
        HttpServletRequest hreq = (HttpServletRequest)request.getRequest();
        String uri = hreq.getRequestURI();
        String contextPath = hreq.getContextPath();
        if (contextPath.length() > 0) {
            uri = uri.substring(contextPath.length());
        }
        uri = RequestUtil.URLDecode(uri);
        String method = hreq.getMethod();
        int i = 0;
        while (i < constraints.length) {
            if (this.debug >= 2) {
                this.log("  Checking constraint '" + constraints[i] + "' against " + method + " " + uri + " --> " + constraints[i].included(uri, method));
            }
            if (constraints[i].included(uri, method)) {
                return constraints[i];
            }
            ++i;
        }
        if (this.debug >= 2) {
            this.log("  No applicable constraint located");
        }
        return null;
    }

    protected synchronized String generateSessionId() {
        Random random = this.getRandom();
        byte[] bytes = new byte[16];
        this.getRandom().nextBytes(bytes);
        bytes = this.getDigest().digest(bytes);
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < bytes.length) {
            byte b1 = (byte)((bytes[i] & 0xF0) >> 4);
            byte b2 = (byte)(bytes[i] & 0xF);
            if (b1 < 10) {
                result.append((char)(48 + b1));
            } else {
                result.append((char)(65 + (b1 - 10)));
            }
            if (b2 < 10) {
                result.append((char)(48 + b2));
            } else {
                result.append((char)(65 + (b2 - 10)));
            }
            ++i;
        }
        return result.toString();
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public boolean getCache() {
        return this.cache;
    }

    public Container getContainer() {
        return this.context;
    }

    public int getDebug() {
        return this.debug;
    }

    protected synchronized MessageDigest getDigest() {
        block4: {
            if (this.digest != null) break block4;
            try {
                this.digest = MessageDigest.getInstance(this.algorithm);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                try {
                    this.digest = MessageDigest.getInstance(DEFAULT_ALGORITHM);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException2) {
                    this.digest = null;
                }
            }
        }
        return this.digest;
    }

    public String getEntropy() {
        if (this.entropy == null) {
            this.setEntropy(this.toString());
        }
        return this.entropy;
    }

    public String getInfo() {
        return info;
    }

    protected synchronized Random getRandom() {
        block3: {
            if (this.random != null) break block3;
            try {
                Class<?> clazz = Class.forName(this.randomClass);
                this.random = (Random)clazz.newInstance();
                long seed = System.currentTimeMillis();
                char[] entropy = this.getEntropy().toCharArray();
                int i = 0;
                while (i < entropy.length) {
                    long update = (byte)entropy[i] << i % 8 * 8;
                    seed ^= update;
                    ++i;
                }
                this.random.setSeed(seed);
            }
            catch (Exception exception) {
                this.random = new Random();
            }
        }
        return this.random;
    }

    public String getRandomClass() {
        return this.randomClass;
    }

    protected Session getSession(HttpRequest request) {
        return this.getSession(request, false);
    }

    protected Session getSession(HttpRequest request, boolean create) {
        HttpServletRequest hreq = (HttpServletRequest)request.getRequest();
        HttpSession hses = hreq.getSession(create);
        if (hses == null) {
            return null;
        }
        Manager manager = this.context.getManager();
        if (manager == null) {
            return null;
        }
        try {
            return manager.findSession(hses.getId());
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public void invoke(Request request, Response response, ValveContext context) throws IOException, ServletException {
        Session session;
        Principal principal;
        if (!(request instanceof HttpRequest) || !(response instanceof HttpResponse)) {
            context.invokeNext(request, response);
            return;
        }
        if (!(request.getRequest() instanceof HttpServletRequest) || !(response.getResponse() instanceof HttpServletResponse)) {
            context.invokeNext(request, response);
            return;
        }
        HttpRequest hrequest = (HttpRequest)request;
        HttpResponse hresponse = (HttpResponse)response;
        if (this.debug >= 1) {
            this.log("Security checking request " + ((HttpServletRequest)request.getRequest()).getMethod() + " " + ((HttpServletRequest)request.getRequest()).getRequestURI());
        }
        LoginConfig config = this.context.getLoginConfig();
        if (this.cache && (principal = ((HttpServletRequest)request.getRequest()).getUserPrincipal()) == null && (session = this.getSession(hrequest)) != null && (principal = session.getPrincipal()) != null) {
            if (this.debug >= 1) {
                this.log("We have cached auth type " + session.getAuthType() + " for principal " + session.getPrincipal());
            }
            hrequest.setAuthType(session.getAuthType());
            hrequest.setUserPrincipal(principal);
        }
        String contextPath = this.context.getPath();
        String requestURI = ((HttpServletRequest)request.getRequest()).getRequestURI();
        if (requestURI.startsWith(contextPath) && requestURI.endsWith("/j_security_check") && !this.authenticate(hrequest, hresponse, config)) {
            if (this.debug >= 1) {
                this.log(" Failed authenticate() test");
            }
            return;
        }
        SecurityConstraint constraint = this.findConstraint(hrequest);
        if (constraint == null) {
            if (this.debug >= 1) {
                this.log(" Not subject to any constraint");
            }
            context.invokeNext(request, response);
            return;
        }
        if (this.debug >= 1 && constraint != null) {
            this.log(" Subject to constraint " + constraint);
        }
        HttpServletResponse sresponse = (HttpServletResponse)response.getResponse();
        sresponse.setHeader("Pragma", "No-cache");
        sresponse.setHeader("Cache-Control", "no-cache");
        sresponse.setDateHeader("Expires", 1L);
        if (this.debug >= 1) {
            this.log(" Calling checkUserData()");
        }
        if (!this.checkUserData(hrequest, hresponse, constraint)) {
            if (this.debug >= 1) {
                this.log(" Failed checkUserData() test");
            }
            return;
        }
        if (constraint.getAuthConstraint()) {
            if (this.debug >= 1) {
                this.log(" Calling authenticate()");
            }
            if (!this.authenticate(hrequest, hresponse, config)) {
                if (this.debug >= 1) {
                    this.log(" Failed authenticate() test");
                }
                return;
            }
        }
        if (constraint.getAuthConstraint()) {
            if (this.debug >= 1) {
                this.log(" Calling accessControl()");
            }
            if (!this.accessControl(hrequest, hresponse, constraint)) {
                if (this.debug >= 1) {
                    this.log(" Failed accessControl() test");
                }
                return;
            }
        }
        if (this.debug >= 1) {
            this.log(" Successfully passed all security constraints");
        }
        context.invokeNext(request, response);
    }

    protected void log(String message) {
        Logger logger = this.context.getLogger();
        if (logger != null) {
            logger.log("Authenticator[" + this.context.getPath() + "]: " + message);
        } else {
            System.out.println("Authenticator[" + this.context.getPath() + "]: " + message);
        }
    }

    protected void log(String message, Throwable throwable) {
        Logger logger = this.context.getLogger();
        if (logger != null) {
            logger.log("Authenticator[" + this.context.getPath() + "]: " + message, throwable);
        } else {
            System.out.println("Authenticator[" + this.context.getPath() + "]: " + message);
            throwable.printStackTrace(System.out);
        }
    }

    protected void register(HttpRequest request, HttpResponse response, Principal principal, String authType, String username, String password) {
        Session session;
        if (this.debug >= 1) {
            this.log("Authenticated '" + principal.getName() + "' with type '" + authType + "'");
        }
        request.setAuthType(authType);
        request.setUserPrincipal(principal);
        if (this.cache && (session = this.getSession(request, false)) != null) {
            session.setAuthType(authType);
            session.setPrincipal(principal);
            if (username != null) {
                session.setNote("org.apache.catalina.session.USERNAME", username);
            } else {
                session.removeNote("org.apache.catalina.session.USERNAME");
            }
            if (password != null) {
                session.setNote("org.apache.catalina.session.PASSWORD", password);
            } else {
                session.removeNote("org.apache.catalina.session.PASSWORD");
            }
        }
        if (this.sso == null) {
            return;
        }
        HttpServletRequest hreq = (HttpServletRequest)request.getRequest();
        HttpServletResponse hres = (HttpServletResponse)response.getResponse();
        String value = this.generateSessionId();
        Cookie cookie = new Cookie("JSESSIONIDSSO", value);
        cookie.setMaxAge(-1);
        cookie.setPath("/");
        hres.addCookie(cookie);
        this.sso.register(value, principal, authType, username, password);
        request.setNote("org.apache.catalina.request.SSOID", value);
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public void setCache(boolean cache) {
        this.cache = cache;
    }

    public void setContainer(Container container) {
        if (!(container instanceof Context)) {
            throw new IllegalArgumentException(sm.getString("authenticator.notContext"));
        }
        super.setContainer(container);
        this.context = (Context)container;
    }

    public void setDebug(int debug) {
        this.debug = debug;
    }

    public void setEntropy(String entropy) {
        this.entropy = entropy;
    }

    public void setRandomClass(String randomClass) {
        this.randomClass = randomClass;
    }

    public void start() throws LifecycleException {
        if (this.started) {
            throw new LifecycleException(sm.getString("authenticator.alreadyStarted"));
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        if (this.context instanceof StandardContext) {
            this.setDebug(((StandardContext)this.context).getDebug());
        }
        this.started = true;
        Container parent = this.context.getParent();
        while (this.sso == null && parent != null) {
            if (!(parent instanceof Pipeline)) {
                parent = parent.getParent();
                continue;
            }
            Valve[] valves = ((Pipeline)((Object)parent)).getValves();
            int i = 0;
            while (i < valves.length) {
                if (valves[i] instanceof SingleSignOn) {
                    this.sso = (SingleSignOn)valves[i];
                    break;
                }
                ++i;
            }
            if (this.sso != null) continue;
            parent = parent.getParent();
        }
        if (this.debug >= 1) {
            if (this.sso != null) {
                this.log("Found SingleSignOn Valve at " + this.sso);
            } else {
                this.log("No SingleSignOn Valve is present");
            }
        }
    }

    public void stop() throws LifecycleException {
        if (!this.started) {
            throw new LifecycleException(sm.getString("authenticator.notStarted"));
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
        this.sso = null;
    }
}

