/*
 * Decompiled with CFR 0.152.
 */
package tyrex.tm;

import java.io.PrintWriter;
import java.security.AccessController;
import javax.transaction.InvalidTransactionException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import tyrex.server.TransactionServer;
import tyrex.tm.TransactionDomain;
import tyrex.tm.TransactionImpl;
import tyrex.tm.TransactionManagerImpl;
import tyrex.tm.TransactionStatus;
import tyrex.tm.TyrexPermission;

public final class Tyrex {
    private static TransactionDomain _txDomain = TransactionServer.getTransactionDomain("Default", true);

    public static void dumpCurrentTransaction(PrintWriter printWriter) {
        AccessController.checkPermission(TyrexPermission.Transaction.List);
        TransactionStatus transactionStatus = Tyrex.getTransaction(Thread.currentThread());
        if (transactionStatus == null) {
            printWriter.println("Current Transaction: No Transaction");
        } else {
            printWriter.println("Current Transaction:");
            printWriter.println("TX: " + transactionStatus.toString());
            printWriter.println("TX: Timeout: " + transactionStatus.getTimeout());
            String[] stringArray = transactionStatus.listResources();
            int n = 0;
            while (n < stringArray.length) {
                printWriter.println("TX: Resource: " + stringArray[n]);
                ++n;
            }
        }
    }

    public static void dumpTransactionList(PrintWriter printWriter) {
        AccessController.checkPermission(TyrexPermission.Transaction.List);
        TransactionStatus[] transactionStatusArray = Tyrex.listTransactions();
        if (transactionStatusArray.length == 0) {
            printWriter.println("Server Transactions: No Transactions");
        } else {
            printWriter.println("Server Transactions:");
            int n = 0;
            while (n < transactionStatusArray.length) {
                printWriter.println("TX: " + transactionStatusArray[n].toString() + (transactionStatusArray[n].isInThread() ? " [In Thread]" : ""));
                printWriter.println("TX: Timeout: " + transactionStatusArray[n].getTimeout());
                String[] stringArray = transactionStatusArray[n].listResources();
                int n2 = 0;
                while (n2 < stringArray.length) {
                    printWriter.println("TX: Resource: " + stringArray[n2]);
                    ++n2;
                }
                ++n;
            }
        }
    }

    public static TransactionStatus getTransaction(Thread thread) {
        AccessController.checkPermission(TyrexPermission.Transaction.List);
        Transaction transaction = ((TransactionManagerImpl)_txDomain.getTransactionManager()).getTransaction(thread);
        if (transaction != null) {
            return _txDomain.getTransactionStatus(transaction);
        }
        return null;
    }

    public static TransactionManager getTransactionManager() {
        AccessController.checkPermission(TyrexPermission.Transaction.Manager);
        return _txDomain.getTransactionManager();
    }

    public static UserTransaction getUserTransaction() {
        return _txDomain.getUserTransaction();
    }

    public static TransactionStatus[] listTransactions() {
        AccessController.checkPermission(TyrexPermission.Transaction.List);
        return _txDomain.listTransactions();
    }

    public static void recycleThread() throws RollbackException {
        AccessController.checkPermission(TyrexPermission.Transaction.Manager);
        ((TransactionManagerImpl)_txDomain.getTransactionManager()).recycleThread();
    }

    public static void resumeGlobal(byte[] byArray) throws InvalidTransactionException, IllegalStateException, SystemException {
        AccessController.checkPermission(TyrexPermission.Transaction.Manager);
        TransactionImpl transactionImpl = _txDomain.getTransaction(byArray);
        _txDomain.getTransactionManager().resume((Transaction)transactionImpl);
    }

    public static void terminateTransaction(Transaction transaction) throws InvalidTransactionException {
        AccessController.checkPermission(TyrexPermission.Transaction.Terminate);
        _txDomain.terminateTransaction(transaction);
    }
}

