/*
 * Decompiled with CFR 0.152.
 */
package tyrex.tm;

import java.io.PrintWriter;
import java.security.AccessController;
import java.util.Enumeration;
import javax.transaction.InvalidTransactionException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.omg.CosTransactions.Inactive;
import org.omg.CosTransactions.PropagationContext;
import tyrex.interceptor.TransactionInterceptor;
import tyrex.recovery.LogWriter;
import tyrex.resource.ResourceLimits;
import tyrex.resource.ResourcePool;
import tyrex.resource.ResourcePoolManager;
import tyrex.resource.ResourcePoolManagerImpl;
import tyrex.resource.ResourceTimeoutException;
import tyrex.server.RemoteTransactionServer;
import tyrex.tm.TransactionImpl;
import tyrex.tm.TransactionManagerImpl;
import tyrex.tm.TransactionStatus;
import tyrex.tm.TransactionTimeoutException;
import tyrex.tm.TransactionTimer;
import tyrex.tm.TyrexPermission;
import tyrex.tm.UserTransactionImpl;
import tyrex.tm.XidHashtable;
import tyrex.tm.XidImpl;
import tyrex.util.Messages;

public class TransactionDomain
implements ResourcePool,
RemoteTransactionServer {
    public static final int DefaultTimeout = 30;
    public static final String DefaultDomain = "default";
    private XidHashtable _txTable = new XidHashtable();
    private ResourcePoolManager _poolManager;
    private ResourceLimits _limits;
    private TransactionInterceptor[] _interceptors;
    private boolean _threadTerminate;
    private int _txTimeout;
    private PrintWriter _logWriter;
    private Thread _background;
    private boolean _nestedTx;
    private String _domainName;
    private TransactionManagerImpl _txManager;
    private UserTransaction _userTx;
    private TransactionTimer _txTimer;

    public TransactionDomain(String string, ResourceLimits resourceLimits) {
        this._domainName = string;
        this._poolManager = new ResourcePoolManagerImpl(resourceLimits);
        this._poolManager.manage(this, false);
        this._limits = resourceLimits;
        this._interceptors = new TransactionInterceptor[0];
        this._txManager = new TransactionManagerImpl(this);
        this._userTx = new UserTransactionImpl(this._txManager);
        this._txTimer = new TransactionTimer();
        this._txTimer.setDaemon(true);
        this._txTimer.start();
    }

    public synchronized void addInterceptor(TransactionInterceptor transactionInterceptor) {
        int n = 0;
        while (n < this._interceptors.length) {
            if (this._interceptors[n] == transactionInterceptor) {
                return;
            }
            ++n;
        }
        TransactionInterceptor[] transactionInterceptorArray = new TransactionInterceptor[this._interceptors.length + 1];
        System.arraycopy(this._interceptors, 0, transactionInterceptorArray, 0, this._interceptors.length);
        transactionInterceptorArray[this._interceptors.length] = transactionInterceptor;
        this._interceptors = transactionInterceptorArray;
    }

    public byte[] createRemoteTransaction() throws SystemException {
        return this.createTransaction(null, null).getXid().getGlobalTransactionId();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    TransactionImpl createTransaction(TransactionImpl transactionImpl, Thread thread) throws SystemException {
        XidImpl xidImpl = transactionImpl == null ? new XidImpl() : transactionImpl.getXid().newBranch();
        TransactionHolder transactionHolder = new TransactionHolder();
        transactionHolder.tx = new TransactionImpl(xidImpl, transactionImpl, this);
        transactionHolder.started = System.currentTimeMillis();
        transactionHolder.timeout = this._txTimeout * 1000;
        LogWriter.out.begin_transaction(xidImpl);
        if (transactionImpl != null) {
            return transactionHolder.tx;
        }
        ResourcePoolManager resourcePoolManager = this._poolManager;
        synchronized (resourcePoolManager) {
            block19: {
                try {
                    this._poolManager.canCreateNew();
                }
                catch (ResourceTimeoutException resourceTimeoutException) {
                    throw new SystemException(Messages.message("tyrex.server.txCreateExceedsQuota"));
                }
                int n = 0;
                while (true) {
                    if (n >= this._interceptors.length) {
                        try {
                            this._poolManager.canActivate();
                            break;
                        }
                        catch (ResourceTimeoutException resourceTimeoutException) {
                            throw new SystemException(Messages.message("tyrex.server.txActiveExceedsQuota"));
                        }
                    }
                    try {
                        this._interceptors[n].begin(xidImpl);
                    }
                    catch (Throwable throwable) {}
                    ++n;
                }
                if (thread != null) {
                    int n2 = 0;
                    try {
                        n2 = 0;
                        while (true) {
                            if (n2 >= this._interceptors.length) {
                                transactionHolder.threads = new Thread[1];
                                transactionHolder.threads[0] = thread;
                                break block19;
                            }
                            this._interceptors[n2].resume(xidImpl, thread);
                            ++n2;
                        }
                    }
                    catch (InvalidTransactionException invalidTransactionException) {}
                    while (n2-- > 0) {
                        this._interceptors[n2].suspend(xidImpl, thread);
                    }
                    break block19;
                    catch (Throwable throwable) {}
                }
            }
            this._txTable.put(xidImpl.getGlobalTransactionId(), transactionHolder);
        }
        this._txTimer.register(transactionHolder.tx, transactionHolder.timeout);
        return transactionHolder.tx;
    }

    void delistThread(TransactionImpl transactionImpl, Thread thread) {
        TransactionImpl transactionImpl2 = transactionImpl;
        synchronized (transactionImpl2) {
            XidImpl xidImpl = transactionImpl.getXid();
            TransactionHolder transactionHolder = (TransactionHolder)this._txTable.get(xidImpl.getGlobalTransactionId());
            int n = 0;
            while (n < this._interceptors.length) {
                try {
                    this._interceptors[n].suspend(xidImpl, thread);
                }
                catch (Throwable throwable) {}
                ++n;
            }
            if (transactionHolder != null && transactionHolder.threads != null) {
                if (transactionHolder.threads.length == 1) {
                    if (transactionHolder.threads[0] == thread) {
                        transactionHolder.threads = null;
                    }
                } else {
                    int n2 = 0;
                    while (n2 < transactionHolder.threads.length) {
                        if (transactionHolder.threads[n2] == thread) {
                            transactionHolder.threads[n2] = transactionHolder.threads[transactionHolder.threads.length - 1];
                            Thread[] threadArray = new Thread[transactionHolder.threads.length - 1];
                            System.arraycopy(transactionHolder.threads, 0, threadArray, 0, transactionHolder.threads.length - 1);
                            transactionHolder.threads = threadArray;
                            Object var6_9 = null;
                            return;
                        }
                        ++n2;
                    }
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    void enlistThread(TransactionImpl var1_1, Thread var2_2) throws SystemException {
        var5_3 = var1_1;
        synchronized (var5_3) {
            block11: {
                var4_4 = var1_1.getXid();
                var3_5 = (TransactionHolder)this._txTable.get(var4_4.getGlobalTransactionId());
                if (var3_5 != null) {
                    var7_6 = 0;
                    try {
                        var7_6 = 0;
                        while (var7_6 < this._interceptors.length) {
                            this._interceptors[var7_6].resume(var4_4, var2_2);
                            ++var7_6;
                        }
                        if (var3_5.threads == null) {
                            var3_5.threads = new Thread[1];
                            var3_5.threads[0] = var2_2;
                        } else {
                            var8_7 = new Thread[var3_5.threads.length + 1];
                            System.arraycopy(var3_5.threads, 0, var8_7, 0, var3_5.threads.length);
                            var8_7[var3_5.threads.length] = var2_2;
                            var3_5.threads = var8_7;
                        }
                        break block11;
                    }
                    catch (InvalidTransactionException v0) {
                        ** while (var7_6-- > 0)
                    }
lbl-1000:
                    // 1 sources

                    {
                        this._interceptors[var7_6].suspend(var4_4, var2_2);
                        continue;
lbl27:
                        // 1 sources

                        break block11;
                    }
                    catch (Throwable v1) {}
                }
            }
        }
    }

    void forgetTransaction(TransactionImpl transactionImpl) {
        TransactionImpl transactionImpl2 = transactionImpl;
        synchronized (transactionImpl2) {
            TransactionHolder transactionHolder = (TransactionHolder)this._txTable.remove(transactionImpl.getXid().getGlobalTransactionId());
            if (transactionHolder != null) {
                if (transactionHolder.threads != null && transactionHolder.threads.length > 0) {
                    int n = 0;
                    while (n < transactionHolder.threads.length) {
                        int n2 = 0;
                        while (n2 < this._interceptors.length) {
                            try {
                                this._interceptors[n2].suspend(transactionHolder.tx.getXid(), transactionHolder.threads[n]);
                            }
                            catch (Throwable throwable) {}
                            ++n2;
                        }
                        transactionHolder.threads[n] = null;
                        ++n;
                    }
                    transactionHolder.threads = null;
                }
                transactionHolder.tx = null;
            }
        }
        this._poolManager.released();
    }

    public int getActiveCount() {
        return this._txTable.size();
    }

    public PrintWriter getLogWriter() {
        return this._logWriter;
    }

    public boolean getNestedTransactions() {
        return this._nestedTx;
    }

    public int getPooledCount() {
        return 0;
    }

    public ResourceLimits getResourceLimits() {
        return this._limits;
    }

    public boolean getThreadTerminate() {
        return this._threadTerminate;
    }

    TransactionImpl getTransaction(byte[] byArray) throws InvalidTransactionException {
        if (byArray.length == 12) {
            if (!XidImpl.isLocal(byArray)) {
                throw new InvalidTransactionException(Messages.message("tyrex.server.originateElsewhere"));
            }
            TransactionHolder transactionHolder = (TransactionHolder)this._txTable.get(byArray);
            if (transactionHolder == null || transactionHolder.tx == null) {
                throw new InvalidTransactionException(Messages.message("tyrex.server.txRemoteMissing"));
            }
            return transactionHolder.tx;
        }
        throw new InvalidTransactionException(Messages.message("tyrex.server.xidIllegalFormat"));
    }

    public TransactionManager getTransactionManager() {
        return this.internalGetTransactionManager();
    }

    TransactionStatus getTransactionStatus(Transaction transaction) {
        TransactionHolder transactionHolder = (TransactionHolder)this._txTable.get(((TransactionImpl)transaction).getXid().getGlobalTransactionId());
        if (transactionHolder != null && transactionHolder.tx != null) {
            TransactionStatus transactionStatus = new TransactionStatus(transactionHolder.tx, transactionHolder.started + transactionHolder.timeout, transactionHolder.threads != null);
            return transactionStatus;
        }
        return null;
    }

    public int getTransactionTimeout() {
        return this._txTimeout;
    }

    int getTransactionTimeout(TransactionImpl transactionImpl) {
        TransactionHolder transactionHolder = (TransactionHolder)this._txTable.get(transactionImpl.getXid().getGlobalTransactionId());
        if (transactionHolder == null) {
            return this._txTimeout;
        }
        return (int)transactionHolder.timeout / 1000;
    }

    public UserTransaction getUserTransaction() {
        return this._userTx;
    }

    final TransactionManagerImpl internalGetTransactionManager() {
        return this._txManager;
    }

    boolean isOwner(TransactionImpl transactionImpl, Thread thread) {
        if (thread == this._background) {
            return true;
        }
        TransactionHolder transactionHolder = (TransactionHolder)this._txTable.get(transactionImpl.getXid().getGlobalTransactionId());
        if (transactionHolder != null && transactionHolder.threads != null) {
            int n = 0;
            while (n < transactionHolder.threads.length) {
                if (transactionHolder.threads[n] == thread) {
                    return true;
                }
                ++n;
            }
        }
        return transactionHolder != null && transactionHolder.threads == null;
    }

    public TransactionInterceptor[] listInterceptors() {
        return (TransactionInterceptor[])this._interceptors.clone();
    }

    TransactionStatus[] listTransactions() {
        TransactionStatus[] transactionStatusArray = new TransactionStatus[this._txTable.size()];
        int n = 0;
        Enumeration enumeration = this._txTable.elements();
        while (enumeration.hasMoreElements() && n < transactionStatusArray.length) {
            TransactionHolder transactionHolder = (TransactionHolder)enumeration.nextElement();
            if (transactionHolder.tx == null) continue;
            transactionStatusArray[n] = new TransactionStatus(transactionHolder.tx, transactionHolder.started + transactionHolder.timeout, transactionHolder.threads != null);
            ++n;
        }
        if (n < transactionStatusArray.length) {
            TransactionStatus[] transactionStatusArray2 = new TransactionStatus[n];
            System.arraycopy(transactionStatusArray, 0, transactionStatusArray2, 0, n);
            return transactionStatusArray2;
        }
        return transactionStatusArray;
    }

    void logMessage(String string) {
        if (this._logWriter != null) {
            this._logWriter.println(string);
        }
    }

    void notifyCommit(XidImpl xidImpl) throws RollbackException {
        int n = 0;
        while (n < this._interceptors.length) {
            try {
                this._interceptors[n].commit(xidImpl);
            }
            catch (RollbackException rollbackException) {
                throw rollbackException;
            }
            catch (Throwable throwable) {}
            ++n;
        }
    }

    void notifyCompletion(XidImpl xidImpl, int n) {
        int n2 = 0;
        while (n2 < this._interceptors.length) {
            try {
                this._interceptors[n2].completed(xidImpl, n);
            }
            catch (Throwable throwable) {}
            ++n2;
        }
    }

    void notifyRollback(XidImpl xidImpl) {
        int n = 0;
        while (n < this._interceptors.length) {
            try {
                this._interceptors[n].rollback(xidImpl);
            }
            catch (Throwable throwable) {}
            ++n;
        }
    }

    TransactionImpl recreateTransaction(PropagationContext propagationContext) throws SystemException {
        XidImpl xidImpl = new XidImpl();
        TransactionHolder transactionHolder = new TransactionHolder();
        try {
            transactionHolder.tx = new TransactionImpl(xidImpl, propagationContext, this);
        }
        catch (Inactive inactive) {
            throw new SystemException(Messages.message("tyrex.tx.inactive"));
        }
        transactionHolder.started = System.currentTimeMillis();
        transactionHolder.timeout = propagationContext.timeout;
        ResourcePoolManager resourcePoolManager = this._poolManager;
        synchronized (resourcePoolManager) {
            try {
                this._poolManager.canCreateNew();
            }
            catch (ResourceTimeoutException resourceTimeoutException) {
                throw new SystemException(Messages.message("tyrex.server.txCreateExceedsQuota"));
            }
            int n = 0;
            while (n < this._interceptors.length) {
                try {
                    this._interceptors[n].begin(xidImpl);
                }
                catch (Throwable throwable) {}
                ++n;
            }
            this._txTable.put(xidImpl.getGlobalTransactionId(), transactionHolder);
        }
        this._txTimer.register(transactionHolder.tx, transactionHolder.timeout);
        return transactionHolder.tx;
    }

    public void releasePooled(int n) {
    }

    public synchronized void removeInterceptor(TransactionInterceptor transactionInterceptor) {
        int n = 0;
        while (n < this._interceptors.length) {
            if (this._interceptors[n] == transactionInterceptor) {
                this._interceptors[n] = this._interceptors[this._interceptors.length - 1];
                TransactionInterceptor[] transactionInterceptorArray = new TransactionInterceptor[this._interceptors.length - 1];
                System.arraycopy(this._interceptors, 0, transactionInterceptorArray, 0, this._interceptors.length - 1);
                this._interceptors = transactionInterceptorArray;
                break;
            }
            ++n;
        }
    }

    public void run() {
        while (true) {
            try {
                block5: while (true) {
                    Thread.sleep(this._limits.getCheckEvery() * 1000);
                    long l = System.currentTimeMillis();
                    Enumeration enumeration = this._txTable.elements();
                    while (true) {
                        if (!enumeration.hasMoreElements()) continue block5;
                        TransactionHolder transactionHolder = (TransactionHolder)enumeration.nextElement();
                        if (transactionHolder.started + transactionHolder.timeout >= l) continue;
                        TransactionImpl transactionImpl = transactionHolder.tx;
                        if (transactionImpl.getStatus() != 0 && transactionImpl.getStatus() != 1) {
                            transactionImpl = null;
                        }
                        this.terminateTransaction(transactionHolder);
                        if (transactionImpl == null) continue;
                        transactionHolder.tx = transactionImpl;
                        transactionHolder.timeout = this._limits.getCheckEvery() * 1000;
                        this._txTable.put(transactionImpl.getXid().getGlobalTransactionId(), transactionHolder);
                    }
                    break;
                }
            }
            catch (InterruptedException interruptedException) {
                try {
                    AccessController.checkPermission(TyrexPermission.Server.Shutdown);
                    return;
                }
                catch (SecurityException securityException) {
                    continue;
                }
            }
            break;
        }
    }

    public void setLogWriter(PrintWriter printWriter) {
        if (printWriter == null) {
            throw new IllegalArgumentException("Argument 'logWriter' is null");
        }
        this._logWriter = printWriter;
    }

    public void setNestedTransaction(boolean bl) {
        this._nestedTx = bl;
    }

    public void setResourceLimits(ResourceLimits resourceLimits) {
        ResourcePoolManager resourcePoolManager = this._poolManager;
        synchronized (resourcePoolManager) {
            ResourcePoolManagerImpl resourcePoolManagerImpl = new ResourcePoolManagerImpl(resourceLimits);
            this._poolManager.unmanage();
            this._poolManager = resourcePoolManagerImpl;
            resourcePoolManagerImpl.manage(this, false);
            this._limits = resourceLimits;
        }
    }

    public void setThreadTerminate(boolean bl) {
        this._threadTerminate = bl;
    }

    public void setTransactionTimeout(int n) {
        this._txTimeout = n > 0 ? n : 30;
    }

    void setTransactionTimeout(TransactionImpl transactionImpl, int n) {
        if (n <= 0) {
            n = this._txTimeout;
        }
        TransactionImpl transactionImpl2 = transactionImpl;
        synchronized (transactionImpl2) {
            TransactionHolder transactionHolder = (TransactionHolder)this._txTable.get(transactionImpl.getXid().getGlobalTransactionId());
            if (transactionHolder != null) {
                transactionHolder.timeout = n * 1000;
                if (transactionHolder.tx != null) {
                    transactionHolder.tx.internalSetTransactionTimeout(n);
                }
            }
        }
    }

    public void shutdown() {
        Enumeration enumeration = this._txTable.elements();
        while (enumeration.hasMoreElements()) {
            TransactionHolder transactionHolder = (TransactionHolder)enumeration.nextElement();
            try {
                this.terminateTransaction(transactionHolder);
            }
            catch (Exception exception) {}
        }
    }

    public void stopTxTimer(TransactionImpl transactionImpl) {
        this._txTimer.unregister(transactionImpl);
    }

    void terminateTransaction(Transaction transaction) throws InvalidTransactionException {
        if (!(transaction instanceof TransactionImpl)) {
            throw new InvalidTransactionException(Messages.message("tyrex.server.originateElsewhere"));
        }
        TransactionHolder transactionHolder = (TransactionHolder)this._txTable.get(((TransactionImpl)transaction).getXid().getGlobalTransactionId());
        if (transactionHolder == null) {
            throw new InvalidTransactionException(Messages.message("tyrex.tx.inactive"));
        }
        this.terminateTransaction(transactionHolder);
    }

    private void terminateTransaction(TransactionHolder transactionHolder) {
        TransactionImpl transactionImpl = transactionHolder.tx;
        synchronized (transactionImpl) {
            block24: {
                XidImpl xidImpl = transactionHolder.tx.getXid();
                if (transactionHolder.tx.getStatus() != 0 && transactionHolder.tx.getStatus() != 1) {
                    this._txTable.remove(xidImpl.getGlobalTransactionId());
                    this._poolManager.released();
                    if (transactionHolder.threads != null && transactionHolder.threads.length > 0) {
                        int n = 0;
                        while (n < transactionHolder.threads.length) {
                            int n2 = 0;
                            while (n2 < this._interceptors.length) {
                                try {
                                    this._interceptors[n2].suspend(transactionHolder.tx.getXid(), transactionHolder.threads[n]);
                                }
                                catch (Throwable throwable) {}
                                ++n2;
                            }
                            transactionHolder.threads[n] = null;
                            ++n;
                        }
                        transactionHolder.threads = null;
                    }
                    transactionHolder.tx = null;
                } else {
                    try {
                        Thread[] threadArray = null;
                        this.logMessage(Messages.format("tyrex.server.timeoutTerminate", ((Object)xidImpl).toString()));
                        if (transactionHolder.threads != null) {
                            threadArray = (Thread[])transactionHolder.threads.clone();
                        }
                        try {
                            int n = 0;
                            while (n < this._interceptors.length) {
                                try {
                                    this._interceptors[n].completed(xidImpl, 16);
                                }
                                catch (Throwable throwable) {}
                                ++n;
                            }
                            transactionHolder.tx.timedOut();
                        }
                        catch (Exception exception) {
                            this.logMessage(Messages.format("tyrex.server.timeoutTerminateError", ((Object)xidImpl).toString(), exception));
                        }
                        if (threadArray == null || !this._threadTerminate) break block24;
                        int n = 0;
                        while (n < threadArray.length) {
                            try {
                                int n3 = 0;
                                while (n3 < this._interceptors.length) {
                                    try {
                                        this._interceptors[n3].suspend(xidImpl, transactionHolder.threads[n]);
                                    }
                                    catch (Throwable throwable) {}
                                    ++n3;
                                }
                                threadArray[n].stop(new TransactionTimeoutException());
                            }
                            catch (Exception exception) {}
                            ++n;
                        }
                    }
                    catch (Exception exception) {
                        this.logMessage(Messages.format("tyrex.server.timeoutTerminateError", transactionHolder.tx.toString(), exception));
                    }
                }
            }
        }
    }

    static class TransactionHolder {
        TransactionImpl tx;
        Thread[] threads;
        long timeout;
        long started;

        TransactionHolder() {
        }
    }
}

