/*
 * Decompiled with CFR 0.152.
 */
package tyrex.connector.transaction;

import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import tyrex.connector.ConnectionException;
import tyrex.connector.LocalTransaction;
import tyrex.tm.XidImpl;

public final class XALocalTransaction
implements LocalTransaction {
    private final XAResource xaResource;
    private Xid xid = null;
    private final XALocalTransactionListener listener;

    public XALocalTransaction(XAResource xAResource, XALocalTransactionListener xALocalTransactionListener) {
        if (xAResource == null) {
            throw new IllegalArgumentException("The argument 'xaResource' is null.");
        }
        if (xALocalTransactionListener == null) {
            throw new IllegalArgumentException("The argument 'listener' is null.");
        }
        this.xaResource = xAResource;
        this.listener = xALocalTransactionListener;
    }

    public synchronized void begin() throws ConnectionException {
        if (this.xid != null) {
            throw new ConnectionException("Transaction in process: Nested transactions are not supported.");
        }
        this.xid = new XidImpl();
        try {
            this.xaResource.start(this.xid, 0);
            try {
                this.listener.beginCalled();
            }
            catch (Exception exception) {}
        }
        catch (XAException xAException) {
            throw new ConnectionException("Failed to begin transaction", xAException);
        }
    }

    public synchronized void commit() throws ConnectionException {
        if (this.xid == null) {
            throw new ConnectionException("No transaction in process.");
        }
        try {
            try {
                this.xaResource.end(this.xid, 0x4000000);
                this.xaResource.commit(this.xid, true);
                try {
                    this.listener.commitCalled();
                }
                catch (Exception exception) {}
            }
            catch (XAException xAException) {
                this.handleXAException("Failed to commit transaction", xAException);
            }
            Object var2_2 = null;
            this.xid = null;
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.xid = null;
            throw throwable;
        }
    }

    private void forget(XAException xAException) throws XAException {
        int n = xAException.errorCode;
        if (n == 7 || n == 8 || n == 5 || n >= 100 && n <= 107) {
            this.xaResource.forget(this.xid);
        }
    }

    private void handleXAException(String string, XAException xAException) throws ConnectionException {
        String string2 = null;
        try {
            int n = xAException.errorCode;
            if (n == 7 || n == 8 || n == 5 || n >= 100 && n <= 107) {
                this.xaResource.forget(this.xid);
            }
        }
        catch (Exception exception) {
            string2 = exception.toString();
        }
        throw new ConnectionException(String.valueOf(string) + (string2 == null ? "" : "(Forget failed: " + string2 + ")"), xAException);
    }

    public synchronized void rollback() throws ConnectionException {
        if (this.xid == null) {
            throw new ConnectionException("No transaction in process.");
        }
        try {
            try {
                this.xaResource.end(this.xid, 0x4000000);
                this.xaResource.rollback(this.xid);
                try {
                    this.listener.rollbackCalled();
                }
                catch (Exception exception) {}
            }
            catch (XAException xAException) {
                this.handleXAException("Failed to rollback transaction", xAException);
            }
            Object var2_2 = null;
            this.xid = null;
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.xid = null;
            throw throwable;
        }
    }

    public static interface XALocalTransactionListener {
        public void beginCalled();

        public void commitCalled();

        public void rollbackCalled();
    }
}

