/*
 * Decompiled with CFR 0.152.
 */
package tyrex.connector;

import java.io.PrintWriter;
import javax.naming.NamingException;
import javax.naming.Reference;
import tyrex.connector.ConnectionException;
import tyrex.connector.ConnectionFactory;
import tyrex.connector.ConnectionManager;
import tyrex.connector.ManagedConnectionFactory;

public class ConnectionFactoryImpl
implements ConnectionFactory {
    protected static final String loginTimeoutType = "loginTimeout".intern();
    protected static final String descriptionType = "description".intern();
    protected static final String logWriterType = "logWriter".intern();
    private final ConnectionManager connectionManager;
    private final ManagedConnectionFactory managedConnectionFactory;
    private String description = null;
    private PrintWriter logWriter = null;
    private int timeout = 0;
    private Reference reference = null;

    public ConnectionFactoryImpl(ManagedConnectionFactory managedConnectionFactory, ConnectionManager connectionManager) {
        if (connectionManager == null) {
            throw new IllegalArgumentException("The argument 'connectionManager' is null.");
        }
        if (managedConnectionFactory == null) {
            throw new IllegalArgumentException("The argument 'managedConnectionFactory' is null.");
        }
        this.connectionManager = connectionManager;
        this.managedConnectionFactory = managedConnectionFactory;
    }

    public Object getConnection(Object object) throws ConnectionException {
        return this.connectionManager.getConnection(this.managedConnectionFactory, object);
    }

    protected final ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public final String getDescription() {
        return this.description;
    }

    public final PrintWriter getLogWriter() {
        return this.logWriter;
    }

    public final int getLoginTimeout() {
        return this.timeout;
    }

    protected final ManagedConnectionFactory getManagedConnectionFactory() {
        return this.managedConnectionFactory;
    }

    protected String getObjectFactoryClassName() {
        return "tyrex.connector.ConnectionFactoryImplObjectFactory";
    }

    public final Reference getReference() throws NamingException {
        return this.reference;
    }

    protected void propertyHasChanged(String string) {
    }

    public final void setDescription(String string) {
        this.description = string;
        this.propertyHasChanged(descriptionType);
    }

    public final void setLogWriter(PrintWriter printWriter) {
        this.logWriter = printWriter;
        this.propertyHasChanged(logWriterType);
    }

    public final void setLoginTimeout(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("The argument 'timeout' is less than 0.");
        }
        this.timeout = n;
        this.propertyHasChanged(loginTimeoutType);
    }

    public final void setReference(Reference reference) {
        this.reference = reference;
    }
}

