/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.LogOutputStream;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.GlobPatternMapper;
import org.apache.tools.ant.util.SourceFileScanner;
import sun.rmi.rmic.Main;

public class Rmic
extends MatchingTask {
    private File baseDir;
    private String classname;
    private File sourceBase;
    private String stubVersion;
    private Path compileClasspath;
    private boolean verify = false;
    private boolean filtering = false;
    private boolean iiop = false;
    private String iiopopts;
    private boolean idl = false;
    private String idlopts;
    private Vector compileList = new Vector();
    private ClassLoader loader = null;
    static /* synthetic */ Class class$java$rmi$Remote;

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public Path createClasspath() {
        if (this.compileClasspath == null) {
            this.compileClasspath = new Path(this.project);
        }
        return this.compileClasspath.createPath();
    }

    public void execute() throws BuildException {
        int j;
        int fileCount;
        if (this.baseDir == null) {
            throw new BuildException("base attribute must be set!", this.location);
        }
        if (!this.baseDir.exists()) {
            throw new BuildException("base does not exist!", this.location);
        }
        if (this.verify) {
            this.log("Verify has been turned on.", 2);
        }
        if (this.iiop) {
            this.log("IIOP has been turned on.", 2);
            if (this.iiopopts != null) {
                this.log("IIOP Options: " + this.iiopopts, 2);
            }
        }
        if (this.idl) {
            this.log("IDL has been turned on.", 2);
            if (this.idlopts != null) {
                this.log("IDL Options: " + this.idlopts, 2);
            }
        }
        Path classpath = this.getCompileClasspath(this.baseDir);
        this.loader = new AntClassLoader(this.project, classpath);
        if (this.classname == null) {
            DirectoryScanner ds = this.getDirectoryScanner(this.baseDir);
            String[] files = ds.getIncludedFiles();
            this.scanDir(this.baseDir, files);
        } else {
            this.scanDir(this.baseDir, new String[]{String.valueOf(this.classname.replace('.', File.separatorChar)) + ".class"});
        }
        LogOutputStream logstr = new LogOutputStream(this, 1);
        Main compiler = new Main((OutputStream)logstr, "rmic");
        Commandline cmd = new Commandline();
        cmd.createArgument().setValue("-d");
        cmd.createArgument().setFile(this.baseDir);
        cmd.createArgument().setValue("-classpath");
        cmd.createArgument().setPath(classpath);
        if (this.stubVersion != null) {
            if ("1.1".equals(this.stubVersion)) {
                cmd.createArgument().setValue("-v1.1");
            } else if ("1.2".equals(this.stubVersion)) {
                cmd.createArgument().setValue("-v1.2");
            } else {
                cmd.createArgument().setValue("-vcompat");
            }
        }
        if (this.sourceBase != null) {
            cmd.createArgument().setValue("-keepgenerated");
        }
        if (this.iiop) {
            cmd.createArgument().setValue("-iiop");
            if (this.iiopopts != null) {
                cmd.createArgument().setValue(this.iiopopts);
            }
        }
        if (this.idl) {
            cmd.createArgument().setValue("-idl");
            if (this.idlopts != null) {
                cmd.createArgument().setValue(this.idlopts);
            }
        }
        if ((fileCount = this.compileList.size()) > 0) {
            this.log("RMI Compiling " + fileCount + " class" + (fileCount > 1 ? "es" : "") + " to " + this.baseDir, 2);
            j = 0;
            while (j < fileCount) {
                cmd.createArgument().setValue((String)this.compileList.elementAt(j));
                ++j;
            }
            this.log("Compilation args: " + cmd.toString(), 3);
            compiler.compile(cmd.getArguments());
        }
        if (this.sourceBase != null) {
            j = 0;
            while (j < fileCount) {
                this.moveGeneratedFile(this.baseDir, this.sourceBase, (String)this.compileList.elementAt(j));
                ++j;
            }
        }
        this.compileList.removeAllElements();
    }

    private Path getCompileClasspath(File baseFile) {
        String bootcp;
        Path classpath = new Path(this.project, baseFile.getAbsolutePath());
        if (this.compileClasspath != null) {
            classpath.addExisting(this.compileClasspath);
        }
        classpath.addExisting(Path.systemClasspath);
        if (Project.getJavaVersion().startsWith("1.2") && (bootcp = System.getProperty("sun.boot.class.path")) != null) {
            classpath.addExisting(new Path(this.project, bootcp));
        }
        return classpath;
    }

    private void moveGeneratedFile(File baseDir, File sourceBaseFile, String classname) throws BuildException {
        String stubFileName = String.valueOf(classname.replace('.', File.separatorChar)) + "_Stub.java";
        File oldStubFile = new File(baseDir, stubFileName);
        File newStubFile = new File(sourceBaseFile, stubFileName);
        try {
            this.project.copyFile(oldStubFile, newStubFile, this.filtering);
            oldStubFile.delete();
        }
        catch (IOException ioe) {
            String msg = "Failed to copy " + oldStubFile + " to " + newStubFile + " due to " + ioe.getMessage();
            throw new BuildException(msg, ioe, this.location);
        }
        if (!"1.2".equals(this.stubVersion)) {
            String skelFileName = String.valueOf(classname.replace('.', '/')) + "_Skel.java";
            File oldSkelFile = new File(baseDir, skelFileName);
            File newSkelFile = new File(sourceBaseFile, skelFileName);
            try {
                this.project.copyFile(oldSkelFile, newSkelFile, this.filtering);
                oldSkelFile.delete();
            }
            catch (IOException ioe) {
                String msg = "Failed to copy " + oldSkelFile + " to " + newSkelFile + " due to " + ioe.getMessage();
                throw new BuildException(msg, ioe, this.location);
            }
        }
    }

    protected void scanDir(File baseDir, String[] files) {
        SourceFileScanner sfs = new SourceFileScanner(this);
        String[] newFiles = sfs.restrict(files, baseDir, baseDir, new RmicFileNameMapper());
        int i = 0;
        while (i < newFiles.length) {
            String classname = newFiles[i].replace(File.separatorChar, '.');
            classname = classname.substring(0, classname.indexOf(".class"));
            this.compileList.addElement(classname);
            ++i;
        }
    }

    public void setBase(File base) {
        this.baseDir = base;
    }

    public void setClassname(String classname) {
        this.classname = classname;
    }

    public void setClasspath(Path classpath) {
        if (this.compileClasspath == null) {
            this.compileClasspath = classpath;
        } else {
            this.compileClasspath.append(classpath);
        }
    }

    public void setClasspathRef(Reference r) {
        this.createClasspath().setRefid(r);
    }

    public void setFiltering(boolean filter) {
        this.filtering = filter;
    }

    public void setIdl(boolean idl) {
        this.idl = idl;
    }

    public void setIdlopts(String idlopts) {
        this.idlopts = idlopts;
    }

    public void setIiop(boolean iiop) {
        this.iiop = iiop;
    }

    public void setIiopopts(String iiopopts) {
        this.iiopopts = iiopopts;
    }

    public void setSourceBase(File sourceBase) {
        this.sourceBase = sourceBase;
    }

    public void setStubVersion(String stubVersion) {
        this.stubVersion = stubVersion;
    }

    public void setVerify(boolean verify) {
        this.verify = verify;
    }

    private class RmicFileNameMapper
    implements FileNameMapper {
        private GlobPatternMapper stubMapper = new GlobPatternMapper();
        private GlobPatternMapper skelMapper;

        RmicFileNameMapper() {
            this.stubMapper.setFrom("*.class");
            this.stubMapper.setTo("*_Stub.class");
            if (!"1.2".equals(Rmic.this.stubVersion)) {
                this.skelMapper = new GlobPatternMapper();
                this.skelMapper.setFrom("*.class");
                this.skelMapper.setTo("*_Skel.class");
            }
        }

        private boolean isValidRmiRemote(Class testClass) {
            Class rmiRemote;
            Class clazz = rmiRemote = class$java$rmi$Remote != null ? class$java$rmi$Remote : (class$java$rmi$Remote = Rmic.class$("java.rmi.Remote"));
            if (rmiRemote.equals(testClass)) {
                return true;
            }
            Class<?>[] interfaces = testClass.getInterfaces();
            if (interfaces != null) {
                int i = 0;
                while (i < interfaces.length) {
                    if (rmiRemote.equals(interfaces[i])) {
                        return true;
                    }
                    if (this.isValidRmiRemote(interfaces[i])) {
                        return true;
                    }
                    ++i;
                }
            }
            return false;
        }

        public String[] mapFileName(String name) {
            String[] stubName = this.stubMapper.mapFileName(name);
            if (stubName == null || name.endsWith("_Stub.class") || name.endsWith("_Skel.class")) {
                return null;
            }
            String classname = name.replace(File.separatorChar, '.');
            classname = classname.substring(0, classname.indexOf(".class"));
            if (Rmic.this.verify) {
                try {
                    Class<?> testClass = Rmic.this.loader.loadClass(classname);
                    if (testClass.isInterface() || !this.isValidRmiRemote(testClass)) {
                        return null;
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    Rmic.this.log("Unable to verify class " + classname + ". It could not be found.", 1);
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    Rmic.this.log("Unable to verify class " + classname + ". It is not defined.", 1);
                }
            }
            if (this.skelMapper != null) {
                return new String[]{stubName[0], this.skelMapper.mapFileName(name)[0]};
            }
            return stubName;
        }

        public void setFrom(String s) {
        }

        public void setTo(String s) {
        }
    }
}

