/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;

public class JikesOutputParser
implements ExecuteStreamHandler {
    protected Task task;
    protected boolean errorFlag = false;
    protected int errors;
    protected int warnings;
    protected boolean error = false;
    protected boolean emacsMode;
    protected BufferedReader br;

    protected JikesOutputParser(Task task, boolean emacsMode) {
        this.task = task;
        this.emacsMode = emacsMode;
    }

    protected boolean getErrorFlag() {
        return this.errorFlag;
    }

    private void log(String line) {
        if (!this.emacsMode) {
            this.task.log("", this.error ? 0 : 1);
        }
        this.task.log(line, this.error ? 0 : 1);
    }

    private void parseEmacsOutput(BufferedReader reader) throws IOException {
        this.parseStandardOutput(reader);
    }

    protected void parseOutput(BufferedReader reader) throws IOException {
        if (this.emacsMode) {
            this.parseEmacsOutput(reader);
        } else {
            this.parseStandardOutput(reader);
        }
    }

    private void parseStandardOutput(BufferedReader reader) throws IOException {
        String line;
        while ((line = reader.readLine()) != null) {
            String lower = line.toLowerCase();
            if (line.trim().equals("")) continue;
            if (lower.indexOf("error") != -1) {
                this.setError(true);
            } else if (lower.indexOf("warning") != -1) {
                this.setError(false);
            } else if (this.emacsMode) {
                this.setError(true);
            }
            this.log(line);
        }
    }

    private void setError(boolean err) {
        this.error = err;
        if (this.error) {
            this.errorFlag = true;
        }
    }

    public void setProcessErrorStream(InputStream is) {
    }

    public void setProcessInputStream(OutputStream os) {
    }

    public void setProcessOutputStream(InputStream is) throws IOException {
        this.br = new BufferedReader(new InputStreamReader(is));
    }

    public void start() throws IOException {
        this.parseOutput(this.br);
    }

    public void stop() {
    }
}

