/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Location;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.UnknownElement;

public class Target {
    private String name;
    private String ifCondition = "";
    private String unlessCondition = "";
    private Vector dependencies = new Vector(2);
    private Vector tasks = new Vector(5);
    private Project project;
    private String description = null;

    public void addDependency(String dependency) {
        this.dependencies.addElement(dependency);
    }

    public void addTask(Task task) {
        this.tasks.addElement(task);
    }

    public void execute() throws BuildException {
        if (this.testIfCondition() && this.testUnlessCondition()) {
            Enumeration enumeration = this.tasks.elements();
            while (enumeration.hasMoreElements()) {
                Task task = (Task)enumeration.nextElement();
                try {
                    this.project.fireTaskStarted(task);
                    task.maybeConfigure();
                    task.execute();
                    this.project.fireTaskFinished(task, null);
                }
                catch (RuntimeException exc) {
                    BuildException be;
                    if (exc instanceof BuildException && (be = (BuildException)exc).getLocation() == Location.UNKNOWN_LOCATION) {
                        be.setLocation(task.getLocation());
                    }
                    this.project.fireTaskFinished(task, exc);
                    throw exc;
                }
            }
        } else if (!this.testIfCondition()) {
            this.project.log(this, "Skipped because property '" + this.ifCondition + "' not set.", 3);
        } else {
            this.project.log(this, "Skipped because property '" + this.unlessCondition + "' set.", 3);
        }
    }

    public Enumeration getDependencies() {
        return this.dependencies.elements();
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public Project getProject() {
        return this.project;
    }

    public Task[] getTasks() {
        Object[] retval = new Task[this.tasks.size()];
        this.tasks.copyInto(retval);
        return retval;
    }

    void replaceTask(UnknownElement el, Task t) {
        int index = -1;
        while ((index = this.tasks.indexOf(el)) >= 0) {
            this.tasks.setElementAt(t, index);
        }
    }

    public void setDepends(String depS) {
        if (depS.length() > 0) {
            StringTokenizer tok = new StringTokenizer(depS, ",", false);
            while (tok.hasMoreTokens()) {
                this.addDependency(tok.nextToken().trim());
            }
        }
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setIf(String property) {
        this.ifCondition = property == null ? "" : property;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public void setUnless(String property) {
        this.unlessCondition = property == null ? "" : property;
    }

    private boolean testIfCondition() {
        return "".equals(this.ifCondition) || this.project.getProperty(this.ifCondition) != null;
    }

    private boolean testUnlessCondition() {
        return "".equals(this.unlessCondition) || this.project.getProperty(this.unlessCondition) == null;
    }

    public String toString() {
        return this.name;
    }
}

