/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.request;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import javax.servlet.ServletOutputStream;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.core.Response;
import org.apache.tomcat.core.ServletWrapper;
import org.apache.tomcat.util.MimeHeaderField;
import org.apache.tomcat.util.MimeHeaders;

class FileHandler
extends ServletWrapper {
    int realFileNote;

    FileHandler() {
        this.initialized = true;
        this.internal = true;
        this.name = "tomcat.fileHandler";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doService(Request req, Response res) throws Exception {
        String mimeType;
        String base;
        Request subReq = req;
        if (req.getChild() != null) {
            subReq = req.getChild();
        }
        Context ctx = subReq.getContext();
        String pathInfo = subReq.getServletPath();
        String absPath = (String)subReq.getNote(this.realFileNote);
        if (absPath == null) {
            absPath = ctx.getRealPath(pathInfo);
        }
        if (this.debug > 0) {
            this.log("Requested file = " + absPath);
        }
        if ((absPath = this.extraCheck(base = ctx.getAbsolutePath(), absPath)) == null) {
            this.context.getContextManager().handleStatus(req, res, 404);
            return;
        }
        File file = new File(absPath);
        if (this.debug > 0) {
            this.log("After paranoic checks = " + absPath);
        }
        if ((mimeType = ctx.getMimeMap().getContentTypeFor(absPath)) == null) {
            mimeType = "text/plain";
        }
        if (this.debug > 0) {
            this.log("Serving  " + absPath);
        }
        res.setContentType(mimeType);
        res.setContentLength((int)file.length());
        FileHandler.setDateHeader(res, "Last-Modified", file.lastModified());
        FileInputStream in = null;
        try {
            try {
                in = new FileInputStream(file);
                if (res.isUsingWriter()) {
                    InputStreamReader r = new InputStreamReader(in);
                    PrintWriter out = res.getWriter();
                    char[] buf = new char[1024];
                    int read = 0;
                    while ((read = r.read(buf)) != -1) {
                        out.write(buf, 0, read);
                    }
                } else {
                    ServletOutputStream out = res.getOutputStream();
                    byte[] buf = new byte[1024];
                    int read = 0;
                    while ((read = in.read(buf)) != -1) {
                        out.write(buf, 0, read);
                    }
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.context.getContextManager().handleStatus(req, res, 404);
            }
            Object var12_18 = null;
            if (in == null) return;
        }
        catch (Throwable throwable) {
            Object var12_19 = null;
            if (in == null) throw throwable;
            in.close();
            throw throwable;
        }
        in.close();
    }

    String extraCheck(String base, String absPath) {
        if (absPath.endsWith("/") || absPath.endsWith("\\") || absPath.endsWith(".")) {
            this.log("Ends with \\/. " + absPath);
            return null;
        }
        if (absPath.length() > base.length()) {
            String relPathU;
            String relPath = absPath.substring(base.length() + 1);
            if (this.debug > 0) {
                this.log("RelPath = " + relPath);
            }
            if ((relPathU = relPath.toUpperCase()).startsWith("WEB-INF") || relPathU.startsWith("META-INF") || relPathU.indexOf("/WEB-INF/") >= 0 || relPathU.indexOf("/META-INF/") >= 0) {
                return null;
            }
        }
        return absPath;
    }

    static void setDateHeader(Response res, String name, long value) {
        MimeHeaders headers = res.getMimeHeaders();
        MimeHeaderField headerF = headers.find(name);
        if (headerF == null) {
            headerF = headers.putHeader();
        }
        headerF.setName(name);
        headerF.setDateValue(value);
    }

    public void setNoteId(int n) {
        this.realFileNote = n;
    }
}

