/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.depend;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.taskdefs.optional.depend.ClassFile;
import org.apache.tools.ant.taskdefs.optional.depend.ClassFileUtils;
import org.apache.tools.ant.types.Path;

public class Depend
extends MatchingTask {
    private Path srcPath;
    private Path destPath;
    private File cache;
    private Hashtable affectedClassMap;
    private Hashtable classFileInfoMap;
    private Vector outOfDateClasses;
    private boolean closure;

    private void addClassFiles(Vector classFileList, File dir, File root) {
        String[] filesInDir = dir.list();
        if (filesInDir != null) {
            int length = filesInDir.length;
            int i = 0;
            while (i < length) {
                File file = new File(dir, filesInDir[i]);
                if (file.isDirectory()) {
                    this.addClassFiles(classFileList, file, root);
                } else if (file.getName().endsWith(".class")) {
                    ClassFileInfo info = new ClassFileInfo();
                    info.absoluteFile = file;
                    info.relativeName = file.getPath().substring(root.getPath().length() + 1, file.getPath().length() - 6);
                    info.className = ClassFileUtils.convertSlashName(info.relativeName);
                    classFileList.addElement(info);
                }
                ++i;
            }
        }
    }

    private void deleteAffectedFiles(String className) {
        Hashtable affectedClasses = (Hashtable)this.affectedClassMap.get(className);
        if (affectedClasses != null) {
            Enumeration e = affectedClasses.keys();
            while (e.hasMoreElements()) {
                String affectedClassName = (String)e.nextElement();
                ClassFileInfo affectedClassInfo = (ClassFileInfo)affectedClasses.get(affectedClassName);
                if (!affectedClassInfo.absoluteFile.exists()) continue;
                this.log("Deleting file " + affectedClassInfo.absoluteFile.getPath() + " since " + className + " out of date", 3);
                affectedClassInfo.absoluteFile.delete();
                if (this.closure) {
                    this.deleteAffectedFiles(affectedClassName);
                    continue;
                }
                if (affectedClassName.indexOf("$") == -1) continue;
                String topLevelClassName = affectedClassName.substring(0, affectedClassName.indexOf("$"));
                this.log("Top level class = " + topLevelClassName, 2);
                ClassFileInfo topLevelClassInfo = (ClassFileInfo)this.classFileInfoMap.get(topLevelClassName);
                if (!topLevelClassInfo.absoluteFile.exists()) continue;
                this.log("Deleting file " + topLevelClassInfo.absoluteFile.getPath() + " since " + "one of its inner classes was removed", 3);
                topLevelClassInfo.absoluteFile.delete();
                if (!this.closure) continue;
                this.deleteAffectedFiles(topLevelClassName);
            }
        }
    }

    private void deleteAllAffectedFiles() {
        Enumeration e = this.outOfDateClasses.elements();
        while (e.hasMoreElements()) {
            String className = (String)e.nextElement();
            this.deleteAffectedFiles(className);
        }
    }

    private void determineDependencies() throws IOException {
        this.affectedClassMap = new Hashtable();
        this.classFileInfoMap = new Hashtable();
        Enumeration e = this.getClassFiles(this.destPath).elements();
        while (e.hasMoreElements()) {
            File depFile;
            ClassFileInfo info = (ClassFileInfo)e.nextElement();
            this.classFileInfoMap.put(info.className, info);
            Vector dependencyList = null;
            if (this.cache != null && (depFile = new File(this.cache, String.valueOf(info.relativeName) + ".dep")).exists() && depFile.lastModified() > info.absoluteFile.lastModified()) {
                dependencyList = this.readDependencyList(depFile);
            }
            if (dependencyList == null) {
                Object var6_7;
                FileInputStream inFileStream;
                block9: {
                    inFileStream = null;
                    try {
                        inFileStream = new FileInputStream(info.absoluteFile);
                        ClassFile classFile = new ClassFile();
                        classFile.read(inFileStream);
                        dependencyList = classFile.getClassRefs();
                        if (this.cache == null) break block9;
                        File depFile2 = new File(this.cache, String.valueOf(info.relativeName) + ".dep");
                        this.writeDependencyList(depFile2, dependencyList);
                    }
                    catch (Throwable throwable) {
                        var6_7 = null;
                        if (inFileStream != null) {
                            inFileStream.close();
                        }
                        throw throwable;
                    }
                }
                var6_7 = null;
                if (inFileStream != null) {
                    inFileStream.close();
                }
            }
            Enumeration depEnum = dependencyList.elements();
            while (depEnum.hasMoreElements()) {
                String dependentClass = (String)depEnum.nextElement();
                Hashtable<String, ClassFileInfo> affectedClasses = (Hashtable<String, ClassFileInfo>)this.affectedClassMap.get(dependentClass);
                if (affectedClasses == null) {
                    affectedClasses = new Hashtable<String, ClassFileInfo>();
                    this.affectedClassMap.put(dependentClass, affectedClasses);
                }
                affectedClasses.put(info.className, info);
            }
        }
    }

    public void execute() throws BuildException {
        try {
            long start = System.currentTimeMillis();
            String[] srcPathList = this.srcPath.list();
            if (srcPathList.length == 0) {
                throw new BuildException("srcdir attribute must be set!", this.location);
            }
            if (this.destPath == null) {
                this.destPath = this.srcPath;
            }
            if (this.cache != null && this.cache.exists() && !this.cache.isDirectory()) {
                throw new BuildException("The cache, if specified, must point to a directory");
            }
            if (this.cache != null && !this.cache.exists()) {
                this.cache.mkdirs();
            }
            this.determineDependencies();
            this.outOfDateClasses = new Vector();
            int i = 0;
            while (i < srcPathList.length) {
                File srcDir = this.project.resolveFile(srcPathList[i]);
                if (srcDir.exists()) {
                    DirectoryScanner ds = this.getDirectoryScanner(srcDir);
                    String[] files = ds.getIncludedFiles();
                    this.scanDir(srcDir, files);
                }
                ++i;
            }
            this.deleteAllAffectedFiles();
            this.log("Duration = " + (System.currentTimeMillis() - start));
        }
        catch (Exception e) {
            throw new BuildException(e);
        }
    }

    private Vector getClassFiles(Path classLocations) {
        String[] classLocationsList = classLocations.list();
        Vector classFileList = new Vector();
        int i = 0;
        while (i < classLocationsList.length) {
            File dir = new File(classLocationsList[i]);
            if (dir.isDirectory()) {
                this.addClassFiles(classFileList, dir, dir);
            }
            ++i;
        }
        return classFileList;
    }

    private Vector readDependencyList(File depFile) throws IOException {
        Vector<String> dependencyList = null;
        BufferedReader in = null;
        try {
            in = new BufferedReader(new FileReader(depFile));
            String line = null;
            dependencyList = new Vector<String>();
            while ((line = in.readLine()) != null) {
                dependencyList.addElement(line);
            }
        }
        finally {
            Object var5_5 = null;
            if (in != null) {
                in.close();
            }
        }
        return dependencyList;
    }

    protected void scanDir(File srcDir, String[] files) {
        long now = System.currentTimeMillis();
        int i = 0;
        while (i < files.length) {
            File srcFile = new File(srcDir, files[i]);
            if (files[i].endsWith(".java")) {
                String filePath = srcFile.getPath();
                String className = filePath.substring(srcDir.getPath().length() + 1, filePath.length() - ".java".length());
                ClassFileInfo info = (ClassFileInfo)this.classFileInfoMap.get(className = ClassFileUtils.convertSlashName(className));
                if (info == null) {
                    this.outOfDateClasses.addElement(className);
                } else if (srcFile.lastModified() > info.absoluteFile.lastModified()) {
                    this.outOfDateClasses.addElement(className);
                }
            }
            ++i;
        }
    }

    public void setCache(File cache) {
        this.cache = cache;
    }

    public void setClosure(boolean closure) {
        this.closure = closure;
    }

    public void setDestDir(Path destPath) {
        this.destPath = destPath;
    }

    public void setSrcdir(Path srcPath) {
        this.srcPath = srcPath;
    }

    private void writeDependencyList(File depFile, Vector dependencyList) throws IOException {
        PrintWriter pw = null;
        try {
            String parent = depFile.getParent();
            if (parent != null) {
                new File(parent).mkdirs();
            }
            pw = new PrintWriter(new FileWriter(depFile));
            Enumeration deps = dependencyList.elements();
            while (deps.hasMoreElements()) {
                pw.println(deps.nextElement());
            }
        }
        finally {
            Object var5_6 = null;
            if (pw != null) {
                pw.close();
            }
        }
    }

    private static class ClassFileInfo {
        public File absoluteFile;
        public String relativeName;
        public String className;

        ClassFileInfo() {
        }
    }
}

