/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Mapper;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.MergingMapper;
import org.apache.tools.ant.util.SourceFileScanner;

public class UpToDate
extends MatchingTask {
    private String _property;
    private File _targetFile;
    private Vector sourceFileSets = new Vector();
    protected Mapper mapperElement = null;

    public void addSrcfiles(FileSet fs) {
        this.sourceFileSets.addElement(fs);
    }

    public Mapper createMapper() throws BuildException {
        if (this.mapperElement != null) {
            throw new BuildException("Cannot define more than one mapper", this.location);
        }
        this.mapperElement = new Mapper(this.project);
        return this.mapperElement;
    }

    public void execute() throws BuildException {
        if (this.sourceFileSets.size() == 0) {
            throw new BuildException("At least one <srcfiles> element must be set");
        }
        if (this._targetFile == null && this.mapperElement == null) {
            throw new BuildException("The targetfile attribute or a nested mapper element must be set");
        }
        if (this._targetFile != null && !this._targetFile.exists()) {
            return;
        }
        Enumeration enumeration = this.sourceFileSets.elements();
        boolean upToDate = true;
        while (upToDate && enumeration.hasMoreElements()) {
            FileSet fs = (FileSet)enumeration.nextElement();
            DirectoryScanner ds = fs.getDirectoryScanner(this.project);
            boolean bl = upToDate = upToDate && this.scanDir(fs.getDir(this.project), ds.getIncludedFiles());
        }
        if (upToDate) {
            this.project.setProperty(this._property, "true");
            if (this.mapperElement == null) {
                this.log("File \"" + this._targetFile.getAbsolutePath() + "\" is up to date.", 3);
            } else {
                this.log("All target files have been up to date.", 3);
            }
        }
    }

    protected boolean scanDir(File srcDir, String[] files) {
        SourceFileScanner sfs = new SourceFileScanner(this);
        FileNameMapper mapper = null;
        if (this.mapperElement == null) {
            MergingMapper mm = new MergingMapper();
            mm.setTo(this._targetFile.getAbsolutePath());
        } else {
            mapper = this.mapperElement.getImplementation();
        }
        return sfs.restrict(files, srcDir, null, mapper).length == 0;
    }

    public void setProperty(String property) {
        this._property = property;
    }

    public void setTargetFile(File file) {
        this._targetFile = file;
    }
}

