/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Hashtable;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.compiler.JavaCompiler;
import org.apache.jasper.compiler.JspParseEventListener;
import org.apache.jasper.compiler.JspReader;
import org.apache.jasper.compiler.Mangler;
import org.apache.jasper.compiler.ParseException;
import org.apache.jasper.compiler.Parser;
import org.apache.jasper.compiler.ServletWriter;

public class Compiler {
    protected JavaCompiler javac;
    protected Mangler mangler;
    protected JspCompilationContext ctxt;

    public Compiler(JspCompilationContext ctxt) {
        this.ctxt = ctxt;
    }

    public String changeEncodingIfNecessary(JspReader tmpReader) throws ParseException {
        while (tmpReader.skipUntil("<%@") != null) {
            tmpReader.skipSpaces();
            if (!tmpReader.matches("page")) continue;
            tmpReader.advance(4);
            tmpReader.skipSpaces();
            try {
                int loc;
                Hashtable attrs = tmpReader.parseTagAttributes();
                String ct = (String)attrs.get("contentType");
                if (ct == null || (loc = ct.indexOf("charset=")) <= 0) continue;
                String encoding = ct.substring(loc + 8);
                return encoding;
            }
            catch (ParseException parseException) {
                return null;
            }
        }
        return null;
    }

    public boolean compile() throws FileNotFoundException, JasperException, Exception {
        String pkgName = this.mangler.getPackageName();
        String classFileName = this.mangler.getClassFileName();
        this.ctxt.setServletPackageName(pkgName);
        Constants.message("jsp.message.package_name_is", new Object[]{pkgName == null ? "[default package]" : pkgName}, 4);
        Constants.message("jsp.message.class_file_name_is", new Object[]{classFileName}, 4);
        if (!this.isOutDated()) {
            return false;
        }
        String javaFileName = this.mangler.getJavaFileName();
        this.ctxt.setServletJavaFileName(javaFileName);
        Constants.message("jsp.message.java_file_name_is", new Object[]{javaFileName}, 4);
        String className = this.mangler.getClassName();
        this.ctxt.setServletClassName(className);
        Constants.message("jsp.message.class_name_is", new Object[]{className}, 4);
        String jspEncoding = "8859_1";
        String javaEncoding = "UTF8";
        JspReader tmpReader = JspReader.createJspReader(this.ctxt.getJspFile(), this.ctxt, jspEncoding);
        String newEncode = this.changeEncodingIfNecessary(tmpReader);
        if (newEncode != null) {
            jspEncoding = newEncode;
        }
        JspReader reader = JspReader.createJspReader(this.ctxt.getJspFile(), this.ctxt, jspEncoding);
        ServletWriter writer = new ServletWriter(new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(javaFileName), javaEncoding)));
        this.ctxt.setReader(reader);
        this.ctxt.setWriter(writer);
        JspParseEventListener listener = new JspParseEventListener(this.ctxt);
        Parser p = new Parser(reader, listener);
        listener.beginPageProcessing();
        p.parse();
        listener.endPageProcessing();
        writer.close();
        String classpath = this.ctxt.getClassPath();
        String sep = System.getProperty("path.separator");
        String[] argv = new String[]{"-encoding", javaEncoding, "-classpath", String.valueOf(System.getProperty("java.class.path")) + sep + classpath + sep + System.getProperty("tc_path_add") + sep + this.ctxt.getOutputDir(), "-d", this.ctxt.getOutputDir(), javaFileName};
        StringBuffer b = new StringBuffer();
        int i = 0;
        while (i < argv.length) {
            b.append(argv[i]);
            b.append(" ");
            ++i;
        }
        Constants.message("jsp.message.compiling_with", new Object[]{b.toString()}, 4);
        ByteArrayOutputStream out = new ByteArrayOutputStream(256);
        if (this.javac == null) {
            return true;
        }
        this.javac.setEncoding(javaEncoding);
        this.javac.setClasspath(String.valueOf(System.getProperty("java.class.path")) + sep + System.getProperty("tc_path_add") + sep + classpath + sep + this.ctxt.getOutputDir());
        this.javac.setOutputDir(this.ctxt.getOutputDir());
        this.javac.setMsgOutput(out);
        boolean status = this.javac.compile(javaFileName);
        if (!this.ctxt.keepGenerated()) {
            File javaFile = new File(javaFileName);
            javaFile.delete();
        }
        if (!status) {
            String msg = out.toString();
            throw new JasperException(String.valueOf(Constants.getString("jsp.error.unable.compile")) + msg);
        }
        String classFile = String.valueOf(this.ctxt.getOutputDir()) + File.separatorChar;
        if (pkgName != null && !pkgName.equals("")) {
            classFile = String.valueOf(classFile) + pkgName.replace('.', File.separatorChar) + File.separatorChar;
        }
        if (!(classFile = String.valueOf(classFile) + className + ".class").equals(classFileName)) {
            File classFileObject = new File(classFile);
            File myClassFileObject = new File(classFileName);
            if (myClassFileObject.exists()) {
                myClassFileObject.delete();
            }
            if (!classFileObject.renameTo(myClassFileObject)) {
                throw new JasperException(Constants.getString("jsp.error.unable.rename", new Object[]{classFileObject, myClassFileObject}));
            }
        }
        return true;
    }

    public void computeServletClassName() {
        String className = this.mangler.getClassName();
        this.ctxt.setServletClassName(className);
        Constants.message("jsp.message.class_name_is", new Object[]{className}, 4);
    }

    public boolean isOutDated() {
        return true;
    }

    public void setJavaCompiler(JavaCompiler javac) {
        this.javac = javac;
    }

    public void setMangler(Mangler mangler) {
        this.mangler = mangler;
    }
}

