/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.request;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.tomcat.core.BaseInterceptor;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.core.Response;
import org.apache.tomcat.core.TomcatException;
import org.apache.tomcat.util.SecurityTools;
import org.apache.tomcat.util.StringManager;

public class JDBCRealm
extends BaseInterceptor {
    ContextManager cm;
    int reqRolesNote;
    private Connection dbConnection = null;
    private PreparedStatement preparedAuthenticate = null;
    private PreparedStatement preparedRoles = null;
    private String connectionURL = null;
    private String connectionName = null;
    private String connectionPassword = null;
    private String userTable = null;
    private String userNameCol = null;
    private String userCredCol = null;
    private String userRoleTable = null;
    private String roleNameCol = null;
    private String driverName = null;
    private static StringManager sm = StringManager.getManager("org.apache.tomcat.request");
    private boolean started = false;

    public synchronized boolean authenticate(String username, String credentials) {
        try {
            if (this.dbConnection == null || this.dbConnection.isClosed()) {
                this.log(sm.getString("jdbcRealm.authDBClosed"));
                this.dbConnection = DriverManager.getConnection(this.connectionURL);
                if (this.dbConnection == null || this.dbConnection.isClosed()) {
                    this.log(sm.getString("jdbcRealm.authDBReOpenFail"));
                    return false;
                }
                this.dbConnection.setReadOnly(true);
            }
            if (this.preparedAuthenticate == null) {
                String sql = "SELECT " + this.userCredCol + " FROM " + this.userTable + " WHERE " + this.userNameCol + " = ?";
                if (this.debug >= 1) {
                    this.log("JDBCRealm.authenticate: " + sql);
                }
                this.preparedAuthenticate = this.dbConnection.prepareStatement(sql);
            }
            this.preparedAuthenticate.setString(1, username);
            ResultSet rs1 = this.preparedAuthenticate.executeQuery();
            boolean found = false;
            if (rs1.next() && credentials.equals(rs1.getString(1))) {
                if (this.debug >= 2) {
                    this.log(sm.getString("jdbcRealm.authenticateSuccess", username));
                }
                return true;
            }
            rs1.close();
            if (this.debug >= 2) {
                this.log(sm.getString("jdbcRealm.authenticateFailure", username));
            }
            return false;
        }
        catch (SQLException ex) {
            this.log(sm.getString("jdbcRealm.authenticateSQLException", username));
            this.log("SQLException: " + ex);
            if (this.preparedAuthenticate != null) {
                try {
                    this.preparedAuthenticate.close();
                }
                catch (Throwable throwable) {}
                this.preparedAuthenticate = null;
            }
            if (this.dbConnection != null) {
                try {
                    this.dbConnection.close();
                }
                catch (Throwable throwable) {}
                this.dbConnection = null;
            }
            return false;
        }
    }

    public int authenticate(Request req, Response response) {
        Hashtable cred = new Hashtable();
        SecurityTools.credentials(req, cred);
        String user = (String)cred.get("username");
        String password = (String)cred.get("password");
        if (this.authenticate(user, password)) {
            if (this.debug > 0) {
                this.log("Auth ok, user=" + user);
            }
            req.setRemoteUser(user);
            Context ctx = req.getContext();
            if (ctx != null) {
                req.setAuthType(ctx.getAuthMethod());
            }
        }
        return 0;
    }

    public int authorize(Request req, Response response, String[] roles) {
        if (roles == null) {
            return 0;
        }
        Context ctx = req.getContext();
        String[] userRoles = null;
        String user = req.getRemoteUser();
        if (user == null) {
            return 401;
        }
        if (this.debug > 0) {
            this.log("Controled access for " + user + " " + req + " " + req.getContainer());
        }
        userRoles = this.getUserRoles(user);
        req.setUserRoles(userRoles);
        if (this.debug > 0) {
            if (userRoles != null && userRoles.length > 0) {
                this.log("Auth ok, first role=" + userRoles[0]);
            } else {
                this.log("Auth ok, user has no roles");
            }
        }
        if (SecurityTools.haveRole(userRoles, roles)) {
            return 0;
        }
        if (this.debug > 0) {
            if (roles != null && roles.length > 0) {
                this.log("UnAuthorized " + roles[0]);
            } else {
                this.log("UnAuthorized - no roles specified");
            }
        }
        return 401;
    }

    public void contextInit(Context ctx) throws TomcatException {
        if (!this.started) {
            this.started = true;
            try {
                Class.forName(this.driverName);
                this.dbConnection = (this.connectionName == null || this.connectionName.equals("")) && (this.connectionPassword == null || this.connectionPassword.equals("")) ? DriverManager.getConnection(this.connectionURL) : DriverManager.getConnection(this.connectionURL, this.connectionName, this.connectionPassword);
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException("JDBCRealm.start.readXml: " + ex);
            }
            catch (SQLException ex) {
                throw new RuntimeException("JDBCRealm.start.readXml: " + ex);
            }
        }
    }

    public void contextShutdown(Context ctx) throws TomcatException {
        block2: {
            if (!this.started || this.dbConnection == null) break block2;
            try {
                this.dbConnection.close();
            }
            catch (SQLException sQLException) {
                this.log("dbConnection.close Exception!!!");
            }
        }
    }

    public synchronized String[] getUserRoles(String username) {
        try {
            if (this.dbConnection == null || this.dbConnection.isClosed()) {
                this.log(sm.getString("jdbcRealm.getUserRolesDBClosed"));
                this.dbConnection = DriverManager.getConnection(this.connectionURL);
                if (this.dbConnection == null || this.dbConnection.isClosed()) {
                    this.log(sm.getString("jdbcRealm.getUserRolesDBReOpenFail"));
                    return null;
                }
            }
            if (this.preparedRoles == null) {
                String sql = "SELECT " + this.roleNameCol + " FROM " + this.userRoleTable + " WHERE " + this.userNameCol + " = ?";
                if (this.debug >= 1) {
                    this.log("JDBCRealm.roles: " + sql);
                }
                this.preparedRoles = this.dbConnection.prepareStatement(sql);
            }
            this.preparedRoles.clearParameters();
            this.preparedRoles.setString(1, username);
            ResultSet rs = this.preparedRoles.executeQuery();
            Vector<String> vrol = new Vector<String>();
            while (rs.next()) {
                vrol.addElement(rs.getString(1));
            }
            String[] res = new String[vrol.size()];
            int i = 0;
            while (i < vrol.size()) {
                res[i] = (String)vrol.elementAt(i);
                ++i;
            }
            return res;
        }
        catch (SQLException ex) {
            this.log(sm.getString("jdbcRealm.getUserRolesSQLException", username));
            this.log("SQLException: " + ex);
            if (this.preparedRoles != null) {
                try {
                    this.preparedRoles.close();
                }
                catch (Throwable throwable) {}
                this.preparedRoles = null;
            }
            if (this.dbConnection != null) {
                try {
                    this.dbConnection.close();
                }
                catch (Throwable throwable) {}
                this.dbConnection = null;
            }
            return null;
        }
    }

    public void setConnectionName(String connectionName) {
        this.connectionName = connectionName;
    }

    public void setConnectionPassword(String connectionPassword) {
        this.connectionPassword = connectionPassword;
    }

    public void setConnectionURL(String connectionURL) {
        this.connectionURL = connectionURL;
    }

    public void setContextManager(ContextManager cm) {
        super.setContextManager(cm);
        this.cm = cm;
        try {
            this.reqRolesNote = cm.getNoteId(2, "required.roles");
        }
        catch (TomcatException ex) {
            ex.printStackTrace();
            throw new RuntimeException("Invalid state ");
        }
    }

    public void setDriverName(String driverName) {
        this.driverName = driverName;
    }

    public void setRoleNameCol(String roleNameCol) {
        this.roleNameCol = roleNameCol;
    }

    public void setUserCredCol(String userCredCol) {
        this.userCredCol = userCredCol;
    }

    public void setUserNameCol(String userNameCol) {
        this.userNameCol = userNameCol;
    }

    public void setUserRoleTable(String userRoleTable) {
        this.userRoleTable = userRoleTable;
    }

    public void setUserTable(String userTable) {
        this.userTable = userTable;
    }
}

