/*
 * Decompiled with CFR 0.152.
 */
package fr.jayasoft.ivy.ant;

import fr.jayasoft.ivy.DefaultPublishingDRResolver;
import fr.jayasoft.ivy.Ivy;
import fr.jayasoft.ivy.IvyContext;
import fr.jayasoft.ivy.ModuleDescriptor;
import fr.jayasoft.ivy.ModuleRevisionId;
import fr.jayasoft.ivy.ant.IvyTask;
import fr.jayasoft.ivy.status.StatusManager;
import fr.jayasoft.ivy.util.Message;
import fr.jayasoft.ivy.util.MessageImpl;
import java.io.File;
import java.util.Date;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.CallTarget;
import org.apache.tools.ant.taskdefs.Echo;
import org.apache.tools.ant.taskdefs.Input;
import org.apache.tools.ant.taskdefs.Property;

public class IvyDeliver
extends IvyTask {
    private String _organisation;
    private String _module;
    private String _revision;
    private String _pubRevision;
    private File _cache;
    private String _deliverpattern;
    private String _status;
    private String _pubdate;
    private String _deliverTarget;
    private File _deliveryList;
    private boolean _replacedynamicrev = true;

    public File getCache() {
        return this._cache;
    }

    public void setCache(File cache) {
        this._cache = cache;
    }

    public String getDeliverpattern() {
        return this._deliverpattern;
    }

    public void setDeliverpattern(String destivypattern) {
        this._deliverpattern = destivypattern;
    }

    public String getModule() {
        return this._module;
    }

    public void setModule(String module) {
        this._module = module;
    }

    public String getOrganisation() {
        return this._organisation;
    }

    public void setOrganisation(String organisation) {
        this._organisation = organisation;
    }

    public String getPubdate() {
        return this._pubdate;
    }

    public void setPubdate(String pubdate) {
        this._pubdate = pubdate;
    }

    public String getPubrevision() {
        return this._pubRevision;
    }

    public void setPubrevision(String pubRevision) {
        this._pubRevision = pubRevision;
    }

    public String getRevision() {
        return this._revision;
    }

    public void setRevision(String revision) {
        this._revision = revision;
    }

    public String getStatus() {
        return this._status;
    }

    public void setStatus(String status) {
        this._status = status;
    }

    public void setDelivertarget(String deliverTarget) {
        this._deliverTarget = deliverTarget;
    }

    public void setDeliveryList(File deliveryList) {
        this._deliveryList = deliveryList;
    }

    public boolean isReplacedynamicrev() {
        return this._replacedynamicrev;
    }

    public void setReplacedynamicrev(boolean replacedynamicrev) {
        this._replacedynamicrev = replacedynamicrev;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws BuildException {
        Ivy ivy = this.getIvyInstance();
        this._organisation = this.getProperty(this._organisation, ivy, "ivy.organisation");
        this._module = this.getProperty(this._module, ivy, "ivy.module");
        this._revision = this.getProperty(this._revision, ivy, "ivy.revision");
        this._pubRevision = this.getProperty(this._pubRevision, ivy, "ivy.deliver.revision");
        if (this._cache == null) {
            this._cache = ivy.getDefaultCache();
        }
        this._deliverpattern = this.getProperty(this._deliverpattern, ivy, "ivy.deliver.ivy.pattern");
        this._status = this.getProperty(this._status, ivy, "ivy.status");
        if (this._deliveryList == null) {
            String deliveryListPath = this.getProperty(ivy, "ivy.delivery.list.file");
            this._deliveryList = deliveryListPath == null ? new File(System.getProperty("java.io.tmpdir") + "/delivery.properties") : this.getProject().resolveFile(ivy.substitute(deliveryListPath));
        }
        if (this._organisation == null) {
            throw new BuildException("no organisation provided for ivy deliver task: It can either be set explicitely via the attribute 'organisation' or via 'ivy.organisation' property or a prior call to <resolve/>");
        }
        if (this._module == null) {
            throw new BuildException("no module name provided for ivy deliver task: It can either be set explicitely via the attribute 'module' or via 'ivy.module' property or a prior call to <resolve/>");
        }
        if (this._revision == null) {
            this._revision = "working@" + Ivy.getLocalHostName();
        }
        Date pubdate = this.getPubDate(this._pubdate, new Date());
        if (this._pubRevision == null) {
            this._pubRevision = this._revision.startsWith("working@") ? Ivy.DATE_FORMAT.format(pubdate) : this._revision;
        }
        if (this._deliverpattern == null) {
            throw new BuildException("deliver ivy pattern is missing: either provide it as parameters or through ivy.deliver.ivy.pattern properties");
        }
        if (this._status == null) {
            throw new BuildException("no status provided: either provide it as parameter or through the ivy.status.default property");
        }
        ModuleRevisionId mrid = ModuleRevisionId.newInstance(this._organisation, this._module, this._revision);
        boolean isLeading = false;
        try {
            try {
                if (!this._deliveryList.exists()) {
                    isLeading = true;
                }
                this.loadDeliveryList();
                DefaultPublishingDRResolver drResolver = this._deliverTarget != null && this._deliverTarget.trim().length() > 0 ? new DeliverDRResolver() : new DefaultPublishingDRResolver();
                ivy.deliver(mrid, this._pubRevision, this._cache, this._deliverpattern, this._status, pubdate, drResolver, this.doValidate(ivy), this._replacedynamicrev);
            }
            catch (Exception e) {
                throw new BuildException("impossible to deliver " + mrid + ": " + e, (Throwable)e);
            }
            Object var7_7 = null;
            if (!isLeading) return;
            if (!this._deliveryList.exists()) return;
            this._deliveryList.delete();
            return;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (!isLeading) throw throwable;
            if (!this._deliveryList.exists()) throw throwable;
            this._deliveryList.delete();
            throw throwable;
        }
    }

    private void loadDeliveryList() {
        Property property = (Property)this.getProject().createTask("property");
        property.setOwningTarget(this.getOwningTarget());
        property.init();
        property.setFile(this._deliveryList);
        property.perform();
    }

    private void appendDeliveryList(String msg) {
        Echo echo = (Echo)this.getProject().createTask("echo");
        echo.setOwningTarget(this.getOwningTarget());
        echo.init();
        echo.setFile(this._deliveryList);
        echo.setMessage(msg + "\n");
        echo.setAppend(true);
        echo.perform();
    }

    private final class DeliverDRResolver
    extends DefaultPublishingDRResolver {
        private DeliverDRResolver() {
        }

        public String resolve(ModuleDescriptor published, String publishedStatus, ModuleRevisionId depMrid, String depStatus) {
            if (StatusManager.getCurrent().isIntegration(publishedStatus)) {
                return super.resolve(published, publishedStatus, depMrid, depStatus);
            }
            if (!StatusManager.getCurrent().isIntegration(depStatus)) {
                return super.resolve(published, publishedStatus, depMrid, depStatus);
            }
            String statusProperty = depMrid.getName() + "." + depMrid.getRevision() + ".status";
            String versionProperty = depMrid.getName() + "." + depMrid.getRevision() + ".version";
            String deliveredProperty = depMrid.getName() + "." + depMrid.getRevision() + ".delivered";
            String version = IvyDeliver.this.getProject().getProperty(versionProperty);
            String status = IvyDeliver.this.getProject().getProperty(statusProperty);
            String delivered = IvyDeliver.this.getProject().getProperty(deliveredProperty);
            Message.debug("found version = " + version + " status=" + status + " delivered=" + delivered);
            if (version != null && status != null) {
                if ("true".equals(delivered)) {
                    return version;
                }
                this.deliverDependency(depMrid, version, status, depStatus);
                IvyDeliver.this.loadDeliveryList();
                return version;
            }
            String globalStatusProperty = "recursive.delivery.status";
            String globalVersionProperty = "recursive.delivery.version";
            version = IvyDeliver.this.getProject().getProperty(globalVersionProperty);
            status = IvyDeliver.this.getProject().getProperty(globalStatusProperty);
            if (version != null && status != null) {
                delivered = IvyDeliver.this.getProject().getProperty("recursive." + depMrid.getName() + ".delivered");
                Message.debug("found global version = " + version + " and global status=" + status + " - delivered = " + delivered);
                if ("true".equals(delivered)) {
                    return version;
                }
                IvyDeliver.this.getProject().setProperty(statusProperty, status);
                this.deliverDependency(depMrid, version, status, depStatus);
                IvyDeliver.this.loadDeliveryList();
                return version;
            }
            Input input = (Input)IvyDeliver.this.getProject().createTask("input");
            input.setOwningTarget(IvyDeliver.this.getOwningTarget());
            input.init();
            input.setMessage(depMrid.getName() + " " + depMrid.getRevision() + ": please enter a status: ");
            input.setValidargs(StatusManager.getCurrent().getDeliveryStatusListString());
            input.setAddproperty(statusProperty);
            input.perform();
            status = IvyDeliver.this.getProject().getProperty(statusProperty);
            IvyDeliver.this.appendDeliveryList(statusProperty + " = " + status);
            input.setMessage(depMrid.getName() + " " + depMrid.getRevision() + ": please enter a version: ");
            input.setValidargs(null);
            input.setAddproperty(versionProperty);
            input.perform();
            version = IvyDeliver.this.getProject().getProperty(versionProperty);
            IvyDeliver.this.appendDeliveryList(versionProperty + " = " + version);
            this.deliverDependency(depMrid, version, status, depStatus);
            IvyDeliver.this.loadDeliveryList();
            return version;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void deliverDependency(ModuleRevisionId depMrid, String version, String status, String depStatus) {
            if (IvyDeliver.this._deliverTarget != null && IvyDeliver.this._deliverTarget.trim().length() > 0) {
                CallTarget ct = (CallTarget)IvyDeliver.this.getProject().createTask("antcall");
                ct.setOwningTarget(IvyDeliver.this.getOwningTarget());
                ct.init();
                ct.setTarget(IvyDeliver.this._deliverTarget);
                ct.setInheritAll(true);
                ct.setInheritRefs(true);
                Property param = ct.createParam();
                param.setName("dependency.name");
                param.setValue(depMrid.getName());
                param = ct.createParam();
                param.setName("dependency.published.status");
                param.setValue(status);
                param = ct.createParam();
                param.setName("dependency.published.version");
                param.setValue(version);
                param = ct.createParam();
                param.setName("dependency.version");
                param.setValue(depMrid.getRevision());
                param = ct.createParam();
                param.setName("dependency.status");
                param.setValue(depStatus == null ? "null" : depStatus);
                MessageImpl impl = IvyContext.getContext().getMessageImpl();
                try {
                    IvyContext.getContext().setMessageImpl(null);
                    ct.perform();
                }
                finally {
                    IvyContext.getContext().setMessageImpl(impl);
                }
                String deliveredProperty = depMrid.getName() + "." + depMrid.getRevision() + ".delivered";
                IvyDeliver.this.getProject().setProperty(deliveredProperty, "true");
                IvyDeliver.this.appendDeliveryList(deliveredProperty + " = true");
                IvyDeliver.this.getProject().setProperty("recursive." + depMrid.getName() + ".delivered", "true");
                IvyDeliver.this.appendDeliveryList("recursive." + depMrid.getName() + ".delivered" + " = true");
            }
        }
    }
}

