/*
 * ircaux.h: header file for ircaux.c 
 *
 * Written By Michael Sandrof
 *
 * Copyright (c) 1990 Michael Sandrof.
 * Copyright (c) 1991, 1992 Troy Rollo.
 * Copyright (c) 1992-2001 Matthew R. Green.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * @(#)$eterna: ircaux.h,v 1.25 2001/08/12 16:24:52 mrg Exp $
 */

#ifndef __ircaux_h_
#define __ircaux_h_

#include <stdio.h>

	u_char	*next_arg _((u_char *, u_char **));
	u_char	*new_next_arg _((u_char *, u_char **));
	u_char	*expand_twiddle _((u_char *));
	u_char	*upper _((u_char *));
	u_char	*lower _((u_char *));
	u_char	*sindex _((u_char *, u_char *));
	u_char	*srindex _((u_char *, u_char *));
	char	*rfgets _((char *, int, FILE *));
	u_char	*path_search _((u_char *, u_char *));
	u_char	*double_quote _((u_char *, u_char *));
	u_char	*new_malloc _((size_t));
#ifdef ALLOC_DEBUG
	void	alloc_cmd _((u_char *, u_char *, u_char *));
#endif /* ALLOC_DEBUG */
	u_char	*new_realloc _((u_char *, size_t));
	void	malloc_strcpy _((u_char **, u_char *));
	void	malloc_strcat _((u_char **, u_char *));
	void	malloc_strcat_ue _((u_char **, u_char *));
	void	new_free _((void *));
	void	wait_new_free _((u_char **));
	FILE	*zcat _((u_char *));
	int	is_number _((u_char *));
	int	connect_by_number _((int, u_char *, int));
	int	my_stricmp _((u_char *, u_char *));
	int	my_strnicmp _((u_char *, u_char *, size_t));
	int	set_non_blocking _((int));
	int	set_blocking _((int));
	int	scanstr _((u_char *, u_char *));
	void	really_free _((int));
	void	strmcpy _((u_char *, u_char *, size_t));
	void	strmcat _((u_char *, u_char *, size_t));
	void	strmcat_ue _((u_char *, u_char *, size_t));
	void	new_stty _((u_char *));

#endif /* __ircaux_h_ */
