#include <stdlib.h>
#ifndef lint
#ifdef __unused
__unused
#endif
static char const 
yyrcsid[] = "$FreeBSD: src/usr.bin/yacc/skeleton.c,v 1.37 2003/02/12 18:03:55 davidc Exp $";
#endif
#define YYBYACC 1
#define YYMAJOR 1
#define YYMINOR 9
#define YYLEX yylex()
#define YYEMPTY -1
#define yyclearin (yychar=(YYEMPTY))
#define yyerrok (yyerrflag=0)
#define YYRECOVERING() (yyerrflag!=0)
#if defined(__cplusplus) || __STDC__
static int yygrowstack(void);
#else
static int yygrowstack();
#endif
#define YYPREFIX "yy"
#line 26 "ircd_parser.y"

#define YY_NO_UNPUT
#include <sys/types.h>

#include "stdinc.h"
#include "ircd.h"
#include "tools.h"
#include "list.h"
#include "s_conf.h"
#include "event.h"
#include "s_log.h"
#include "client.h"	/* for UMODE_ALL only */
#include "pcre.h"
#include "irc_string.h"
#include "irc_getaddrinfo.h"
#include "sprintf_irc.h"
#include "memory.h"
#include "modules.h"
#include "s_serv.h" /* for CAP_LL / IsCapable */
#include "hostmask.h"
#include "send.h"
#include "listener.h"
#include "resv.h"
#include "numeric.h"
#include "s_user.h"

#ifdef HAVE_LIBCRYPTO
#include <openssl/rsa.h>
#include <openssl/bio.h>
#include <openssl/pem.h>
#endif

static char *class_name = NULL;
static struct ConfItem *yy_conf = NULL;
static struct AccessItem *yy_aconf = NULL;
static struct MatchItem *yy_match_item = NULL;
static struct ClassItem *yy_class = NULL;
static char *yy_class_name = NULL;

static dlink_list col_conf_list  = { NULL, NULL, 0 };
static dlink_list hub_conf_list  = { NULL, NULL, 0 };
static dlink_list leaf_conf_list = { NULL, NULL, 0 };
static unsigned int listener_flags = 0;
static unsigned int regex_ban = 0;
static char userbuf[IRCD_BUFSIZE];
static char hostbuf[IRCD_BUFSIZE];
static char reasonbuf[REASONLEN + 1];
static char gecos_name[REALLEN * 4];

extern dlink_list gdeny_items; /* XXX */

static char *resv_reason = NULL;
static char *listener_address = NULL;
static int not_atom = 0;

struct CollectItem
{
  dlink_node node;
  char *name;
  char *user;
  char *host;
  char *passwd;
  int  port;
  int  flags;
#ifdef HAVE_LIBCRYPTO
  char *rsa_public_key_file;
  RSA *rsa_public_key;
#endif
};

static void
free_collect_item(struct CollectItem *item)
{
  MyFree(item->name);
  MyFree(item->user);
  MyFree(item->host);
  MyFree(item->passwd);
#ifdef HAVE_LIBCRYPTO
  MyFree(item->rsa_public_key_file);
#endif
  MyFree(item);
}

static void
unhook_hub_leaf_confs(void)
{
  dlink_node *ptr;
  dlink_node *next_ptr;
  struct CollectItem *yy_hconf;
  struct CollectItem *yy_lconf;

  DLINK_FOREACH_SAFE(ptr, next_ptr, hub_conf_list.head)
  {
    yy_hconf = ptr->data;
    dlinkDelete(&yy_hconf->node, &hub_conf_list);
    free_collect_item(yy_hconf);
  }

  DLINK_FOREACH_SAFE(ptr, next_ptr, leaf_conf_list.head)
  {
    yy_lconf = ptr->data;
    dlinkDelete(&yy_lconf->node, &leaf_conf_list);
    free_collect_item(yy_lconf);
  }
}

#line 134 "ircd_parser.y"
typedef union {
  int number;
  char *string;
} YYSTYPE;
#line 136 "y.tab.c"
#define YYERRCODE 256
#define ACCEPT_PASSWORD 257
#define ACTION 258
#define ADMIN 259
#define AFTYPE 260
#define T_ALLOW 261
#define ANTI_NICK_FLOOD 262
#define ANTI_SPAM_EXIT_MESSAGE_TIME 263
#define AUTOCONN 264
#define T_BLOCK 265
#define BURST_AWAY 266
#define BURST_TOPICWHO 267
#define BYTES 268
#define KBYTES 269
#define MBYTES 270
#define GBYTES 271
#define TBYTES 272
#define CALLER_ID_WAIT 273
#define CAN_FLOOD 274
#define CAN_IDLE 275
#define CHANNEL 276
#define CIDR_BITLEN_IPV4 277
#define CIDR_BITLEN_IPV6 278
#define CIPHER_PREFERENCE 279
#define CLASS 280
#define COMPRESSED 281
#define COMPRESSION_LEVEL 282
#define CONNECT 283
#define CONNECTFREQ 284
#define CRYPTLINK 285
#define DEFAULT_CIPHER_PREFERENCE 286
#define DEFAULT_FLOODCOUNT 287
#define DEFAULT_SPLIT_SERVER_COUNT 288
#define DEFAULT_SPLIT_USER_COUNT 289
#define DENY 290
#define DESCRIPTION 291
#define DIE 292
#define DISABLE_AUTH 293
#define DISABLE_FAKE_CHANNELS 294
#define DISABLE_HIDDEN 295
#define DISABLE_LOCAL_CHANNELS 296
#define DISABLE_REMOTE_COMMANDS 297
#define DOT_IN_IP6_ADDR 298
#define DOTS_IN_IDENT 299
#define DURATION 300
#define EGDPOOL_PATH 301
#define EMAIL 302
#define ENABLE 303
#define ENCRYPTED 304
#define EXCEED_LIMIT 305
#define EXEMPT 306
#define FAILED_OPER_NOTICE 307
#define FAKENAME 308
#define IRCD_FLAGS 309
#define FLATTEN_LINKS 310
#define FFAILED_OPERLOG 311
#define FKILLLOG 312
#define FKLINELOG 313
#define FGLINELOG 314
#define FIOERRLOG 315
#define FOPERLOG 316
#define FOPERSPYLOG 317
#define FUSERLOG 318
#define GECOS 319
#define GENERAL 320
#define GLINE 321
#define GLINES 322
#define GLINE_EXEMPT 323
#define GLINE_LOG 324
#define GLINE_TIME 325
#define GLINE_MIN_CIDR 326
#define GLINE_MIN_CIDR6 327
#define GLOBAL_KILL 328
#define IRCD_AUTH 329
#define NEED_IDENT 330
#define HAVENT_READ_CONF 331
#define HIDDEN 332
#define HIDDEN_ADMIN 333
#define HIDDEN_NAME 334
#define HIDDEN_OPER 335
#define HIDE_SERVER_IPS 336
#define HIDE_SERVERS 337
#define HIDE_SPOOF_IPS 338
#define HOST 339
#define HUB 340
#define HUB_MASK 341
#define IDLETIME 342
#define IGNORE_BOGUS_TS 343
#define INVISIBLE_ON_CONNECT 344
#define IP 345
#define KILL 346
#define KILL_CHASE_TIME_LIMIT 347
#define KLINE 348
#define KLINE_EXEMPT 349
#define KLINE_REASON 350
#define KLINE_WITH_REASON 351
#define KNOCK_DELAY 352
#define KNOCK_DELAY_CHANNEL 353
#define LAZYLINK 354
#define LEAF_MASK 355
#define LINKS_DELAY 356
#define LISTEN 357
#define T_LOG 358
#define LOGGING 359
#define LOG_LEVEL 360
#define MAX_ACCEPT 361
#define MAX_BANS 362
#define MAX_CHANS_PER_USER 363
#define MAX_GLOBAL 364
#define MAX_IDENT 365
#define MAX_LOCAL 366
#define MAX_NICK_CHANGES 367
#define MAX_NICK_TIME 368
#define MAX_NUMBER 369
#define MAX_TARGETS 370
#define MESSAGE_LOCALE 371
#define MIN_NONWILDCARD 372
#define MIN_NONWILDCARD_SIMPLE 373
#define MODULE 374
#define MODULES 375
#define NAME 376
#define NEED_PASSWORD 377
#define NETWORK_DESC 378
#define NETWORK_NAME 379
#define NICK 380
#define NICK_CHANGES 381
#define NO_CREATE_ON_SPLIT 382
#define NO_JOIN_ON_SPLIT 383
#define NO_OPER_FLOOD 384
#define NO_TILDE 385
#define NOT 386
#define NUMBER 387
#define NUMBER_PER_IDENT 388
#define NUMBER_PER_CIDR 389
#define NUMBER_PER_IP 390
#define NUMBER_PER_IP_GLOBAL 391
#define OPERATOR 392
#define OPERS_BYPASS_CALLERID 393
#define OPER_LOG 394
#define OPER_ONLY_UMODES 395
#define OPER_PASS_RESV 396
#define OPER_SPY_T 397
#define OPER_UMODES 398
#define JOIN_FLOOD_COUNT 399
#define JOIN_FLOOD_TIME 400
#define PACE_WAIT 401
#define PACE_WAIT_SIMPLE 402
#define PASSWORD 403
#define PATH 404
#define PING_COOKIE 405
#define PING_TIME 406
#define PING_WARNING 407
#define PORT 408
#define QSTRING 409
#define QUIET_ON_BAN 410
#define REASON 411
#define REDIRPORT 412
#define REDIRSERV 413
#define REGEX_T 414
#define REHASH 415
#define TREJECT_HOLD_TIME 416
#define REMOTE 417
#define REMOTEBAN 418
#define RESTRICT_CHANNELS 419
#define RESTRICTED 420
#define RSA_PRIVATE_KEY_FILE 421
#define RSA_PUBLIC_KEY_FILE 422
#define SSL_CERTIFICATE_FILE 423
#define RESV 424
#define RESV_EXEMPT 425
#define SECONDS 426
#define MINUTES 427
#define HOURS 428
#define DAYS 429
#define WEEKS 430
#define SENDQ 431
#define SEND_PASSWORD 432
#define SERVERHIDE 433
#define SERVERINFO 434
#define SERVLINK_PATH 435
#define IRCD_SID 436
#define TKLINE_EXPIRE_NOTICES 437
#define T_SHARED 438
#define T_CLUSTER 439
#define TYPE 440
#define SHORT_MOTD 441
#define SILENT 442
#define SPOOF 443
#define SPOOF_NOTICE 444
#define STATS_E_DISABLED 445
#define STATS_I_OPER_ONLY 446
#define STATS_K_OPER_ONLY 447
#define STATS_O_OPER_ONLY 448
#define STATS_P_OPER_ONLY 449
#define TBOOL 450
#define TMASKED 451
#define T_REJECT 452
#define TS_MAX_DELTA 453
#define TS_WARN_DELTA 454
#define TWODOTS 455
#define T_ALL 456
#define T_BOTS 457
#define T_SOFTCALLERID 458
#define T_CALLERID 459
#define T_CCONN 460
#define T_CCONN_FULL 461
#define T_CLIENT_FLOOD 462
#define T_DEAF 463
#define T_DEBUG 464
#define T_DRONE 465
#define T_EXTERNAL 466
#define T_FULL 467
#define T_INVISIBLE 468
#define T_IPV4 469
#define T_IPV6 470
#define T_LOCOPS 471
#define T_LOGPATH 472
#define T_L_CRIT 473
#define T_L_DEBUG 474
#define T_L_ERROR 475
#define T_L_INFO 476
#define T_L_NOTICE 477
#define T_L_TRACE 478
#define T_L_WARN 479
#define T_MAX_CLIENTS 480
#define T_NCHANGE 481
#define T_OPERWALL 482
#define T_REJ 483
#define T_SERVNOTICE 484
#define T_SKILL 485
#define T_SPY 486
#define T_SSL 487
#define T_UMODES 488
#define T_UNAUTH 489
#define T_UNRESV 490
#define T_UNXLINE 491
#define T_WALLOP 492
#define THROTTLE_TIME 493
#define TOPICBURST 494
#define TRUE_NO_OPER_FLOOD 495
#define TKLINE 496
#define TXLINE 497
#define TRESV 498
#define UNKLINE 499
#define USER 500
#define USE_EGD 501
#define USE_EXCEPT 502
#define USE_INVEX 503
#define USE_KNOCK 504
#define USE_LOGGING 505
#define USE_WHOIS_ACTUALLY 506
#define VHOST 507
#define VHOST6 508
#define XLINE 509
#define WARN 510
#define WARN_NO_NLINE 511
const short yylhs[] = {                                        -1,
    0,    0,    5,    5,    5,    5,    5,    5,    5,    5,
    5,    5,    5,    5,    5,    5,    5,    5,    5,    5,
    5,    5,    5,    5,    2,    2,    1,    1,    1,    1,
    1,    1,    4,    4,    3,    3,    3,    3,   25,   26,
   26,   27,   27,   27,   28,   29,   13,   30,   30,   31,
   31,   31,   31,   31,   31,   31,   31,   31,   31,   31,
   31,   42,   39,   32,   41,   35,   36,   37,   33,   40,
   38,   34,    6,   43,   43,   44,   44,   44,   44,   45,
   47,   46,    7,   48,   48,   49,   49,   49,   49,   49,
   49,   49,   49,   49,   49,   49,   49,   49,   50,   51,
   54,   61,   55,   59,   56,   57,   60,   58,   52,   52,
   52,   52,   52,   52,   52,   53,   63,    8,   62,   62,
   64,   64,   66,   66,   66,   66,   66,   66,   66,   66,
   66,   66,   66,   66,   66,   66,   66,   66,   66,   66,
   66,   66,   66,   66,   66,   67,   65,   68,   69,   86,
   87,   73,   89,   72,   90,   90,   91,   91,   91,   91,
   91,   91,   91,   91,   91,   91,   91,   91,   91,   91,
   91,   91,   91,   91,   91,   74,   75,   81,   76,   77,
   78,   79,   80,   82,   83,   84,   70,   71,   85,   92,
   88,   93,   93,   96,   94,   97,   94,   95,   95,   95,
   95,   95,   95,   95,   95,   95,   95,   95,   95,   95,
   95,   95,   95,   99,   10,   98,   98,  100,  100,  102,
  102,  102,  102,  102,  102,  102,  102,  102,  102,  102,
  102,  102,  102,  103,  101,  106,  107,  109,  110,  111,
  112,  113,  114,  115,  104,  105,  108,  116,   11,  119,
  118,  120,  120,  121,  121,  117,  117,  122,  122,  122,
  122,  122,  127,  123,  126,  126,  128,  128,  124,  125,
  129,   12,  130,  130,  131,  131,  131,  131,  131,  131,
  131,  131,  131,  131,  131,  131,  131,  131,  131,  131,
  131,  132,  133,  142,  134,  147,  148,  135,  149,  149,
  152,  150,  153,  150,  151,  151,  151,  151,  151,  151,
  151,  151,  151,  151,  136,  137,  138,  145,  139,  140,
  141,  143,  144,  146,  154,   15,  155,  155,  156,  156,
  156,  156,  157,  158,  159,  160,   16,  161,  161,  162,
  162,  162,  162,  163,  164,  166,  165,  167,  167,  168,
  168,  168,  168,  168,  168,  168,  168,  168,  168,  168,
  169,   17,  170,  170,  171,  171,  171,  172,  174,  173,
  175,  175,  176,  176,  176,  176,  176,  176,  176,  176,
  176,  176,  176,  178,   18,  177,  177,  179,  179,  181,
  181,  181,  181,  181,  181,  181,  181,  181,  181,  181,
  181,  181,  181,  181,  181,  181,  181,  181,  181,  182,
  180,  183,  184,  185,  186,  188,  187,  187,  189,  201,
  190,  202,  202,  205,  203,  206,  203,  204,  204,  204,
  204,  204,  204,  198,  195,  197,  196,  194,  200,  191,
  192,  193,  199,  207,   19,  210,  209,  211,  211,  212,
  208,  208,  213,  213,  213,  213,  214,  215,  216,   20,
  217,  217,  218,  218,  218,  219,  220,   21,  221,  221,
  222,  222,  223,  224,   24,  227,  226,  228,  228,  229,
  225,  225,  230,  230,  230,  230,  231,  232,   22,  233,
  233,  234,  234,  234,  234,  234,  234,  234,  234,  234,
  234,  234,  234,  234,  234,  234,  234,  234,  234,  234,
  234,  234,  234,  234,  234,  234,  234,  234,  234,  234,
  234,  234,  234,  234,  234,  234,  234,  234,  234,  234,
  234,  234,  234,  234,  234,  234,  234,  234,  234,  234,
  234,  234,  234,  234,  234,  234,  234,  285,  286,  283,
  287,  288,  284,  245,  235,  236,  274,  237,  238,  239,
  240,  241,  242,  243,  244,  279,  246,  247,  248,  249,
  289,  251,  256,  252,  252,  254,  254,  253,  268,  269,
  255,  257,  258,  259,  260,  262,  261,  250,  264,  273,
  275,  276,  265,  266,  281,  282,  278,  290,  267,  291,
  291,  292,  292,  292,  292,  292,  292,  292,  292,  292,
  292,  292,  292,  292,  292,  292,  292,  292,  292,  292,
  293,  263,  294,  294,  295,  295,  295,  295,  295,  295,
  295,  295,  295,  295,  295,  295,  295,  295,  295,  295,
  295,  295,  295,  271,  272,  270,  277,  280,  296,   23,
  297,  297,  298,  298,  298,  298,  298,  298,  298,  299,
  300,  305,  301,  306,  306,  307,  307,  302,  303,  308,
  304,  309,  309,  310,  310,    9,  311,  311,  312,  312,
  312,  312,  312,  312,  312,  312,  312,  312,  312,  312,
  312,  312,  312,  312,  312,  312,  312,  330,  325,  313,
  314,  315,  316,  318,  319,  320,  321,  317,  322,  323,
  324,  326,  327,  328,  329,   14,  331,  331,  332,  332,
  332,  332,  332,  332,  332,  332,  333,  334,  338,  335,
  337,  336,  339,
};
const short yylen[] = {                                         2,
    0,    2,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    2,    2,    0,    1,    2,    3,    3,    3,
    3,    3,    0,    1,    2,    3,    3,    3,    5,    2,
    1,    1,    1,    2,    4,    4,    5,    2,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    2,    4,    4,    4,    4,    4,    4,    4,    4,    4,
    4,    4,    5,    2,    1,    1,    1,    1,    2,    4,
    4,    4,    5,    2,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    2,    4,    4,
    4,    4,    4,    4,    4,    4,    4,    4,    4,    4,
    4,    4,    4,    4,    4,    4,    0,    7,    0,    1,
    2,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    2,    4,    1,    4,    4,    4,
    4,    4,    0,    5,    3,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    4,    4,    4,    4,    4,
    4,    4,    4,    4,    4,    4,    4,    4,    4,    0,
    5,    3,    1,    0,    3,    0,    2,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    0,    7,    0,    1,    2,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    2,    4,    1,    4,    4,    4,    4,    4,
    4,    4,    4,    4,    4,    4,    4,    0,    6,    0,
    5,    3,    1,    1,    1,    2,    1,    1,    1,    1,
    1,    2,    0,    5,    3,    1,    1,    3,    4,    4,
    0,    6,    2,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    2,    4,    4,    4,    4,    4,    0,    5,    3,    1,
    0,    3,    0,    2,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    4,    4,    4,    4,    4,    4,
    4,    4,    4,    4,    0,    6,    2,    1,    1,    1,
    1,    2,    4,    4,    4,    0,    6,    2,    1,    1,
    1,    1,    2,    4,    4,    0,    5,    3,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    0,    6,    2,    1,    1,    1,    2,    4,    0,    5,
    3,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    0,    7,    0,    1,    2,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    2,    4,
    1,    4,    4,    4,    4,    4,    4,    4,    4,    0,
    5,    3,    1,    0,    3,    0,    2,    1,    1,    1,
    1,    1,    1,    4,    4,    4,    4,    4,    4,    4,
    4,    4,    4,    0,    6,    0,    5,    3,    1,    1,
    2,    1,    1,    1,    1,    1,    4,    4,    0,    6,
    2,    1,    1,    1,    1,    4,    4,    5,    2,    1,
    1,    1,    4,    0,    6,    0,    5,    3,    1,    1,
    2,    1,    1,    1,    1,    1,    4,    4,    5,    2,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    4,    4,    4,
    4,    4,    4,    4,    4,    4,    4,    4,    4,    4,
    4,    4,    4,    4,    4,    4,    4,    4,    4,    4,
    4,    4,    4,    4,    4,    4,    4,    4,    4,    4,
    4,    4,    4,    4,    4,    4,    4,    4,    4,    4,
    4,    4,    4,    4,    4,    4,    4,    0,    5,    3,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    0,    5,    3,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    4,    4,    4,    4,    4,    0,    6,
    2,    1,    1,    1,    1,    1,    1,    1,    1,    4,
    4,    0,    5,    3,    1,    1,    1,    4,    4,    0,
    5,    3,    1,    1,    1,    5,    2,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    4,    4,    4,
    4,    4,    4,    4,    4,    4,    4,    4,    4,    4,
    4,    4,    4,    4,    4,    5,    2,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    4,    4,    4,    4,
    4,    4,    4,
};
const short yydefred[] = {                                      1,
    0,    0,    0,    0,  214,  384,  459,    0,  474,    0,
  649,  271,  444,  248,    0,    0,  117,  325,    0,    0,
  336,  361,    2,    3,    4,    5,    6,    7,    8,    9,
   10,   11,   12,   13,   14,   15,   16,   17,   18,   19,
   20,   21,   22,   23,   24,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   75,   76,   77,   78,  697,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  678,  679,  680,  681,  682,  683,
  684,  685,  686,  687,  688,  689,  690,  691,  692,  693,
  694,  695,  696,  235,    0,  217,  411,    0,  387,    0,
  472,    0,    0,  470,  471,    0,  547,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  621,
    0,  598,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  491,  492,  493,  494,  495,  496,  497,
  498,  499,  500,  501,  502,  503,  504,  505,  506,  507,
  508,  509,  510,  511,  512,  513,  514,  515,  516,  517,
  518,  519,  520,  521,  522,  523,  524,  525,  526,  527,
  528,  529,  530,  531,  532,  533,  534,  535,  536,  537,
  538,  539,  540,  541,  542,  543,  544,  545,  546,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   85,   86,   87,
   88,   89,   90,   91,   92,   93,   94,   95,   96,   97,
    0,    0,    0,    0,   41,   42,   43,  147,    0,  120,
    0,  726,    0,    0,    0,    0,    0,    0,    0,    0,
  718,  719,  720,  721,  722,  723,  724,  725,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   49,   50,   51,   52,   53,   54,   55,   56,   57,
   58,   59,   60,    0,    0,   79,    0,    0,    0,    0,
   74,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  677,    0,    0,  465,    0,    0,    0,  462,  463,  464,
    0,    0,  469,  486,    0,    0,  476,    0,  485,  482,
  483,  484,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  490,  659,
  670,    0,    0,  662,    0,    0,    0,  652,  653,  654,
  655,  656,  657,  658,    0,    0,    0,    0,    0,  297,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  274,  275,  276,  277,  278,  279,  280,  281,
  282,  283,  284,  285,  286,  287,  288,  289,  290,  456,
    0,  446,    0,    0,  455,  452,  453,  454,    0,  250,
    0,    0,    0,    0,  259,  257,  258,  260,  261,   98,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   84,   44,    0,    0,    0,   40,    0,
    0,    0,    0,    0,    0,  328,  329,  330,  331,    0,
    0,    0,    0,    0,    0,    0,    0,  717,   61,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   48,    0,    0,  346,    0,    0,  339,  340,  341,
  342,    0,    0,  369,    0,  364,  365,  366,    0,    0,
    0,   73,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  676,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  219,  220,  221,
  222,  223,  224,  225,  226,  227,  228,  229,  230,  231,
  232,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  420,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  389,  390,  391,  392,  393,  394,  395,  396,
  397,  398,  399,  400,  401,  402,  403,  404,  405,  406,
  407,  408,    0,    0,    0,  461,    0,  468,    0,    0,
    0,    0,  481,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  489,    0,    0,    0,    0,    0,    0,    0,  651,
  291,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  273,    0,
    0,    0,    0,  451,  262,    0,    0,    0,    0,    0,
  256,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   83,
    0,    0,   39,    0,    0,    0,    0,    0,  190,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  153,    0,    0,    0,    0,  122,  123,  124,
  125,  126,  127,  128,  129,  130,  131,  132,  133,  134,
  135,  136,  137,  138,  139,  140,  141,  142,  143,  144,
  332,    0,    0,    0,    0,  327,    0,    0,    0,    0,
    0,    0,    0,  716,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   47,  343,    0,    0,    0,
    0,  338,  367,    0,    0,    0,  363,   82,   81,   80,
  713,  710,  709,  698,  700,    0,    0,    0,    0,    0,
   26,   27,  704,  705,  708,  706,  711,  712,  714,  715,
  707,  699,  701,  702,  703,  233,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  218,  409,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  388,    0,    0,  460,  473,    0,    0,    0,
  475,  559,  563,  550,  579,  592,  591,  646,  596,  557,
  648,  588,  594,  558,  548,  549,  566,  555,  587,  556,
  569,  554,  568,  567,  562,  561,  560,  589,  586,  644,
  645,  583,  580,  625,  641,  642,  626,  627,  628,  629,
  636,  630,  639,  643,  632,  637,  633,  638,  631,  635,
  634,  640,    0,  624,  585,  602,  618,  619,  603,  604,
  605,  606,  613,  607,  616,  620,  609,  614,  610,  615,
  608,  612,  611,  617,    0,  601,  578,  581,  595,  552,
  590,  553,  582,  571,  576,  577,  574,  575,  572,  573,
  565,  564,    0,    0,    0,   34,   35,  647,  597,  584,
  593,  551,  570,    0,    0,    0,    0,    0,    0,  650,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  272,    0,    0,    0,
  445,    0,    0,    0,    0,    0,  266,  249,  102,  108,
  106,  105,  107,  103,  104,  101,  109,  115,  110,  114,
  112,  113,  111,  100,   99,  116,   45,   46,  145,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  121,    0,    0,    0,  326,  732,  727,  731,
  729,  733,  728,  730,   66,   72,   64,   68,   67,   63,
   62,   65,   71,   69,   70,    0,    0,    0,  337,    0,
    0,  362,   28,   29,   30,   31,   32,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  215,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  385,  466,  467,  487,  488,  480,    0,  479,  622,
    0,  599,    0,   36,   37,   38,  675,  674,    0,  673,
  661,  660,  667,  666,    0,  665,  669,  668,  318,  295,
  296,  317,  301,    0,  300,    0,  320,  316,  315,  324,
  319,  293,  323,  322,  321,  294,  292,  458,  450,    0,
  449,  457,  255,  254,    0,  253,  270,  269,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  118,  334,  335,  333,  344,  350,  356,
  360,  359,  358,  355,  351,  354,  357,  352,  353,    0,
  349,  345,  368,  373,  379,  383,  382,  381,  378,  374,
  377,  380,  375,  376,    0,  372,  245,  246,  239,  241,
  243,  242,  240,  234,  247,  238,  236,  237,  244,  415,
  417,  418,  438,  443,  442,  437,  436,  435,  419,  424,
    0,  423,    0,  412,  440,  441,  410,  416,  434,  414,
  439,  413,  477,    0,  623,  600,  671,    0,  663,    0,
    0,  298,    0,  309,  310,  306,  312,  308,  307,  314,
  311,  313,  305,  304,  447,    0,  251,    0,  268,  265,
  264,  186,  152,  184,  150,  194,    0,  193,    0,  182,
  176,  187,  188,  179,  146,  183,  149,  185,  177,  178,
  151,  189,  157,  173,  174,  158,  159,  160,  161,  168,
  162,  171,  175,  164,  169,  165,  170,  163,  167,  166,
  172,    0,  156,  181,  148,  180,  347,    0,  370,    0,
    0,  421,    0,  431,  432,  429,  430,  428,  433,  427,
  478,  672,  664,  302,  299,  448,  252,    0,  191,    0,
  206,  204,  213,  203,  198,  207,  211,  200,  208,  210,
  205,  199,  212,  209,  201,  202,  197,  154,    0,  348,
  371,  425,  422,  195,  192,  155,
};
const short yydgoto[] = {                                       1,
  891,  892, 1046, 1047,   23,   24,   25,   26,   27,   28,
   29,   30,   31,   32,   33,   34,   35,   36,   37,   38,
   39,   40,   41,   42,   43,  274,  275,  276,  277,  311,
  312,  313,  314,  315,  316,  317,  318,  319,  320,  321,
  322,  323,   70,   71,   72,   73,   74,  257,  258,  259,
  260,  261,  262,  263,  264,  265,  266,  267,  268,  269,
  270,  279,   60,  817,  280,  818,  819,  820,  821,  822,
  823,  824,  825,  826,  827,  828,  829,  830,  831,  832,
  833,  834,  835,  836,  837,  838,  839,  840, 1128, 1422,
 1423, 1114, 1387, 1388, 1467, 1448, 1389,  115,   48,  607,
  116,  608,  609,  610,  611,  612,  613,  614,  615,  616,
  617,  618,  619,  620,  621,   57,  494,  495,  766, 1255,
 1256,  496,  497,  498,  499, 1086, 1261, 1087,   55,  462,
  463,  464,  465,  466,  467,  468,  469,  470,  471,  472,
  473,  474,  475,  476,  477,  478,  479,  746, 1234, 1235,
 1374, 1361, 1236,   61,  525,  526,  527,  528,  529,   64,
  557,  558,  559,  560,  561,  869, 1300, 1301,   65,  565,
  566,  567,  568,  875, 1315, 1316,  118,   49,  642,  119,
  643,  644,  645,  646,  647,  648,  649,  650,  651,  652,
  653,  654,  655,  656,  657,  658,  659,  660,  661,  662,
  932, 1341, 1342, 1440, 1431, 1343,   56,  484,  485,  761,
 1250, 1251,  486,  487,  488,   50,  357,  358,  359,  360,
  123,  124,  125,   52,  368,  369,  671, 1208, 1209,  370,
  371,  372,  183,  184,  185,  186,  187,  188,  189,  190,
  191,  192,  193,  194,  195,  196,  197,  198,  199,  200,
  201,  202,  203,  204,  205,  206,  207,  208,  209,  210,
  211,  212,  213,  214,  215,  216,  217,  218,  219,  220,
  221,  222,  223,  224,  225,  226,  227,  228,  229,  230,
  231,  232,  233,  234,  235,  236,  237,  238,  239,  407,
 1025, 1026,  405, 1003, 1004,   54,  437,  438,  439,  440,
  441,  442,  443,  444,  736, 1225, 1226,  733, 1219, 1220,
   94,   95,   96,   97,   98,   99,  100,  101,  102,  103,
  104,  105,  106,  107,  108,  109,  110,  111,  112,  113,
  290,  291,  292,  293,  294,  295,  296,  297,  298,
};
const short yysindex[] = {                                      0,
  792,  -38,  -67,  -64,    0,    0,    0,  -59,    0,  -47,
    0,    0,    0,    0,  -29,  -27,    0,    0,  -24,  -11,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, -223,  643, -387, -291,    2,
 -229,    9,  376,   19,   23,   29,   31,  374, -218, -282,
   35,  309,  440,   39,   40,   74,   78,   84,  100,  -90,
    0,    0,    0,    0,    0,  109,  112,  113,  120,  122,
  123,  126,  128,  131,  133,  134,  136,  142,  149,  150,
  152,  154,  156,  164,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   95,    0,    0,   96,    0, -231,
    0,  162, -119,    0,    0, -233,    0,  166,  170,  173,
  176,  177,  179,  181,  182,  183,  197,  200,  217,  224,
  226,  227,  231,  234,  235,  236,  237,  239,  240,  245,
  246,  248,  253,  255,  256,  267,  269,  277,  281,    0,
  282,    0,  283,  286,  287,  296,  297,  298,  299,  300,
  301,  303,  306,  307,  308,  311,  313,  314,  315,  319,
  320,  322, -122,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0, -248,
  714, -244, -236,  188,  324,  327,  330,  331,  334,  335,
  337,  339,  340,  341,  342,  344,  -48,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  347,  346,  351, -120,    0,    0,    0,    0,  247,    0,
 -242,    0,  352,  353,  356,  360,  364,  365,  367,  186,
    0,    0,    0,    0,    0,    0,    0,    0,  349,  368,
  369,  372,  375,  379,  380,  382,  383,  384,  387,  390,
  -58,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0, -247, -226,    0,   28,   45,   46,  397,
    0,  -15,   72,   75,   11,   13,   77,   77,   80,   81,
   15,   20,   85,   77,   24,   25,   30,   32,   36,  414,
    0,  796,  585,    0,  417,  418, -121,    0,    0,    0,
   82,  428,    0,    0,  427,  431,    0,  -74,    0,    0,
    0,    0,   43,   77,   44,   77,  118,   98,  121,   59,
   61,   62,  137,  104,   86,  138,  141,  143,   87,   77,
   89,   91,  144,  125,   93,  145,  157,   77,  158,  139,
  167,  168,  101,  103,  468,  106,  497,   77,   77,  110,
   77,  159,  111,  116,  117, -406, -327,  129,  132,   77,
   77,  184,   77,  140,  148,  151,  153,  514,    0,    0,
    0,  530,  531,    0,  532,  533,  -68,    0,    0,    0,
    0,    0,    0,    0,  540,  539,  541,  544,  545,    0,
  546,  547,  550,  551,  553,  554,  556,  557,  559,  560,
  564,  210,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  567,    0,  568, -107,    0,    0,    0,    0,  572,    0,
  573,  574,  575, -109,    0,    0,    0,    0,    0,    0,
  238,  241,  243,  250,  251,  252,  261,  262, -123,  263,
  270,  190,  589,    0,    0,  271,  272,  596,    0,  499,
  597,  583,  603,  615, -108,    0,    0,    0,    0,  207,
  228,  232,  275,  244,  249,   77,  634,    0,    0,  288,
  254,  289,  291,  292,  302,  304,  312,  318,  316,  321,
  636,    0,  647,  648,    0,  651, -101,    0,    0,    0,
    0,  649,  654,    0,  -99,    0,    0,    0,  657,  658,
  663,    0,  665,  669,  670,  673,  674, -338,  676,  677,
  679,  681,  682,  683,  686,  691,  692,  693,  694,  695,
  697,    0,  698,  678,  700,  701,  702,  703,  704,  705,
  706,  709,  712,  715,  721,  722,  220,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  716,  723,  724,  725,  726,  727,  728,  729,  732,
  733,    0,  734,  735,  736,  737,  738,  739,  740,  741,
  743,  130,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  350,  396,  747,    0,  748,    0,  400,  401,
  751,  755,    0,  756,  767,  769,  772,  774,  776,  777,
  778,  780,  781,  784,  785,  789,  791,  793,  795,  797,
  798,  799,  800,  801,  803,  808,  809,  813,  814,  815,
  819,  822,  824,  825,  826,  775,  829,  811,  831,  832,
  833,  836,  837,  838,  842,  844,  845,  846,  848,  849,
  850,  852,  853,  854, -228,  859,  860,  864,  866,  869,
  871,    0,  790,   77,  405,  873,  526,  527,  879,    0,
    0,  456,  534,  491,  494,  885,  500,  501,  502,  503,
  506,  548,  562,  555,  558,  509,  563,  901,    0,  569,
  902,  570,  906,    0,    0,  905,  571,  577,  581,  912,
    0,  914,  918,  923,  924,  925,  931,  933,  938,  941,
  942,  943,  945,  954,  955,  956,  957,  961,  962,    0,
  965,  968,    0,  969,  970,  971,  972,  974,    0,  975,
  978,  979,  980,  984,  985,  986,  988,  989,  993,  994,
  999, 1000,    0, 1003, 1006, 1008,    1,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  621,  661,  662, 1018,    0, 1019, 1024, 1025, 1026,
 1027, 1028, 1029,    0, 1030, 1031, 1035, 1036, 1037, 1038,
 1043, 1045, 1051, 1054, 1056,    0,    0,  707, 1057,  711,
 1063,    0,    0,  719, 1064, 1070,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   77,   77,   77,   77,   77,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  744,  745,   77,  746,
  749,  750,  752,  754,  757,  761,   77,   77,  184, 1071,
    0,    0,  759, -339,  684,  760,  762,  685,  720,  730,
  764, 1080,  765,  766,  768,  770,  779,  773,  782,  731,
  783, 1083,    0, 1084, 1093,    0,    0, 1094, 1095,  219,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   -1,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    3,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  184,  184,  184,    0,    0,    0,    0,    0,
    0,    0,    0, -250, 1096, 1097, -246, 1100, 1105,    0,
 1117, 1119, 1124, 1128,  802, 1130, 1131, 1134, 1135, 1136,
 1137, 1138, 1139, 1140, 1141, 1142,    0, 1145,  794, 1146,
    0, -296, 1147, 1148,  758, 1165,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  771,
  806,  787,  804, 1149,  805,  812,  816,  823,  830,  810,
  834,  820,  835,  839,  840,  841,  851, 1150,  862,  843,
  867, 1153,    0, 1158, 1159, 1161,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1163,   79, 1164,    0, 1169,
  610,    0,    0,    0,    0,    0,    0, 1181, 1185, 1186,
 1188, 1189, 1190, 1192, 1194, 1204, 1206, 1217, 1222, 1224,
    0, 1227, 1228, 1229, 1232, 1239, 1240, 1243, 1250, 1257,
 1260,  934, 1262, 1263, 1264, 1265, 1266, 1267, 1268, 1275,
 1276,    0,    0,    0,    0,    0,    0,    4,    0,    0,
  775,    0,  811,    0,    0,    0,    0,    0,   10,    0,
    0,    0,    0,    0,   16,    0,    0,    0,    0,    0,
    0,    0,    0,   21,    0,  172,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   22,
    0,    0,    0,    0,   26,    0,    0,    0,  950,  581,
 1279, 1281, 1282, 1283, 1284,  958, 1286, 1287, 1288, 1289,
 1290, 1291, 1292, 1293, 1294, 1295, 1296, 1297, 1298,  847,
 1299, 1300, 1301,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   34,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   38,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   51,    0, -253,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  219,    0,    0,    0, -250,    0, -246,
  172,    0,  802,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  794,    0, -296,    0,    0,
    0,    0,    0,    0,    0,    0,   54,    0,  594,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   56,    0,    0,    0,    0,    0,   79,    0,  610,
 -253,    0,  934,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  594,    0,  958,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  847,    0,
    0,    0,    0,    0,    0,    0,
};
const short yyrindex[] = {                                      0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 1101, 1238,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 1241,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 1303,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1304,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1303, 1303, 1303, 1303, 1303,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1304, 1304, 1304,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  680,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   58, 1306,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, -235,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  641,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  680,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, -235,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  641,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,
};
const short yygindex[] = {                                      0,
 -337, -782, -420, -923,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 1092,    0,    0,    0,
 1058,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 1302,    0,    0,    0,    0, 1110,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  561,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  -98,    0,    0,  -82,  -78,    0,    0,    0,    0,    0,
    0,  786,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   -5,  880,    0,    0,    0,    0,    0,  115,    0,    0,
  915,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   17,
   18,    0,    0,    0,    0,  856,    0,    0,    0,    0,
    0,  827,    0,    0,    0,    0,    0,  -52,    0,    0,
  817,    0,    0,    0,    0,  -45,    0,    0,    0,    0,
  753,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  -50,  -44,    0,    0,    0,    0,    0,    0,
    0,   12,  907,    0,    0,    0,    0, 1032,    0,    0,
    0, 1269,    0,    0,    0,    0,    0,    0,   42, 1022,
    0,    0,    0, 1203,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  185,    0,    0,  189,    0,    0,  960,    0,    0,
    0,    0,    0,    0,    0,    0,   41,    0,    0,   47,
    0, 1305,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1104,    0,    0,    0,    0,    0,    0,    0,
};
#define YYTABLESIZE 1405
const short yytable[] = {                                     579,
  580,  726,  428,  665,  518,  362,  586,  430,  553,  431,
 1434,  480, 1435,  521, 1217,  770,  845,  763, 1223,  489,
   44,  114,  364,  871,  354,  876,  121, 1436,  426,  562,
  426, 1437,   66,  522,  330, 1253,  675,  271,  677, 1043,
 1044, 1045, 1211,  717,  718,  426, 1213, 1354,  578,  426,
  672,  432,  691, 1358,  433,   46,  739, 1210,   47, 1360,
  699, 1212, 1353,   51, 1363, 1376,  551,   67, 1357, 1378,
  709,  710,  490,  712, 1359,   53,  513, 1428,   68, 1362,
 1375, 1430,  723,  724, 1377,  727,   45,  886,  887,  888,
  889,  890, 1427,   58, 1433,   59, 1429, 1450,   62, 1469,
 1438,  267,  491, 1163, 1164, 1165, 1166, 1167,  492, 1432,
  434,   63, 1449,  355, 1468,  122,  267,  117,  426, 1214,
 1215, 1216,  719,  720,  120, 1132,  278,  435,  554, 1183,
 1184,  126,  326,  127,  354,  271,  121,  523,  327,  128,
  129,  240,  365,  130,  328,  241,  489,  521,  480,  563,
  131,  242,   69,  243,  553,  272,  562,  281,  725,  132,
  329,  324,  325,  133,  134,   66,  481,  522,  524,  332,
  135,  493,  333,  334,  136,  137,  138,  366,  139,  356,
  335,  364,  336,  337,  140,  273,  338,  430,  339,  431,
 1254,  340,  555,  341,  342,  482,  343,  299,  853,  490,
   67, 1218,  344,  141,  142, 1224,  367,  244,  143,  345,
  346,   68,  347,  564,  348,  144,  349,  352,  353,  145,
  146,  147,  361,  355,  148,  122,  373,  149,  150,  491,
  374,  432,  300,  375,  433,  492,  376,  377,  151,  378,
 1439,  379,  380,  381,  152,  153,  500,  154,  155,  156,
  157,  436,  556,  272,  942,  483,  794,  382,  426,  795,
  383,  158,  245,  246,  247,  248,  249,  250,  251,  252,
  159,  523,  160,  161,  554,  162,  563,  384,  163,  164,
  796,  301,  165,  273,  385,   69,  386,  387,  350,  356,
  434,  388,  797,  166,  389,  390,  391,  392,  493,  393,
  394,  365,  524,  481,  798,  395,  396,  435,  397,  799,
  537,  253,  167,  398,  168,  399,  400,  302,  169,  303,
  304,  800,  170,  171,  172,  173,  174,  401,  801,  402,
  175,  176,  482,  802,  758,  803,  366,  403,  555,  177,
  564,  404,  406,  408,  920,  254,  409,  410,  804,  780,
  781,  782,  783,  784,  785,  786,  411,  412,  413,  414,
  415,  416,  305,  417,  306,  367,  418,  419,  420,  520,
  178,  421,  179,  422,  423,  424,  805,  307,  180,  425,
  426,  806,  427,  181,  501,  622,  623,  502,  182,  624,
  503,  504,  483,  625,  505,  506, 1055,  507,  556,  508,
  509,  510,  511,  807,  512,  515,  516,  539,  626,  627,
  628,  517,  530,  531,  629,  808,  532,  809,  810,   75,
  533,  308,  811,  255,  534,  535, 1289,  536,  540,  541,
   76,  436,  542,  630,  573,  543,  569,  631,  632,  544,
  545,  282,  546,  547,  548, 1364, 1365,  549,  309,  310,
  550,   77,   78,  570,  571,  572,  256,   79,  574,   80,
  576,  575,  577,  578,  583,  445,  581,  582,  633,  584,
  634,  585,  592,  587,  588,  593, 1366,  663,  664,  589,
  283,  590,  812,  446,  635,  591,  668,  669,  813,  447,
  667,  670,  674,  676, 1367,  284,  594,  595, 1180,  814,
  815, 1368, 1290,  596,  678,  636,  679,  680,  681,  816,
  682,  683,  685,  448,  449,   81,   82,  285,  450,  286,
 1369,  287,  288,  684,  687,   83,   84,  688,  706,  689,
  694,  697,  451,  695, 1291,  686,  690,  637,  692,  452,
  693,  289,  696,  698,  700,   85,   86,  701, 1370, 1292,
  704,  638,  705,  702,  703,  707, 1371,  708,  453,  711,
  714,  639,   87,   88,  282,  715,  716,  713, 1293, 1294,
  725, 1170,  732,   89, 1295, 1296, 1297, 1298,  721, 1178,
 1179,  722,   90,  597,  598,  599,  454, 1299,  600,  728,
  734,  735,  737,  738,  455,  601, 1372,  729,  741,  742,
  730,  743,  731,  283,  744,  745,  747,  748,  602,  603,
  749,  750,  456,  751,  752, 1373,  753,  754,  284,  755,
  756,  457,  458,  640,  757,  604,  605,  760,  762,  244,
  765,  127, 1207,  767,  768,  769,  641,  128,  129,  789,
  285,  130,  286,  842,  287,  288,  772,  790,  131,  773,
  606,  774,  459,  460,  793,  841,  847,  132,  775,  776,
  777,  133,  134,  843,  289,   91,   92,   93,  135,  778,
  779,  787,  136,  137,  138,  844,  139,  848,  788,  791,
  792,  849,  140,  850,  245,  246,  247,  248,  249,  250,
  251,  252,  854,  851,  866,  299,  855,  857,  852,  858,
  859,  141,  142,  856,  863,  867,  143,  873,  868,  461,
  860,  870,  861,  144,  874,  878,  879,  145,  146,  147,
  862,  880,  148,  881,  864,  149,  150,  882,  883,  865,
  300,  884,  885,  253,  893,  894,  151,  895,  907,  896,
  897,  898,  152,  153,  899,  154,  155,  156,  157,  900,
  901,  902,  903,  904,  794,  905,  906,  795,  944,  158,
  908,  909,  910,  911,  912,  913,  914,  254,  159,  915,
  160,  161,  916,  162,  922,  917,  163,  164,  796,  301,
  165,  918,  919,  923,  924,  925,  926,  927,  928,  929,
  797,  166,  930,  931,  933,  934,  935,  936,  937,  938,
  939,  940,  798,  941,  945,  946,  947,  799,  948,  949,
  167,  950,  168,  951,  952,  302,  169,  303,  304,  800,
  170,  171,  172,  173,  174,  953,  801,  954,  175,  176,
  955,  802,  956,  803,  957,  958,  959,  177,  960,  961,
  622,  623,  962,  963,  624,  255,  804,  964,  625,  965,
 1054,  966, 1451,  967, 1056,  968,  969,  970,  971,  972,
  305,  973,  306,  626,  627,  628,  974,  975,  178,  629,
  179,  976,  977,  978,  805,  307,  180,  979,  256,  806,
  980,  181,  981,  982,  983, 1452,  182, 1005,  630, 1027,
 1028, 1029,  631,  632, 1030, 1031, 1032, 1453,   75,  196,
 1033,  807, 1034, 1035, 1036, 1061, 1037, 1038, 1039,   76,
 1040, 1041, 1042,  808, 1454,  809,  810, 1048, 1049,  308,
  811, 1455, 1050,  633, 1051,  634, 1456, 1052, 1457, 1053,
   77,   78,  196, 1057, 1058, 1059,   79, 1060,   80,  635,
 1063, 1458, 1062, 1064,  196, 1065,  309,  310, 1072, 1066,
 1067, 1068, 1069,  303,  303, 1070, 1071, 1304, 1075, 1077,
  636,  196, 1079, 1073, 1081, 1082, 1074, 1085,  196,  445,
 1088, 1076, 1089,  196, 1459,  196, 1090, 1078, 1080, 1083,
  812, 1091, 1092, 1093,  303, 1084,  813,  446,  196, 1094,
 1460, 1095,  637,  447,   81,   82, 1096,  814,  815, 1097,
 1098, 1099,  303, 1100,   83,   84,  638,  816, 1461,  303,
 1462, 1463, 1101, 1102, 1103, 1104,  639,  448,  449, 1105,
 1106,  196,  450, 1107,   85,   86, 1108, 1109,  303, 1134,
 1110, 1111, 1112, 1305, 1113, 1115,  451,  196, 1116, 1117,
 1118,   87,   88,  452, 1119, 1120, 1121,    2, 1122, 1123,
    3,  593,   89, 1124, 1125,  196,  303,  196,  196, 1126,
 1127,   90,  453, 1129,  303, 1306, 1130,    4, 1131, 1135,
 1136,    5,  594,  595,    6, 1464, 1137, 1138,  640,  596,
 1307,    7, 1139, 1140, 1141, 1142, 1143, 1144, 1145, 1146,
  454,  641, 1465, 1147, 1148, 1149, 1150,    8,  455, 1308,
 1309, 1151, 1466, 1152,  303, 1310, 1311, 1312, 1313, 1153,
    9,   10, 1154,   11, 1155, 1156,  456, 1157, 1314, 1158,
   12, 1159,  196,  303, 1161,  457,  458, 1160, 1162, 1181,
 1168, 1169, 1171, 1185, 1188, 1172, 1173,   13, 1174,  196,
 1192, 1202, 1203, 1176,   91,   92,   93, 1177,   14,  196,
   15, 1204, 1205, 1206, 1221, 1222,  459,  460, 1227,  597,
  598,  599, 1175, 1228,  600, 1197,   16, 1182, 1186, 1189,
 1187,  601, 1191, 1193, 1194, 1229, 1195, 1230, 1196, 1190,
 1200, 1198, 1231,   17,  602,  603, 1232, 1233, 1237, 1238,
 1199, 1201, 1239, 1240, 1241, 1242, 1243, 1244, 1245, 1246,
 1247,  604,  605, 1248, 1252, 1257, 1258, 1249, 1260, 1266,
 1280, 1284, 1259,  461, 1263,   18, 1285, 1286, 1272, 1287,
 1262, 1288, 1302,  216,   19,   20,  606, 1303, 1274,   21,
   22,  984,  985,  986,  987,  988, 1264,  989,  990, 1317,
  991,  992,  993, 1318, 1319,  994, 1320, 1321, 1322, 1278,
 1323, 1282, 1324, 1265, 1267,  995,  996,  997,  998,  999,
 1000, 1268, 1325, 1001, 1326, 1269, 1002, 1006, 1007, 1008,
 1009, 1010, 1270, 1011, 1012, 1327, 1013, 1014, 1015, 1271,
 1328, 1016, 1329, 1273, 1275, 1330, 1331, 1332, 1276, 1277,
 1333, 1017, 1018, 1019, 1020, 1021, 1022, 1334, 1335, 1023,
 1279, 1336, 1024, 1403, 1404, 1405, 1406, 1407, 1337, 1408,
 1409, 1281, 1410, 1411, 1412, 1338, 1283, 1413, 1339, 1340,
 1344, 1345, 1346, 1347, 1348, 1349, 1350, 1414, 1415, 1416,
 1417, 1418, 1419, 1351, 1352, 1420, 1379, 1381, 1421, 1382,
 1383, 1384, 1385, 1386, 1390, 1391, 1392, 1393, 1394, 1395,
 1396, 1397, 1398, 1399, 1400, 1401, 1402, 1424, 1425, 1426,
  386,   25,   33,  119,  263,  519,  514, 1475,  552, 1474,
 1476,  331, 1447,  771, 1380, 1470,  759, 1133, 1444, 1445,
  846,  877, 1473,  872, 1471,  429, 1472, 1446,  666,  673,
  764,  363,  921,  538,  943, 1441,  740, 1356,  351, 1355,
 1443,    0,    0,    0, 1442,
};
const short yycheck[] = {                                     337,
  338,  422,  125,  125,  125,  125,  344,  256,  256,  258,
  264,  256,  266,  256,  265,  125,  125,  125,  265,  256,
   59,  409,  256,  125,  256,  125,  256,  281,  264,  256,
  266,  285,  256,  276,  125,  332,  374,  256,  376,  268,
  269,  270,   44,  450,  451,  281,   44,   44,  387,  285,
  125,  300,  390,   44,  303,  123,  125,   59,  123,   44,
  398,   59,   59,  123,   44,   44,  125,  291,   59,   44,
  408,  409,  309,  411,   59,  123,  125,   44,  302,   59,
   59,   44,  420,  421,   59,  423,  125,  426,  427,  428,
  429,  430,   59,  123,   44,  123,   59,   44,  123,   44,
  354,   44,  339,  886,  887,  888,  889,  890,  345,   59,
  359,  123,   59,  345,   59,  345,   59,  409,  354, 1043,
 1044, 1045,  450,  451,  123,  125,  409,  376,  376,  469,
  470,  123,   59,  256,  256,  256,  256,  380,   61,  262,
  263,  123,  376,  266,   61,  123,  256,  256,  256,  376,
  273,  123,  376,  123,  256,  374,  256,  123,  387,  282,
   61,  123,  123,  286,  287,  256,  411,  276,  411,   61,
  293,  408,   61,   61,  297,  298,  299,  411,  301,  411,
   61,  256,   61,   61,  307,  404,   61,  256,   61,  258,
  487,   61,  440,   61,   61,  440,   61,  256,  536,  309,
  291,  452,   61,  326,  327,  452,  440,  256,  331,   61,
   61,  302,   61,  440,   61,  338,   61,  123,  123,  342,
  343,  344,   61,  345,  347,  345,   61,  350,  351,  339,
   61,  300,  291,   61,  303,  345,   61,   61,  361,   61,
  494,   61,   61,   61,  367,  368,   59,  370,  371,  372,
  373,  500,  500,  374,  125,  500,  256,   61,  494,  259,
   61,  384,  311,  312,  313,  314,  315,  316,  317,  318,
  393,  380,  395,  396,  376,  398,  376,   61,  401,  402,
  280,  340,  405,  404,   61,  376,   61,   61,  125,  411,
  359,   61,  292,  416,   61,   61,   61,   61,  408,   61,
   61,  376,  411,  411,  304,   61,   61,  376,   61,  309,
  125,  360,  435,   61,  437,   61,   61,  376,  441,  378,
  379,  321,  445,  446,  447,  448,  449,   61,  328,   61,
  453,  454,  440,  333,  125,  335,  411,   61,  440,  462,
  440,   61,   61,   61,  125,  394,   61,   61,  348,  473,
  474,  475,  476,  477,  478,  479,   61,   61,   61,   61,
   61,   61,  421,   61,  423,  440,   61,   61,   61,  123,
  493,   61,  495,   61,   61,   61,  376,  436,  501,   61,
   61,  381,   61,  506,   61,  256,  257,   61,  511,  260,
   61,   61,  500,  264,   61,   61,  734,   61,  500,   61,
   61,   61,   61,  403,   61,   59,   61,   59,  279,  280,
  281,   61,   61,   61,  285,  415,   61,  417,  418,  256,
   61,  480,  422,  472,   61,   61,  348,   61,   61,   61,
  267,  500,   61,  304,  450,   61,  409,  308,  309,   61,
   61,  256,   61,   61,   61,  274,  275,   61,  507,  508,
   61,  288,  289,  409,  409,   59,  505,  294,  387,  296,
  450,  387,  450,  387,  450,  256,  387,  387,  339,  450,
  341,  387,   59,  450,  450,  256,  305,   61,   61,  450,
  295,  450,  482,  274,  355,  450,   59,   61,  488,  280,
  409,   61,  450,  450,  323,  310,  277,  278,  919,  499,
  500,  330,  424,  284,  387,  376,  409,  387,  450,  509,
  450,  450,  409,  304,  305,  352,  353,  332,  309,  334,
  349,  336,  337,  387,  387,  362,  363,  387,   61,  387,
  387,  387,  323,  409,  456,  450,  450,  408,  450,  330,
  450,  356,  450,  387,  387,  382,  383,  409,  377,  471,
  450,  422,  450,  387,  387,  450,  385,   61,  349,  450,
  450,  432,  399,  400,  256,  450,  450,  409,  490,  491,
  387,  909,   59,  410,  496,  497,  498,  499,  450,  917,
  918,  450,  419,  364,  365,  366,  377,  509,  369,  450,
   61,   61,   61,   61,  385,  376,  425,  450,   59,   61,
  450,   61,  450,  295,   61,   61,   61,   61,  389,  390,
   61,   61,  403,   61,   61,  444,   61,   61,  310,   61,
   61,  412,  413,  494,   61,  406,  407,   61,   61,  256,
   59,  256,  414,   61,   61,   61,  507,  262,  263,  450,
  332,  266,  334,   61,  336,  337,  409,   59,  273,  409,
  431,  409,  443,  444,   59,   59,  450,  282,  409,  409,
  409,  286,  287,   61,  356,  502,  503,  504,  293,  409,
  409,  409,  297,  298,  299,   61,  301,  450,  409,  409,
  409,  450,  307,  409,  311,  312,  313,  314,  315,  316,
  317,  318,   59,  450,   59,  256,  409,  409,  450,  409,
  409,  326,  327,  450,  387,   59,  331,   59,   61,  500,
  409,   61,  409,  338,   61,   59,   59,  342,  343,  344,
  409,   59,  347,   59,  409,  350,  351,   59,   59,  409,
  291,   59,   59,  360,   59,   59,  361,   59,   61,   59,
   59,   59,  367,  368,   59,  370,  371,  372,  373,   59,
   59,   59,   59,   59,  256,   59,   59,  259,  409,  384,
   61,   61,   61,   61,   61,   61,   61,  394,  393,   61,
  395,  396,   61,  398,   59,   61,  401,  402,  280,  340,
  405,   61,   61,   61,   61,   61,   61,   61,   61,   61,
  292,  416,   61,   61,   61,   61,   61,   61,   61,   61,
   61,   61,  304,   61,  409,   59,   59,  309,  409,  409,
  435,   61,  437,   59,   59,  376,  441,  378,  379,  321,
  445,  446,  447,  448,  449,   59,  328,   59,  453,  454,
   59,  333,   59,  335,   59,   59,   59,  462,   59,   59,
  256,  257,   59,   59,  260,  472,  348,   59,  264,   59,
   61,   59,  259,   59,  450,   59,   59,   59,   59,   59,
  421,   59,  423,  279,  280,  281,   59,   59,  493,  285,
  495,   59,   59,   59,  376,  436,  501,   59,  505,  381,
   59,  506,   59,   59,   59,  292,  511,   59,  304,   59,
   59,   59,  308,  309,   59,   59,   59,  304,  256,  259,
   59,  403,   59,   59,   59,  450,   59,   59,   59,  267,
   59,   59,   59,  415,  321,  417,  418,   59,   59,  480,
  422,  328,   59,  339,   59,  341,  333,   59,  335,   59,
  288,  289,  292,   61,  409,  409,  294,   59,  296,  355,
  450,  348,  409,  450,  304,   61,  507,  508,  387,  450,
  450,  450,  450,  274,  275,  450,  409,  348,  450,   59,
  376,  321,   61,  409,   59,   61,  409,  387,  328,  256,
   59,  409,   59,  333,  381,  335,   59,  409,  409,  409,
  482,   59,   59,   59,  305,  409,  488,  274,  348,   59,
  397,   59,  408,  280,  352,  353,   59,  499,  500,   59,
   59,   59,  323,   59,  362,  363,  422,  509,  415,  330,
  417,  418,   59,   59,   59,   59,  432,  304,  305,   59,
   59,  381,  309,   59,  382,  383,   59,   59,  349,  409,
   61,   61,   61,  424,   61,   61,  323,  397,   61,   61,
   61,  399,  400,  330,   61,   61,   61,  256,   61,   61,
  259,  256,  410,   61,   61,  415,  377,  417,  418,   61,
   61,  419,  349,   61,  385,  456,   61,  276,   61,  409,
  409,  280,  277,  278,  283,  482,   59,   59,  494,  284,
  471,  290,   59,   59,   59,   59,   59,   59,   59,   59,
  377,  507,  499,   59,   59,   59,   59,  306,  385,  490,
  491,   59,  509,   59,  425,  496,  497,  498,  499,   59,
  319,  320,   59,  322,   59,  409,  403,   61,  509,  409,
  329,   59,  482,  444,   61,  412,  413,  409,   59,   59,
  387,  387,  387,  450,  450,  387,  387,  346,  387,  499,
   61,   59,   59,  387,  502,  503,  504,  387,  357,  509,
  359,   59,   59,   59,   59,   59,  443,  444,   59,  364,
  365,  366,  409,   59,  369,  387,  375,  409,  409,  450,
  409,  376,  409,  409,  409,   59,  409,   59,  409,  450,
  450,  409,   59,  392,  389,  390,   59,  386,   59,   59,
  409,  409,   59,   59,   59,   59,   59,   59,   59,   59,
   59,  406,  407,   59,   59,   59,   59,  414,   44,   61,
   61,   59,  455,  500,  409,  424,   59,   59,  409,   59,
  450,   59,   59,  123,  433,  434,  431,   59,  409,  438,
  439,  457,  458,  459,  460,  461,  450,  463,  464,   59,
  466,  467,  468,   59,   59,  471,   59,   59,   59,  409,
   59,  409,   59,  450,  450,  481,  482,  483,  484,  485,
  486,  450,   59,  489,   59,  450,  492,  457,  458,  459,
  460,  461,  450,  463,  464,   59,  466,  467,  468,  450,
   59,  471,   59,  450,  450,   59,   59,   59,  450,  450,
   59,  481,  482,  483,  484,  485,  486,   59,   59,  489,
  450,   59,  492,  457,  458,  459,  460,  461,   59,  463,
  464,  450,  466,  467,  468,   59,  450,  471,   59,  386,
   59,   59,   59,   59,   59,   59,   59,  481,  482,  483,
  484,  485,  486,   59,   59,  489,  387,   59,  492,   59,
   59,   59,   59,  386,   59,   59,   59,   59,   59,   59,
   59,   59,   59,   59,   59,   59,   59,   59,   59,   59,
  123,   59,   59,  123,   59,  274,  257, 1450,  311, 1448,
 1469,   70, 1378,  494, 1260, 1428,  462,  817, 1361, 1363,
  525,  565, 1433,  557, 1430,  183, 1431, 1376,  357,  368,
  484,  123,  607,  290,  642, 1354,  437, 1213,   94, 1211,
 1360,   -1,   -1,   -1, 1358,
};
#define YYFINAL 1
#ifndef YYDEBUG
#define YYDEBUG 0
#endif
#define YYMAXTOKEN 511
#if YYDEBUG
const char * const yyname[] = {
"end-of-file",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,"','",0,0,0,0,0,0,0,0,0,0,0,0,0,0,"';'",0,"'='",0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,"'{'",0,"'}'",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
"ACCEPT_PASSWORD","ACTION","ADMIN","AFTYPE","T_ALLOW","ANTI_NICK_FLOOD",
"ANTI_SPAM_EXIT_MESSAGE_TIME","AUTOCONN","T_BLOCK","BURST_AWAY",
"BURST_TOPICWHO","BYTES","KBYTES","MBYTES","GBYTES","TBYTES","CALLER_ID_WAIT",
"CAN_FLOOD","CAN_IDLE","CHANNEL","CIDR_BITLEN_IPV4","CIDR_BITLEN_IPV6",
"CIPHER_PREFERENCE","CLASS","COMPRESSED","COMPRESSION_LEVEL","CONNECT",
"CONNECTFREQ","CRYPTLINK","DEFAULT_CIPHER_PREFERENCE","DEFAULT_FLOODCOUNT",
"DEFAULT_SPLIT_SERVER_COUNT","DEFAULT_SPLIT_USER_COUNT","DENY","DESCRIPTION",
"DIE","DISABLE_AUTH","DISABLE_FAKE_CHANNELS","DISABLE_HIDDEN",
"DISABLE_LOCAL_CHANNELS","DISABLE_REMOTE_COMMANDS","DOT_IN_IP6_ADDR",
"DOTS_IN_IDENT","DURATION","EGDPOOL_PATH","EMAIL","ENABLE","ENCRYPTED",
"EXCEED_LIMIT","EXEMPT","FAILED_OPER_NOTICE","FAKENAME","IRCD_FLAGS",
"FLATTEN_LINKS","FFAILED_OPERLOG","FKILLLOG","FKLINELOG","FGLINELOG",
"FIOERRLOG","FOPERLOG","FOPERSPYLOG","FUSERLOG","GECOS","GENERAL","GLINE",
"GLINES","GLINE_EXEMPT","GLINE_LOG","GLINE_TIME","GLINE_MIN_CIDR",
"GLINE_MIN_CIDR6","GLOBAL_KILL","IRCD_AUTH","NEED_IDENT","HAVENT_READ_CONF",
"HIDDEN","HIDDEN_ADMIN","HIDDEN_NAME","HIDDEN_OPER","HIDE_SERVER_IPS",
"HIDE_SERVERS","HIDE_SPOOF_IPS","HOST","HUB","HUB_MASK","IDLETIME",
"IGNORE_BOGUS_TS","INVISIBLE_ON_CONNECT","IP","KILL","KILL_CHASE_TIME_LIMIT",
"KLINE","KLINE_EXEMPT","KLINE_REASON","KLINE_WITH_REASON","KNOCK_DELAY",
"KNOCK_DELAY_CHANNEL","LAZYLINK","LEAF_MASK","LINKS_DELAY","LISTEN","T_LOG",
"LOGGING","LOG_LEVEL","MAX_ACCEPT","MAX_BANS","MAX_CHANS_PER_USER","MAX_GLOBAL",
"MAX_IDENT","MAX_LOCAL","MAX_NICK_CHANGES","MAX_NICK_TIME","MAX_NUMBER",
"MAX_TARGETS","MESSAGE_LOCALE","MIN_NONWILDCARD","MIN_NONWILDCARD_SIMPLE",
"MODULE","MODULES","NAME","NEED_PASSWORD","NETWORK_DESC","NETWORK_NAME","NICK",
"NICK_CHANGES","NO_CREATE_ON_SPLIT","NO_JOIN_ON_SPLIT","NO_OPER_FLOOD",
"NO_TILDE","NOT","NUMBER","NUMBER_PER_IDENT","NUMBER_PER_CIDR","NUMBER_PER_IP",
"NUMBER_PER_IP_GLOBAL","OPERATOR","OPERS_BYPASS_CALLERID","OPER_LOG",
"OPER_ONLY_UMODES","OPER_PASS_RESV","OPER_SPY_T","OPER_UMODES",
"JOIN_FLOOD_COUNT","JOIN_FLOOD_TIME","PACE_WAIT","PACE_WAIT_SIMPLE","PASSWORD",
"PATH","PING_COOKIE","PING_TIME","PING_WARNING","PORT","QSTRING","QUIET_ON_BAN",
"REASON","REDIRPORT","REDIRSERV","REGEX_T","REHASH","TREJECT_HOLD_TIME",
"REMOTE","REMOTEBAN","RESTRICT_CHANNELS","RESTRICTED","RSA_PRIVATE_KEY_FILE",
"RSA_PUBLIC_KEY_FILE","SSL_CERTIFICATE_FILE","RESV","RESV_EXEMPT","SECONDS",
"MINUTES","HOURS","DAYS","WEEKS","SENDQ","SEND_PASSWORD","SERVERHIDE",
"SERVERINFO","SERVLINK_PATH","IRCD_SID","TKLINE_EXPIRE_NOTICES","T_SHARED",
"T_CLUSTER","TYPE","SHORT_MOTD","SILENT","SPOOF","SPOOF_NOTICE",
"STATS_E_DISABLED","STATS_I_OPER_ONLY","STATS_K_OPER_ONLY","STATS_O_OPER_ONLY",
"STATS_P_OPER_ONLY","TBOOL","TMASKED","T_REJECT","TS_MAX_DELTA","TS_WARN_DELTA",
"TWODOTS","T_ALL","T_BOTS","T_SOFTCALLERID","T_CALLERID","T_CCONN",
"T_CCONN_FULL","T_CLIENT_FLOOD","T_DEAF","T_DEBUG","T_DRONE","T_EXTERNAL",
"T_FULL","T_INVISIBLE","T_IPV4","T_IPV6","T_LOCOPS","T_LOGPATH","T_L_CRIT",
"T_L_DEBUG","T_L_ERROR","T_L_INFO","T_L_NOTICE","T_L_TRACE","T_L_WARN",
"T_MAX_CLIENTS","T_NCHANGE","T_OPERWALL","T_REJ","T_SERVNOTICE","T_SKILL",
"T_SPY","T_SSL","T_UMODES","T_UNAUTH","T_UNRESV","T_UNXLINE","T_WALLOP",
"THROTTLE_TIME","TOPICBURST","TRUE_NO_OPER_FLOOD","TKLINE","TXLINE","TRESV",
"UNKLINE","USER","USE_EGD","USE_EXCEPT","USE_INVEX","USE_KNOCK","USE_LOGGING",
"USE_WHOIS_ACTUALLY","VHOST","VHOST6","XLINE","WARN","WARN_NO_NLINE",
};
const char * const yyrule[] = {
"$accept : conf",
"conf :",
"conf : conf conf_item",
"conf_item : admin_entry",
"conf_item : logging_entry",
"conf_item : oper_entry",
"conf_item : channel_entry",
"conf_item : class_entry",
"conf_item : listen_entry",
"conf_item : auth_entry",
"conf_item : serverinfo_entry",
"conf_item : serverhide_entry",
"conf_item : resv_entry",
"conf_item : shared_entry",
"conf_item : cluster_entry",
"conf_item : connect_entry",
"conf_item : kill_entry",
"conf_item : deny_entry",
"conf_item : exempt_entry",
"conf_item : general_entry",
"conf_item : gline_entry",
"conf_item : gecos_entry",
"conf_item : modules_entry",
"conf_item : error ';'",
"conf_item : error '}'",
"timespec_ :",
"timespec_ : timespec",
"timespec : NUMBER timespec_",
"timespec : NUMBER SECONDS timespec_",
"timespec : NUMBER MINUTES timespec_",
"timespec : NUMBER HOURS timespec_",
"timespec : NUMBER DAYS timespec_",
"timespec : NUMBER WEEKS timespec_",
"sizespec_ :",
"sizespec_ : sizespec",
"sizespec : NUMBER sizespec_",
"sizespec : NUMBER BYTES sizespec_",
"sizespec : NUMBER KBYTES sizespec_",
"sizespec : NUMBER MBYTES sizespec_",
"modules_entry : MODULES '{' modules_items '}' ';'",
"modules_items : modules_items modules_item",
"modules_items : modules_item",
"modules_item : modules_module",
"modules_item : modules_path",
"modules_item : error ';'",
"modules_module : MODULE '=' QSTRING ';'",
"modules_path : PATH '=' QSTRING ';'",
"serverinfo_entry : SERVERINFO '{' serverinfo_items '}' ';'",
"serverinfo_items : serverinfo_items serverinfo_item",
"serverinfo_items : serverinfo_item",
"serverinfo_item : serverinfo_name",
"serverinfo_item : serverinfo_vhost",
"serverinfo_item : serverinfo_hub",
"serverinfo_item : serverinfo_description",
"serverinfo_item : serverinfo_network_name",
"serverinfo_item : serverinfo_network_desc",
"serverinfo_item : serverinfo_max_clients",
"serverinfo_item : serverinfo_rsa_private_key_file",
"serverinfo_item : serverinfo_vhost6",
"serverinfo_item : serverinfo_sid",
"serverinfo_item : serverinfo_ssl_certificate_file",
"serverinfo_item : error ';'",
"serverinfo_ssl_certificate_file : SSL_CERTIFICATE_FILE '=' QSTRING ';'",
"serverinfo_rsa_private_key_file : RSA_PRIVATE_KEY_FILE '=' QSTRING ';'",
"serverinfo_name : NAME '=' QSTRING ';'",
"serverinfo_sid : IRCD_SID '=' QSTRING ';'",
"serverinfo_description : DESCRIPTION '=' QSTRING ';'",
"serverinfo_network_name : NETWORK_NAME '=' QSTRING ';'",
"serverinfo_network_desc : NETWORK_DESC '=' QSTRING ';'",
"serverinfo_vhost : VHOST '=' QSTRING ';'",
"serverinfo_vhost6 : VHOST6 '=' QSTRING ';'",
"serverinfo_max_clients : T_MAX_CLIENTS '=' NUMBER ';'",
"serverinfo_hub : HUB '=' TBOOL ';'",
"admin_entry : ADMIN '{' admin_items '}' ';'",
"admin_items : admin_items admin_item",
"admin_items : admin_item",
"admin_item : admin_name",
"admin_item : admin_description",
"admin_item : admin_email",
"admin_item : error ';'",
"admin_name : NAME '=' QSTRING ';'",
"admin_email : EMAIL '=' QSTRING ';'",
"admin_description : DESCRIPTION '=' QSTRING ';'",
"logging_entry : LOGGING '{' logging_items '}' ';'",
"logging_items : logging_items logging_item",
"logging_items : logging_item",
"logging_item : logging_path",
"logging_item : logging_oper_log",
"logging_item : logging_log_level",
"logging_item : logging_use_logging",
"logging_item : logging_fuserlog",
"logging_item : logging_foperlog",
"logging_item : logging_fglinelog",
"logging_item : logging_fklinelog",
"logging_item : logging_killlog",
"logging_item : logging_foperspylog",
"logging_item : logging_ioerrlog",
"logging_item : logging_ffailed_operlog",
"logging_item : error ';'",
"logging_path : T_LOGPATH '=' QSTRING ';'",
"logging_oper_log : OPER_LOG '=' QSTRING ';'",
"logging_fuserlog : FUSERLOG '=' QSTRING ';'",
"logging_ffailed_operlog : FFAILED_OPERLOG '=' QSTRING ';'",
"logging_foperlog : FOPERLOG '=' QSTRING ';'",
"logging_foperspylog : FOPERSPYLOG '=' QSTRING ';'",
"logging_fglinelog : FGLINELOG '=' QSTRING ';'",
"logging_fklinelog : FKLINELOG '=' QSTRING ';'",
"logging_ioerrlog : FIOERRLOG '=' QSTRING ';'",
"logging_killlog : FKILLLOG '=' QSTRING ';'",
"logging_log_level : LOG_LEVEL '=' T_L_CRIT ';'",
"logging_log_level : LOG_LEVEL '=' T_L_ERROR ';'",
"logging_log_level : LOG_LEVEL '=' T_L_WARN ';'",
"logging_log_level : LOG_LEVEL '=' T_L_NOTICE ';'",
"logging_log_level : LOG_LEVEL '=' T_L_TRACE ';'",
"logging_log_level : LOG_LEVEL '=' T_L_INFO ';'",
"logging_log_level : LOG_LEVEL '=' T_L_DEBUG ';'",
"logging_use_logging : USE_LOGGING '=' TBOOL ';'",
"$$1 :",
"oper_entry : OPERATOR $$1 oper_name_b '{' oper_items '}' ';'",
"oper_name_b :",
"oper_name_b : oper_name_t",
"oper_items : oper_items oper_item",
"oper_items : oper_item",
"oper_item : oper_name",
"oper_item : oper_user",
"oper_item : oper_password",
"oper_item : oper_hidden_admin",
"oper_item : oper_hidden_oper",
"oper_item : oper_umodes",
"oper_item : oper_class",
"oper_item : oper_global_kill",
"oper_item : oper_remote",
"oper_item : oper_kline",
"oper_item : oper_xline",
"oper_item : oper_unkline",
"oper_item : oper_gline",
"oper_item : oper_nick_changes",
"oper_item : oper_remoteban",
"oper_item : oper_die",
"oper_item : oper_rehash",
"oper_item : oper_admin",
"oper_item : oper_operwall",
"oper_item : oper_encrypted",
"oper_item : oper_rsa_public_key_file",
"oper_item : oper_flags",
"oper_item : error ';'",
"oper_name : NAME '=' QSTRING ';'",
"oper_name_t : QSTRING",
"oper_user : USER '=' QSTRING ';'",
"oper_password : PASSWORD '=' QSTRING ';'",
"oper_encrypted : ENCRYPTED '=' TBOOL ';'",
"oper_rsa_public_key_file : RSA_PUBLIC_KEY_FILE '=' QSTRING ';'",
"oper_class : CLASS '=' QSTRING ';'",
"$$2 :",
"oper_umodes : T_UMODES $$2 '=' oper_umodes_items ';'",
"oper_umodes_items : oper_umodes_items ',' oper_umodes_item",
"oper_umodes_items : oper_umodes_item",
"oper_umodes_item : T_BOTS",
"oper_umodes_item : T_CCONN",
"oper_umodes_item : T_CCONN_FULL",
"oper_umodes_item : T_DEAF",
"oper_umodes_item : T_DEBUG",
"oper_umodes_item : T_FULL",
"oper_umodes_item : T_SKILL",
"oper_umodes_item : T_NCHANGE",
"oper_umodes_item : T_REJ",
"oper_umodes_item : T_UNAUTH",
"oper_umodes_item : T_SPY",
"oper_umodes_item : T_EXTERNAL",
"oper_umodes_item : T_OPERWALL",
"oper_umodes_item : T_SERVNOTICE",
"oper_umodes_item : T_INVISIBLE",
"oper_umodes_item : T_WALLOP",
"oper_umodes_item : T_SOFTCALLERID",
"oper_umodes_item : T_CALLERID",
"oper_umodes_item : T_LOCOPS",
"oper_global_kill : GLOBAL_KILL '=' TBOOL ';'",
"oper_remote : REMOTE '=' TBOOL ';'",
"oper_remoteban : REMOTEBAN '=' TBOOL ';'",
"oper_kline : KLINE '=' TBOOL ';'",
"oper_xline : XLINE '=' TBOOL ';'",
"oper_unkline : UNKLINE '=' TBOOL ';'",
"oper_gline : GLINE '=' TBOOL ';'",
"oper_nick_changes : NICK_CHANGES '=' TBOOL ';'",
"oper_die : DIE '=' TBOOL ';'",
"oper_rehash : REHASH '=' TBOOL ';'",
"oper_admin : ADMIN '=' TBOOL ';'",
"oper_hidden_admin : HIDDEN_ADMIN '=' TBOOL ';'",
"oper_hidden_oper : HIDDEN_OPER '=' TBOOL ';'",
"oper_operwall : T_OPERWALL '=' TBOOL ';'",
"$$3 :",
"oper_flags : IRCD_FLAGS $$3 '=' oper_flags_items ';'",
"oper_flags_items : oper_flags_items ',' oper_flags_item",
"oper_flags_items : oper_flags_item",
"$$4 :",
"oper_flags_item : NOT $$4 oper_flags_item_atom",
"$$5 :",
"oper_flags_item : $$5 oper_flags_item_atom",
"oper_flags_item_atom : GLOBAL_KILL",
"oper_flags_item_atom : REMOTE",
"oper_flags_item_atom : KLINE",
"oper_flags_item_atom : UNKLINE",
"oper_flags_item_atom : XLINE",
"oper_flags_item_atom : GLINE",
"oper_flags_item_atom : DIE",
"oper_flags_item_atom : REHASH",
"oper_flags_item_atom : ADMIN",
"oper_flags_item_atom : HIDDEN_ADMIN",
"oper_flags_item_atom : NICK_CHANGES",
"oper_flags_item_atom : T_OPERWALL",
"oper_flags_item_atom : OPER_SPY_T",
"oper_flags_item_atom : HIDDEN_OPER",
"oper_flags_item_atom : REMOTEBAN",
"oper_flags_item_atom : ENCRYPTED",
"$$6 :",
"class_entry : CLASS $$6 class_name_b '{' class_items '}' ';'",
"class_name_b :",
"class_name_b : class_name_t",
"class_items : class_items class_item",
"class_items : class_item",
"class_item : class_name",
"class_item : class_cidr_bitlen_ipv4",
"class_item : class_cidr_bitlen_ipv6",
"class_item : class_ping_time",
"class_item : class_ping_warning",
"class_item : class_number_per_cidr",
"class_item : class_number_per_ip",
"class_item : class_connectfreq",
"class_item : class_max_number",
"class_item : class_max_global",
"class_item : class_max_local",
"class_item : class_max_ident",
"class_item : class_sendq",
"class_item : error ';'",
"class_name : NAME '=' QSTRING ';'",
"class_name_t : QSTRING",
"class_ping_time : PING_TIME '=' timespec ';'",
"class_ping_warning : PING_WARNING '=' timespec ';'",
"class_number_per_ip : NUMBER_PER_IP '=' NUMBER ';'",
"class_connectfreq : CONNECTFREQ '=' timespec ';'",
"class_max_number : MAX_NUMBER '=' NUMBER ';'",
"class_max_global : MAX_GLOBAL '=' NUMBER ';'",
"class_max_local : MAX_LOCAL '=' NUMBER ';'",
"class_max_ident : MAX_IDENT '=' NUMBER ';'",
"class_sendq : SENDQ '=' sizespec ';'",
"class_cidr_bitlen_ipv4 : CIDR_BITLEN_IPV4 '=' NUMBER ';'",
"class_cidr_bitlen_ipv6 : CIDR_BITLEN_IPV6 '=' NUMBER ';'",
"class_number_per_cidr : NUMBER_PER_CIDR '=' NUMBER ';'",
"$$7 :",
"listen_entry : LISTEN $$7 '{' listen_items '}' ';'",
"$$8 :",
"listen_flags : IRCD_FLAGS $$8 '=' listen_flags_items ';'",
"listen_flags_items : listen_flags_items ',' listen_flags_item",
"listen_flags_items : listen_flags_item",
"listen_flags_item : T_SSL",
"listen_flags_item : HIDDEN",
"listen_items : listen_items listen_item",
"listen_items : listen_item",
"listen_item : listen_port",
"listen_item : listen_flags",
"listen_item : listen_address",
"listen_item : listen_host",
"listen_item : error ';'",
"$$9 :",
"listen_port : PORT '=' port_items $$9 ';'",
"port_items : port_items ',' port_item",
"port_items : port_item",
"port_item : NUMBER",
"port_item : NUMBER TWODOTS NUMBER",
"listen_address : IP '=' QSTRING ';'",
"listen_host : HOST '=' QSTRING ';'",
"$$10 :",
"auth_entry : IRCD_AUTH $$10 '{' auth_items '}' ';'",
"auth_items : auth_items auth_item",
"auth_items : auth_item",
"auth_item : auth_user",
"auth_item : auth_passwd",
"auth_item : auth_class",
"auth_item : auth_flags",
"auth_item : auth_kline_exempt",
"auth_item : auth_need_ident",
"auth_item : auth_exceed_limit",
"auth_item : auth_no_tilde",
"auth_item : auth_gline_exempt",
"auth_item : auth_spoof",
"auth_item : auth_spoof_notice",
"auth_item : auth_redir_serv",
"auth_item : auth_redir_port",
"auth_item : auth_can_flood",
"auth_item : auth_need_password",
"auth_item : auth_encrypted",
"auth_item : error ';'",
"auth_user : USER '=' QSTRING ';'",
"auth_passwd : PASSWORD '=' QSTRING ';'",
"auth_spoof_notice : SPOOF_NOTICE '=' TBOOL ';'",
"auth_class : CLASS '=' QSTRING ';'",
"auth_encrypted : ENCRYPTED '=' TBOOL ';'",
"$$11 :",
"auth_flags : IRCD_FLAGS $$11 '=' auth_flags_items ';'",
"auth_flags_items : auth_flags_items ',' auth_flags_item",
"auth_flags_items : auth_flags_item",
"$$12 :",
"auth_flags_item : NOT $$12 auth_flags_item_atom",
"$$13 :",
"auth_flags_item : $$13 auth_flags_item_atom",
"auth_flags_item_atom : SPOOF_NOTICE",
"auth_flags_item_atom : EXCEED_LIMIT",
"auth_flags_item_atom : KLINE_EXEMPT",
"auth_flags_item_atom : NEED_IDENT",
"auth_flags_item_atom : CAN_FLOOD",
"auth_flags_item_atom : CAN_IDLE",
"auth_flags_item_atom : NO_TILDE",
"auth_flags_item_atom : GLINE_EXEMPT",
"auth_flags_item_atom : RESV_EXEMPT",
"auth_flags_item_atom : NEED_PASSWORD",
"auth_kline_exempt : KLINE_EXEMPT '=' TBOOL ';'",
"auth_need_ident : NEED_IDENT '=' TBOOL ';'",
"auth_exceed_limit : EXCEED_LIMIT '=' TBOOL ';'",
"auth_can_flood : CAN_FLOOD '=' TBOOL ';'",
"auth_no_tilde : NO_TILDE '=' TBOOL ';'",
"auth_gline_exempt : GLINE_EXEMPT '=' TBOOL ';'",
"auth_spoof : SPOOF '=' QSTRING ';'",
"auth_redir_serv : REDIRSERV '=' QSTRING ';'",
"auth_redir_port : REDIRPORT '=' NUMBER ';'",
"auth_need_password : NEED_PASSWORD '=' TBOOL ';'",
"$$14 :",
"resv_entry : RESV $$14 '{' resv_items '}' ';'",
"resv_items : resv_items resv_item",
"resv_items : resv_item",
"resv_item : resv_creason",
"resv_item : resv_channel",
"resv_item : resv_nick",
"resv_item : error ';'",
"resv_creason : REASON '=' QSTRING ';'",
"resv_channel : CHANNEL '=' QSTRING ';'",
"resv_nick : NICK '=' QSTRING ';'",
"$$15 :",
"shared_entry : T_SHARED $$15 '{' shared_items '}' ';'",
"shared_items : shared_items shared_item",
"shared_items : shared_item",
"shared_item : shared_name",
"shared_item : shared_user",
"shared_item : shared_type",
"shared_item : error ';'",
"shared_name : NAME '=' QSTRING ';'",
"shared_user : USER '=' QSTRING ';'",
"$$16 :",
"shared_type : TYPE $$16 '=' shared_types ';'",
"shared_types : shared_types ',' shared_type_item",
"shared_types : shared_type_item",
"shared_type_item : KLINE",
"shared_type_item : TKLINE",
"shared_type_item : UNKLINE",
"shared_type_item : XLINE",
"shared_type_item : TXLINE",
"shared_type_item : T_UNXLINE",
"shared_type_item : RESV",
"shared_type_item : TRESV",
"shared_type_item : T_UNRESV",
"shared_type_item : T_LOCOPS",
"shared_type_item : T_ALL",
"$$17 :",
"cluster_entry : T_CLUSTER $$17 '{' cluster_items '}' ';'",
"cluster_items : cluster_items cluster_item",
"cluster_items : cluster_item",
"cluster_item : cluster_name",
"cluster_item : cluster_type",
"cluster_item : error ';'",
"cluster_name : NAME '=' QSTRING ';'",
"$$18 :",
"cluster_type : TYPE $$18 '=' cluster_types ';'",
"cluster_types : cluster_types ',' cluster_type_item",
"cluster_types : cluster_type_item",
"cluster_type_item : KLINE",
"cluster_type_item : TKLINE",
"cluster_type_item : UNKLINE",
"cluster_type_item : XLINE",
"cluster_type_item : TXLINE",
"cluster_type_item : T_UNXLINE",
"cluster_type_item : RESV",
"cluster_type_item : TRESV",
"cluster_type_item : T_UNRESV",
"cluster_type_item : T_LOCOPS",
"cluster_type_item : T_ALL",
"$$19 :",
"connect_entry : CONNECT $$19 connect_name_b '{' connect_items '}' ';'",
"connect_name_b :",
"connect_name_b : connect_name_t",
"connect_items : connect_items connect_item",
"connect_items : connect_item",
"connect_item : connect_name",
"connect_item : connect_host",
"connect_item : connect_vhost",
"connect_item : connect_send_password",
"connect_item : connect_accept_password",
"connect_item : connect_aftype",
"connect_item : connect_port",
"connect_item : connect_fakename",
"connect_item : connect_flags",
"connect_item : connect_hub_mask",
"connect_item : connect_leaf_mask",
"connect_item : connect_class",
"connect_item : connect_auto",
"connect_item : connect_encrypted",
"connect_item : connect_compressed",
"connect_item : connect_cryptlink",
"connect_item : connect_rsa_public_key_file",
"connect_item : connect_cipher_preference",
"connect_item : connect_topicburst",
"connect_item : error ';'",
"connect_name : NAME '=' QSTRING ';'",
"connect_name_t : QSTRING",
"connect_host : HOST '=' QSTRING ';'",
"connect_vhost : VHOST '=' QSTRING ';'",
"connect_send_password : SEND_PASSWORD '=' QSTRING ';'",
"connect_accept_password : ACCEPT_PASSWORD '=' QSTRING ';'",
"connect_port : PORT '=' NUMBER ';'",
"connect_aftype : AFTYPE '=' T_IPV4 ';'",
"connect_aftype : AFTYPE '=' T_IPV6 ';'",
"connect_fakename : FAKENAME '=' QSTRING ';'",
"$$20 :",
"connect_flags : IRCD_FLAGS $$20 '=' connect_flags_items ';'",
"connect_flags_items : connect_flags_items ',' connect_flags_item",
"connect_flags_items : connect_flags_item",
"$$21 :",
"connect_flags_item : NOT $$21 connect_flags_item_atom",
"$$22 :",
"connect_flags_item : $$22 connect_flags_item_atom",
"connect_flags_item_atom : LAZYLINK",
"connect_flags_item_atom : COMPRESSED",
"connect_flags_item_atom : CRYPTLINK",
"connect_flags_item_atom : AUTOCONN",
"connect_flags_item_atom : BURST_AWAY",
"connect_flags_item_atom : TOPICBURST",
"connect_rsa_public_key_file : RSA_PUBLIC_KEY_FILE '=' QSTRING ';'",
"connect_encrypted : ENCRYPTED '=' TBOOL ';'",
"connect_cryptlink : CRYPTLINK '=' TBOOL ';'",
"connect_compressed : COMPRESSED '=' TBOOL ';'",
"connect_auto : AUTOCONN '=' TBOOL ';'",
"connect_topicburst : TOPICBURST '=' TBOOL ';'",
"connect_hub_mask : HUB_MASK '=' QSTRING ';'",
"connect_leaf_mask : LEAF_MASK '=' QSTRING ';'",
"connect_class : CLASS '=' QSTRING ';'",
"connect_cipher_preference : CIPHER_PREFERENCE '=' QSTRING ';'",
"$$23 :",
"kill_entry : KILL $$23 '{' kill_items '}' ';'",
"$$24 :",
"kill_type : TYPE $$24 '=' kill_type_items ';'",
"kill_type_items : kill_type_items ',' kill_type_item",
"kill_type_items : kill_type_item",
"kill_type_item : REGEX_T",
"kill_items : kill_items kill_item",
"kill_items : kill_item",
"kill_item : kill_user",
"kill_item : kill_reason",
"kill_item : kill_type",
"kill_item : error",
"kill_user : USER '=' QSTRING ';'",
"kill_reason : REASON '=' QSTRING ';'",
"$$25 :",
"deny_entry : DENY $$25 '{' deny_items '}' ';'",
"deny_items : deny_items deny_item",
"deny_items : deny_item",
"deny_item : deny_ip",
"deny_item : deny_reason",
"deny_item : error",
"deny_ip : IP '=' QSTRING ';'",
"deny_reason : REASON '=' QSTRING ';'",
"exempt_entry : EXEMPT '{' exempt_items '}' ';'",
"exempt_items : exempt_items exempt_item",
"exempt_items : exempt_item",
"exempt_item : exempt_ip",
"exempt_item : error",
"exempt_ip : IP '=' QSTRING ';'",
"$$26 :",
"gecos_entry : GECOS $$26 '{' gecos_items '}' ';'",
"$$27 :",
"gecos_flags : TYPE $$27 '=' gecos_flags_items ';'",
"gecos_flags_items : gecos_flags_items ',' gecos_flags_item",
"gecos_flags_items : gecos_flags_item",
"gecos_flags_item : REGEX_T",
"gecos_items : gecos_items gecos_item",
"gecos_items : gecos_item",
"gecos_item : gecos_name",
"gecos_item : gecos_reason",
"gecos_item : gecos_flags",
"gecos_item : error",
"gecos_name : NAME '=' QSTRING ';'",
"gecos_reason : REASON '=' QSTRING ';'",
"general_entry : GENERAL '{' general_items '}' ';'",
"general_items : general_items general_item",
"general_items : general_item",
"general_item : general_hide_spoof_ips",
"general_item : general_ignore_bogus_ts",
"general_item : general_failed_oper_notice",
"general_item : general_anti_nick_flood",
"general_item : general_max_nick_time",
"general_item : general_max_nick_changes",
"general_item : general_max_accept",
"general_item : general_anti_spam_exit_message_time",
"general_item : general_ts_warn_delta",
"general_item : general_ts_max_delta",
"general_item : general_kill_chase_time_limit",
"general_item : general_kline_with_reason",
"general_item : general_kline_reason",
"general_item : general_invisible_on_connect",
"general_item : general_warn_no_nline",
"general_item : general_dots_in_ident",
"general_item : general_stats_o_oper_only",
"general_item : general_stats_k_oper_only",
"general_item : general_pace_wait",
"general_item : general_stats_i_oper_only",
"general_item : general_pace_wait_simple",
"general_item : general_stats_P_oper_only",
"general_item : general_short_motd",
"general_item : general_no_oper_flood",
"general_item : general_true_no_oper_flood",
"general_item : general_oper_pass_resv",
"general_item : general_idletime",
"general_item : general_message_locale",
"general_item : general_oper_only_umodes",
"general_item : general_max_targets",
"general_item : general_use_egd",
"general_item : general_egdpool_path",
"general_item : general_oper_umodes",
"general_item : general_caller_id_wait",
"general_item : general_opers_bypass_callerid",
"general_item : general_default_floodcount",
"general_item : general_min_nonwildcard",
"general_item : general_min_nonwildcard_simple",
"general_item : general_servlink_path",
"general_item : general_disable_remote_commands",
"general_item : general_default_cipher_preference",
"general_item : general_compression_level",
"general_item : general_client_flood",
"general_item : general_throttle_time",
"general_item : general_havent_read_conf",
"general_item : general_dot_in_ip6_addr",
"general_item : general_ping_cookie",
"general_item : general_disable_auth",
"general_item : general_burst_away",
"general_item : general_tkline_expire_notices",
"general_item : general_gline_min_cidr",
"general_item : general_gline_min_cidr6",
"general_item : general_use_whois_actually",
"general_item : general_reject_hold_time",
"general_item : general_stats_e_disabled",
"general_item : error",
"general_gline_min_cidr : GLINE_MIN_CIDR '=' NUMBER ';'",
"general_gline_min_cidr6 : GLINE_MIN_CIDR6 '=' NUMBER ';'",
"general_burst_away : BURST_AWAY '=' TBOOL ';'",
"general_use_whois_actually : USE_WHOIS_ACTUALLY '=' TBOOL ';'",
"general_reject_hold_time : TREJECT_HOLD_TIME '=' timespec ';'",
"general_tkline_expire_notices : TKLINE_EXPIRE_NOTICES '=' TBOOL ';'",
"general_kill_chase_time_limit : KILL_CHASE_TIME_LIMIT '=' NUMBER ';'",
"general_hide_spoof_ips : HIDE_SPOOF_IPS '=' TBOOL ';'",
"general_ignore_bogus_ts : IGNORE_BOGUS_TS '=' TBOOL ';'",
"general_disable_remote_commands : DISABLE_REMOTE_COMMANDS '=' TBOOL ';'",
"general_failed_oper_notice : FAILED_OPER_NOTICE '=' TBOOL ';'",
"general_anti_nick_flood : ANTI_NICK_FLOOD '=' TBOOL ';'",
"general_max_nick_time : MAX_NICK_TIME '=' timespec ';'",
"general_max_nick_changes : MAX_NICK_CHANGES '=' NUMBER ';'",
"general_max_accept : MAX_ACCEPT '=' NUMBER ';'",
"general_anti_spam_exit_message_time : ANTI_SPAM_EXIT_MESSAGE_TIME '=' timespec ';'",
"general_ts_warn_delta : TS_WARN_DELTA '=' timespec ';'",
"general_ts_max_delta : TS_MAX_DELTA '=' timespec ';'",
"general_havent_read_conf : HAVENT_READ_CONF '=' NUMBER ';'",
"general_kline_with_reason : KLINE_WITH_REASON '=' TBOOL ';'",
"general_kline_reason : KLINE_REASON '=' QSTRING ';'",
"general_invisible_on_connect : INVISIBLE_ON_CONNECT '=' TBOOL ';'",
"general_warn_no_nline : WARN_NO_NLINE '=' TBOOL ';'",
"general_stats_e_disabled : STATS_E_DISABLED '=' TBOOL ';'",
"general_stats_o_oper_only : STATS_O_OPER_ONLY '=' TBOOL ';'",
"general_stats_P_oper_only : STATS_P_OPER_ONLY '=' TBOOL ';'",
"general_stats_k_oper_only : STATS_K_OPER_ONLY '=' TBOOL ';'",
"general_stats_k_oper_only : STATS_K_OPER_ONLY '=' TMASKED ';'",
"general_stats_i_oper_only : STATS_I_OPER_ONLY '=' TBOOL ';'",
"general_stats_i_oper_only : STATS_I_OPER_ONLY '=' TMASKED ';'",
"general_pace_wait : PACE_WAIT '=' timespec ';'",
"general_caller_id_wait : CALLER_ID_WAIT '=' timespec ';'",
"general_opers_bypass_callerid : OPERS_BYPASS_CALLERID '=' TBOOL ';'",
"general_pace_wait_simple : PACE_WAIT_SIMPLE '=' timespec ';'",
"general_short_motd : SHORT_MOTD '=' TBOOL ';'",
"general_no_oper_flood : NO_OPER_FLOOD '=' TBOOL ';'",
"general_true_no_oper_flood : TRUE_NO_OPER_FLOOD '=' TBOOL ';'",
"general_oper_pass_resv : OPER_PASS_RESV '=' TBOOL ';'",
"general_message_locale : MESSAGE_LOCALE '=' QSTRING ';'",
"general_idletime : IDLETIME '=' timespec ';'",
"general_dots_in_ident : DOTS_IN_IDENT '=' NUMBER ';'",
"general_max_targets : MAX_TARGETS '=' NUMBER ';'",
"general_servlink_path : SERVLINK_PATH '=' QSTRING ';'",
"general_default_cipher_preference : DEFAULT_CIPHER_PREFERENCE '=' QSTRING ';'",
"general_compression_level : COMPRESSION_LEVEL '=' NUMBER ';'",
"general_use_egd : USE_EGD '=' TBOOL ';'",
"general_egdpool_path : EGDPOOL_PATH '=' QSTRING ';'",
"general_ping_cookie : PING_COOKIE '=' TBOOL ';'",
"general_disable_auth : DISABLE_AUTH '=' TBOOL ';'",
"general_throttle_time : THROTTLE_TIME '=' timespec ';'",
"$$28 :",
"general_oper_umodes : OPER_UMODES $$28 '=' umode_oitems ';'",
"umode_oitems : umode_oitems ',' umode_oitem",
"umode_oitems : umode_oitem",
"umode_oitem : T_BOTS",
"umode_oitem : T_CCONN",
"umode_oitem : T_CCONN_FULL",
"umode_oitem : T_DEAF",
"umode_oitem : T_DEBUG",
"umode_oitem : T_FULL",
"umode_oitem : T_SKILL",
"umode_oitem : T_NCHANGE",
"umode_oitem : T_REJ",
"umode_oitem : T_UNAUTH",
"umode_oitem : T_SPY",
"umode_oitem : T_EXTERNAL",
"umode_oitem : T_OPERWALL",
"umode_oitem : T_SERVNOTICE",
"umode_oitem : T_INVISIBLE",
"umode_oitem : T_WALLOP",
"umode_oitem : T_SOFTCALLERID",
"umode_oitem : T_CALLERID",
"umode_oitem : T_LOCOPS",
"$$29 :",
"general_oper_only_umodes : OPER_ONLY_UMODES $$29 '=' umode_items ';'",
"umode_items : umode_items ',' umode_item",
"umode_items : umode_item",
"umode_item : T_BOTS",
"umode_item : T_CCONN",
"umode_item : T_CCONN_FULL",
"umode_item : T_DEAF",
"umode_item : T_DEBUG",
"umode_item : T_FULL",
"umode_item : T_SKILL",
"umode_item : T_NCHANGE",
"umode_item : T_REJ",
"umode_item : T_UNAUTH",
"umode_item : T_SPY",
"umode_item : T_EXTERNAL",
"umode_item : T_OPERWALL",
"umode_item : T_SERVNOTICE",
"umode_item : T_INVISIBLE",
"umode_item : T_WALLOP",
"umode_item : T_SOFTCALLERID",
"umode_item : T_CALLERID",
"umode_item : T_LOCOPS",
"general_min_nonwildcard : MIN_NONWILDCARD '=' NUMBER ';'",
"general_min_nonwildcard_simple : MIN_NONWILDCARD_SIMPLE '=' NUMBER ';'",
"general_default_floodcount : DEFAULT_FLOODCOUNT '=' NUMBER ';'",
"general_client_flood : T_CLIENT_FLOOD '=' sizespec ';'",
"general_dot_in_ip6_addr : DOT_IN_IP6_ADDR '=' TBOOL ';'",
"$$30 :",
"gline_entry : GLINES $$30 '{' gline_items '}' ';'",
"gline_items : gline_items gline_item",
"gline_items : gline_item",
"gline_item : gline_enable",
"gline_item : gline_duration",
"gline_item : gline_logging",
"gline_item : gline_user",
"gline_item : gline_server",
"gline_item : gline_action",
"gline_item : error",
"gline_enable : ENABLE '=' TBOOL ';'",
"gline_duration : DURATION '=' timespec ';'",
"$$31 :",
"gline_logging : LOGGING $$31 '=' gline_logging_types ';'",
"gline_logging_types : gline_logging_types ',' gline_logging_type_item",
"gline_logging_types : gline_logging_type_item",
"gline_logging_type_item : T_REJECT",
"gline_logging_type_item : T_BLOCK",
"gline_user : USER '=' QSTRING ';'",
"gline_server : NAME '=' QSTRING ';'",
"$$32 :",
"gline_action : ACTION $$32 '=' gdeny_types ';'",
"gdeny_types : gdeny_types ',' gdeny_type_item",
"gdeny_types : gdeny_type_item",
"gdeny_type_item : T_REJECT",
"gdeny_type_item : T_BLOCK",
"channel_entry : CHANNEL '{' channel_items '}' ';'",
"channel_items : channel_items channel_item",
"channel_items : channel_item",
"channel_item : channel_disable_local_channels",
"channel_item : channel_use_except",
"channel_item : channel_use_invex",
"channel_item : channel_use_knock",
"channel_item : channel_max_bans",
"channel_item : channel_knock_delay",
"channel_item : channel_knock_delay_channel",
"channel_item : channel_max_chans_per_user",
"channel_item : channel_quiet_on_ban",
"channel_item : channel_default_split_user_count",
"channel_item : channel_default_split_server_count",
"channel_item : channel_no_create_on_split",
"channel_item : channel_restrict_channels",
"channel_item : channel_no_join_on_split",
"channel_item : channel_burst_topicwho",
"channel_item : channel_jflood_count",
"channel_item : channel_jflood_time",
"channel_item : channel_disable_fake_channels",
"channel_item : error",
"channel_disable_fake_channels : DISABLE_FAKE_CHANNELS '=' TBOOL ';'",
"channel_restrict_channels : RESTRICT_CHANNELS '=' TBOOL ';'",
"channel_disable_local_channels : DISABLE_LOCAL_CHANNELS '=' TBOOL ';'",
"channel_use_except : USE_EXCEPT '=' TBOOL ';'",
"channel_use_invex : USE_INVEX '=' TBOOL ';'",
"channel_use_knock : USE_KNOCK '=' TBOOL ';'",
"channel_knock_delay : KNOCK_DELAY '=' timespec ';'",
"channel_knock_delay_channel : KNOCK_DELAY_CHANNEL '=' timespec ';'",
"channel_max_chans_per_user : MAX_CHANS_PER_USER '=' NUMBER ';'",
"channel_quiet_on_ban : QUIET_ON_BAN '=' TBOOL ';'",
"channel_max_bans : MAX_BANS '=' NUMBER ';'",
"channel_default_split_user_count : DEFAULT_SPLIT_USER_COUNT '=' NUMBER ';'",
"channel_default_split_server_count : DEFAULT_SPLIT_SERVER_COUNT '=' NUMBER ';'",
"channel_no_create_on_split : NO_CREATE_ON_SPLIT '=' TBOOL ';'",
"channel_no_join_on_split : NO_JOIN_ON_SPLIT '=' TBOOL ';'",
"channel_burst_topicwho : BURST_TOPICWHO '=' TBOOL ';'",
"channel_jflood_count : JOIN_FLOOD_COUNT '=' NUMBER ';'",
"channel_jflood_time : JOIN_FLOOD_TIME '=' timespec ';'",
"serverhide_entry : SERVERHIDE '{' serverhide_items '}' ';'",
"serverhide_items : serverhide_items serverhide_item",
"serverhide_items : serverhide_item",
"serverhide_item : serverhide_flatten_links",
"serverhide_item : serverhide_hide_servers",
"serverhide_item : serverhide_links_delay",
"serverhide_item : serverhide_disable_hidden",
"serverhide_item : serverhide_hidden",
"serverhide_item : serverhide_hidden_name",
"serverhide_item : serverhide_hide_server_ips",
"serverhide_item : error",
"serverhide_flatten_links : FLATTEN_LINKS '=' TBOOL ';'",
"serverhide_hide_servers : HIDE_SERVERS '=' TBOOL ';'",
"serverhide_hidden_name : HIDDEN_NAME '=' QSTRING ';'",
"serverhide_links_delay : LINKS_DELAY '=' timespec ';'",
"serverhide_hidden : HIDDEN '=' TBOOL ';'",
"serverhide_disable_hidden : DISABLE_HIDDEN '=' TBOOL ';'",
"serverhide_hide_server_ips : HIDE_SERVER_IPS '=' TBOOL ';'",
};
#endif
#if YYDEBUG
#include <stdio.h>
#endif
#ifdef YYSTACKSIZE
#undef YYMAXDEPTH
#define YYMAXDEPTH YYSTACKSIZE
#else
#ifdef YYMAXDEPTH
#define YYSTACKSIZE YYMAXDEPTH
#else
#define YYSTACKSIZE 10000
#define YYMAXDEPTH 10000
#endif
#endif
#define YYINITSTACKSIZE 200
int yydebug;
int yynerrs;
int yyerrflag;
int yychar;
short *yyssp;
YYSTYPE *yyvsp;
YYSTYPE yyval;
YYSTYPE yylval;
short *yyss;
short *yysslim;
YYSTYPE *yyvs;
int yystacksize;
/* allocate initial stack or double stack size, up to YYMAXDEPTH */
static int yygrowstack()
{
    int newsize, i;
    short *newss;
    YYSTYPE *newvs;

    if ((newsize = yystacksize) == 0)
        newsize = YYINITSTACKSIZE;
    else if (newsize >= YYMAXDEPTH)
        return -1;
    else if ((newsize *= 2) > YYMAXDEPTH)
        newsize = YYMAXDEPTH;
    i = yyssp - yyss;
    newss = yyss ? (short *)realloc(yyss, newsize * sizeof *newss) :
      (short *)malloc(newsize * sizeof *newss);
    if (newss == NULL)
        return -1;
    yyss = newss;
    yyssp = newss + i;
    newvs = yyvs ? (YYSTYPE *)realloc(yyvs, newsize * sizeof *newvs) :
      (YYSTYPE *)malloc(newsize * sizeof *newvs);
    if (newvs == NULL)
        return -1;
    yyvs = newvs;
    yyvsp = newvs + i;
    yystacksize = newsize;
    yysslim = yyss + newsize - 1;
    return 0;
}

#define YYABORT goto yyabort
#define YYREJECT goto yyabort
#define YYACCEPT goto yyaccept
#define YYERROR goto yyerrlab

#ifndef YYPARSE_PARAM
#if defined(__cplusplus) || __STDC__
#define YYPARSE_PARAM_ARG void
#define YYPARSE_PARAM_DECL
#else	/* ! ANSI-C/C++ */
#define YYPARSE_PARAM_ARG
#define YYPARSE_PARAM_DECL
#endif	/* ANSI-C/C++ */
#else	/* YYPARSE_PARAM */
#ifndef YYPARSE_PARAM_TYPE
#define YYPARSE_PARAM_TYPE void *
#endif
#if defined(__cplusplus) || __STDC__
#define YYPARSE_PARAM_ARG YYPARSE_PARAM_TYPE YYPARSE_PARAM
#define YYPARSE_PARAM_DECL
#else	/* ! ANSI-C/C++ */
#define YYPARSE_PARAM_ARG YYPARSE_PARAM
#define YYPARSE_PARAM_DECL YYPARSE_PARAM_TYPE YYPARSE_PARAM;
#endif	/* ANSI-C/C++ */
#endif	/* ! YYPARSE_PARAM */

int
yyparse (YYPARSE_PARAM_ARG)
    YYPARSE_PARAM_DECL
{
    int yym, yyn, yystate;
#if YYDEBUG
    const char *yys;

    if ((yys = getenv("YYDEBUG")))
    {
        yyn = *yys;
        if (yyn >= '0' && yyn <= '9')
            yydebug = yyn - '0';
    }
#endif

    yynerrs = 0;
    yyerrflag = 0;
    yychar = (-1);

    if (yyss == NULL && yygrowstack()) goto yyoverflow;
    yyssp = yyss;
    yyvsp = yyvs;
    *yyssp = yystate = 0;

yyloop:
    if ((yyn = yydefred[yystate])) goto yyreduce;
    if (yychar < 0)
    {
        if ((yychar = yylex()) < 0) yychar = 0;
#if YYDEBUG
        if (yydebug)
        {
            yys = 0;
            if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
            if (!yys) yys = "illegal-symbol";
            printf("%sdebug: state %d, reading %d (%s)\n",
                    YYPREFIX, yystate, yychar, yys);
        }
#endif
    }
    if ((yyn = yysindex[yystate]) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yychar)
    {
#if YYDEBUG
        if (yydebug)
            printf("%sdebug: state %d, shifting to state %d\n",
                    YYPREFIX, yystate, yytable[yyn]);
#endif
        if (yyssp >= yysslim && yygrowstack())
        {
            goto yyoverflow;
        }
        *++yyssp = yystate = yytable[yyn];
        *++yyvsp = yylval;
        yychar = (-1);
        if (yyerrflag > 0)  --yyerrflag;
        goto yyloop;
    }
    if ((yyn = yyrindex[yystate]) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yychar)
    {
        yyn = yytable[yyn];
        goto yyreduce;
    }
    if (yyerrflag) goto yyinrecovery;
#if defined(lint) || defined(__GNUC__)
    goto yynewerror;
#endif
yynewerror:
    yyerror("syntax error");
#if defined(lint) || defined(__GNUC__)
    goto yyerrlab;
#endif
yyerrlab:
    ++yynerrs;
yyinrecovery:
    if (yyerrflag < 3)
    {
        yyerrflag = 3;
        for (;;)
        {
            if ((yyn = yysindex[*yyssp]) && (yyn += YYERRCODE) >= 0 &&
                    yyn <= YYTABLESIZE && yycheck[yyn] == YYERRCODE)
            {
#if YYDEBUG
                if (yydebug)
                    printf("%sdebug: state %d, error recovery shifting\
 to state %d\n", YYPREFIX, *yyssp, yytable[yyn]);
#endif
                if (yyssp >= yysslim && yygrowstack())
                {
                    goto yyoverflow;
                }
                *++yyssp = yystate = yytable[yyn];
                *++yyvsp = yylval;
                goto yyloop;
            }
            else
            {
#if YYDEBUG
                if (yydebug)
                    printf("%sdebug: error recovery discarding state %d\n",
                            YYPREFIX, *yyssp);
#endif
                if (yyssp <= yyss) goto yyabort;
                --yyssp;
                --yyvsp;
            }
        }
    }
    else
    {
        if (yychar == 0) goto yyabort;
#if YYDEBUG
        if (yydebug)
        {
            yys = 0;
            if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
            if (!yys) yys = "illegal-symbol";
            printf("%sdebug: state %d, error recovery discards token %d (%s)\n",
                    YYPREFIX, yystate, yychar, yys);
        }
#endif
        yychar = (-1);
        goto yyloop;
    }
yyreduce:
#if YYDEBUG
    if (yydebug)
        printf("%sdebug: state %d, reducing by rule %d (%s)\n",
                YYPREFIX, yystate, yyn, yyrule[yyn]);
#endif
    yym = yylen[yyn];
    yyval = yyvsp[1-yym];
    switch (yyn)
    {
case 25:
#line 424 "ircd_parser.y"
{ yyval.number = 0; }
break;
case 27:
#line 426 "ircd_parser.y"
{
			yyval.number = yyvsp[-1].number + yyvsp[0].number;
		}
break;
case 28:
#line 430 "ircd_parser.y"
{
			yyval.number = yyvsp[-2].number + yyvsp[0].number;
		}
break;
case 29:
#line 434 "ircd_parser.y"
{
			yyval.number = yyvsp[-2].number * 60 + yyvsp[0].number;
		}
break;
case 30:
#line 438 "ircd_parser.y"
{
			yyval.number = yyvsp[-2].number * 60 * 60 + yyvsp[0].number;
		}
break;
case 31:
#line 442 "ircd_parser.y"
{
			yyval.number = yyvsp[-2].number * 60 * 60 * 24 + yyvsp[0].number;
		}
break;
case 32:
#line 446 "ircd_parser.y"
{
			yyval.number = yyvsp[-2].number * 60 * 60 * 24 * 7 + yyvsp[0].number;
		}
break;
case 33:
#line 451 "ircd_parser.y"
{ yyval.number = 0; }
break;
case 35:
#line 452 "ircd_parser.y"
{ yyval.number = yyvsp[-1].number + yyvsp[0].number; }
break;
case 36:
#line 453 "ircd_parser.y"
{ yyval.number = yyvsp[-2].number + yyvsp[0].number; }
break;
case 37:
#line 454 "ircd_parser.y"
{ yyval.number = yyvsp[-2].number * 1024 + yyvsp[0].number; }
break;
case 38:
#line 455 "ircd_parser.y"
{ yyval.number = yyvsp[-2].number * 1024 * 1024 + yyvsp[0].number; }
break;
case 45:
#line 469 "ircd_parser.y"
{
#ifndef STATIC_MODULES /* NOOP in the static case */
  if (ypass == 2)
  {
    char *m_bn;

    m_bn = basename(yylval.string);

    /* I suppose we should just ignore it if it is already loaded(since
     * otherwise we would flood the opers on rehash) -A1kmm.
     */
    add_conf_module(yylval.string);
  }
#endif
}
break;
case 46:
#line 486 "ircd_parser.y"
{
#ifndef STATIC_MODULES
  if (ypass == 2)
    mod_add_path(yylval.string);
#endif
}
break;
case 62:
#line 510 "ircd_parser.y"
{
#ifdef HAVE_LIBCRYPTO
  if (ypass == 2 && ServerInfo.ctx) 
  {
    if (!ServerInfo.rsa_private_key_file)
    {
      yyerror("No rsa_private_key_file specified, SSL disabled");
      break;
    }

    if (SSL_CTX_use_certificate_file(ServerInfo.ctx,
      yylval.string, SSL_FILETYPE_PEM) <= 0)
    {
      yyerror(ERR_lib_error_string(ERR_get_error()));
      break;
    }

    if (SSL_CTX_use_PrivateKey_file(ServerInfo.ctx,
      ServerInfo.rsa_private_key_file, SSL_FILETYPE_PEM) <= 0)
    {
      yyerror(ERR_lib_error_string(ERR_get_error()));
      break;
    }

    if (!SSL_CTX_check_private_key(ServerInfo.ctx))
    {
      yyerror("RSA private key does not match the SSL certificate public key!");
      break;
    }
  }
#endif
}
break;
case 63:
#line 544 "ircd_parser.y"
{
#ifdef HAVE_LIBCRYPTO
  if (ypass == 1)
  {
    BIO *file;

    if (ServerInfo.rsa_private_key)
    {
      RSA_free(ServerInfo.rsa_private_key);
      ServerInfo.rsa_private_key = NULL;
    }

    if (ServerInfo.rsa_private_key_file)
    {
      MyFree(ServerInfo.rsa_private_key_file);
      ServerInfo.rsa_private_key_file = NULL;
    }

    DupString(ServerInfo.rsa_private_key_file, yylval.string);

    if ((file = BIO_new_file(yylval.string, "r")) == NULL)
    {
      yyerror("File open failed, ignoring");
      break;
    }

    ServerInfo.rsa_private_key = (RSA *)PEM_read_bio_RSAPrivateKey(file, NULL,
      0, NULL);

    BIO_set_close(file, BIO_CLOSE);
    BIO_free(file);

    if (ServerInfo.rsa_private_key == NULL)
    {
      yyerror("Couldn't extract key, ignoring");
      break;
    }

    if (!RSA_check_key(ServerInfo.rsa_private_key))
    {
      RSA_free(ServerInfo.rsa_private_key);
      ServerInfo.rsa_private_key = NULL;

      yyerror("Invalid key, ignoring");
      break;
    }

    /* require 2048 bit (256 byte) key */
    if (RSA_size(ServerInfo.rsa_private_key) != 256)
    {
      RSA_free(ServerInfo.rsa_private_key);
      ServerInfo.rsa_private_key = NULL;

      yyerror("Not a 2048 bit key, ignoring");
    }
  }
#endif
}
break;
case 64:
#line 604 "ircd_parser.y"
{
  /* this isn't rehashable */
  if (ypass == 2)
  {
    if (ServerInfo.name == NULL)
    {
      /* the ircd will exit() in main() if we dont set one */
      if (strlen(yylval.string) <= HOSTLEN)
        DupString(ServerInfo.name, yylval.string);
    }
  }
}
break;
case 65:
#line 618 "ircd_parser.y"
{
  /* this isn't rehashable */
  if (ypass == 2 && !ServerInfo.sid)
  {
    if (valid_sid(yylval.string))
      DupString(ServerInfo.sid, yylval.string);
    else
    {
      ilog(L_ERROR, "Ignoring config file entry SID -- invalid SID. Aborting.");
      exit(0);
    }
  }
}
break;
case 66:
#line 633 "ircd_parser.y"
{
  if (ypass == 2)
  {
    MyFree(ServerInfo.description);
    DupString(ServerInfo.description,yylval.string);
  }
}
break;
case 67:
#line 642 "ircd_parser.y"
{
  if (ypass == 2)
  {
    char *p;

    if ((p = strchr(yylval.string, ' ')) != NULL)
      p = '\0';

    MyFree(ServerInfo.network_name);
    DupString(ServerInfo.network_name, yylval.string);
  }
}
break;
case 68:
#line 656 "ircd_parser.y"
{
  if (ypass == 2)
  {
    MyFree(ServerInfo.network_desc);
    DupString(ServerInfo.network_desc, yylval.string);
  }
}
break;
case 69:
#line 665 "ircd_parser.y"
{
  if (ypass == 2 && *yylval.string != '*')
  {
    struct addrinfo hints, *res;

    memset(&hints, 0, sizeof(hints));

    hints.ai_family   = AF_UNSPEC;
    hints.ai_socktype = SOCK_STREAM;
    hints.ai_flags    = AI_PASSIVE | AI_NUMERICHOST;

    if (irc_getaddrinfo(yylval.string, NULL, &hints, &res))
      ilog(L_ERROR, "Invalid netmask for server vhost(%s)", yylval.string);
    else
    {
      assert(res != NULL);

      memcpy(&ServerInfo.ip, res->ai_addr, res->ai_addrlen);
      ServerInfo.ip.ss.ss_family = res->ai_family;
      ServerInfo.ip.ss_len = res->ai_addrlen;
      irc_freeaddrinfo(res);

      ServerInfo.specific_ipv4_vhost = 1;
    }
  }
}
break;
case 70:
#line 693 "ircd_parser.y"
{
#ifdef IPV6
  if (ypass == 2 && *yylval.string != '*')
  {
    struct addrinfo hints, *res;

    memset(&hints, 0, sizeof(hints));

    hints.ai_family   = AF_UNSPEC;
    hints.ai_socktype = SOCK_STREAM;
    hints.ai_flags    = AI_PASSIVE | AI_NUMERICHOST;

    if (irc_getaddrinfo(yylval.string, NULL, &hints, &res))
      ilog(L_ERROR, "Invalid netmask for server vhost6(%s)", yylval.string);
    else
    {
      assert(res != NULL);

      memcpy(&ServerInfo.ip6, res->ai_addr, res->ai_addrlen);
      ServerInfo.ip6.ss.ss_family = res->ai_family;
      ServerInfo.ip6.ss_len = res->ai_addrlen;
      irc_freeaddrinfo(res);

      ServerInfo.specific_ipv6_vhost = 1;
    }
  }
#endif
}
break;
case 71:
#line 723 "ircd_parser.y"
{
  if (ypass == 2)
  {
    recalc_fdlimit(NULL);

    if (yyvsp[-1].number < MAXCLIENTS_MIN)
    {
      char buf[IRCD_BUFSIZE];
      ircsprintf(buf, "MAXCLIENTS too low, setting to %d", MAXCLIENTS_MIN);
      yyerror(buf);
    }
    else if (yyvsp[-1].number > MAXCLIENTS_MAX)
    {
      char buf[IRCD_BUFSIZE];
      ircsprintf(buf, "MAXCLIENTS too high, setting to %d", MAXCLIENTS_MAX);
      yyerror(buf);
    }
    else
      ServerInfo.max_clients = yyvsp[-1].number;
  }
}
break;
case 72:
#line 746 "ircd_parser.y"
{
  if (ypass == 2)
  {
    if (yylval.number)
    {
      /* Don't become a hub if we have a lazylink active. */
      if (!ServerInfo.hub && uplink && IsCapable(uplink, CAP_LL))
      {
        sendto_realops_flags(UMODE_ALL, L_ALL,
                             "Ignoring config file line hub=yes; "
                             "due to active LazyLink (%s)", uplink->name);
      }
      else
      {
        ServerInfo.hub = 1;
        uplink = NULL;
        delete_capability("HUB");
        add_capability("HUB", CAP_HUB, 1);
      }
    }
    else if (ServerInfo.hub)
    {
      dlink_node *ptr = NULL;

      ServerInfo.hub = 0;
      delete_capability("HUB");

      /* Don't become a leaf if we have a lazylink active. */
      DLINK_FOREACH(ptr, serv_list.head)
      {
        const struct Client *acptr = ptr->data;
        if (MyConnect(acptr) && IsCapable(acptr, CAP_LL))
        {
          sendto_realops_flags(UMODE_ALL, L_ALL,
                               "Ignoring config file line hub=no; "
                               "due to active LazyLink (%s)",
                               acptr->name);
          add_capability("HUB", CAP_HUB, 1);
          ServerInfo.hub = 1;
          break;
        }
      }
    }
  }
}
break;
case 80:
#line 802 "ircd_parser.y"
{
  if (ypass == 2)
  {
    MyFree(AdminInfo.name);
    DupString(AdminInfo.name, yylval.string);
  }
}
break;
case 81:
#line 811 "ircd_parser.y"
{
  if (ypass == 2)
  {
    MyFree(AdminInfo.email);
    DupString(AdminInfo.email, yylval.string);
  }
}
break;
case 82:
#line 820 "ircd_parser.y"
{
  if (ypass == 2)
  {
    MyFree(AdminInfo.description);
    DupString(AdminInfo.description, yylval.string);
  }
}
break;
case 99:
#line 847 "ircd_parser.y"
{
                        }
break;
case 100:
#line 851 "ircd_parser.y"
{
                        }
break;
case 101:
#line 855 "ircd_parser.y"
{
  if (ypass == 2)
    strlcpy(ConfigLoggingEntry.userlog, yylval.string,
            sizeof(ConfigLoggingEntry.userlog));
}
break;
case 102:
#line 862 "ircd_parser.y"
{
  if (ypass == 2)
    strlcpy(ConfigLoggingEntry.failed_operlog, yylval.string,
            sizeof(ConfigLoggingEntry.failed_operlog));
}
break;
case 103:
#line 869 "ircd_parser.y"
{
  if (ypass == 2)
    strlcpy(ConfigLoggingEntry.operlog, yylval.string,
            sizeof(ConfigLoggingEntry.operlog));
}
break;
case 104:
#line 876 "ircd_parser.y"
{
  if (ypass == 2)
    strlcpy(ConfigLoggingEntry.operspylog, yylval.string,
            sizeof(ConfigLoggingEntry.operspylog));
}
break;
case 105:
#line 883 "ircd_parser.y"
{
  if (ypass == 2)
    strlcpy(ConfigLoggingEntry.glinelog, yylval.string,
            sizeof(ConfigLoggingEntry.glinelog));
}
break;
case 106:
#line 890 "ircd_parser.y"
{
  if (ypass == 2)
    strlcpy(ConfigLoggingEntry.klinelog, yylval.string,
            sizeof(ConfigLoggingEntry.klinelog));
}
break;
case 107:
#line 897 "ircd_parser.y"
{
  if (ypass == 2)
    strlcpy(ConfigLoggingEntry.ioerrlog, yylval.string,
            sizeof(ConfigLoggingEntry.ioerrlog));
}
break;
case 108:
#line 904 "ircd_parser.y"
{
  if (ypass == 2)
    strlcpy(ConfigLoggingEntry.killlog, yylval.string,
            sizeof(ConfigLoggingEntry.killlog));
}
break;
case 109:
#line 911 "ircd_parser.y"
{ 
  if (ypass == 2)
    set_log_level(L_CRIT);
}
break;
case 110:
#line 915 "ircd_parser.y"
{
  if (ypass == 2)
    set_log_level(L_ERROR);
}
break;
case 111:
#line 919 "ircd_parser.y"
{
  if (ypass == 2)
    set_log_level(L_WARN);
}
break;
case 112:
#line 923 "ircd_parser.y"
{
  if (ypass == 2)
    set_log_level(L_NOTICE);
}
break;
case 113:
#line 927 "ircd_parser.y"
{
  if (ypass == 2)
    set_log_level(L_TRACE);
}
break;
case 114:
#line 931 "ircd_parser.y"
{
  if (ypass == 2)
    set_log_level(L_INFO);
}
break;
case 115:
#line 935 "ircd_parser.y"
{
  if (ypass == 2)
    set_log_level(L_DEBUG);
}
break;
case 116:
#line 941 "ircd_parser.y"
{
  if (ypass == 2)
    ConfigLoggingEntry.use_logging = yylval.number;
}
break;
case 117:
#line 950 "ircd_parser.y"
{
  if (ypass == 2)
  {
    yy_conf = make_conf_item(OPER_TYPE);
    yy_aconf = map_to_conf(yy_conf);
    SetConfEncrypted(yy_aconf); /* Yes, the default is encrypted */
  }
  else
  {
    MyFree(class_name);
    class_name = NULL;
  }
}
break;
case 118:
#line 963 "ircd_parser.y"
{
  if (ypass == 2)
  {
    struct CollectItem *yy_tmp;
    dlink_node *ptr;
    dlink_node *next_ptr;

    conf_add_class_to_conf(yy_conf, class_name);

    /* Now, make sure there is a copy of the "base" given oper
     * block in each of the collected copies
     */

    DLINK_FOREACH_SAFE(ptr, next_ptr, col_conf_list.head)
    {
      struct AccessItem *new_aconf;
      struct ConfItem *new_conf;
      yy_tmp = ptr->data;

      new_conf = make_conf_item(OPER_TYPE);
      new_aconf = (struct AccessItem *)map_to_conf(new_conf);

      new_aconf->flags = yy_aconf->flags;

      if (yy_conf->name != NULL)
        DupString(new_conf->name, yy_conf->name);
      if (yy_tmp->user != NULL)
	DupString(new_aconf->user, yy_tmp->user);
      else
	DupString(new_aconf->user, "*");
      if (yy_tmp->host != NULL)
	DupString(new_aconf->host, yy_tmp->host);
      else
	DupString(new_aconf->host, "*");
      conf_add_class_to_conf(new_conf, class_name);
      if (yy_aconf->passwd != NULL)
        DupString(new_aconf->passwd, yy_aconf->passwd);

      new_aconf->port = yy_aconf->port;
#ifdef HAVE_LIBCRYPTO
      if (yy_aconf->rsa_public_key_file != NULL)
      {
        BIO *file;

        DupString(new_aconf->rsa_public_key_file,
		  yy_aconf->rsa_public_key_file);

        file = BIO_new_file(yy_aconf->rsa_public_key_file, "r");
        new_aconf->rsa_public_key = (RSA *)PEM_read_bio_RSA_PUBKEY(file, 
							   NULL, 0, NULL);
        BIO_set_close(file, BIO_CLOSE);
        BIO_free(file);
      }
#endif

#ifdef HAVE_LIBCRYPTO
      if (yy_tmp->name && (yy_tmp->passwd || yy_aconf->rsa_public_key)
	  && yy_tmp->host)
#else
      if (yy_tmp->name && yy_tmp->passwd && yy_tmp->host)
#endif
      {
        conf_add_class_to_conf(new_conf, class_name);
	if (yy_tmp->name != NULL)
	  DupString(new_conf->name, yy_tmp->name);
      }

      dlinkDelete(&yy_tmp->node, &col_conf_list);
      free_collect_item(yy_tmp);
    }

    yy_conf = NULL;
    yy_aconf = NULL;


    MyFree(class_name);
    class_name = NULL;
  }
}
break;
case 146:
#line 1055 "ircd_parser.y"
{
  if (ypass == 2)
  {
    if (strlen(yylval.string) > OPERNICKLEN)
      yylval.string[OPERNICKLEN] = '\0';

    MyFree(yy_conf->name);
    DupString(yy_conf->name, yylval.string);
  }
}
break;
case 147:
#line 1067 "ircd_parser.y"
{
  if (ypass == 2)
  {
    if (strlen(yylval.string) > OPERNICKLEN)
      yylval.string[OPERNICKLEN] = '\0';

    MyFree(yy_conf->name);
    DupString(yy_conf->name, yylval.string);
  }
}
break;
case 148:
#line 1079 "ircd_parser.y"
{
  if (ypass == 2)
  {
    struct split_nuh_item nuh;

    nuh.nuhmask  = yylval.string;
    nuh.nickptr  = NULL;
    nuh.userptr  = userbuf;
    nuh.hostptr  = hostbuf;

    nuh.nicksize = 0;
    nuh.usersize = sizeof(userbuf);
    nuh.hostsize = sizeof(hostbuf);

    split_nuh(&nuh);

    if (yy_aconf->user == NULL)
    {
      DupString(yy_aconf->user, userbuf);
      DupString(yy_aconf->host, hostbuf);
    }
    else
    {
      struct CollectItem *yy_tmp = MyMalloc(sizeof(struct CollectItem));

      DupString(yy_tmp->user, userbuf);
      DupString(yy_tmp->host, hostbuf);

      dlinkAdd(yy_tmp, &yy_tmp->node, &col_conf_list);
    }
  }
}
break;
case 149:
#line 1113 "ircd_parser.y"
{
  if (ypass == 2)
  {
    if (yy_aconf->passwd != NULL)
      memset(yy_aconf->passwd, 0, strlen(yy_aconf->passwd));

    MyFree(yy_aconf->passwd);
    DupString(yy_aconf->passwd, yylval.string);
  }
}
break;
case 150:
#line 1125 "ircd_parser.y"
{
  if (ypass == 2)
  {
    if (yylval.number)
      SetConfEncrypted(yy_aconf);
    else
      ClearConfEncrypted(yy_aconf);
  }
}
break;
case 151:
#line 1136 "ircd_parser.y"
{
#ifdef HAVE_LIBCRYPTO
  if (ypass == 2)
  {
    BIO *file;

    if (yy_aconf->rsa_public_key != NULL)
    {
      RSA_free(yy_aconf->rsa_public_key);
      yy_aconf->rsa_public_key = NULL;
    }

    if (yy_aconf->rsa_public_key_file != NULL)
    {
      MyFree(yy_aconf->rsa_public_key_file);
      yy_aconf->rsa_public_key_file = NULL;
    }

    DupString(yy_aconf->rsa_public_key_file, yylval.string);
    file = BIO_new_file(yylval.string, "r");

    if (file == NULL)
    {
      yyerror("Ignoring rsa_public_key_file -- file doesn't exist");
      break;
    }

    yy_aconf->rsa_public_key = (RSA *)PEM_read_bio_RSA_PUBKEY(file, NULL, 0, NULL);

    if (yy_aconf->rsa_public_key == NULL)
    {
      yyerror("Ignoring rsa_public_key_file -- Key invalid; check key syntax.");
      break;
    }

    BIO_set_close(file, BIO_CLOSE);
    BIO_free(file);
  }
#endif /* HAVE_LIBCRYPTO */
}
break;
case 152:
#line 1178 "ircd_parser.y"
{
  if (ypass == 2)
  {
    MyFree(class_name);
    DupString(class_name, yylval.string);
  }
}
break;
case 153:
#line 1187 "ircd_parser.y"
{
  if (ypass == 2)
    yy_aconf->modes = 0;
}
break;
case 157:
#line 1194 "ircd_parser.y"
{
  if (ypass == 2)
    yy_aconf->modes |= UMODE_BOTS;
}
break;
case 158:
#line 1198 "ircd_parser.y"
{
  if (ypass == 2)
    yy_aconf->modes |= UMODE_CCONN;
}
break;
case 159:
#line 1202 "ircd_parser.y"
{
  if (ypass == 2)
    yy_aconf->modes |= UMODE_CCONN_FULL;
}
break;
case 160:
#line 1206 "ircd_parser.y"
{
  if (ypass == 2)
    yy_aconf->modes |= UMODE_DEAF;
}
break;
case 161:
#line 1210 "ircd_parser.y"
{
  if (ypass == 2)
    yy_aconf->modes |= UMODE_DEBUG;
}
break;
case 162:
#line 1214 "ircd_parser.y"
{
  if (ypass == 2)
    yy_aconf->modes |= UMODE_FULL;
}
break;
case 163:
#line 1218 "ircd_parser.y"
{
  if (ypass == 2)
    yy_aconf->modes |= UMODE_SKILL;
}
break;
case 164:
#line 1222 "ircd_parser.y"
{
  if (ypass == 2)
    yy_aconf->modes |= UMODE_NCHANGE;
}
break;
case 165:
#line 1226 "ircd_parser.y"
{
  if (ypass == 2)
    yy_aconf->modes |= UMODE_REJ;
}
break;
case 166:
#line 1230 "ircd_parser.y"
{
  if (ypass == 2)
    yy_aconf->modes |= UMODE_UNAUTH;
}
break;
case 167:
#line 1234 "ircd_parser.y"
{
  if (ypass == 2)
    yy_aconf->modes |= UMODE_SPY;
}
break;
case 168:
#line 1238 "ircd_parser.y"
{
  if (ypass == 2)
    yy_aconf->modes |= UMODE_EXTERNAL;
}
break;
case 169:
#line 1242 "ircd_parser.y"
{
  if (ypass == 2)
    yy_aconf->modes |= UMODE_OPERWALL;
}
break;
case 170:
#line 1246 "ircd_parser.y"
{
  if (ypass == 2)
    yy_aconf->modes |= UMODE_SERVNOTICE;
}
break;
case 171:
#line 1250 "ircd_parser.y"
{
  if (ypass == 2)
    yy_aconf->modes |= UMODE_INVISIBLE;
}
break;
case 172:
#line 1254 "ircd_parser.y"
{
  if (ypass == 2)
    yy_aconf->modes |= UMODE_WALLOP;
}
break;
case 173:
#line 1258 "ircd_parser.y"
{
  if (ypass == 2)
    yy_aconf->modes |= UMODE_SOFTCALLERID;
}
break;
case 174:
#line 1262 "ircd_parser.y"
{
  if (ypass == 2)
    yy_aconf->modes |= UMODE_CALLERID;
}
break;
case 175:
#line 1266 "ircd_parser.y"
{
  if (ypass == 2)
    yy_aconf->modes |= UMODE_LOCOPS;
}
break;
case 176:
#line 1272 "ircd_parser.y"
{
  if (ypass == 2)
  {
    if (yylval.number)
      yy_aconf->port |= OPER_FLAG_GLOBAL_KILL;
    else
      yy_aconf->port &= ~OPER_FLAG_GLOBAL_KILL;
  }
}
break;
case 177:
#line 1283 "ircd_parser.y"
{
  if (ypass == 2)
  {
    if (yylval.number)
      yy_aconf->port |= OPER_FLAG_REMOTE;
    else
      yy_aconf->port &= ~OPER_FLAG_REMOTE; 
  }
}
break;
case 178:
#line 1294 "ircd_parser.y"
{
  if (ypass == 2)
  {
    if (yylval.number)
      yy_aconf->port |= OPER_FLAG_REMOTEBAN;
    else
      yy_aconf->port &= ~OPER_FLAG_REMOTEBAN;
  }
}
break;
case 179:
#line 1305 "ircd_parser.y"
{
  if (ypass == 2)
  {
    if (yylval.number)
      yy_aconf->port |= OPER_FLAG_K;
    else
      yy_aconf->port &= ~OPER_FLAG_K;
  }
}
break;
case 180:
#line 1316 "ircd_parser.y"
{
  if (ypass == 2)
  {
    if (yylval.number)
      yy_aconf->port |= OPER_FLAG_X;
    else
      yy_aconf->port &= ~OPER_FLAG_X;
  }
}
break;
case 181:
#line 1327 "ircd_parser.y"
{
  if (ypass == 2)
  {
    if (yylval.number)
      yy_aconf->port |= OPER_FLAG_UNKLINE;
    else
      yy_aconf->port &= ~OPER_FLAG_UNKLINE; 
  }
}
break;
case 182:
#line 1338 "ircd_parser.y"
{
  if (ypass == 2)
  {
    if (yylval.number)
      yy_aconf->port |= OPER_FLAG_GLINE;
    else
      yy_aconf->port &= ~OPER_FLAG_GLINE;
  }
}
break;
case 183:
#line 1349 "ircd_parser.y"
{
  if (ypass == 2)
  {
    if (yylval.number)
      yy_aconf->port |= OPER_FLAG_N;
    else
      yy_aconf->port &= ~OPER_FLAG_N;
  }
}
break;
case 184:
#line 1360 "ircd_parser.y"
{
  if (ypass == 2)
  {
    if (yylval.number)
      yy_aconf->port |= OPER_FLAG_DIE;
    else
      yy_aconf->port &= ~OPER_FLAG_DIE;
  }
}
break;
case 185:
#line 1371 "ircd_parser.y"
{
  if (ypass == 2)
  {
    if (yylval.number)
      yy_aconf->port |= OPER_FLAG_REHASH;
    else
      yy_aconf->port &= ~OPER_FLAG_REHASH;
  }
}
break;
case 186:
#line 1382 "ircd_parser.y"
{
  if (ypass == 2)
  {
    if (yylval.number)
      yy_aconf->port |= OPER_FLAG_ADMIN;
    else
      yy_aconf->port &= ~OPER_FLAG_ADMIN;
  }
}
break;
case 187:
#line 1393 "ircd_parser.y"
{
  if (ypass == 2)
  {
    if (yylval.number)
      yy_aconf->port |= OPER_FLAG_HIDDEN_ADMIN;
    else
      yy_aconf->port &= ~OPER_FLAG_HIDDEN_ADMIN;
  }
}
break;
case 188:
#line 1404 "ircd_parser.y"
{
  if (ypass == 2)
  {
    if (yylval.number)
      yy_aconf->port |= OPER_FLAG_HIDDEN_OPER;
    else
      yy_aconf->port &= ~OPER_FLAG_HIDDEN_OPER;
  }
}
break;
case 189:
#line 1415 "ircd_parser.y"
{
  if (ypass == 2)
  {
    if (yylval.number)
      yy_aconf->port |= OPER_FLAG_OPERWALL;
    else
      yy_aconf->port &= ~OPER_FLAG_OPERWALL;
  }
}
break;
case 190:
#line 1426 "ircd_parser.y"
{
}
break;
case 194:
#line 1430 "ircd_parser.y"
{ not_atom = 1; }
break;
case 196:
#line 1431 "ircd_parser.y"
{ not_atom = 0; }
break;
case 198:
#line 1434 "ircd_parser.y"
{
  if (ypass == 2)
  {
    if (not_atom)yy_aconf->port &= ~OPER_FLAG_GLOBAL_KILL;
    else yy_aconf->port |= OPER_FLAG_GLOBAL_KILL;
  }
}
break;
case 199:
#line 1441 "ircd_parser.y"
{
  if (ypass == 2)
  {
    if (not_atom) yy_aconf->port &= ~OPER_FLAG_REMOTE;
    else yy_aconf->port |= OPER_FLAG_REMOTE;
  }
}
break;
case 200:
#line 1448 "ircd_parser.y"
{
  if (ypass == 2)
  {
    if (not_atom) yy_aconf->port &= ~OPER_FLAG_K;
    else yy_aconf->port |= OPER_FLAG_K;
  }
}
break;
case 201:
#line 1455 "ircd_parser.y"
{
  if (ypass == 2)
  {
    if (not_atom) yy_aconf->port &= ~OPER_FLAG_UNKLINE;
    else yy_aconf->port |= OPER_FLAG_UNKLINE;
  } 
}
break;
case 202:
#line 1462 "ircd_parser.y"
{
  if (ypass == 2)
  {
    if (not_atom) yy_aconf->port &= ~OPER_FLAG_X;
    else yy_aconf->port |= OPER_FLAG_X;
  }
}
break;
case 203:
#line 1469 "ircd_parser.y"
{
  if (ypass == 2)
  {
    if (not_atom) yy_aconf->port &= ~OPER_FLAG_GLINE;
    else yy_aconf->port |= OPER_FLAG_GLINE;
  }
}
break;
case 204:
#line 1476 "ircd_parser.y"
{
  if (ypass == 2)
  {
    if (not_atom) yy_aconf->port &= ~OPER_FLAG_DIE;
    else yy_aconf->port |= OPER_FLAG_DIE;
  }
}
break;
case 205:
#line 1483 "ircd_parser.y"
{
  if (ypass == 2)
  {
    if (not_atom) yy_aconf->port &= ~OPER_FLAG_REHASH;
    else yy_aconf->port |= OPER_FLAG_REHASH;
  }
}
break;
case 206:
#line 1490 "ircd_parser.y"
{
  if (ypass == 2)
  {
    if (not_atom) yy_aconf->port &= ~OPER_FLAG_ADMIN;
    else yy_aconf->port |= OPER_FLAG_ADMIN;
  }
}
break;
case 207:
#line 1497 "ircd_parser.y"
{
  if (ypass == 2)
  {
    if (not_atom) yy_aconf->port &= ~OPER_FLAG_HIDDEN_ADMIN;
    else yy_aconf->port |= OPER_FLAG_HIDDEN_ADMIN;
  }
}
break;
case 208:
#line 1504 "ircd_parser.y"
{
  if (ypass == 2)
  {
    if (not_atom) yy_aconf->port &= ~OPER_FLAG_N;
    else yy_aconf->port |= OPER_FLAG_N;
  }
}
break;
case 209:
#line 1511 "ircd_parser.y"
{
  if (ypass == 2)
  {
    if (not_atom) yy_aconf->port &= ~OPER_FLAG_OPERWALL;
    else yy_aconf->port |= OPER_FLAG_OPERWALL;
  }
}
break;
case 210:
#line 1518 "ircd_parser.y"
{
  if (ypass == 2)
  {
    if (not_atom) yy_aconf->port &= ~OPER_FLAG_OPER_SPY;
    else yy_aconf->port |= OPER_FLAG_OPER_SPY;
  }
}
break;
case 211:
#line 1525 "ircd_parser.y"
{
  if (ypass == 2)
  {
    if (not_atom) yy_aconf->port &= ~OPER_FLAG_HIDDEN_OPER;
    else yy_aconf->port |= OPER_FLAG_HIDDEN_OPER;
  }
}
break;
case 212:
#line 1532 "ircd_parser.y"
{
  if (ypass == 2)
  {
    if (not_atom) yy_aconf->port &= ~OPER_FLAG_REMOTEBAN;
    else yy_aconf->port |= OPER_FLAG_REMOTEBAN;
  }
}
break;
case 213:
#line 1539 "ircd_parser.y"
{
  if (ypass == 2)
  {
    if (not_atom) ClearConfEncrypted(yy_aconf);
    else SetConfEncrypted(yy_aconf);
  }
}
break;
case 214:
#line 1552 "ircd_parser.y"
{
  if (ypass == 1)
  {
    yy_conf = make_conf_item(CLASS_TYPE);
    yy_class = map_to_conf(yy_conf);
  }
}
break;
case 215:
#line 1559 "ircd_parser.y"
{
  if (ypass == 1)
  {
    struct ConfItem *cconf = NULL;
    struct ClassItem *class = NULL;

    if (yy_class_name == NULL)
      delete_conf_item(yy_conf);
    else
    {
      cconf = find_exact_name_conf(CLASS_TYPE, yy_class_name, NULL, NULL);

      if (cconf != NULL)		/* The class existed already */
      {
        int user_count = 0;

        rebuild_cidr_class(cconf, yy_class);

        class = map_to_conf(cconf);

        user_count = class->curr_user_count;
        memcpy(class, yy_class, sizeof(*class));
        class->curr_user_count = user_count;
        class->active = 1;

        delete_conf_item(yy_conf);

        MyFree(cconf->name);            /* Allows case change of class name */
        cconf->name = yy_class_name;
      }
      else	/* Brand new class */
      {
        MyFree(yy_conf->name);          /* just in case it was allocated */
        yy_conf->name = yy_class_name;
        yy_class->active = 1;
      }
    }

    yy_class_name = NULL;
  }
}
break;
case 234:
#line 1619 "ircd_parser.y"
{
  if (ypass == 1)
  {
    MyFree(yy_class_name);
    DupString(yy_class_name, yylval.string);
  }
}
break;
case 235:
#line 1628 "ircd_parser.y"
{
  if (ypass == 1)
  {
    MyFree(yy_class_name);
    DupString(yy_class_name, yylval.string);
  }
}
break;
case 236:
#line 1637 "ircd_parser.y"
{
  if (ypass == 1)
    PingFreq(yy_class) = yyvsp[-1].number;
}
break;
case 237:
#line 1643 "ircd_parser.y"
{
  if (ypass == 1)
    PingWarning(yy_class) = yyvsp[-1].number;
}
break;
case 238:
#line 1649 "ircd_parser.y"
{
  if (ypass == 1)
    MaxPerIp(yy_class) = yyvsp[-1].number;
}
break;
case 239:
#line 1655 "ircd_parser.y"
{
  if (ypass == 1)
    ConFreq(yy_class) = yyvsp[-1].number;
}
break;
case 240:
#line 1661 "ircd_parser.y"
{
  if (ypass == 1)
    MaxTotal(yy_class) = yyvsp[-1].number;
}
break;
case 241:
#line 1667 "ircd_parser.y"
{
  if (ypass == 1)
    MaxGlobal(yy_class) = yyvsp[-1].number;
}
break;
case 242:
#line 1673 "ircd_parser.y"
{
  if (ypass == 1)
    MaxLocal(yy_class) = yyvsp[-1].number;
}
break;
case 243:
#line 1679 "ircd_parser.y"
{
  if (ypass == 1)
    MaxIdent(yy_class) = yyvsp[-1].number;
}
break;
case 244:
#line 1685 "ircd_parser.y"
{
  if (ypass == 1)
    MaxSendq(yy_class) = yyvsp[-1].number;
}
break;
case 245:
#line 1691 "ircd_parser.y"
{
  if (ypass == 1)
    CidrBitlenIPV4(yy_class) = yyvsp[-1].number;
}
break;
case 246:
#line 1697 "ircd_parser.y"
{
  if (ypass == 1)
    CidrBitlenIPV6(yy_class) = yyvsp[-1].number;
}
break;
case 247:
#line 1703 "ircd_parser.y"
{
  if (ypass == 1)
    NumberPerCidr(yy_class) = yyvsp[-1].number;
}
break;
case 248:
#line 1712 "ircd_parser.y"
{
  if (ypass == 2)
  {
    listener_address = NULL;
    listener_flags = 0;
  }
}
break;
case 249:
#line 1719 "ircd_parser.y"
{
  if (ypass == 2)
  {
    MyFree(listener_address);
    listener_address = NULL;
  }
}
break;
case 250:
#line 1728 "ircd_parser.y"
{
  listener_flags = 0;
}
break;
case 254:
#line 1734 "ircd_parser.y"
{
  if (ypass == 2)
    listener_flags |= LISTENER_SSL;
}
break;
case 255:
#line 1738 "ircd_parser.y"
{
  if (ypass == 2)
    listener_flags |= LISTENER_HIDDEN;
}
break;
case 263:
#line 1746 "ircd_parser.y"
{ listener_flags = 0; }
break;
case 267:
#line 1751 "ircd_parser.y"
{
  if (ypass == 2)
  {
    if ((listener_flags & LISTENER_SSL))
#ifdef HAVE_LIBCRYPTO
      if (!ServerInfo.ctx)
#endif
      {
        yyerror("SSL not available - port closed");
	break;
      }
    add_listener(yyvsp[0].number, listener_address, listener_flags);
  }
}
break;
case 268:
#line 1765 "ircd_parser.y"
{
  if (ypass == 2)
  {
    int i;

    if ((listener_flags & LISTENER_SSL))
#ifdef HAVE_LIBCRYPTO
      if (!ServerInfo.ctx)
#endif
      {
        yyerror("SSL not available - port closed");
	break;
      }

    for (i = yyvsp[-2].number; i <= yyvsp[0].number; ++i)
      add_listener(i, listener_address, listener_flags);
  }
}
break;
case 269:
#line 1785 "ircd_parser.y"
{
  if (ypass == 2)
  {
    MyFree(listener_address);
    DupString(listener_address, yylval.string);
  }
}
break;
case 270:
#line 1794 "ircd_parser.y"
{
  if (ypass == 2)
  {
    MyFree(listener_address);
    DupString(listener_address, yylval.string);
  }
}
break;
case 271:
#line 1806 "ircd_parser.y"
{
  if (ypass == 2)
  {
    yy_conf = make_conf_item(CLIENT_TYPE);
    yy_aconf = map_to_conf(yy_conf);
  }
  else
  {
    MyFree(class_name);
    class_name = NULL;
  }
}
break;
case 272:
#line 1818 "ircd_parser.y"
{
  if (ypass == 2)
  {
    struct CollectItem *yy_tmp = NULL;
    dlink_node *ptr = NULL, *next_ptr = NULL;

    if (yy_aconf->user && yy_aconf->host)
    {
      conf_add_class_to_conf(yy_conf, class_name);
      add_conf_by_address(CONF_CLIENT, yy_aconf);
    }
    else
      delete_conf_item(yy_conf);

    /* copy over settings from first struct */
    DLINK_FOREACH_SAFE(ptr, next_ptr, col_conf_list.head)
    {
      struct AccessItem *new_aconf;
      struct ConfItem *new_conf;

      new_conf = make_conf_item(CLIENT_TYPE);
      new_aconf = map_to_conf(new_conf);

      yy_tmp = ptr->data;

      assert(yy_tmp->user && yy_tmp->host);

      if (yy_aconf->passwd != NULL)
        DupString(new_aconf->passwd, yy_aconf->passwd);
      if (yy_conf->name != NULL)
        DupString(new_conf->name, yy_conf->name);
      if (yy_aconf->passwd != NULL)
        DupString(new_aconf->passwd, yy_aconf->passwd);

      new_aconf->flags = yy_aconf->flags;
      new_aconf->port  = yy_aconf->port;

      DupString(new_aconf->user, yy_tmp->user);
      collapse(new_aconf->user);

      DupString(new_aconf->host, yy_tmp->host);
      collapse(new_aconf->host);

      conf_add_class_to_conf(new_conf, class_name);
      add_conf_by_address(CONF_CLIENT, new_aconf);
      dlinkDelete(&yy_tmp->node, &col_conf_list);
      free_collect_item(yy_tmp);
    }

    MyFree(class_name);
    class_name = NULL;
    yy_conf = NULL;
    yy_aconf = NULL;
  }
}
break;
case 292:
#line 1883 "ircd_parser.y"
{
  if (ypass == 2)
  {
    struct CollectItem *yy_tmp = NULL;
    struct split_nuh_item nuh;

    nuh.nuhmask  = yylval.string;
    nuh.nickptr  = NULL;
    nuh.userptr  = userbuf;
    nuh.hostptr  = hostbuf;

    nuh.nicksize = 0;
    nuh.usersize = sizeof(userbuf);
    nuh.hostsize = sizeof(hostbuf);

    split_nuh(&nuh);

    if (yy_aconf->user == NULL)
    {
      DupString(yy_aconf->user, userbuf);
      DupString(yy_aconf->host, hostbuf);
    }
    else
    {
      yy_tmp = MyMalloc(sizeof(struct CollectItem));

      DupString(yy_tmp->user, userbuf);
      DupString(yy_tmp->host, hostbuf);

      dlinkAdd(yy_tmp, &yy_tmp->node, &col_conf_list);
    }
  }
}
break;
case 293:
#line 1920 "ircd_parser.y"
{
  if (ypass == 2)
  {
    /* be paranoid */
    if (yy_aconf->passwd != NULL)
      memset(yy_aconf->passwd, 0, strlen(yy_aconf->passwd));

    MyFree(yy_aconf->passwd);
    DupString(yy_aconf->passwd, yylval.string);
  }
}
break;
case 294:
#line 1933 "ircd_parser.y"
{
  if (ypass == 2)
  {
    if (yylval.number)
      yy_aconf->flags |= CONF_FLAGS_SPOOF_NOTICE;
    else
      yy_aconf->flags &= ~CONF_FLAGS_SPOOF_NOTICE;
  }
}
break;
case 295:
#line 1944 "ircd_parser.y"
{
  if (ypass == 2)
  {
    MyFree(class_name);
    DupString(class_name, yylval.string);
  }
}
break;
case 296:
#line 1953 "ircd_parser.y"
{
  if (ypass == 2)
  {
    if (yylval.number)
      SetConfEncrypted(yy_aconf);
    else
      ClearConfEncrypted(yy_aconf);
  }
}
break;
case 297:
#line 1964 "ircd_parser.y"
{
}
break;
case 301:
#line 1968 "ircd_parser.y"
{ not_atom = 1; }
break;
case 303:
#line 1969 "ircd_parser.y"
{ not_atom = 0; }
break;
case 305:
#line 1972 "ircd_parser.y"
{
  if (ypass == 2)
  {
    if (not_atom) yy_aconf->flags &= ~CONF_FLAGS_SPOOF_NOTICE;
    else yy_aconf->flags |= CONF_FLAGS_SPOOF_NOTICE;
  }

}
break;
case 306:
#line 1980 "ircd_parser.y"
{
  if (ypass == 2)
  {
    if (not_atom) yy_aconf->flags &= ~CONF_FLAGS_NOLIMIT;
    else yy_aconf->flags |= CONF_FLAGS_NOLIMIT;
  }
}
break;
case 307:
#line 1987 "ircd_parser.y"
{
  if (ypass == 2)
  {
    if (not_atom) yy_aconf->flags &= ~CONF_FLAGS_EXEMPTKLINE;
    else yy_aconf->flags |= CONF_FLAGS_EXEMPTKLINE;
  } 
}
break;
case 308:
#line 1994 "ircd_parser.y"
{
  if (ypass == 2)
  {
    if (not_atom) yy_aconf->flags &= ~CONF_FLAGS_NEED_IDENTD;
    else yy_aconf->flags |= CONF_FLAGS_NEED_IDENTD;
  }
}
break;
case 309:
#line 2001 "ircd_parser.y"
{
  if (ypass == 2)
  {
    if (not_atom) yy_aconf->flags &= ~CONF_FLAGS_CAN_FLOOD;
    else yy_aconf->flags |= CONF_FLAGS_CAN_FLOOD;
  }
}
break;
case 310:
#line 2008 "ircd_parser.y"
{
  if (ypass == 2)
  {
    if (not_atom) yy_aconf->flags &= ~CONF_FLAGS_IDLE_LINED;
    else yy_aconf->flags |= CONF_FLAGS_IDLE_LINED;
  }
}
break;
case 311:
#line 2015 "ircd_parser.y"
{
  if (ypass == 2)
  {
    if (not_atom) yy_aconf->flags &= ~CONF_FLAGS_NO_TILDE;
    else yy_aconf->flags |= CONF_FLAGS_NO_TILDE;
  } 
}
break;
case 312:
#line 2022 "ircd_parser.y"
{
  if (ypass == 2)
  {
    if (not_atom) yy_aconf->flags &= ~CONF_FLAGS_EXEMPTGLINE;
    else yy_aconf->flags |= CONF_FLAGS_EXEMPTGLINE;
  } 
}
break;
case 313:
#line 2029 "ircd_parser.y"
{
  if (ypass == 2)
  {
    if (not_atom) yy_aconf->flags &= ~CONF_FLAGS_EXEMPTRESV;
    else yy_aconf->flags |= CONF_FLAGS_EXEMPTRESV;
  }
}
break;
case 314:
#line 2036 "ircd_parser.y"
{
  if (ypass == 2)
  {
    if (not_atom) yy_aconf->flags &= ~CONF_FLAGS_NEED_PASSWORD;
    else yy_aconf->flags |= CONF_FLAGS_NEED_PASSWORD;
  }
}
break;
case 315:
#line 2045 "ircd_parser.y"
{
  if (ypass == 2)
  {
    if (yylval.number)
      yy_aconf->flags |= CONF_FLAGS_EXEMPTKLINE;
    else
      yy_aconf->flags &= ~CONF_FLAGS_EXEMPTKLINE;
  }
}
break;
case 316:
#line 2056 "ircd_parser.y"
{
  if (ypass == 2)
  {
    if (yylval.number)
      yy_aconf->flags |= CONF_FLAGS_NEED_IDENTD;
    else
      yy_aconf->flags &= ~CONF_FLAGS_NEED_IDENTD;
  }
}
break;
case 317:
#line 2067 "ircd_parser.y"
{
  if (ypass == 2)
  {
    if (yylval.number)
      yy_aconf->flags |= CONF_FLAGS_NOLIMIT;
    else
      yy_aconf->flags &= ~CONF_FLAGS_NOLIMIT;
  }
}
break;
case 318:
#line 2078 "ircd_parser.y"
{
  if (ypass == 2)
  {
    if (yylval.number)
      yy_aconf->flags |= CONF_FLAGS_CAN_FLOOD;
    else
      yy_aconf->flags &= ~CONF_FLAGS_CAN_FLOOD;
  }
}
break;
case 319:
#line 2089 "ircd_parser.y"
{
  if (ypass == 2)
  {
    if (yylval.number)
      yy_aconf->flags |= CONF_FLAGS_NO_TILDE;
    else
      yy_aconf->flags &= ~CONF_FLAGS_NO_TILDE;
  }
}
break;
case 320:
#line 2100 "ircd_parser.y"
{
  if (ypass == 2)
  {
    if (yylval.number)
      yy_aconf->flags |= CONF_FLAGS_EXEMPTGLINE;
    else
      yy_aconf->flags &= ~CONF_FLAGS_EXEMPTGLINE;
  }
}
break;
case 321:
#line 2112 "ircd_parser.y"
{
  if (ypass == 2)
  {
    MyFree(yy_conf->name);

    if (strlen(yylval.string) < HOSTLEN)
    {    
      DupString(yy_conf->name, yylval.string);
      yy_aconf->flags |= CONF_FLAGS_SPOOF_IP;
    }
    else
    {
      ilog(L_ERROR, "Spoofs must be less than %d..ignoring it", HOSTLEN);
      yy_conf->name = NULL;
    }
  }
}
break;
case 322:
#line 2131 "ircd_parser.y"
{
  if (ypass == 2)
  {
    yy_aconf->flags |= CONF_FLAGS_REDIR;
    MyFree(yy_conf->name);
    DupString(yy_conf->name, yylval.string);
  }
}
break;
case 323:
#line 2141 "ircd_parser.y"
{
  if (ypass == 2)
  {
    yy_aconf->flags |= CONF_FLAGS_REDIR;
    yy_aconf->port = yyvsp[-1].number;
  }
}
break;
case 324:
#line 2150 "ircd_parser.y"
{
  if (ypass == 2)
  {
    if (yylval.number)
      yy_aconf->flags |= CONF_FLAGS_NEED_PASSWORD;
    else
      yy_aconf->flags &= ~CONF_FLAGS_NEED_PASSWORD;
  }
}
break;
case 325:
#line 2165 "ircd_parser.y"
{
  if (ypass == 2)
  {
    MyFree(resv_reason);
    resv_reason = NULL;
  }
}
break;
case 326:
#line 2172 "ircd_parser.y"
{
  if (ypass == 2)
  {
    MyFree(resv_reason);
    resv_reason = NULL;
  }
}
break;
case 333:
#line 2184 "ircd_parser.y"
{
  if (ypass == 2)
  {
    MyFree(resv_reason);
    DupString(resv_reason, yylval.string);
  }
}
break;
case 334:
#line 2193 "ircd_parser.y"
{
  if (ypass == 2)
  {
    if (IsChanPrefix(*yylval.string))
    {
      char def_reason[] = "No reason";

      create_channel_resv(yylval.string, resv_reason != NULL ? resv_reason : def_reason, 1);
    }
  }
  /* ignore it for now.. but we really should make a warning if
   * its an erroneous name --fl_ */
}
break;
case 335:
#line 2208 "ircd_parser.y"
{
  if (ypass == 2)
  {
    char def_reason[] = "No reason";

    create_nick_resv(yylval.string, resv_reason != NULL ? resv_reason : def_reason, 1);
  }
}
break;
case 336:
#line 2221 "ircd_parser.y"
{
  if (ypass == 2)
  {
    yy_conf = make_conf_item(ULINE_TYPE);
    yy_match_item = map_to_conf(yy_conf);
    yy_match_item->action = SHARED_ALL;
  }
}
break;
case 337:
#line 2229 "ircd_parser.y"
{
  if (ypass == 2)
  {
    yy_conf = NULL;
  }
}
break;
case 344:
#line 2240 "ircd_parser.y"
{
  if (ypass == 2)
  {
    MyFree(yy_conf->name);
    DupString(yy_conf->name, yylval.string);
  }
}
break;
case 345:
#line 2249 "ircd_parser.y"
{
  if (ypass == 2)
  {
    struct split_nuh_item nuh;

    nuh.nuhmask  = yylval.string;
    nuh.nickptr  = NULL;
    nuh.userptr  = userbuf;
    nuh.hostptr  = hostbuf;

    nuh.nicksize = 0;
    nuh.usersize = sizeof(userbuf);
    nuh.hostsize = sizeof(hostbuf);

    split_nuh(&nuh);

    DupString(yy_match_item->user, userbuf);
    DupString(yy_match_item->host, hostbuf);
  }
}
break;
case 346:
#line 2271 "ircd_parser.y"
{
  if (ypass == 2)
    yy_match_item->action = 0;
}
break;
case 350:
#line 2278 "ircd_parser.y"
{
  if (ypass == 2)
    yy_match_item->action |= SHARED_KLINE;
}
break;
case 351:
#line 2282 "ircd_parser.y"
{
  if (ypass == 2)
    yy_match_item->action |= SHARED_TKLINE;
}
break;
case 352:
#line 2286 "ircd_parser.y"
{
  if (ypass == 2)
    yy_match_item->action |= SHARED_UNKLINE;
}
break;
case 353:
#line 2290 "ircd_parser.y"
{
  if (ypass == 2)
    yy_match_item->action |= SHARED_XLINE;
}
break;
case 354:
#line 2294 "ircd_parser.y"
{
  if (ypass == 2)
    yy_match_item->action |= SHARED_TXLINE;
}
break;
case 355:
#line 2298 "ircd_parser.y"
{
  if (ypass == 2)
    yy_match_item->action |= SHARED_UNXLINE;
}
break;
case 356:
#line 2302 "ircd_parser.y"
{
  if (ypass == 2)
    yy_match_item->action |= SHARED_RESV;
}
break;
case 357:
#line 2306 "ircd_parser.y"
{
  if (ypass == 2)
    yy_match_item->action |= SHARED_TRESV;
}
break;
case 358:
#line 2310 "ircd_parser.y"
{
  if (ypass == 2)
    yy_match_item->action |= SHARED_UNRESV;
}
break;
case 359:
#line 2314 "ircd_parser.y"
{
  if (ypass == 2)
    yy_match_item->action |= SHARED_LOCOPS;
}
break;
case 360:
#line 2318 "ircd_parser.y"
{
  if (ypass == 2)
    yy_match_item->action = SHARED_ALL;
}
break;
case 361:
#line 2327 "ircd_parser.y"
{
  if (ypass == 2)
  {
    yy_conf = make_conf_item(CLUSTER_TYPE);
    yy_conf->flags = SHARED_ALL;
  }
}
break;
case 362:
#line 2334 "ircd_parser.y"
{
  if (ypass == 2)
  {
    if (yy_conf->name == NULL)
      DupString(yy_conf->name, "*");
    yy_conf = NULL;
  }
}
break;
case 368:
#line 2347 "ircd_parser.y"
{
  if (ypass == 2)
    DupString(yy_conf->name, yylval.string);
}
break;
case 369:
#line 2353 "ircd_parser.y"
{
  if (ypass == 2)
    yy_conf->flags = 0;
}
break;
case 373:
#line 2360 "ircd_parser.y"
{
  if (ypass == 2)
    yy_conf->flags |= SHARED_KLINE;
}
break;
case 374:
#line 2364 "ircd_parser.y"
{
  if (ypass == 2)
    yy_conf->flags |= SHARED_TKLINE;
}
break;
case 375:
#line 2368 "ircd_parser.y"
{
  if (ypass == 2)
    yy_conf->flags |= SHARED_UNKLINE;
}
break;
case 376:
#line 2372 "ircd_parser.y"
{
  if (ypass == 2)
    yy_conf->flags |= SHARED_XLINE;
}
break;
case 377:
#line 2376 "ircd_parser.y"
{
  if (ypass == 2)
    yy_conf->flags |= SHARED_TXLINE;
}
break;
case 378:
#line 2380 "ircd_parser.y"
{
  if (ypass == 2)
    yy_conf->flags |= SHARED_UNXLINE;
}
break;
case 379:
#line 2384 "ircd_parser.y"
{
  if (ypass == 2)
    yy_conf->flags |= SHARED_RESV;
}
break;
case 380:
#line 2388 "ircd_parser.y"
{
  if (ypass == 2)
    yy_conf->flags |= SHARED_TRESV;
}
break;
case 381:
#line 2392 "ircd_parser.y"
{
  if (ypass == 2)
    yy_conf->flags |= SHARED_UNRESV;
}
break;
case 382:
#line 2396 "ircd_parser.y"
{
  if (ypass == 2)
    yy_conf->flags |= SHARED_LOCOPS;
}
break;
case 383:
#line 2400 "ircd_parser.y"
{
  if (ypass == 2)
    yy_conf->flags = SHARED_ALL;
}
break;
case 384:
#line 2409 "ircd_parser.y"
{
  if (ypass == 2)
  {
    yy_conf = make_conf_item(SERVER_TYPE);
    yy_aconf = (struct AccessItem *)map_to_conf(yy_conf);
    yy_aconf->passwd = NULL;
    /* defaults */
    yy_aconf->port = PORTNUM;

    if (ConfigFileEntry.burst_away)
      yy_aconf->flags = CONF_FLAGS_BURST_AWAY;
  }
  else
  {
    MyFree(class_name);
    class_name = NULL;
  }
}
break;
case 385:
#line 2427 "ircd_parser.y"
{
  if (ypass == 2)
  {
    struct CollectItem *yy_hconf=NULL;
    struct CollectItem *yy_lconf=NULL;
    dlink_node *ptr;
    dlink_node *next_ptr;
#ifdef HAVE_LIBCRYPTO
    if (yy_aconf->host &&
	((yy_aconf->passwd && yy_aconf->spasswd) ||
	 (yy_aconf->rsa_public_key && IsConfCryptLink(yy_aconf))))
#else /* !HAVE_LIBCRYPTO */
      if (yy_aconf->host && !IsConfCryptLink(yy_aconf) && 
	  yy_aconf->passwd && yy_aconf->spasswd)
#endif /* !HAVE_LIBCRYPTO */
	{
	  if (conf_add_server(yy_conf, class_name) == -1)
	  {
	    delete_conf_item(yy_conf);
	    yy_conf = NULL;
	    yy_aconf = NULL;
	  }
	}
	else
	{
	  /* Even if yy_conf ->name is NULL
	   * should still unhook any hub/leaf confs still pending
	   */
	  unhook_hub_leaf_confs();

	  if (yy_conf->name != NULL)
	  {
#ifndef HAVE_LIBCRYPTO
	    if (IsConfCryptLink(yy_aconf))
	      yyerror("Ignoring connect block -- no OpenSSL support");
#else
	    if (IsConfCryptLink(yy_aconf) && !yy_aconf->rsa_public_key)
	      yyerror("Ignoring connect block -- missing key");
#endif
	    if (yy_aconf->host == NULL)
	      yyerror("Ignoring connect block -- missing host");
	    else if (!IsConfCryptLink(yy_aconf) && 
		    (!yy_aconf->passwd || !yy_aconf->spasswd))
              yyerror("Ignoring connect block -- missing password");
	  }


          /* XXX
           * This fixes a try_connections() core (caused by invalid class_ptr
           * pointers) reported by metalrock. That's an ugly fix, but there
           * is currently no better way. The entire config subsystem needs an
           * rewrite ASAP. make_conf_item() shouldn't really add things onto
           * a doubly linked list immediately without any sanity checks!  -Michael
           */
          delete_conf_item(yy_conf);

          yy_aconf = NULL;
	  yy_conf = NULL;
	}

      /*
       * yy_conf is still pointing at the server that is having
       * a connect block built for it. This means, y_aconf->name 
       * points to the actual irc name this server will be known as.
       * Now this new server has a set or even just one hub_mask (or leaf_mask)
       * given in the link list at yy_hconf. Fill in the HUB confs
       * from this link list now.
       */        
      DLINK_FOREACH_SAFE(ptr, next_ptr, hub_conf_list.head)
      {
	struct ConfItem *new_hub_conf;
	struct MatchItem *match_item;

	yy_hconf = ptr->data;

	/* yy_conf == NULL is a fatal error for this connect block! */
	if ((yy_conf != NULL) && (yy_conf->name != NULL))
	{
	  new_hub_conf = make_conf_item(HUB_TYPE);
	  match_item = (struct MatchItem *)map_to_conf(new_hub_conf);
	  DupString(new_hub_conf->name, yy_conf->name);
	  if (yy_hconf->user != NULL)
	    DupString(match_item->user, yy_hconf->user);
	  else
	    DupString(match_item->user, "*");
	  if (yy_hconf->host != NULL)
	    DupString(match_item->host, yy_hconf->host);
	  else
	    DupString(match_item->host, "*");
	}
	dlinkDelete(&yy_hconf->node, &hub_conf_list);
	free_collect_item(yy_hconf);
      }

      /* Ditto for the LEAF confs */

      DLINK_FOREACH_SAFE(ptr, next_ptr, leaf_conf_list.head)
      {
	struct ConfItem *new_leaf_conf;
	struct MatchItem *match_item;

	yy_lconf = ptr->data;

	if ((yy_conf != NULL) && (yy_conf->name != NULL))
	{
	  new_leaf_conf = make_conf_item(LEAF_TYPE);
	  match_item = (struct MatchItem *)map_to_conf(new_leaf_conf);
	  DupString(new_leaf_conf->name, yy_conf->name);
	  if (yy_lconf->user != NULL)
	    DupString(match_item->user, yy_lconf->user);
	  else
	    DupString(match_item->user, "*");
	  if (yy_lconf->host != NULL)
	    DupString(match_item->host, yy_lconf->host);
	  else
	    DupString(match_item->host, "*");
	}
	dlinkDelete(&yy_lconf->node, &leaf_conf_list);
	free_collect_item(yy_lconf);
      }
      MyFree(class_name);
      class_name = NULL;
      yy_conf = NULL;
      yy_aconf = NULL;
  }
}
break;
case 410:
#line 2566 "ircd_parser.y"
{
  if (ypass == 2)
  {
    if (yy_conf->name != NULL)
      yyerror("Multiple connect name entry");

    MyFree(yy_conf->name);
    DupString(yy_conf->name, yylval.string);
  }
}
break;
case 411:
#line 2578 "ircd_parser.y"
{
  if (ypass == 2)
  {
    if (yy_conf->name != NULL)
      yyerror("Multiple connect name entry");

    MyFree(yy_conf->name);
    DupString(yy_conf->name, yylval.string);
  }
}
break;
case 412:
#line 2590 "ircd_parser.y"
{
  if (ypass == 2)
  {
    MyFree(yy_aconf->host);
    DupString(yy_aconf->host, yylval.string);
  }
}
break;
case 413:
#line 2599 "ircd_parser.y"
{
  if (ypass == 2)
  {
    struct addrinfo hints, *res;

    memset(&hints, 0, sizeof(hints));

    hints.ai_family   = AF_UNSPEC;
    hints.ai_socktype = SOCK_STREAM;
    hints.ai_flags    = AI_PASSIVE | AI_NUMERICHOST;

    if (irc_getaddrinfo(yylval.string, NULL, &hints, &res))
      ilog(L_ERROR, "Invalid netmask for server vhost(%s)", yylval.string);
    else
    {
      assert(res != NULL);

      memcpy(&yy_aconf->my_ipnum, res->ai_addr, res->ai_addrlen);
      yy_aconf->my_ipnum.ss.ss_family = res->ai_family;
      yy_aconf->my_ipnum.ss_len = res->ai_addrlen;
      irc_freeaddrinfo(res);
    }
  }
}
break;
case 414:
#line 2625 "ircd_parser.y"
{
  if (ypass == 2)
  {
    if (yyvsp[-1].string[0] == ':')
      yyerror("Server passwords cannot begin with a colon");
    else if (strchr(yyvsp[-1].string, ' ') != NULL)
      yyerror("Server passwords cannot contain spaces");
    else {
      if (yy_aconf->spasswd != NULL)
        memset(yy_aconf->spasswd, 0, strlen(yy_aconf->spasswd));

      MyFree(yy_aconf->spasswd);
      DupString(yy_aconf->spasswd, yylval.string);
    }
  }
}
break;
case 415:
#line 2643 "ircd_parser.y"
{
  if (ypass == 2)
  {
    if (yyvsp[-1].string[0] == ':')
      yyerror("Server passwords cannot begin with a colon");
    else if (strchr(yyvsp[-1].string, ' ') != NULL)
      yyerror("Server passwords cannot contain spaces");
    else {
      if (yy_aconf->passwd != NULL)
        memset(yy_aconf->passwd, 0, strlen(yy_aconf->passwd));

      MyFree(yy_aconf->passwd);
      DupString(yy_aconf->passwd, yylval.string);
    }
  }
}
break;
case 416:
#line 2661 "ircd_parser.y"
{
  if (ypass == 2)
    yy_aconf->port = yyvsp[-1].number;
}
break;
case 417:
#line 2667 "ircd_parser.y"
{
  if (ypass == 2)
    yy_aconf->aftype = AF_INET;
}
break;
case 418:
#line 2671 "ircd_parser.y"
{
#ifdef IPV6
  if (ypass == 2)
    yy_aconf->aftype = AF_INET6;
#endif
}
break;
case 419:
#line 2679 "ircd_parser.y"
{
  if (ypass == 2)
  {
    MyFree(yy_aconf->fakename);
    DupString(yy_aconf->fakename, yylval.string);
  }
}
break;
case 420:
#line 2688 "ircd_parser.y"
{
}
break;
case 424:
#line 2692 "ircd_parser.y"
{ not_atom = 1; }
break;
case 426:
#line 2693 "ircd_parser.y"
{ not_atom = 0; }
break;
case 428:
#line 2696 "ircd_parser.y"
{
  if (ypass == 2)
  {
    if (not_atom)ClearConfLazyLink(yy_aconf);
    else SetConfLazyLink(yy_aconf);
  }
}
break;
case 429:
#line 2703 "ircd_parser.y"
{
  if (ypass == 2)
#ifndef HAVE_LIBZ
    yyerror("Ignoring flags = compressed; -- no zlib support");
#else
 {
   if (not_atom)ClearConfCompressed(yy_aconf);
   else SetConfCompressed(yy_aconf);
 }
#endif
}
break;
case 430:
#line 2714 "ircd_parser.y"
{
  if (ypass == 2)
  {
    if (not_atom)ClearConfCryptLink(yy_aconf);
    else SetConfCryptLink(yy_aconf);
  }
}
break;
case 431:
#line 2721 "ircd_parser.y"
{
  if (ypass == 2)
  {
    if (not_atom)ClearConfAllowAutoConn(yy_aconf);
    else SetConfAllowAutoConn(yy_aconf);
  }
}
break;
case 432:
#line 2728 "ircd_parser.y"
{
  if (ypass == 2)
  {
    if (not_atom)ClearConfAwayBurst(yy_aconf);
    else SetConfAwayBurst(yy_aconf);
  }
}
break;
case 433:
#line 2735 "ircd_parser.y"
{
  if (ypass == 2)
  {
    if (not_atom)ClearConfTopicBurst(yy_aconf);
    else SetConfTopicBurst(yy_aconf);
  }
}
break;
case 434:
#line 2745 "ircd_parser.y"
{
#ifdef HAVE_LIBCRYPTO
  if (ypass == 2)
  {
    BIO *file;

    if (yy_aconf->rsa_public_key != NULL)
    {
      RSA_free(yy_aconf->rsa_public_key);
      yy_aconf->rsa_public_key = NULL;
    }

    if (yy_aconf->rsa_public_key_file != NULL)
    {
      MyFree(yy_aconf->rsa_public_key_file);
      yy_aconf->rsa_public_key_file = NULL;
    }

    DupString(yy_aconf->rsa_public_key_file, yylval.string);

    if ((file = BIO_new_file(yylval.string, "r")) == NULL)
    {
      yyerror("Ignoring rsa_public_key_file -- file doesn't exist");
      break;
    }

    yy_aconf->rsa_public_key = (RSA *)PEM_read_bio_RSA_PUBKEY(file, NULL, 0, NULL);

    if (yy_aconf->rsa_public_key == NULL)
    {
      yyerror("Ignoring rsa_public_key_file -- Key invalid; check key syntax.");
      break;
    }
      
    BIO_set_close(file, BIO_CLOSE);
    BIO_free(file);
  }
#endif /* HAVE_LIBCRYPTO */
}
break;
case 435:
#line 2786 "ircd_parser.y"
{
  if (ypass == 2)
  {
    if (yylval.number)
      yy_aconf->flags |= CONF_FLAGS_ENCRYPTED;
    else
      yy_aconf->flags &= ~CONF_FLAGS_ENCRYPTED;
  }
}
break;
case 436:
#line 2797 "ircd_parser.y"
{
  if (ypass == 2)
  {
    if (yylval.number)
      yy_aconf->flags |= CONF_FLAGS_CRYPTLINK;
    else
      yy_aconf->flags &= ~CONF_FLAGS_CRYPTLINK;
  }
}
break;
case 437:
#line 2808 "ircd_parser.y"
{
  if (ypass == 2)
  {
    if (yylval.number)
#ifndef HAVE_LIBZ
      yyerror("Ignoring compressed=yes; -- no zlib support");
#else
      yy_aconf->flags |= CONF_FLAGS_COMPRESSED;
#endif
    else
      yy_aconf->flags &= ~CONF_FLAGS_COMPRESSED;
  }
}
break;
case 438:
#line 2823 "ircd_parser.y"
{
  if (ypass == 2)
  {
    if (yylval.number)
      yy_aconf->flags |= CONF_FLAGS_ALLOW_AUTO_CONN;
    else
      yy_aconf->flags &= ~CONF_FLAGS_ALLOW_AUTO_CONN;
  }
}
break;
case 439:
#line 2834 "ircd_parser.y"
{
  if (ypass == 2)
  {
    if (yylval.number)
      SetConfTopicBurst(yy_aconf);
    else
      ClearConfTopicBurst(yy_aconf);
  }
}
break;
case 440:
#line 2845 "ircd_parser.y"
{
  if (ypass == 2)
  {
    struct CollectItem *yy_tmp;

    yy_tmp = (struct CollectItem *)MyMalloc(sizeof(struct CollectItem));
    DupString(yy_tmp->host, yylval.string);
    DupString(yy_tmp->user, "*");
    dlinkAdd(yy_tmp, &yy_tmp->node, &hub_conf_list);
  }
}
break;
case 441:
#line 2858 "ircd_parser.y"
{
  if (ypass == 2)
  {
    struct CollectItem *yy_tmp;

    yy_tmp = (struct CollectItem *)MyMalloc(sizeof(struct CollectItem));
    DupString(yy_tmp->host, yylval.string);
    DupString(yy_tmp->user, "*");
    dlinkAdd(yy_tmp, &yy_tmp->node, &leaf_conf_list);
  }
}
break;
case 442:
#line 2871 "ircd_parser.y"
{
  if (ypass == 2)
  {
    MyFree(class_name);
    DupString(class_name, yylval.string);
  }
}
break;
case 443:
#line 2880 "ircd_parser.y"
{
#ifdef HAVE_LIBCRYPTO
  if (ypass == 2)
  {
    struct EncCapability *ecap;
    const char *cipher_name;
    int found = 0;

    yy_aconf->cipher_preference = NULL;
    cipher_name = yylval.string;

    for (ecap = CipherTable; ecap->name; ecap++)
    {
      if ((irccmp(ecap->name, cipher_name) == 0) &&
          (ecap->cap & CAP_ENC_MASK))
      {
        yy_aconf->cipher_preference = ecap;
        found = 1;
        break;
      }
    }

    if (!found)
      yyerror("Invalid cipher");
  }
#else
  if (ypass == 2)
    yyerror("Ignoring cipher_preference -- no OpenSSL support");
#endif
}
break;
case 444:
#line 2915 "ircd_parser.y"
{
  if (ypass == 2)
  {
    userbuf[0] = hostbuf[0] = reasonbuf[0] = '\0';
    regex_ban = 0;
  }
}
break;
case 445:
#line 2922 "ircd_parser.y"
{
  if (ypass == 2)
  {
    if (userbuf[0] && hostbuf[0])
    {
      if (regex_ban)
      {
        pcre *exp_user = NULL;
        pcre *exp_host = NULL;
        const char *errptr = NULL;

        if (!(exp_user = ircd_pcre_compile(userbuf, &errptr)) ||
            !(exp_host = ircd_pcre_compile(hostbuf, &errptr)))
        {
          ilog(L_ERROR, "Failed to add regular expression based K-Line: %s",
               errptr);
          break;
        }

        yy_conf = make_conf_item(RKLINE_TYPE);
        yy_aconf = map_to_conf(yy_conf);

        yy_aconf->regexuser = exp_user;
        yy_aconf->regexhost = exp_host;

        DupString(yy_aconf->user, userbuf);
        DupString(yy_aconf->host, hostbuf);

        if (reasonbuf[0])
          DupString(yy_aconf->reason, reasonbuf);
        else
          DupString(yy_aconf->reason, "No reason");
      }
      else
      {
        yy_conf = make_conf_item(KLINE_TYPE);
        yy_aconf = map_to_conf(yy_conf);

        DupString(yy_aconf->user, userbuf);
        DupString(yy_aconf->host, hostbuf);

        if (reasonbuf[0])
          DupString(yy_aconf->reason, reasonbuf);
        else
          DupString(yy_aconf->reason, "No reason");
        add_conf_by_address(CONF_KILL, yy_aconf);
      }
    }
    else
      delete_conf_item(yy_conf);

    yy_conf = NULL;
    yy_aconf = NULL;
  }
}
break;
case 446:
#line 2979 "ircd_parser.y"
{
}
break;
case 450:
#line 2984 "ircd_parser.y"
{
  if (ypass == 2)
    regex_ban = 1;
}
break;
case 457:
#line 2993 "ircd_parser.y"
{
  if (ypass == 2)
  {
    struct split_nuh_item nuh;

    nuh.nuhmask  = yylval.string;
    nuh.nickptr  = NULL;
    nuh.userptr  = userbuf;
    nuh.hostptr  = hostbuf;

    nuh.nicksize = 0;
    nuh.usersize = sizeof(userbuf);
    nuh.hostsize = sizeof(hostbuf);

    split_nuh(&nuh);
  }
}
break;
case 458:
#line 3012 "ircd_parser.y"
{
  if (ypass == 2)
    strlcpy(reasonbuf, yylval.string, sizeof(reasonbuf));
}
break;
case 459:
#line 3021 "ircd_parser.y"
{
  if (ypass == 2)
  {
    yy_conf = make_conf_item(DLINE_TYPE);
    yy_aconf = map_to_conf(yy_conf);
    /* default reason */
    DupString(yy_aconf->reason, "No reason");
  }
}
break;
case 460:
#line 3030 "ircd_parser.y"
{
  if (ypass == 2)
  {
    if (yy_aconf->host && parse_netmask(yy_aconf->host, NULL, NULL) != HM_HOST)
      add_conf_by_address(CONF_DLINE, yy_aconf);
    else
      delete_conf_item(yy_conf);
    yy_conf = NULL;
    yy_aconf = NULL;
  }
}
break;
case 466:
#line 3046 "ircd_parser.y"
{
  if (ypass == 2)
  {
    MyFree(yy_aconf->host);
    DupString(yy_aconf->host, yylval.string);
  }
}
break;
case 467:
#line 3055 "ircd_parser.y"
{
  if (ypass == 2)
  {
    MyFree(yy_aconf->reason);
    DupString(yy_aconf->reason, yylval.string);
  }
}
break;
case 473:
#line 3072 "ircd_parser.y"
{
  if (ypass == 2)
  {
    if (yylval.string[0] && parse_netmask(yylval.string, NULL, NULL) != HM_HOST)
    {
      yy_conf = make_conf_item(EXEMPTDLINE_TYPE);
      yy_aconf = map_to_conf(yy_conf);
      DupString(yy_aconf->host, yylval.string);

      add_conf_by_address(CONF_EXEMPTDLINE, yy_aconf);

      yy_conf = NULL;
      yy_aconf = NULL;
    }
  }
}
break;
case 474:
#line 3093 "ircd_parser.y"
{
  if (ypass == 2)
  {
    regex_ban = 0;
    reasonbuf[0] = gecos_name[0] = '\0';
  }
}
break;
case 475:
#line 3100 "ircd_parser.y"
{
  if (ypass == 2)
  {
    if (gecos_name[0])
    {
      if (regex_ban)
      {
        pcre *exp_p = NULL;
        const char *errptr = NULL;

        if (!(exp_p = ircd_pcre_compile(gecos_name, &errptr)))
        {
          ilog(L_ERROR, "Failed to add regular expression based X-Line: %s",
               errptr);
          break;
        }

        yy_conf = make_conf_item(RXLINE_TYPE);
        yy_conf->regexpname = exp_p;
      }
      else
        yy_conf = make_conf_item(XLINE_TYPE);

      yy_match_item = map_to_conf(yy_conf);
      DupString(yy_conf->name, gecos_name);

      if (reasonbuf[0])
        DupString(yy_match_item->reason, reasonbuf);
      else
        DupString(yy_match_item->reason, "No reason");
    }
  }
}
break;
case 476:
#line 3135 "ircd_parser.y"
{
}
break;
case 480:
#line 3140 "ircd_parser.y"
{
  if (ypass == 2)
    regex_ban = 1;
}
break;
case 487:
#line 3149 "ircd_parser.y"
{
  if (ypass == 2)
    strlcpy(gecos_name, yylval.string, sizeof(gecos_name));
}
break;
case 488:
#line 3155 "ircd_parser.y"
{
  if (ypass == 2)
    strlcpy(reasonbuf, yylval.string, sizeof(reasonbuf));
}
break;
case 548:
#line 3200 "ircd_parser.y"
{
  ConfigFileEntry.gline_min_cidr = yyvsp[-1].number;
}
break;
case 549:
#line 3205 "ircd_parser.y"
{
  ConfigFileEntry.gline_min_cidr6 = yyvsp[-1].number;
}
break;
case 550:
#line 3210 "ircd_parser.y"
{
  ConfigFileEntry.burst_away = yylval.number;
}
break;
case 551:
#line 3215 "ircd_parser.y"
{
  ConfigFileEntry.use_whois_actually = yylval.number;
}
break;
case 552:
#line 3220 "ircd_parser.y"
{
  GlobalSetOptions.rejecttime = yylval.number;
}
break;
case 553:
#line 3225 "ircd_parser.y"
{
  ConfigFileEntry.tkline_expire_notices = yylval.number;
}
break;
case 554:
#line 3230 "ircd_parser.y"
{
  ConfigFileEntry.kill_chase_time_limit = yyvsp[-1].number;
}
break;
case 555:
#line 3235 "ircd_parser.y"
{
  ConfigFileEntry.hide_spoof_ips = yylval.number;
}
break;
case 556:
#line 3240 "ircd_parser.y"
{
  ConfigFileEntry.ignore_bogus_ts = yylval.number;
}
break;
case 557:
#line 3245 "ircd_parser.y"
{
  ConfigFileEntry.disable_remote = yylval.number;
}
break;
case 558:
#line 3250 "ircd_parser.y"
{
  ConfigFileEntry.failed_oper_notice = yylval.number;
}
break;
case 559:
#line 3255 "ircd_parser.y"
{
  ConfigFileEntry.anti_nick_flood = yylval.number;
}
break;
case 560:
#line 3260 "ircd_parser.y"
{
  ConfigFileEntry.max_nick_time = yyvsp[-1].number; 
}
break;
case 561:
#line 3265 "ircd_parser.y"
{
  ConfigFileEntry.max_nick_changes = yyvsp[-1].number;
}
break;
case 562:
#line 3270 "ircd_parser.y"
{
  ConfigFileEntry.max_accept = yyvsp[-1].number;
}
break;
case 563:
#line 3275 "ircd_parser.y"
{
  ConfigFileEntry.anti_spam_exit_message_time = yyvsp[-1].number;
}
break;
case 564:
#line 3280 "ircd_parser.y"
{
  ConfigFileEntry.ts_warn_delta = yyvsp[-1].number;
}
break;
case 565:
#line 3285 "ircd_parser.y"
{
  if (ypass == 2)
    ConfigFileEntry.ts_max_delta = yyvsp[-1].number;
}
break;
case 566:
#line 3291 "ircd_parser.y"
{
  if ((yyvsp[-1].number > 0) && ypass == 1)
  {
    ilog(L_CRIT, "You haven't read your config file properly.");
    ilog(L_CRIT, "There is a line in the example conf that will kill your server if not removed.");
    ilog(L_CRIT, "Consider actually reading/editing the conf file, and removing this line.");
    exit(0);
  }
}
break;
case 567:
#line 3302 "ircd_parser.y"
{
  ConfigFileEntry.kline_with_reason = yylval.number;
}
break;
case 568:
#line 3307 "ircd_parser.y"
{
  if (ypass == 2)
  {
    MyFree(ConfigFileEntry.kline_reason);
    DupString(ConfigFileEntry.kline_reason, yylval.string);
  }
}
break;
case 569:
#line 3316 "ircd_parser.y"
{
  ConfigFileEntry.invisible_on_connect = yylval.number;
}
break;
case 570:
#line 3321 "ircd_parser.y"
{
  ConfigFileEntry.warn_no_nline = yylval.number;
}
break;
case 571:
#line 3326 "ircd_parser.y"
{
  ConfigFileEntry.stats_e_disabled = yylval.number;
}
break;
case 572:
#line 3331 "ircd_parser.y"
{
  ConfigFileEntry.stats_o_oper_only = yylval.number;
}
break;
case 573:
#line 3336 "ircd_parser.y"
{
  ConfigFileEntry.stats_P_oper_only = yylval.number;
}
break;
case 574:
#line 3341 "ircd_parser.y"
{
  ConfigFileEntry.stats_k_oper_only = 2 * yylval.number;
}
break;
case 575:
#line 3344 "ircd_parser.y"
{
  ConfigFileEntry.stats_k_oper_only = 1;
}
break;
case 576:
#line 3349 "ircd_parser.y"
{
  ConfigFileEntry.stats_i_oper_only = 2 * yylval.number;
}
break;
case 577:
#line 3352 "ircd_parser.y"
{
  ConfigFileEntry.stats_i_oper_only = 1;
}
break;
case 578:
#line 3357 "ircd_parser.y"
{
  ConfigFileEntry.pace_wait = yyvsp[-1].number;
}
break;
case 579:
#line 3362 "ircd_parser.y"
{
  ConfigFileEntry.caller_id_wait = yyvsp[-1].number;
}
break;
case 580:
#line 3367 "ircd_parser.y"
{
  ConfigFileEntry.opers_bypass_callerid = yylval.number;
}
break;
case 581:
#line 3372 "ircd_parser.y"
{
  ConfigFileEntry.pace_wait_simple = yyvsp[-1].number;
}
break;
case 582:
#line 3377 "ircd_parser.y"
{
  ConfigFileEntry.short_motd = yylval.number;
}
break;
case 583:
#line 3382 "ircd_parser.y"
{
  ConfigFileEntry.no_oper_flood = yylval.number;
}
break;
case 584:
#line 3387 "ircd_parser.y"
{
  ConfigFileEntry.true_no_oper_flood = yylval.number;
}
break;
case 585:
#line 3392 "ircd_parser.y"
{
  ConfigFileEntry.oper_pass_resv = yylval.number;
}
break;
case 586:
#line 3397 "ircd_parser.y"
{
  if (ypass == 2)
  {
    if (strlen(yylval.string) > LOCALE_LENGTH-2)
      yylval.string[LOCALE_LENGTH-1] = '\0';

    set_locale(yylval.string);
  }
}
break;
case 587:
#line 3408 "ircd_parser.y"
{
  ConfigFileEntry.idletime = yyvsp[-1].number;
}
break;
case 588:
#line 3413 "ircd_parser.y"
{
  ConfigFileEntry.dots_in_ident = yyvsp[-1].number;
}
break;
case 589:
#line 3418 "ircd_parser.y"
{
  ConfigFileEntry.max_targets = yyvsp[-1].number;
}
break;
case 590:
#line 3423 "ircd_parser.y"
{
  if (ypass == 2)
  {
    MyFree(ConfigFileEntry.servlink_path);
    DupString(ConfigFileEntry.servlink_path, yylval.string);
  }
}
break;
case 591:
#line 3432 "ircd_parser.y"
{
#ifdef HAVE_LIBCRYPTO
  if (ypass == 2)
  {
    struct EncCapability *ecap;
    const char *cipher_name;
    int found = 0;

    ConfigFileEntry.default_cipher_preference = NULL;
    cipher_name = yylval.string;

    for (ecap = CipherTable; ecap->name; ecap++)
    {
      if ((irccmp(ecap->name, cipher_name) == 0) &&
          (ecap->cap & CAP_ENC_MASK))
      {
        ConfigFileEntry.default_cipher_preference = ecap;
        found = 1;
        break;
      }
    }

    if (!found)
      yyerror("Invalid cipher");
  }
#else
  if (ypass == 2)
    yyerror("Ignoring default_cipher_preference -- no OpenSSL support");
#endif
}
break;
case 592:
#line 3464 "ircd_parser.y"
{
  if (ypass == 2)
  {
    ConfigFileEntry.compression_level = yyvsp[-1].number;
#ifndef HAVE_LIBZ
    yyerror("Ignoring compression_level -- no zlib support");
#else
    if ((ConfigFileEntry.compression_level < 1) ||
        (ConfigFileEntry.compression_level > 9))
    {
      yyerror("Ignoring invalid compression_level, using default");
      ConfigFileEntry.compression_level = 0;
    }
#endif
  }
}
break;
case 593:
#line 3482 "ircd_parser.y"
{
  ConfigFileEntry.use_egd = yylval.number;
}
break;
case 594:
#line 3487 "ircd_parser.y"
{
  if (ypass == 2)
  {
    MyFree(ConfigFileEntry.egdpool_path);
    DupString(ConfigFileEntry.egdpool_path, yylval.string);
  }
}
break;
case 595:
#line 3496 "ircd_parser.y"
{
  ConfigFileEntry.ping_cookie = yylval.number;
}
break;
case 596:
#line 3501 "ircd_parser.y"
{
  ConfigFileEntry.disable_auth = yylval.number;
}
break;
case 597:
#line 3506 "ircd_parser.y"
{
  ConfigFileEntry.throttle_time = yylval.number;
}
break;
case 598:
#line 3511 "ircd_parser.y"
{
  ConfigFileEntry.oper_umodes = 0;
}
break;
case 602:
#line 3517 "ircd_parser.y"
{
  ConfigFileEntry.oper_umodes |= UMODE_BOTS;
}
break;
case 603:
#line 3520 "ircd_parser.y"
{
  ConfigFileEntry.oper_umodes |= UMODE_CCONN;
}
break;
case 604:
#line 3523 "ircd_parser.y"
{
  ConfigFileEntry.oper_umodes |= UMODE_CCONN_FULL;
}
break;
case 605:
#line 3526 "ircd_parser.y"
{
  ConfigFileEntry.oper_umodes |= UMODE_DEAF;
}
break;
case 606:
#line 3529 "ircd_parser.y"
{
  ConfigFileEntry.oper_umodes |= UMODE_DEBUG;
}
break;
case 607:
#line 3532 "ircd_parser.y"
{
  ConfigFileEntry.oper_umodes |= UMODE_FULL;
}
break;
case 608:
#line 3535 "ircd_parser.y"
{
  ConfigFileEntry.oper_umodes |= UMODE_SKILL;
}
break;
case 609:
#line 3538 "ircd_parser.y"
{
  ConfigFileEntry.oper_umodes |= UMODE_NCHANGE;
}
break;
case 610:
#line 3541 "ircd_parser.y"
{
  ConfigFileEntry.oper_umodes |= UMODE_REJ;
}
break;
case 611:
#line 3544 "ircd_parser.y"
{
  ConfigFileEntry.oper_umodes |= UMODE_UNAUTH;
}
break;
case 612:
#line 3547 "ircd_parser.y"
{
  ConfigFileEntry.oper_umodes |= UMODE_SPY;
}
break;
case 613:
#line 3550 "ircd_parser.y"
{
  ConfigFileEntry.oper_umodes |= UMODE_EXTERNAL;
}
break;
case 614:
#line 3553 "ircd_parser.y"
{
  ConfigFileEntry.oper_umodes |= UMODE_OPERWALL;
}
break;
case 615:
#line 3556 "ircd_parser.y"
{
  ConfigFileEntry.oper_umodes |= UMODE_SERVNOTICE;
}
break;
case 616:
#line 3559 "ircd_parser.y"
{
  ConfigFileEntry.oper_umodes |= UMODE_INVISIBLE;
}
break;
case 617:
#line 3562 "ircd_parser.y"
{
  ConfigFileEntry.oper_umodes |= UMODE_WALLOP;
}
break;
case 618:
#line 3565 "ircd_parser.y"
{
  ConfigFileEntry.oper_umodes |= UMODE_SOFTCALLERID;
}
break;
case 619:
#line 3568 "ircd_parser.y"
{
  ConfigFileEntry.oper_umodes |= UMODE_CALLERID;
}
break;
case 620:
#line 3571 "ircd_parser.y"
{
  ConfigFileEntry.oper_umodes |= UMODE_LOCOPS;
}
break;
case 621:
#line 3576 "ircd_parser.y"
{
  ConfigFileEntry.oper_only_umodes = 0;
}
break;
case 625:
#line 3582 "ircd_parser.y"
{
  ConfigFileEntry.oper_only_umodes |= UMODE_BOTS;
}
break;
case 626:
#line 3585 "ircd_parser.y"
{
  ConfigFileEntry.oper_only_umodes |= UMODE_CCONN;
}
break;
case 627:
#line 3588 "ircd_parser.y"
{
  ConfigFileEntry.oper_only_umodes |= UMODE_CCONN_FULL;
}
break;
case 628:
#line 3591 "ircd_parser.y"
{
  ConfigFileEntry.oper_only_umodes |= UMODE_DEAF;
}
break;
case 629:
#line 3594 "ircd_parser.y"
{
  ConfigFileEntry.oper_only_umodes |= UMODE_DEBUG;
}
break;
case 630:
#line 3597 "ircd_parser.y"
{ 
  ConfigFileEntry.oper_only_umodes |= UMODE_FULL;
}
break;
case 631:
#line 3600 "ircd_parser.y"
{
  ConfigFileEntry.oper_only_umodes |= UMODE_SKILL;
}
break;
case 632:
#line 3603 "ircd_parser.y"
{
  ConfigFileEntry.oper_only_umodes |= UMODE_NCHANGE;
}
break;
case 633:
#line 3606 "ircd_parser.y"
{
  ConfigFileEntry.oper_only_umodes |= UMODE_REJ;
}
break;
case 634:
#line 3609 "ircd_parser.y"
{
  ConfigFileEntry.oper_only_umodes |= UMODE_UNAUTH;
}
break;
case 635:
#line 3612 "ircd_parser.y"
{
  ConfigFileEntry.oper_only_umodes |= UMODE_SPY;
}
break;
case 636:
#line 3615 "ircd_parser.y"
{
  ConfigFileEntry.oper_only_umodes |= UMODE_EXTERNAL;
}
break;
case 637:
#line 3618 "ircd_parser.y"
{
  ConfigFileEntry.oper_only_umodes |= UMODE_OPERWALL;
}
break;
case 638:
#line 3621 "ircd_parser.y"
{
  ConfigFileEntry.oper_only_umodes |= UMODE_SERVNOTICE;
}
break;
case 639:
#line 3624 "ircd_parser.y"
{
  ConfigFileEntry.oper_only_umodes |= UMODE_INVISIBLE;
}
break;
case 640:
#line 3627 "ircd_parser.y"
{
  ConfigFileEntry.oper_only_umodes |= UMODE_WALLOP;
}
break;
case 641:
#line 3630 "ircd_parser.y"
{
  ConfigFileEntry.oper_only_umodes |= UMODE_SOFTCALLERID;
}
break;
case 642:
#line 3633 "ircd_parser.y"
{
  ConfigFileEntry.oper_only_umodes |= UMODE_CALLERID;
}
break;
case 643:
#line 3636 "ircd_parser.y"
{
  ConfigFileEntry.oper_only_umodes |= UMODE_LOCOPS;
}
break;
case 644:
#line 3641 "ircd_parser.y"
{
  ConfigFileEntry.min_nonwildcard = yyvsp[-1].number;
}
break;
case 645:
#line 3646 "ircd_parser.y"
{
  ConfigFileEntry.min_nonwildcard_simple = yyvsp[-1].number;
}
break;
case 646:
#line 3651 "ircd_parser.y"
{
  ConfigFileEntry.default_floodcount = yyvsp[-1].number;
}
break;
case 647:
#line 3656 "ircd_parser.y"
{
  ConfigFileEntry.client_flood = yyvsp[-1].number;
}
break;
case 648:
#line 3661 "ircd_parser.y"
{
  ConfigFileEntry.dot_in_ip6_addr = yylval.number;
}
break;
case 649:
#line 3669 "ircd_parser.y"
{
  if (ypass == 2)
  {
    yy_conf = make_conf_item(GDENY_TYPE);
    yy_aconf = map_to_conf(yy_conf);
  }
}
break;
case 650:
#line 3676 "ircd_parser.y"
{
  if (ypass == 2)
  {
    /*
     * since we re-allocate yy_conf/yy_aconf after the end of action=, at the
     * end we will have one extra, so we should free it.
     */
    if (yy_conf->name == NULL || yy_aconf->user == NULL)
    {
      delete_conf_item(yy_conf);
      yy_conf = NULL;
      yy_aconf = NULL;
    }
  }
}
break;
case 660:
#line 3702 "ircd_parser.y"
{
  if (ypass == 2)
    ConfigFileEntry.glines = yylval.number;
}
break;
case 661:
#line 3708 "ircd_parser.y"
{
  if (ypass == 2)
    ConfigFileEntry.gline_time = yyvsp[-1].number;
}
break;
case 662:
#line 3714 "ircd_parser.y"
{
  if (ypass == 2)
    ConfigFileEntry.gline_logging = 0;
}
break;
case 666:
#line 3720 "ircd_parser.y"
{
  if (ypass == 2)
    ConfigFileEntry.gline_logging |= GDENY_REJECT;
}
break;
case 667:
#line 3724 "ircd_parser.y"
{
  if (ypass == 2)
    ConfigFileEntry.gline_logging |= GDENY_BLOCK;
}
break;
case 668:
#line 3730 "ircd_parser.y"
{
  if (ypass == 2)
  {
    struct split_nuh_item nuh;

    nuh.nuhmask  = yylval.string;
    nuh.nickptr  = NULL;
    nuh.userptr  = userbuf;
    nuh.hostptr  = hostbuf;

    nuh.nicksize = 0;
    nuh.usersize = sizeof(userbuf);
    nuh.hostsize = sizeof(hostbuf);

    split_nuh(&nuh);

    if (yy_aconf->user == NULL)
    {
      DupString(yy_aconf->user, userbuf);
      DupString(yy_aconf->host, hostbuf);
    }
    else
    {
      struct CollectItem *yy_tmp = MyMalloc(sizeof(struct CollectItem));

      DupString(yy_tmp->user, userbuf);
      DupString(yy_tmp->host, hostbuf);

      dlinkAdd(yy_tmp, &yy_tmp->node, &col_conf_list);
    }
  }
}
break;
case 669:
#line 3764 "ircd_parser.y"
{
  if (ypass == 2)  
  {
    MyFree(yy_conf->name);
    DupString(yy_conf->name, yylval.string);
  }
}
break;
case 670:
#line 3773 "ircd_parser.y"
{
  if (ypass == 2)
    yy_aconf->flags = 0;
}
break;
case 671:
#line 3777 "ircd_parser.y"
{
  if (ypass == 2)
  {
    struct CollectItem *yy_tmp = NULL;
    dlink_node *ptr, *next_ptr;

    DLINK_FOREACH_SAFE(ptr, next_ptr, col_conf_list.head)
    {
      struct AccessItem *new_aconf;
      struct ConfItem *new_conf;

      yy_tmp = ptr->data;
      new_conf = make_conf_item(GDENY_TYPE);
      new_aconf = map_to_conf(new_conf);

      new_aconf->flags = yy_aconf->flags;

      if (yy_conf->name != NULL)
        DupString(new_conf->name, yy_conf->name);
      else
        DupString(new_conf->name, "*");
      if (yy_aconf->user != NULL)
         DupString(new_aconf->user, yy_tmp->user);
      else   
        DupString(new_aconf->user, "*");
      if (yy_aconf->host != NULL)
        DupString(new_aconf->host, yy_tmp->host);
      else
        DupString(new_aconf->host, "*");

      dlinkDelete(&yy_tmp->node, &col_conf_list);
    }

    /*
     * In case someone has fed us with more than one action= after user/name
     * which would leak memory  -Michael
     */
    if (yy_conf->name == NULL || yy_aconf->user == NULL)
      delete_conf_item(yy_conf);

    yy_conf = make_conf_item(GDENY_TYPE);
    yy_aconf = map_to_conf(yy_conf);
  }
}
break;
case 674:
#line 3824 "ircd_parser.y"
{
  if (ypass == 2)
    yy_aconf->flags |= GDENY_REJECT;
}
break;
case 675:
#line 3828 "ircd_parser.y"
{
  if (ypass == 2)
    yy_aconf->flags |= GDENY_BLOCK;
}
break;
case 698:
#line 3852 "ircd_parser.y"
{
  ConfigChannel.disable_fake_channels = yylval.number;
}
break;
case 699:
#line 3857 "ircd_parser.y"
{
  ConfigChannel.restrict_channels = yylval.number;
}
break;
case 700:
#line 3862 "ircd_parser.y"
{
  ConfigChannel.disable_local_channels = yylval.number;
}
break;
case 701:
#line 3867 "ircd_parser.y"
{
  ConfigChannel.use_except = yylval.number;
}
break;
case 702:
#line 3872 "ircd_parser.y"
{
  ConfigChannel.use_invex = yylval.number;
}
break;
case 703:
#line 3877 "ircd_parser.y"
{
  ConfigChannel.use_knock = yylval.number;
}
break;
case 704:
#line 3882 "ircd_parser.y"
{
  ConfigChannel.knock_delay = yyvsp[-1].number;
}
break;
case 705:
#line 3887 "ircd_parser.y"
{
  ConfigChannel.knock_delay_channel = yyvsp[-1].number;
}
break;
case 706:
#line 3892 "ircd_parser.y"
{
  ConfigChannel.max_chans_per_user = yyvsp[-1].number;
}
break;
case 707:
#line 3897 "ircd_parser.y"
{
  ConfigChannel.quiet_on_ban = yylval.number;
}
break;
case 708:
#line 3902 "ircd_parser.y"
{
  ConfigChannel.max_bans = yyvsp[-1].number;
}
break;
case 709:
#line 3907 "ircd_parser.y"
{
  ConfigChannel.default_split_user_count = yyvsp[-1].number;
}
break;
case 710:
#line 3912 "ircd_parser.y"
{
  ConfigChannel.default_split_server_count = yyvsp[-1].number;
}
break;
case 711:
#line 3917 "ircd_parser.y"
{
  ConfigChannel.no_create_on_split = yylval.number;
}
break;
case 712:
#line 3922 "ircd_parser.y"
{
  ConfigChannel.no_join_on_split = yylval.number;
}
break;
case 713:
#line 3927 "ircd_parser.y"
{
  ConfigChannel.burst_topicwho = yylval.number;
}
break;
case 714:
#line 3932 "ircd_parser.y"
{
  GlobalSetOptions.joinfloodcount = yylval.number;
}
break;
case 715:
#line 3937 "ircd_parser.y"
{
  GlobalSetOptions.joinfloodtime = yylval.number;
}
break;
case 727:
#line 3956 "ircd_parser.y"
{
  if (ypass == 2)
    ConfigServerHide.flatten_links = yylval.number;
}
break;
case 728:
#line 3962 "ircd_parser.y"
{
  if (ypass == 2)
    ConfigServerHide.hide_servers = yylval.number;
}
break;
case 729:
#line 3968 "ircd_parser.y"
{
  if (ypass == 2)
  {
    MyFree(ConfigServerHide.hidden_name);
    DupString(ConfigServerHide.hidden_name, yylval.string);
  }
}
break;
case 730:
#line 3977 "ircd_parser.y"
{
  if (ypass == 2)
  {
    if ((yyvsp[-1].number > 0) && ConfigServerHide.links_disabled == 1)
    {
      eventAddIsh("write_links_file", write_links_file, NULL, yyvsp[-1].number);
      ConfigServerHide.links_disabled = 0;
    }

    ConfigServerHide.links_delay = yyvsp[-1].number;
  }
}
break;
case 731:
#line 3991 "ircd_parser.y"
{
  if (ypass == 2)
    ConfigServerHide.hidden = yylval.number;
}
break;
case 732:
#line 3997 "ircd_parser.y"
{
  if (ypass == 2)
    ConfigServerHide.disable_hidden = yylval.number;
}
break;
case 733:
#line 4003 "ircd_parser.y"
{
  if (ypass == 2)
    ConfigServerHide.hide_server_ips = yylval.number;
}
break;
#line 6356 "y.tab.c"
    }
    yyssp -= yym;
    yystate = *yyssp;
    yyvsp -= yym;
    yym = yylhs[yyn];
    if (yystate == 0 && yym == 0)
    {
#if YYDEBUG
        if (yydebug)
            printf("%sdebug: after reduction, shifting from state 0 to\
 state %d\n", YYPREFIX, YYFINAL);
#endif
        yystate = YYFINAL;
        *++yyssp = YYFINAL;
        *++yyvsp = yyval;
        if (yychar < 0)
        {
            if ((yychar = yylex()) < 0) yychar = 0;
#if YYDEBUG
            if (yydebug)
            {
                yys = 0;
                if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
                if (!yys) yys = "illegal-symbol";
                printf("%sdebug: state %d, reading %d (%s)\n",
                        YYPREFIX, YYFINAL, yychar, yys);
            }
#endif
        }
        if (yychar == 0) goto yyaccept;
        goto yyloop;
    }
    if ((yyn = yygindex[yym]) && (yyn += yystate) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yystate)
        yystate = yytable[yyn];
    else
        yystate = yydgoto[yym];
#if YYDEBUG
    if (yydebug)
        printf("%sdebug: after reduction, shifting from state %d \
to state %d\n", YYPREFIX, *yyssp, yystate);
#endif
    if (yyssp >= yysslim && yygrowstack())
    {
        goto yyoverflow;
    }
    *++yyssp = yystate;
    *++yyvsp = yyval;
    goto yyloop;
yyoverflow:
    yyerror("yacc stack overflow");
yyabort:
    return (1);
yyaccept:
    return (0);
}
