/*  ipguard.h
 *
 * Copyright (c) 2008 SeaD <sead at deep.perm.ru>
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef _IPGUARD_H
#define _IPGUARD_H 1

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>

#include <limits.h>             /* PATH_MAX */

#define IP_ADDR_LEN     4
#ifndef IFNAMSIZ
# define IFNAMSIZ       16
#endif
#ifndef MAXLOGNAME
# define MAXLOGNAME     16
#endif

#define NAME            "ipguard"
#define VERSION         "1.02"
#define AUTHOR          "SeaD"
#define MAIL            "sead at deep.perm.ru"

#define ETHERSFILE      ETHERS
#define LOGNAME         "/var/log/ipguard"
#define PIDNAME         "/var/run/ipguard"
#define FAKEMAC         "de:ad:xx:xx:xx:xx"
#define PCAP_FILTER     "arp"

#define ETHERSTO        0
#define FAKENUM         2
#define FAKETIME        50      /* milliseconds */
#define BUFSIZE         10

#define ERROR           1
#define WARNING         2
#define NOTICE          3
#define INFO            4

char iface[IFNAMSIZ];
char ethers_name[PATH_MAX];
char log_name[PATH_MAX];
char pid_name[PATH_MAX];
char fmac[18];
char suser[MAXLOGNAME];
int ethers_update;
int fake_num;
int fake_time;
int buffer_num;
int addr_nosubst;
int nofirst;
int grant;
int read_only;
int duplex;
int fixbc;
int hidden;
int promisc;
int debug;
int verbose;

unsigned int all, good, grat, wgrat, zmac, zip, bad, bmac, bsip, btip,
    bnew, bgrat, mymac, fake, nzh, nbe, mis;
char s[128+1];

/*  ethers.c
 */
void ethers_init(void);
void ethers_reinit(void);

/*  packet.c
 */
void buffer_dump(void);
void buffer_dump2ethers(void);
void pair_init(void);
void pair_destroy (void);
void pair_add(char *mac, char *ip);
void pair_dump(void);
void packet_init(char *iface);
void packet_destroy (void);
void packet_recv(void);
void stat_dump(void);

/*  system.c
 */
void exit_ipguard(int reason);
void rand_mac(char *mac);
void sig_init(void);
void sig_func(int signal);
void sig_catch(void);
void log_open(void);
void log_str(int pri, char *ent, char *err);
void log_close(void);
void log_reopen(void);
void pid_creat(void);
void pid_unlink(void);
void daemonize(void);
void set_user(void);
char *time_get(void);
void ethers_rand(char *mac);
void ethers_stat(void);

#endif  /* _IPGUARD_H */
