.\" -*-nroff-*-
.\"
.\"     Copyright (C) 1999 Robert CHERAMY <tibob@via.ecp.fr>
.\"
.\"     This program is free software; you can redistribute it and/or modify
.\"     it under the terms of the GNU General Public License as published by
.\"     the Free Software Foundation; either version 2 of the License, or
.\"     (at your option) any later version.
.\"
.\"     This program is distributed in the hope that it will be useful,
.\"     but WITHOUT ANY WARRANTY; without even the implied warranty of
.\"     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\"     GNU General Public License for more details.
.\"
.\"     You should have received a copy of the GNU General Public License
.\"     along with this program; if not, write to the Free Software
.\"     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
.\"
.TH IPFM 8 "Last change: 12 July 1999"

.SH NAME
ipfm \- IP Flow Meter

.SH SYNOPSIS
.B ipfm
[\-c
.I config-file
][\-\-config
.I config-file
]  [-h][--help] [-n][--nofork]

.SH DESCRIPTION
.B ipfm
is a bandwidth analysis tool. It counts how much data was send and
received by specified hosts through an Internet link.

.B ipfm
is based on the libpcap (ftp://ftp.ee.lbl.gov/libpcapi\-0.4.tar.Z) and
should be portable. It was tested under Linux, Free BSD and IRIX.

.SH OPTIONS
.IP "-c config-file, --config <file>"
.I config-file
specifies an alternate configuration file to use. By default,
.IR __CONFIGURATION_FILE
is used.
.IP "-n, --nofork"
do not run in background
.IP "-h, --help"
display an help message on standard output and exit

.SH SIGNALS
.B ipfm
reacts to certain signals.

.TP
.I SigHUP
This causes
.B ipfm
to flush its data tables in the log file (see
.BR ipfm.conf (8)
), close pcap descriptor, reload configuration file and restart.

.TP
.I SigTERM
This causes
.B ipfm
to flush its data tables in the log file (see
.BR ipfm.conf (8)
) and exit.

.TP
.I SigKILL
This causes
.B ipfm
to exit.

.TP
.I SigINT (ctrl-c)
This causes
.B ipfm
to exit after having flushed its buffers.

.SH SEE ALSO
.BR ipfm.conf (8)

.SH AUTHORS
Robert CHERAMY <tibob@via.ecp.fr>, Andres KRAPF <dae@via.ecp.fr>

.PP
IPFM home page can be found at http://www.via.ecp.fr/~tibob/ipfm/
