/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Label;
import java.awt.List;
import java.awt.Point;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

public class Interface
extends Frame
implements ActionListener,
ItemListener,
WindowListener {
    protected Checkbox mTCP;
    protected Checkbox mUDP;
    protected Label mAmount_L;
    protected TextField mAmount;
    protected Checkbox mAmountSecs;
    protected Checkbox mAmountBytes;
    protected Checkbox mServer;
    protected Checkbox mClient;
    protected TextField mClientHost;
    protected Label mWindow_TCP_L;
    protected Label mWindow_UDP_L;
    protected TextField mWindow;
    protected Label mWindow_U;
    protected Label mInterval_L;
    protected TextField mInterval;
    protected Label mInterval_U;
    protected Label mThreads_L;
    protected TextField mThreads;
    protected Label mBandwidth_L;
    protected TextField mBandwidth;
    protected Label mBandwidth_U;
    protected Label mLength_Recv_L;
    protected Label mLength_Send_L;
    protected TextField mLength;
    protected Label mLength_U;
    protected Label mPort_L;
    protected TextField mPort;
    protected Label mBindAddr_Recv_L;
    protected Label mBindAddr_Send_L;
    protected TextField mBindAddr;
    protected Label mMulticastTTL_L;
    protected TextField mMulticastTTL;
    protected Label mFormat_L;
    protected List mFormat;
    protected Label mNoDelay_L;
    protected Checkbox mNoDelay;
    protected Checkbox mNoDelay_No;
    protected Label mShowMSS_L;
    protected Checkbox mShowMSS;
    protected Checkbox mShowMSS_No;
    protected Label mSetMSS_L;
    protected TextField mSetMSS;
    protected Label mSetMSS_U;
    protected Label mTOS_L;
    protected TextField mTOS;
    protected Button mRun;

    public static void main(String[] stringArray) {
        new Interface();
    }

    public Interface() {
        super("Iperf Measurement Tool");
        ((Component)this).setBackground(Color.white);
        BindLayout bindLayout = new BindLayout();
        this.setLayout(bindLayout);
        this.mRun = new Button("Run test");
        this.add((Component)this.mRun, "tl");
        Label label = new Label("Iperf");
        Label label2 = new Label("by NLANR Applications Support");
        Label label3 = new Label("http://dast.nlanr.net/");
        this.add((Component)label, "tl");
        this.add((Component)label2, "tl");
        this.add((Component)label3, "tr");
        CheckboxGroup checkboxGroup = new CheckboxGroup();
        this.mServer = new Checkbox(" Server", true, checkboxGroup);
        this.mClient = new Checkbox(" Client (specify server)", false, checkboxGroup);
        this.mClientHost = new TextField("", 30);
        this.add((Component)this.mServer, "tl");
        this.add((Component)this.mClient, "tl");
        this.add((Component)this.mClientHost, "tlr");
        CheckboxGroup checkboxGroup2 = new CheckboxGroup();
        this.mTCP = new Checkbox(" TCP", true, checkboxGroup2);
        this.mUDP = new Checkbox(" UDP", false, checkboxGroup2);
        this.add((Component)this.mTCP, "tl");
        this.add((Component)this.mUDP, "tl");
        CheckboxGroup checkboxGroup3 = new CheckboxGroup();
        this.mAmount_L = new Label("Transmit time or bytes:");
        this.mAmount = new TextField("", 5);
        this.mAmountSecs = new Checkbox(" seconds", true, checkboxGroup3);
        this.mAmountBytes = new Checkbox(" [KM] bytes", false, checkboxGroup3);
        this.add((Component)this.mAmount_L, "tl");
        this.add((Component)this.mAmount, "tl");
        this.add((Component)this.mAmountSecs, "tl");
        this.add((Component)this.mAmountBytes, "tl");
        this.mWindow_TCP_L = new Label("TCP window size: ");
        this.mWindow_UDP_L = new Label("UDP buffer size: ");
        this.mWindow = new TextField("", 5);
        this.mWindow_U = new Label("[KM] bytes");
        this.add((Component)this.mWindow_TCP_L, "tl");
        this.add((Component)this.mWindow_UDP_L, "tl");
        this.add((Component)this.mWindow, "tl");
        this.add((Component)this.mWindow_U, "tl");
        this.mInterval_L = new Label("Interval between reports: ");
        this.mInterval = new TextField("", 5);
        this.mInterval_U = new Label("seconds");
        this.add((Component)this.mInterval_L, "tl");
        this.add((Component)this.mInterval, "tl");
        this.add((Component)this.mInterval_U, "tl");
        this.mThreads_L = new Label("Number of client threads: ");
        this.mThreads = new TextField("", 5);
        this.add((Component)this.mThreads_L, "tl");
        this.add((Component)this.mThreads, "tl");
        this.mBandwidth_L = new Label("UDP bandwidth: ");
        this.mBandwidth = new TextField("", 5);
        this.mBandwidth_U = new Label("[KM] bits/sec");
        this.add((Component)this.mBandwidth_L, "tl");
        this.add((Component)this.mBandwidth, "tl");
        this.add((Component)this.mBandwidth_U, "tl");
        this.mLength_Recv_L = new Label("Read size: ");
        this.mLength_Send_L = new Label("Write size: ");
        this.mLength = new TextField("", 5);
        this.mLength_U = new Label("[KM] bytes");
        this.add((Component)this.mLength_Recv_L, "tl");
        this.add((Component)this.mLength_Send_L, "tl");
        this.add((Component)this.mLength, "tl");
        this.add((Component)this.mLength_U, "tl");
        this.mPort_L = new Label("Port: ");
        this.mPort = new TextField("", 5);
        this.add((Component)this.mPort_L, "tl");
        this.add((Component)this.mPort, "tl");
        this.mBindAddr_Recv_L = new Label("Local interface to receive on: ");
        this.mBindAddr_Send_L = new Label("Local interface to send on: ");
        this.mBindAddr = new TextField("", 30);
        this.add((Component)this.mBindAddr_Recv_L, "tl");
        this.add((Component)this.mBindAddr_Send_L, "tl");
        this.add((Component)this.mBindAddr, "tlr");
        this.mMulticastTTL_L = new Label("Multicast TTL: ");
        this.mMulticastTTL = new TextField("", 5);
        this.add((Component)this.mMulticastTTL_L, "tl");
        this.add((Component)this.mMulticastTTL, "tl");
        this.mFormat_L = new Label("Output format: ");
        this.mFormat = new List(3);
        this.add((Component)this.mFormat_L, "tl");
        this.add((Component)this.mFormat, "tl");
        this.mFormat.add("Adaptive bits");
        this.mFormat.add("Adaptive Bytes");
        this.mFormat.add("Kbits");
        this.mFormat.add("KBytes");
        this.mFormat.add("Mbits");
        this.mFormat.add("MBytes");
        this.mFormat.select(0);
        CheckboxGroup checkboxGroup4 = new CheckboxGroup();
        this.mNoDelay_L = new Label("Set TCP no delay option: ");
        this.mNoDelay = new Checkbox(" yes", false, checkboxGroup4);
        this.mNoDelay_No = new Checkbox(" no", true, checkboxGroup4);
        this.add((Component)this.mNoDelay_L, "tl");
        this.add((Component)this.mNoDelay, "tl");
        this.add((Component)this.mNoDelay_No, "tl");
        CheckboxGroup checkboxGroup5 = new CheckboxGroup();
        this.mShowMSS_L = new Label("Show TCP MSS/MTU: ");
        this.mShowMSS = new Checkbox(" yes", false, checkboxGroup5);
        this.mShowMSS_No = new Checkbox(" no", true, checkboxGroup5);
        this.add((Component)this.mShowMSS_L, "tl");
        this.add((Component)this.mShowMSS, "tl");
        this.add((Component)this.mShowMSS_No, "tl");
        this.mSetMSS_L = new Label("Set TCP MSS: ");
        this.mSetMSS = new TextField("", 5);
        this.mSetMSS_U = new Label("bytes");
        this.add((Component)this.mSetMSS_L, "tl");
        this.add((Component)this.mSetMSS, "tl");
        this.add((Component)this.mSetMSS_U, "tl");
        this.mTOS_L = new Label("Type-Of-Service (TOS): ");
        this.mTOS = new TextField("", 5);
        this.add((Component)this.mTOS_L, "tl");
        this.add((Component)this.mTOS, "tl");
        bindLayout.setIgnoreResize(true);
        this.pack();
        bindLayout.setIgnoreResize(false);
        Label[] labelArray = new Label[]{this.mFormat_L, this.mAmount_L, this.mWindow_TCP_L, this.mWindow_UDP_L, this.mInterval_L, this.mThreads_L, this.mBandwidth_L, this.mLength_Recv_L, this.mLength_Send_L, this.mPort_L, this.mBindAddr_Recv_L, this.mBindAddr_Send_L, this.mMulticastTTL_L, this.mNoDelay_L, this.mShowMSS_L, this.mSetMSS_L, this.mTOS_L};
        int n = 0;
        int n2 = 0;
        while (n2 < labelArray.length) {
            Dimension dimension = labelArray[n2].getSize();
            if (dimension.width > n) {
                n = dimension.width;
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < labelArray.length) {
            Dimension dimension = labelArray[n3].getSize();
            dimension.width = n;
            labelArray[n3].setSize(dimension);
            labelArray[n3].setAlignment(2);
            ++n3;
        }
        int n4 = 10;
        Insets insets = this.getInsets();
        Point point = new Point(insets.left + n4, insets.top + n4);
        this.layoutRow(point, new Component[]{label, label2, label3});
        this.layoutRow(point, new Component[]{this.mRun});
        this.layoutRow(point, new Component[]{this.mServer, this.mClient, this.mClientHost});
        this.layoutRow(point, new Component[]{this.mTCP, this.mUDP});
        this.layoutRow(point, new Component[]{this.mAmount_L, this.mAmount, this.mAmountSecs, this.mAmountBytes});
        this.layoutRow(point, new Component[]{this.mWindow_TCP_L, this.mWindow, this.mWindow_U});
        this.mWindow_UDP_L.setBounds(this.mWindow_TCP_L.getBounds());
        this.layoutRow(point, new Component[]{this.mInterval_L, this.mInterval, this.mInterval_U});
        this.layoutRow(point, new Component[]{this.mThreads_L, this.mThreads});
        this.layoutRow(point, new Component[]{this.mBandwidth_L, this.mBandwidth, this.mBandwidth_U});
        this.layoutRow(point, new Component[]{this.mLength_Recv_L, this.mLength, this.mLength_U});
        this.mLength_Send_L.setBounds(this.mLength_Recv_L.getBounds());
        this.layoutRow(point, new Component[]{this.mPort_L, this.mPort});
        this.layoutRow(point, new Component[]{this.mBindAddr_Recv_L, this.mBindAddr});
        this.mBindAddr_Send_L.setBounds(this.mBindAddr_Recv_L.getBounds());
        this.layoutRow(point, new Component[]{this.mMulticastTTL_L, this.mMulticastTTL});
        this.layoutRow(point, new Component[]{this.mNoDelay_L, this.mNoDelay, this.mNoDelay_No});
        this.layoutRow(point, new Component[]{this.mShowMSS_L, this.mShowMSS, this.mShowMSS_No});
        this.layoutRow(point, new Component[]{this.mSetMSS_L, this.mSetMSS, this.mSetMSS_U});
        this.layoutRow(point, new Component[]{this.mTOS_L, this.mTOS});
        this.layoutRow(point, new Component[]{this.mFormat_L, this.mFormat});
        this.mTCP.addItemListener(this);
        this.mUDP.addItemListener(this);
        this.mClient.addItemListener(this);
        this.mServer.addItemListener(this);
        this.mRun.addActionListener(this);
        this.addWindowListener(this);
        bindLayout.setIgnoreResize(true);
        Dimension dimension = this.getPreferredSize();
        dimension.height += n4;
        dimension.width += n4;
        ((Component)this).setSize(dimension);
        this.stateChanged();
        this.show();
        bindLayout.setIgnoreResize(false);
    }

    protected void layoutRow(Point point, Component[] componentArray) {
        int n = point.x;
        int n2 = point.y;
        int n3 = 5;
        int n4 = 0;
        int n5 = 0;
        while (n5 < componentArray.length) {
            Dimension dimension = componentArray[n5].getSize();
            if (dimension.height > n4) {
                n4 = dimension.height;
            }
            ++n5;
        }
        int n6 = 0;
        while (n6 < componentArray.length) {
            Dimension dimension = componentArray[n6].getSize();
            point.y = n2 + (n4 - dimension.height) / 2;
            componentArray[n6].setLocation(point);
            point.x += dimension.width + n3;
            ++n6;
        }
        point.x = n;
        point.y = n2 + n4 + n3;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.mRun) {
            Iperf iperf = new Iperf(this.getOptions());
            iperf.start();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        this.stateChanged();
        if (object == this.mClient) {
            this.mClientHost.requestFocus();
        }
    }

    protected void stateChanged() {
        boolean bl = this.mClient.getState();
        boolean bl2 = this.mTCP.getState();
        this.mAmount_L.setEnabled(bl);
        this.mAmount.setEnabled(bl);
        this.mAmountSecs.setEnabled(bl);
        this.mAmountBytes.setEnabled(bl);
        this.mClientHost.setEnabled(bl);
        this.mWindow_TCP_L.setVisible(bl2);
        this.mWindow_UDP_L.setVisible(!bl2);
        this.mThreads_L.setEnabled(bl);
        this.mThreads.setEnabled(bl);
        this.mBandwidth_L.setEnabled(!bl2 && bl);
        this.mBandwidth.setEnabled(!bl2 && bl);
        this.mBandwidth_U.setEnabled(!bl2 && bl);
        this.mLength_Recv_L.setVisible(!bl);
        this.mLength_Send_L.setVisible(bl);
        this.mBindAddr_Recv_L.setVisible(!bl);
        this.mBindAddr_Send_L.setVisible(bl);
        this.mMulticastTTL_L.setEnabled(!bl2 && bl);
        this.mMulticastTTL.setEnabled(!bl2 && bl);
        this.mNoDelay_L.setEnabled(bl2 && bl);
        this.mNoDelay.setEnabled(bl2 && bl);
        this.mNoDelay_No.setEnabled(bl2 && bl);
        this.mShowMSS_L.setEnabled(bl2);
        this.mShowMSS.setEnabled(bl2);
        this.mShowMSS_No.setEnabled(bl2);
        this.mSetMSS_L.setEnabled(bl2);
        this.mSetMSS.setEnabled(bl2);
        this.mSetMSS_U.setEnabled(bl2);
    }

    protected String getOptions() {
        String string = "";
        string = this.mServer.getState() ? String.valueOf(string) + "-s " : String.valueOf(string) + "-c " + this.mClientHost.getText() + " ";
        if (this.mUDP.getState()) {
            string = String.valueOf(string) + "-u ";
        }
        if (this.mAmount.getText().length() > 0) {
            string = this.mAmountSecs.getState() ? String.valueOf(string) + "-t " + this.mAmount.getText() + " " : String.valueOf(string) + "-n " + this.mAmount.getText() + " ";
        }
        if (this.mWindow.getText().length() > 0) {
            string = String.valueOf(string) + "-w " + this.mWindow.getText() + " ";
        }
        if (this.mInterval.getText().length() > 0) {
            string = String.valueOf(string) + "-i " + this.mInterval.getText() + " ";
        }
        if (this.mThreads.getText().length() > 0) {
            string = String.valueOf(string) + "-P " + this.mThreads.getText() + " ";
        }
        if (this.mBandwidth.getText().length() > 0) {
            string = String.valueOf(string) + "-b " + this.mBandwidth.getText() + " ";
        }
        if (this.mLength.getText().length() > 0) {
            string = String.valueOf(string) + "-l " + this.mLength.getText() + " ";
        }
        if (this.mPort.getText().length() > 0) {
            string = String.valueOf(string) + "-p " + this.mPort.getText() + " ";
        }
        if (this.mBindAddr.getText().length() > 0) {
            string = String.valueOf(string) + "-B " + this.mBindAddr.getText() + " ";
        }
        if (this.mMulticastTTL.getText().length() > 0) {
            string = String.valueOf(string) + "-T " + this.mMulticastTTL.getText() + " ";
        }
        char c = '\u0000';
        switch (this.mFormat.getSelectedIndex()) {
            case 1: {
                c = 'A';
                break;
            }
            case 2: {
                c = 'k';
                break;
            }
            case 3: {
                c = 'K';
                break;
            }
            case 4: {
                c = 'm';
                break;
            }
            case 5: {
                c = 'M';
            }
        }
        if (c != '\u0000') {
            string = String.valueOf(string) + "-f " + c + " ";
        }
        if (this.mNoDelay.getState()) {
            string = String.valueOf(string) + "-N ";
        }
        if (this.mShowMSS.getState()) {
            string = String.valueOf(string) + "-m ";
        }
        if (this.mSetMSS.getText().length() > 0) {
            string = String.valueOf(string) + "-M " + this.mSetMSS.getText() + " ";
        }
        if (this.mTOS.getText().length() > 0) {
            string = String.valueOf(string) + "-S " + this.mTOS.getText() + " ";
        }
        return string;
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        Thread thread = Thread.currentThread();
        ThreadGroup threadGroup = thread.getThreadGroup();
        Thread[] threadArray = new Thread[threadGroup.activeCount()];
        int n = threadGroup.enumerate(threadArray);
        int n2 = 0;
        while (n2 < n) {
            try {
                Iperf iperf = (Iperf)threadArray[n2];
                iperf.quit();
            }
            catch (ClassCastException classCastException) {}
            ++n2;
        }
        int n3 = 0;
        while (n3 < n) {
            try {
                Iperf iperf = (Iperf)threadArray[n3];
                try {
                    iperf.join(5000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            catch (ClassCastException classCastException) {}
            ++n3;
        }
        System.exit(0);
    }
}

