/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Hashtable;

public class BindLayout
implements LayoutManager2 {
    Hashtable mBindingsHash = new Hashtable();
    Dimension mLastSize = new Dimension(-1, -1);
    Insets mLastInsets = new Insets(0, 0, 0, 0);
    boolean mIgnoreResize;

    public void setIgnoreResize(boolean bl) {
        this.mIgnoreResize = bl;
    }

    public void addLayoutComponent(Component component, Object object) {
        String string = object.toString().toLowerCase();
        Binding binding = new Binding(string);
        this.mBindingsHash.put(component, binding);
    }

    public void addLayoutComponent(String string, Component component) {
        System.out.println("addLayoutComponent( String name, Component comp ) is deprecated in Java 1.1, and unimplemented in BindLayout.\n");
    }

    public void removeLayoutComponent(Component component) {
        this.mBindingsHash.remove(component);
    }

    public Dimension preferredLayoutSize(Container container) {
        Dimension dimension = new Dimension(0, 0);
        Enumeration enumeration = this.mBindingsHash.keys();
        while (enumeration.hasMoreElements()) {
            Component component = (Component)enumeration.nextElement();
            Point point = component.getLocation();
            Dimension dimension2 = component.getSize();
            if (dimension2.width == 0 && dimension2.height == 0) {
                dimension2 = component.getPreferredSize();
            }
            dimension.width = Math.max(dimension.width, point.x + dimension2.width);
            dimension.height = Math.max(dimension.height, point.y + dimension2.height);
        }
        return dimension;
    }

    public Dimension minimumLayoutSize(Container container) {
        Dimension dimension = new Dimension(0, 0);
        Enumeration enumeration = this.mBindingsHash.keys();
        while (enumeration.hasMoreElements()) {
            Component component = (Component)enumeration.nextElement();
            Point point = component.getLocation();
            Dimension dimension2 = component.getMinimumSize();
            dimension.width = Math.max(dimension.width, point.x + dimension2.width);
            dimension.height = Math.max(dimension.height, point.y + dimension2.height);
        }
        return dimension;
    }

    public Dimension maximumLayoutSize(Container container) {
        Dimension dimension = new Dimension(0, 0);
        Enumeration enumeration = this.mBindingsHash.keys();
        while (enumeration.hasMoreElements()) {
            Component component = (Component)enumeration.nextElement();
            Point point = component.getLocation();
            Dimension dimension2 = component.getMaximumSize();
            dimension.width = Math.max(dimension.width, point.x + dimension2.width);
            dimension.height = Math.max(dimension.height, point.y + dimension2.height);
        }
        return dimension;
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.0f;
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.0f;
    }

    public void invalidateLayout(Container container) {
    }

    public void layoutContainer(Container container) {
        Dimension dimension = new Dimension(0, 0);
        Dimension dimension2 = container.getSize();
        if (!this.mIgnoreResize && this.mLastSize.width >= 0) {
            dimension.width = dimension2.width - this.mLastSize.width;
            dimension.height = dimension2.height - this.mLastSize.height;
        }
        Insets insets = container.getInsets();
        Point point = new Point(insets.left - this.mLastInsets.left, insets.top - this.mLastInsets.top);
        dimension.width -= point.x + (this.mLastInsets.right - insets.right);
        dimension.height -= point.y + (this.mLastInsets.bottom - insets.bottom);
        this.mLastSize.width = dimension2.width;
        this.mLastSize.height = dimension2.height;
        this.mLastInsets.top = insets.top;
        this.mLastInsets.left = insets.left;
        this.mLastInsets.bottom = insets.bottom;
        this.mLastInsets.right = insets.right;
        Rectangle rectangle = new Rectangle();
        Enumeration enumeration = this.mBindingsHash.keys();
        while (enumeration.hasMoreElements()) {
            Component component = (Component)enumeration.nextElement();
            Binding binding = (Binding)this.mBindingsHash.get(component);
            Dimension dimension3 = component.getSize();
            if (dimension3.width == 0 && dimension3.height == 0) {
                dimension3 = component.getPreferredSize();
            }
            Point point2 = component.getLocation();
            point2.x += point.x;
            point2.y += point.y;
            if (binding.right) {
                if (binding.left) {
                    dimension3.width += dimension.width;
                } else {
                    point2.x += dimension.width;
                }
            }
            if (binding.bottom) {
                if (binding.top) {
                    dimension3.height += dimension.height;
                } else {
                    point2.y += dimension.height;
                }
            }
            rectangle.x = point2.x;
            rectangle.y = point2.y;
            rectangle.height = dimension3.height;
            rectangle.width = dimension3.width;
            component.setBounds(rectangle);
        }
    }
}

