/*-
 * Copyright (c) 2001, 2002, 2003, 2004 Lev Walkin <vlm@lionet.info>.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: ipcad.h,v 1.36 2004/03/11 07:24:03 vlm Exp $
 */
#ifndef	__IPCAD_H__
#define	__IPCAD_H__

#define	IPCAD_VERSION_STRING	"IP Accounting Daemon "		\
				"for BPF/PCAP/ULOG/NetFlow. "	\
				"ipcad Version " IPCAD_VERSION
#define	IPCAD_COPYRIGHT "Copyright (c) 2001, 2002, 2003, 2004 "	\
			"Lev Walkin <vlm@lionet.info>"

#include "headers.h"

typedef struct packet_source_s {

	enum {
		IFACE_UNKNOWN,
		IFACE_BPF,	/* Berkeley Packet Filter */
		IFACE_PCAP,	/* libpcap */
		IFACE_ULOG,	/* Linux iptables' ULOG */
	} iface_type;
		
	enum {
		PST_INVALID,	/* Not initialized */
		PST_EMBRYONIC,	/* Interface name is set */
		PST_READY,	/* Interface name is set */
	} state;

	/*
	 * Interface properties.
	 */
	char	ifName[IFNAMSIZ];
	int	ifIndex;	/* Assigned internal (SNMP) index */
	unsigned int dlt;	/* Data Link Type */
	char *custom_filter;	/* pcap filter */
	enum {
		IFLAG_NONE	= 0x00,
		IFLAG_INONLY	= 0x01,	/* Incoming only */
		IFLAG_PROMISC	= 0x02,	/* Enable promiscuous mode */
		IFLAG_NF_SAMPLED= 0x04,	/* Enable NetFlow sampling mode */
		IFLAG_NF_DISABLE= 0x08,	/* Disable NetFlow */
		IFLAG_RSH_EXTRA	= 0x10,	/* Enable RSH extra info */
		IFLAG_LARGE_CAP = 0x20,	/* Large capture length (BPF/PCAP) */
	} iflags;

	/*
	 * Declare source-dependent interface descriptors.
	 */
	
	union {
#ifdef	PSRC_bpf
    		struct {
			int 	fd;
			char 	*buf;
			size_t	bufsize;
		} bpf;
#endif	/* PSRC_bpf */
#ifdef	PSRC_pcap
		struct {
			pcap_t *dev;
			pthread_mutex_t dev_mutex;
		} pcap;
#endif	/* PSRC_pcap */
#ifdef  NETLINK_NFLOG
		struct {
			int 			fd;
			char 			*buf;
			size_t			bufsize;
			struct	sockaddr_nl	peer;
			u_int32_t 		groupmask;
		} ulog;
#endif  /* NETLINK_NFLOG */
	} iface;

	void    	*(*loop_ptr)(void *); /* pointer to loop function */
	void    	(*print_stats)(FILE *, struct packet_source_s *);

	/*
	 * Run-time variables.
	 */
	pthread_t 	thid;

	/*
	 * Statistics
	 */
	long long bytes_prev;    /* Bytes per previous second, estimated */
	long long bytes_cur;     /* Current bytecount */
	long long packets_prev;  /* Packets per previous second, est. */
	long long packets_cur;   /* Current packets count */

	long long bytes_lp;	/* Bytes per long period */
	long long bps_lp;	/* Bytes per second per long period */

	long long packets_lp;	/* Packets per long period */
	long long pps_lp;	/* Bytes per second per long period */

	double avg_period;	/* Averaging period, seconds */

	unsigned int sample_count;	/* NetFlow sampling-mode counter */

	/*
	 * Internal stuff.
	 */
	struct packet_source_s *next;
} packet_source_t;


#include "psrc-bpf.h"
#include "psrc-pcap.h"
#include "psrc-ulog.h"
#include "init-psrc.h"

/* Router to the specific packet source type */
int init_packet_source(packet_source_t *);
int init_packet_source_pcap(packet_source_t *);
int init_packet_source_bpf(packet_source_t *);
int init_packet_source_ulog(packet_source_t *, int configure_mode);

int reopen_packet_source_pcap(packet_source_t *psrc, int loop);

int process_packet_sources(packet_source_t *sources);

void process_packet_data(packet_source_t *ps,
	const unsigned char *packet, int caplen);

void *pps_loop(void *ps);

int if_stat(FILE *, char *iface);
void system_uptime(FILE *);	/* Print the uptime */

void usage();

int cfgread(const char *);

extern double self_started;

/* Hack against RedHat distribution */
#ifndef	SHUT_RDWR
#define	SHUT_RDWR	2
#endif

int ifst_preopen();	/* Pre-open files inaccessible after chroot() */

int display_internal_averages(FILE *, const char *ifname);

#endif	/* __IPCAD_H__ */
