/*-
 * Copyright (c) 2001 Lev Walkin <vlm@spelio.net.ru>.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: service.c,v 1.5 2001/04/19 12:33:06 vlm Exp $
 */

#include "ipcad.h"

void
clear_ip_accounting(struct ipstream *ips) {
        struct ipstream *nps;

        if(!ips)
                return;

        while(ips) {
                nps = ips->next;
                free(ips);
                ips = nps;
        };

}


int
try_lock(int fd, int wr) {
	int res = 0;

#ifdef	HAVE_FLOCK
	int times = 5;

	wr = (wr?LOCK_EX:LOCK_SH) | LOCK_NB;

	while( (res = flock(fd, wr)) && times ) {
		if(errno != EWOULDBLOCK)
			break;
		sleep(1);
		times--;
	}

#else	/* #ifdef HAVE_FLOCK */
#ifdef	HAVE_FCNTL
	int times = 5;
	struct flock fl;

	fl.l_start = 0;
	fl.l_len = 0;
	fl.l_pid = getpid();
	fl.l_type = (wr?F_WRLCK:F_RDLCK);
	fl.l_whence = SEEK_SET;

	while( (res = fcntl(fd, F_SETLK, fl)) && times ) {
		if(errno != EAGAIN)
			break;
		sleep(1);
		times--;
	};

#else	/* #ifdef HAVE_FCNTL */
	/* It is unknown how to lock on this system, forget about it */
#endif	/* #ifdef HAVE_FCNTL */
#endif	/* #ifdef HAVE_FLOCK */

	return res;

}



