/*-
 * Copyright (c) 2001 Lev Walkin <vlm@spelio.net.ru>.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: got.c,v 1.8 2001/05/24 05:17:36 vlm Exp $
 */

#include "ipcad.h"
#include "cfgvar.h"

struct ipstream *ipstream = NULL;
size_t ipstream_entries = 0;
time_t ipstream_time = 0;

int	top_active = 5;
time_t	remembered_time = 0;

/* size_t: We won't reach 4G replacements per second */
size_t replacements_requested = 0;
size_t replacements_made = 0;
size_t replacements_made_saved = 0;
size_t saved_top_direction = -1;

int
aggregate(unsigned long *srcp, unsigned long *dstp) {
	register struct atable *at;
	register unsigned long src = *srcp, dst = *dstp;
	register int did=0;

	for(at=atable; at; at=at->next) {
		if(!(did & 1) && ((src & at->mask.s_addr) == at->ip.s_addr)) {
			*srcp = src & at->strip.s_addr;
			if((did |= 1) == 3)
				return did;
		};

		if(!(did & 2) && ((dst & at->mask.s_addr) == at->ip.s_addr)) {
			*dstp = dst & at->strip.s_addr;
			if((did |= 2) == 3)
				return did;
		};
	};

	return did;
};

int
got_ipv4_packet(struct in_addr *srcp, struct in_addr *dstp, long long len) {
	struct ipstream *ips, *oips;
	size_t entr;
	unsigned long src, dst;
	register int tactive;

	src = srcp->s_addr;
	dst = dstp->s_addr;

	if(atable)
		aggregate(&src, &dst);

	for(oips = ips = ipstream, entr = 1;
	    ips; oips = ips, ips = ips->next, entr++) {

		/* Addresses not match */
		if(ips->src.s_addr != src || ips->dst.s_addr != dst)
			continue;

		ips->packets++;
		ips->bytes += len;

		/* Don't touch the first entry */
		if(entr == 1) return 0;

		/*
		** Move to the top for next time lookup speed-up.
		*/

		/* Remember top_active */
		tactive = top_active;

		if(entr >= tactive - 2)
			replacements_requested++;

		/* Ignore first TOP entries */
		if(entr <= tactive)
			return 0;

		/* Collapse entry */
		oips->next = ips->next;

		/* Move to the top */
		ips->next = ipstream;
		ipstream = ips;

		replacements_made++;

		return 0;
	};

	/* Memory restrictments */
	if(memsize && (ipstream_entries * sizeof(struct ipstream)) > memsize) {
		if(!ex_current_stalled)
			time(&ex_current_stalled);
		ex_current_packets++;
		ex_current_bytes += len;
		return -1;
	};

	ips = (struct ipstream *)calloc(1, sizeof(struct ipstream));
	if(!ips) {
		/* Indicate the time of first statistics loss */
		if(!ex_current_stalled)
			time(&ex_current_stalled);
		ex_current_packets++;
		ex_current_bytes += len;
		return -1;
	};

	ips->src.s_addr = src;
	ips->dst.s_addr = dst;
	ips->packets = 1;
	ips->bytes = len;

	/* Add to the top */
	ips->next = ipstream;
	ipstream = ips;

	ipstream_entries++;

	return 0;
};


