%{

#define	YYPARSE_PARAM	param

#include "headers.h"
#include "cfgvar.h"
#include "csparse.h"

int yylex();
int yyerror();

void *CS_scan_string(char *);

%}

/*
 * Token value definition
 */
%union {
	int tv_int;
	char *tv_char;
}

/*
 * Token types returned by scanner
 */
%token	<tv_char>	TOK_STRING

%token		ERROR
%token		C_DUMP
%token		C_IMPORT
%token		C_RESTORE
%token		C_IP
%token		C_ACCOUNTING
%token		C_SHOW
%token		C_CHECKPOINT
%token		C_CLEAR
%token		C_STAT
%token		C_HELP
%token		C_SHUTDOWN
%token		C_INTERFACE
%token		C_VERSION

%type	<tv_int>	block

%%

operation:
	block {
		return $1;
	};

block:
	C_HELP { $$ = CS_HELP; }

	| C_STAT { $$ = CS_STAT; }

	| C_DUMP { $$ = CS_DUMP; }
	| C_IMPORT { $$ = CS_IMPT; }
	| C_RESTORE { $$ = CS_REST; }
	| C_SHUTDOWN { $$ = CS_SHUT; }
	| C_DUMP TOK_STRING { $$ = CS_DUMP; *(char **)param = $2; }
	| C_IMPORT TOK_STRING { $$ = CS_IMPT; *(char **)param = $2; }
	| C_RESTORE TOK_STRING { $$ = CS_REST; *(char **)param = $2; }

	| C_SHOW C_VERSION { $$ = CS_SVER; }
	| C_SHOW C_IP C_ACCOUNTING { $$ = CS_SIA; }
	| C_SHOW C_IP C_ACCOUNTING C_CHECKPOINT { $$ = CS_SIAC; }
	| C_SHOW C_INTERFACE TOK_STRING { $$ = CS_SIN; *(char **)param = $3; }

	| C_CLEAR C_IP C_ACCOUNTING { $$ = CS_CIA; }
	| C_CLEAR C_IP C_ACCOUNTING C_CHECKPOINT { $$ = CS_CIAC; }
	;

%%

int
yyerror(char *s) {
	(void)s;

	return 0;
};


