/*-
 * Copyright (c) 2001 Lev Walkin <vlm@spelio.net.ru>.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: cfgvar.c,v 1.11 2001/05/23 12:42:44 vlm Exp $
 */

#include "ipcad.h"
#include "sf_lite.h"
#include "cfgvar.h"

char *cfg_dump_file = NULL;

char *chroot_to = NULL;

size_t memsize = 0;

size_t ex_current_packets = 0;
size_t ex_current_bytes = 0;
time_t ex_current_stalled = 0;

size_t ex_checkpoint_packets = 0;
size_t ex_checkpoint_bytes = 0;
time_t ex_checkpoint_stalled = 0;

packet_source *packet_sources_head = NULL;

int
cfg_add_iface(char *iface, int iflags) {
	packet_source *pss;

	fprintf(stderr, "Opening %s... ", iface);

	pss = init_packet_source(iface, iflags);
	if(!pss) {
		perror("Can't initialize");
		exit(EX_NOINPUT);
	};

	pss->next = packet_sources_head;
	packet_sources_head = pss;

	fprintf(stderr, "Initialized\n");

	return 0;
};


struct rsh_entries {
	char *username;
	unsigned int addr;
	int privlevel;
	struct rsh_entries *next;
};

static struct rsh_entries *rshes = NULL;

int
cfg_add_rsh_host(char *ru, char *rh, int privlevel) {
	unsigned int ia;
	struct rsh_entries *res;
	
	if(!ru || !rh) {
		fprintf(stderr, "Invalid [user@]host_addr specification: %s\n", rh);
		exit(EX_DATAERR);
	};

	if( sf_iaton(rh, &ia) == -1 ) {
		perror("host_addr:");
		fprintf(stderr, "Invalid [user@]host_addr specification: %s", rh);
		exit(EX_DATAERR);
	};

	if((res = rshes)) {
		while(res->next) res = res->next;
		res = res->next = (struct rsh_entries *)malloc(sizeof(*res));
	} else {
		res = rshes = (struct rsh_entries *)malloc(sizeof(*res));
	};

	if(!res) {
		fprintf(stderr, "Memory allocation failed.\n");
		exit(EX_OSERR);
	};

	res->username = strdup(ru);
	res->addr = ia;
	res->privlevel = privlevel;
	res->next = NULL;

	if(!res->username) {
		fprintf(stderr, "Memory allocation failed.\n");
		exit(EX_OSERR);
	};

	return 0;
};

/* 0: None, 1: view only, 2: default, 3: admin  */
int
cfg_check_rsh(char *ru, struct in_addr *ia) {
	struct rsh_entries *res;

	if(!rshes)	/* Allow world readable mode if no rules defined. */
		return 1;

	for(res = rshes; res; res=res->next) {
		if(res->addr != ia->s_addr)
			continue;
		if(!*res->username)
			return res->privlevel;
		if(strcmp(res->username, ru) == 0)
			return res->privlevel;
	};

	return 0;
};

struct atable *atable = NULL;

int
cfg_add_atable2(unsigned int ip, unsigned int mask, unsigned int strip) {
	struct atable *at;

	if(!(at = atable)) {
		at = atable = (struct atable *)malloc(sizeof(struct atable));
	} else {
		while(at->next) at=at->next;
		at = at->next = (struct atable *)malloc(sizeof(struct atable));
	};

	at->ip.s_addr = ip;
	at->mask.s_addr = mask;
	at->strip.s_addr = strip;
	at->next = NULL;
	printf("Aggregate network ");
	print_ip(stdout, at->ip);
	printf("/");
	print_ip(stdout, at->mask);
	printf(" -> ");
	print_ip(stdout, at->strip);
	printf("\n");

	return 0;
};

int
cfg_add_atable(char *sip, char *smask, char *sstrip) {
	unsigned int ip;
	unsigned int mask;
	unsigned int strip;
	unsigned long t;

	t = strchr(sstrip, '.')?1:0;
	if(t && !sf_iaton(sstrip, &strip)) return -1;
	if(!t) {
		errno=0;
		t = strtoul(sstrip, NULL, 10);
		if((t > 32) || errno) return -1;
		if(!t) strip = 0;
		else strip = htonl(0xffffffff << (32 - t));
	};

	if(!sf_iaton(sip, &ip))
		return -1;

	t = strchr(smask, '.')?1:0;
	if(t && !sf_iaton(smask, &mask)) return -1;
	if(!t) {
		errno=0;
		t = strtoul(smask, NULL, 10);
		if((t > 32) || errno) return -1;
		if(!t) mask = 0;
		else mask = htonl(0xffffffff << (32 - t));
	};

	return cfg_add_atable2(ip, mask, strip);
};



