/*-
 * Copyright (c) 2001 Lev Walkin <vlm@spelio.net.ru>.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: capstat-pcap.c,v 1.2 2001/05/24 03:42:06 vlm Exp $
 */

#include "ipcad.h"
#include "cfgvar.h"
#include "got.h"
#include "opt.h"

void
display_capture_stats(FILE *f) {
	packet_source *ps;

	struct pcap_stat pstat;

	for(ps = packet_sources_head; ps; ps = ps->next) {
		if(pcap_stats(ps->dev, &pstat))
			continue;

		fprintf(f, "Interface %s: received %u",
			ps->ifname, pstat.ps_recv);

		fprintf(f, ", %lu m average %lu bytes/sec, %lu pkts/sec",
			ps->period / 60000,
			ps->bps_lp,
			ps->pps_lp
		);

		if(pstat.ps_ifdrop)
			fprintf(f, ", dropped %u", pstat.ps_drop);

		fprintf(f, "\n");
	}

}
