<?php
/*
 * $Horde: imp/redirect.php,v 1.23.2.8 2002/04/12 16:57:52 jan Exp $
 *
 * Copyright 1999-2002 Charles J. Hagenbuch <chuck@horde.org>
 * Copyright 1999-2002 Jon Parise <jon@horde.org>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

define('IMP_BASE', dirname(__FILE__));
require_once IMP_BASE . '/lib/base.php';

if (Horde::getFormData('action') == 'compose') {
    $actionID = LOGIN_COMPOSE;
} else {
    $actionID = Horde::getFormData('actionID', IMP_LOGIN);
}

$imapuser = Horde::getFormData('imapuser');
$pass = Horde::getFormData('pass');

/* If we already have a session... */
if (isset($HTTP_SESSION_VARS['imp']) && is_array($HTTP_SESSION_VARS['imp'])) {
    /* Make sure that if a username was specified, it is the current username */
    if ((is_null($imapuser) || $imapuser == $HTTP_SESSION_VARS['imp']['user']) &&
        (is_null($pass) || $pass == Secret::read(Secret::getKey('imp'), $HTTP_SESSION_VARS['imp']['pass']))) {

        $imp = &$HTTP_SESSION_VARS['imp'];
        if (!empty($HTTP_SESSION_VARS['imp']['_login'])) {
            IMP::authenticate(OP_HALFOPEN);
            IMP::loginTasks();
        }

        if ($actionID == IMP_LOGIN) {
            $actionID = null;
        }
        $url = $prefs->getValue('initial_page');
        if ($url != 'folders.php') {
            $url  = 'mailbox.php?actionID=' . $actionID . '&mailbox=' . urlencode(IMP::addPreambleString($url));
            $url .= '&' . IMP::getComposeArgs();
        }
        header('Location: ' . Horde::applicationUrl($url, true));
        exit;
    } else {
        /* Disable the old session. */
        $imp = false;
        session_unregister('imp');
        header('Location: ' . Horde::applicationUrl(IMP::logoutUrl('login.php', 'failed'), true));
        exit;
    }
}

/* Create a new session if we're given the proper parameters. */
if (!is_null($imapuser) && !is_null($pass)) {
    if (!Horde::getFormData('mailbox')) {
        $HTTP_POST_VARS['mailbox'] = 'INBOX';
    }
    if (($reason = IMP::createSession()) === true) {
        $imp['_login'] = true;
        $entry = sprintf('Login success for %s [%s] to {%s:%s}',
                         $imp['uniquser'], $HTTP_SERVER_VARS['REMOTE_ADDR'], $imp['server'], $imp['port']);
        Horde::logMessage($entry, __FILE__, __LINE__, LOG_NOTICE);

        $horde_language = Horde::getFormData('new_lang');
        if (!empty($horde_language)) {
            session_register('horde_language');
            $HTTP_SESSION_VARS['horde_language'] = $horde_language;
        }

        IMP::loginTasks();

        if (Horde::getFormData('url')) {
            header('Location: ' . Horde::getFormData('url'));
            exit;
        }

        $url = $prefs->getValue('initial_page');
        if ($url != 'folders.php') {
            $url = 'mailbox.php?actionID=' . $actionID . '&mailbox=' . urlencode(IMP::addPreambleString($url));
            $url .= '&' . IMP::getComposeArgs();
        }
        header('Location: ' . Horde::applicationUrl($url, true));
        exit;
    } else {
        header('Location: ' . Horde::applicationUrl(IMP::logoutUrl('login.php', $reason), true));
        exit;
    }
}

/* No session, and no login attempt. Just go to the login page. */
$uri = 'login.php';
if (!empty($HTTP_SERVER_VARS['QUERY_STRING'])) {
    $uri .= '?' . $HTTP_SERVER_VARS['QUERY_STRING'];
}
header('Location: ' . Horde::applicationUrl($uri, true));
exit;

?>
