<?php
/*
 * $Horde: imp/message.php,v 2.257.2.25 2002/06/10 21:55:40 jan Exp $
 *
 * Copyright 1999-2002 Charles J. Hagenbuch <chuck@horde.org>
 * Copyright 1999-2002 Jon Parise <jon@horde.org>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

define('IMP_BASE', dirname(__FILE__));
require_once IMP_BASE . '/lib/base.php';
require_once IMP_BASE . '/lib/Message.php';
require_once HORDE_BASE . '/lib/MIME.php';
require_once HORDE_BASE . '/lib/MIME/Structure.php';
require_once HORDE_BASE . '/lib/MIME/Part.php';
require_once HORDE_BASE . '/lib/MIME/Viewer.php';
require_once HORDE_BASE . '/config/mime_drivers.php';
require_once HORDE_BASE . '/config/mime_mapping.php';
require_once IMP_BASE . '/config/mime_drivers.php';
require_once IMP_BASE . '/lib/Identity/IMP.php';

/**
 * Builds a string containing a list of addresses.  Each address is a link
 * to the compose function.
 *
 * @param $array            Array of address objects.
 *
 * @return  string          String containing the formatted address list.
 */
function buildAddressLinks($array)
{
    global $registry, $prefs, $index, $array_index;

    $ret = '';

    foreach ($array as $ob) {
        /* Ensure we're working with initialized values. */
        $ob->personal = isset($ob->personal) ? MIME::decode($ob->personal) : '';
        if (!isset($ob->mailbox)) $ob->mailbox = '';
        if (!isset($ob->host)) $ob->host = '';

        /* Get full address ($addr) and the trimmed, bare address ($inner). */
        $addr = IMP::addrObject2String($ob, 'undisclosed-recipients@');
        $inner = Mime::trimEmailAddress(imap_rfc822_write_address($ob->mailbox,
                    $ob->host, ''));

        /* Separate multiple addresses with a comma. */
        if (!empty($ret)) $ret .= ', ';

        if (!empty($addr) && !empty($inner)) {
            $ret .= Horde::link(IMP::composeLink(array('to' => $addr)), sprintf(_("Compose Message (%s)"), $inner));
            $ret .= htmlspecialchars($addr) . '</a>';

            /* Append the add address icon to every address if contact manager is available. */
            if ($registry->hasMethod('contacts/add') && $prefs->getValue('add_source') != "") {
                $ret .= Horde::link(Horde::url("message.php?actionID=" . ADD_ADDRESS . "&name=" . urlencode($ob->personal) . "&address=" . urlencode($inner) . "&index=" . $index . "&array_index=" . $array_index), sprintf(_("Add to Addressbook (%s)"), $inner));
                $ret .= Horde::img('addressbook-blue.gif', 'hspace="2"') . '</a>';
            }
        }
    }

    /*
     * If we're left with an empty address list ($ret), inform the user that
     * the recipient list is purposely "undisclosed".
     */
    if (empty($ret)) {
        $ret = _("Undisclosed Recipients");
    }

    return $ret;
}

/**
 * Given two alternative parts, determine which one should be
 * displayed.
 *
 * Return true if $a is preferred to $b
 */
function selectAlternativePart($a, $b)
{
    // Prefer a richer type than text.
    return ($b->type == TYPETEXT && canDisplayInline($a));
}

/**
 * Return true if the encoding is 7bit, 8bit, qprint, or base64.
 */
function isValidEncoding($encoding)
{
    return ($encoding == ENC7BIT ||
            $encoding == ENC8BIT ||
            $encoding == ENCQUOTEDPRINTABLE ||
            $encoding == ENCBINARY ||
            $encoding == ENCBASE64);
}

/**
 * Determine if we can (and know how to) inline a mime part.
 */
function canDisplayInline(&$mime)
{
    /* Attach a mime_viewer object to this MIME entry */
    IMP::resolveMimeViewer($mime);

    /* Check to see if the MIME headers allow it to be inlined */
    if ((!$mime->header) &&
        ($mime->disposition == 'inline') &&
        isValidEncoding($mime->encoding)) {

        /* If the driver allows inline displaying of this type, then
         * return success */
        if (isset($mime->viewer->conf['inline']) && $mime->viewer->conf['inline']) {
            return true;
        }
    }

    /* This MIME type cannot be displayed inline */
    return false;
}

/**
 * Build the body of a message from a given part.
 */
function buildMessageBody(&$mime, $attachments)
{
    if (isset($mime->viewer)) {
        $mime->part->setContents(IMP::getDecodedPart($mime));
        return $mime->viewer->render($mime);
    } else {
        return false;
    }
}

function buildMessage($attachments, $msg)
{
    global $inline_parts, $atc, $index;

    // displayParts contains the parts that we should display, after filtering out alternative parts
    $displayParts = array();

    // determine which is the alternative parts to show
    foreach ($attachments as $ref => $mime) {
        if (!isset($displayParts[$mime->alternative]) || selectAlternativePart($mime, $displayParts[$mime->alternative])) {
            $displayParts[!empty($mime->alternative) ? $mime->alternative : $ref] = $mime;
        }
    }

    // now display the parts
    foreach ($displayParts as $ref => $mime) {
        if (!$mime->header) {
            if (canDisplayInline($mime)) {
                $body = buildMessageBody($mime, $attachments);
                if ($inline_parts > 0) {
                    $msg .= '</td></tr><tr><td align="left"><br /><table border="0">' . IMP::partSummary($mime, $index) . '</table></td></tr><tr><td class="text" align="left">' . $body;
                } elseif (!($mime->type == TYPETEXT && $mime->subtype == 'plain')) {
                    $msg = '<tr><td align="left"><table border="0">' . IMP::partSummary($mime, $index) . '</table></td></tr><tr><td class="text" align="left">' . $body;
                } else {
                    $msg = '<tr><td class="text" align="left">' . $body;
                }
                $inline_parts++;
            } else {
                // Not displaying inline; add to the attachments list.
                $atc .= IMP::partSummary($mime, $index);
            }
        }
    }
    return $msg;
}

if (($reason = IMP::authenticate(null, true)) !== true) {
    header('Location: ' . Horde::applicationUrl(IMP::logoutUrl('login.php?url=' . Horde::selfUrl(), $reason), true));
    exit;
}

$index = Horde::getFormData('index');
$sorted = explode(':', $imp['msgl']);
$indices = array_flip($sorted);
if (is_null($index) || !isset($indices[$index])) {
    header('Location: ' . Horde::applicationUrl('mailbox.php?actionID=' . MESSAGE_MISSING, true));
    exit;
}
$array_index = $indices[$index];
$actionID = Horde::getFormData('actionID', NO_ACTION);

/* Update uidvalidity. */
$status = imap_status($imp['stream'], IMP::serverString() . $imp['mailbox'], SA_UIDVALIDITY);
$uidsvalid = true;
if (empty($imp['uidvalidity']) || $imp['uidvalidity'] != $status->uidvalidity) {
    $uidsvalid = false;
    $imp['uidvalidity'] = $status->uidvalidity;
}

if ($imp['mailbox'] != '**search') {
    if (!$uidsvalid ||
        $array_index == count($sorted) - 1 ||
        $array_index == 0 ||
        (($actionID == DELETE_MESSAGES || $actionID == MOVE_MESSAGES || $actionID == COPY_MESSAGES) &&
         ($array_index == count($sorted) - 2))) {

        if ($prefs->getValue('sortby') != SORTTHREAD) {
            if ($prefs->getValue('delhide')) {
                $sorted = imap_sort($imp['stream'], $prefs->getValue('sortby'),
                                    $prefs->getValue('sortdir'), SE_UID, 'UNDELETED');
            } else {
                $sorted = imap_sort($imp['stream'], $prefs->getValue('sortby'),
                                    $prefs->getValue('sortdir'), SE_UID);
            }
        } else {
            IMP_Message::threadSort();
        }

        $sorted = IMP_Message::range($sorted, $array_index + $imp['offset'] + 1,
                                     $imp['offset'], $array_index, $imp['msgcount']);
        $imp['msgl'] = implode(':', $sorted);
        $sorted = explode(':', $imp['msgl']);
        $indices = array_flip($sorted);
        $array_index = $indices[$index];
    }
}

/* Are we using printer-friendly formatting? */
$printer_friendly = false;

/* Set the current time zone. */
if ($prefs->getValue('timezone') != '') {
    putenv('TZ=' . $prefs->getValue('timezone'));
}

/* Initialize the user's identities */
$user_identity = new Identity_IMP();

/* Run through action handlers */
switch ($actionID) {
 case NO_ACTION:
     break;

 case IMP_BLACKLIST:
     $filters = @unserialize($prefs->getValue('filters'));
     $h = @imap_header($imp['stream'], imap_msgno($imp['stream'], $index));
     if (isset($h->from[0])) {
         $ob = $h->from[0];
         $addr = Mime::trimEmailAddress(imap_rfc822_write_address($ob->mailbox, $ob->host, ''));
         $filters[] = array('fields' => array('from'), 'text' => trim($addr), 'action' => 'delete');
     }
     $prefs->setValue('filters', serialize($filters));
     $prefs->store();
     header('Location: ' . Horde::applicationUrl('filters.php'));
     break;

 case PRINT_MESSAGE:
     $printer_friendly = true;
     break;

 case UNDELETE_MESSAGES:
     IMP_Message::undelete($index);
     $array_index++;
     $index = $sorted[$array_index];
     break;

 case DELETE_MESSAGES:
     if (!IMP_Message::delete($index)) {
         $array_index++;
         $index = $sorted[$array_index];
     } else {
         if ($prefs->getValue('use_trash')) {
             /* Nuke the message we've just deleted from the
                message array. */
             $sorted = array_merge(array_slice($sorted, 0, $array_index),
                                   array_slice($sorted, $array_index + 1));
             $imp['msgl'] = implode(':', $sorted);
             $imp['msgcount']--;
             $index = $sorted[$array_index];
         } elseif (strstr($imp['protocol'], 'pop3')) {
             /* IMP_Message::delete() takes care of expunging the
                mailbox to make the delete stick; now we just need
                to recalculate the message list. */
             if ($prefs->getValue('sortby') != SORTTHREAD) {
                 $sorted = imap_sort($imp['stream'], $prefs->getValue('sortby'), $prefs->getValue('sortdir'), SE_UID);
             } else {
                 IMP_Message::threadSort();
             }
             $sorted = IMP_Message::range($sorted, $array_index + $imp['offset'] + 1,
                                          $imp['offset'], $array_index, $imp['msgcount']);
             $imp['msgl'] = implode(':', $sorted);
             $index = $sorted[$array_index];
         } elseif ($prefs->getValue('delhide')) {
             if ($prefs->getValue('sortby') != SORTTHREAD) {
                 $sorted = imap_sort($imp['stream'], $prefs->getValue('sortby'),
                                     $prefs->getValue('sortdir'), SE_UID, 'UNDELETED');
             } else {
                 IMP_Message::threadSort();
             }
             $sorted = IMP_Message::range($sorted, $array_index + $imp['offset'] + 1,
                                          $imp['offset'], $array_index, $imp['msgcount']);
             $imp['msgl'] = implode(':', $sorted);
             $index = $sorted[$array_index];
         } else {
             $array_index++;
             $index = $sorted[$array_index];
         }
     }
     if ($prefs->getValue('mailbox_return')) {
         header('Location: ' . Horde::applicationUrl('mailbox.php?start=' . ($array_index + $imp['offset'] + 1), true));
         exit;
     }
     break;

 case MOVE_MESSAGES:
 case COPY_MESSAGES:
     if (!empty($HTTP_GET_VARS['targetMbox'])) {
         IMP_Message::copy(Horde::getFormData('targetMbox'), array($index), $actionID);
         if ($actionID == MOVE_MESSAGES && $prefs->getValue('delhide')) {
             if ($prefs->getValue('sortby') != SORTTHREAD) {
                 $sorted = imap_sort($imp['stream'], $prefs->getValue('sortby'),
                                     $prefs->getValue('sortdir'), SE_UID, 'UNDELETED');
             } else {
                 IMP_Message::threadSort();
             }
             $sorted = IMP_Message::range($sorted, $array_index + $imp['offset'] + 1,
                                          $imp['offset'], $array_index, $imp['msgcount']);
             $imp['msgl'] = implode(':', $sorted);
             $index = $sorted[$array_index];
         } elseif ($actionID == MOVE_MESSAGES && $prefs->getValue('use_trash')) {
             $sorted = array_merge(array_slice($sorted, 0, $array_index),
                                   array_slice($sorted, $array_index + 1));
             $imp['msgl'] = implode(':', $sorted);
             $imp['msgcount']--;
             $index = $sorted[$array_index];
         } else {
             $array_index++;
             $index = $sorted[$array_index];
         }
     }
     if ($prefs->getValue('mailbox_return')) {
         header('Location: ' . Horde::applicationUrl('mailbox.php?start=' . ($array_index + $imp['offset'] + 1), true));
         exit;
     }
     break;

 case SPAM_REPORT:
     /* Abort immediately if spam reporting has not been enabled. */
     if (!$conf['spam']['reporting']) {
         break;
     }

     /* Fetch the raw message contents (headers and first 10k of body). */
     $raw_msg = imap_fetchheader($imp['stream'], $index, FT_UID) . "\n" .
         substr(imap_body($imp['stream'], $index, FT_UID), 0, 10240);

     /* Build the MIME structure. */
     include_once HORDE_BASE . '/lib/MIME/Message.php';
     include_once HORDE_BASE . '/lib/MIME/Part.php';

     $mime = new MIME_Message($raw_msg);
     $body = new MIME_Part('text/plain', $raw_msg);
     $mime->addPart($body);
     $msg = $mime->toString();

     $headers['Message-ID'] = '<' . uniqid(time() . '.') . '@' . $HTTP_SERVER_VARS['SERVER_NAME'] . '>';
     $headers['Date'] = date('r');
     $headers['To'] = $conf['spam']['email'];
     $headers['From'] = $user_identity->getFromLine();
     $recipients = $conf['spam']['email'];
     $headers['Subject'] = _("Spam Report from") . ' ' . $imp['user'];
     $headers = $mime->header($headers);
     IMP::addSiteHeaders($headers);

     include_once 'Mail.php';
     if (!empty($imp['smtphost'])) {
         $conf['mailer']['params']['host'] = $imp['smtphost'];
     }
     $mailer = &Mail::factory($conf['mailer']['type'], $conf['mailer']['params']);
     $mailer->send($recipients, $headers, $msg);

     Horde::raiseMessage(_("This message has been reported as spam to your system administrator."), HORDE_MESSAGE);
     break;

 case ADD_ADDRESS:
     $newAddress = Horde::getFormData('address');
     $newName = Horde::getFormData('name');
     if (empty($newName)) {
         $newName = $newAddress;
     }

     $res = $registry->call('contacts/add', array($newName, $newAddress, $prefs->getValue('add_source')));
     if (PEAR::isError($res)) {
         Horde::raiseMessage($res->getMessage(), $res->getCode());
     } elseif (!$res) {
         Horde::raiseMessage(_("An unknown error occured adding the new entry."), HORDE_ERROR);
     } else {
         Horde::raiseMessage(sprintf(_("Entry \"%s\" was successfully added to the addressbook"), $newName), HORDE_SUCCESS);
     }
     break;
}

if ($conf['user']['allow_folders']) {
    $options = IMP::flistSelect(_("This message to"), true, array($imp['mailbox']));
}

/* If we grab the headers before grabbing body parts, we'll see when a message is unread */
$h = @imap_header($imp['stream'], imap_msgno($imp['stream'], $index));

/* parse MIME info */
if ($structure = @imap_fetchstructure($imp['stream'], $index, FT_UID)) {
    $bodypart = 1;
    $inline_parts = 0;
    $atc = '';
    $msg = '&nbsp;';
    $attachments = MIME_Structure::parse($structure, $index, $MimeID);
    $msg = buildMessage($attachments, $msg);
    if ($msg == '&nbsp;') {
        $msg = '<tr><td class="text">' . $msg;
    }
} else {
    header('Location: ' . Horde::applicationUrl('mailbox.php?actionID=' . MESSAGE_MISSING, true));
    exit;
}

if ($conf['compress_pages'] && (!$printer_friendly || !$browser->isBrowser('mozilla'))) {
    ob_start('ob_gzhandler');
}

if (isset($h->date))     $dat = htmlspecialchars(MIME::decode($h->date));
if (isset($h->to))       $to  = buildAddressLinks($h->to);
if (isset($h->from))     $frm = buildAddressLinks($h->from);
if (isset($h->cc))       $cc  = buildAddressLinks($h->cc);
if (isset($h->bcc))      $bcc = buildAddressLinks($h->bcc);
if (isset($h->reply_to)) $rep = buildAddressLinks($h->reply_to);

if ((isset($h->subject)) && (strlen($h->subject) != 0)) {
    $sub = MIME::decode($h->subject);

    /* filter the subject text, if requested */
    if ($prefs->getValue('filtering')) {
        include_once HORDE_BASE . '/lib/Text.php';
        $sub = Text::filter($sub, $conf['msg']['filtering']['words'],
                            $conf['msg']['filtering']['replacement']);
    }

    if (strlen($sub) > $conf['mailbox']['max_subj_chars']) {
        $shortsub = substr($sub, 0, $conf['mailbox']['max_subj_chars']) . '...';
    } else {
        $shortsub = $sub;
    }
    $sub = htmlspecialchars($sub);
    $shortsub = htmlspecialchars($shortsub);
} else {
    $sub = $shortsub = _("[No Subject]");
}

/* Set the status information of the message */
$msgindex = $array_index + $imp['offset'] + 1;
$status = '';
$identity = null;
if (!strstr($imp['protocol'], 'pop3')) {
    if (!empty($h->toaddress)) {
        $head_addresses = $h->toaddress;
        if (!empty($h->ccaddress)) {
            $head_addresses .= $h->ccaddress;
        }
        if (!empty($h->bccaddress)) {
            $head_addresses .= $h->bccaddress;
        }
        $addresses = $user_identity->getAllFromAddresses();

        $default = $user_identity->getDefault();
        if (isset($addresses[$default]) && strstr(strtolower($head_addresses), strtolower($addresses[$default]))) {
            $status .= $conf['mailbox']['personal_flag'];
            $identity = $default;
        } else {
            unset($addresses[$default]);
            foreach ($addresses as $id => $address) {
                if (strstr(strtolower($head_addresses), strtolower($address))) {
                    $status .= $conf['mailbox']['personal_flag'];
                    $identity = $id;
                    break;
                }
            }
        }
    }
    if ($h->Unseen == 'U' || $h->Recent == 'N') $status .= $conf['mailbox']['unseen_flag'];
    if ($h->Answered == 'A') $status .= $conf['mailbox']['answered_flag'];
    if (isset($h->Draft) && $h->Draft == 'X') $status .= $conf['mailbox']['draft_flag'];
    if ($h->Flagged == 'F') $status .= $conf['mailbox']['important_flag'];
    if ($h->Deleted == 'D') {
        $status .= $conf['mailbox']['deleted_flag'];
    }
}

$title = $imp['label'] . ": $sub";
$js_onLoad = null;
require IMP_TEMPLATES . '/common-header.inc';

if (!$printer_friendly) {
    include IMP_BASE . '/menu.php';
    include IMP_BASE . '/status.php';
}

if (!empty($conf['hooks']['quota']) && function_exists($conf['hooks']['quota'])) {
    echo call_user_func($conf['hooks']['quota'], $imp);
}

$prev_index = $array_index - 1;
$next_index = $array_index + 1;
if ($array_index != 0) {
    if ($imp['mailbox'] == '**search') {
        $tmp = explode(':', $imp['messagefolders']);
        $prev_link = Horde::url('message.php?index=' . $sorted[$prev_index] . '&thismailbox=' . $tmp[$prev_index]);
    } else {
        $prev_link = Horde::url('message.php?index=' . $sorted[$prev_index]);
    }
}
if ($array_index != count($sorted) - 1) {
    if ($imp['mailbox'] == '**search') {
        $tmp = explode(':', $imp['messagefolders']);
        $next_link = Horde::url('message.php?index=' . $sorted[$next_index] . '&thismailbox=' . $tmp[$next_index]);
    } else {
        $next_link = Horde::url('message.php?index=' . $sorted[$next_index]);
    }
}
$mailbox_link = Horde::url('mailbox.php?start=' . $msgindex);

if (($array_index + 1) != count($sorted)) {
    $form_target = 'message.php';
    $form_ident  = 'index';
    $form_method = 'get';
} else {
    $form_target = 'mailbox.php';
    $form_ident  = 'indices';
    $form_method = 'post';
}

if ($imp['mailbox'] == '**search') {
    $form_index = $index . ':' . Horde::getFormData('thismailbox');
} else {
    $form_index = $index;
}

$delete_warning = '';
if (strstr($imp['protocol'], 'pop3')) {
    $delete_warning = "return window.confirm('" . addslashes(_("Are you sure you wish to PERMANENTLY delete these messages?")) . "');";
}

if (!$printer_friendly) {
    if ($browser->hasFeature('javascript')) {
        include IMP_TEMPLATES . '/javascript/open_print_win.js';
    }
    include IMP_TEMPLATES . '/message/navbar_aux_top.inc';
    include IMP_TEMPLATES . '/message/navbar.inc';
}
require IMP_TEMPLATES . '/message/headers.inc';
require IMP_TEMPLATES . '/message/message.inc';
if (!$printer_friendly) {
    include IMP_TEMPLATES . '/message/navbar.inc';
    include IMP_TEMPLATES . '/message/navbar_aux_bottom.inc';
}
if ($browser->hasFeature('javascript')) {
    require IMP_TEMPLATES . '/message/javascript.inc';
    if ($printer_friendly) {
        require IMP_TEMPLATES . '/message/print.inc';
    }
}

$registry->shutdown();

require IMP_TEMPLATES . '/common-footer.inc';

$prefs->store();

// catch error messages from c-client
imap_errors();

?>
