<?php
// $Horde: imp/lib/base.php,v 1.24.2.3 2002/04/12 16:57:55 jan Exp $

/*
 * IMP base inclusion file.
 *
 * This file brings in all of the dependencies that every IMP script
 * will need, and sets up objects that all scripts use.
 */

// Find the base file path of Horde
@define('HORDE_BASE', dirname(__FILE__) . '/../..');

// Find the base file path of IMP
@define('IMP_BASE', dirname(__FILE__) . '/..');

// Browser detection library
require_once HORDE_BASE . '/lib/Browser.php';
$browser = new Browser();
if (isset($session_control)) {
    switch ($session_control) {
    case 'netscape':
        if ($browser->isBrowser('mozilla')) {
            session_cache_limiter('private, must-revalidate');
        }
        break;

    case 'cache_ssl_downloads':
        header('Vary: User-Agent');
        if ($browser->hasQuirk('cache_ssl_downloads')) {
            session_cache_limiter('private, must-revalidate');
        }
        break;
    }
}

// Registry
require_once HORDE_BASE . '/lib/Registry.php';
$registry = &Registry::singleton();
$registry->pushApp('imp');
$conf = &$GLOBALS['conf'];
@define('IMP_TEMPLATES', $registry->getParam('templates'));

// set error reporting according to config settings
error_reporting($conf['debug_level']);

// set max execution time according to config settings
set_time_limit($conf['max_exec_time']);

// set the umask according to config settings
if (isset($conf['umask'])) {
    umask($conf['umask']);
}

// Horde base libraries
require_once HORDE_BASE . '/lib/Horde.php';
require_once HORDE_BASE . '/lib/Auth.php';
require_once HORDE_BASE . '/lib/Secret.php';

// IMP base library
require_once IMP_BASE . '/lib/IMP.php';

// Help
require_once HORDE_BASE . '/lib/Help.php';

// If IMP isn't responsible for Horde auth, and no one is logged into
// Horde, redirect to the login screen.
if (!(Auth::getAuth() || $registry->getMethod('auth/login') == 'imp')) {
    header('Location: ' . Horde::url($registry->getParam('webroot', 'horde') . '/login.php?url=' . urlencode(Horde::selfUrl()), true));
    echo "\n";
    exit;
}

?>
