<?php
/*
 * $Horde: imp/status.php,v 2.6.2.1 2002/01/02 17:05:34 jan Exp $
 *
 * Copyright 1999-2002 Charles J. Hagenbuch <chuck@horde.org>
 * Copyright 1999-2002 Jon Parise <jon@horde.org>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

if (isset($imp['stream'])) {
    $alerts = imap_alerts();
    if (is_array($alerts)) {
        foreach ($alerts as $alert) {
            Horde::raiseMessage($alert, HORDE_MESSAGE);
        }
    }
}

if (isset($hordeMessageStack) && is_array($hordeMessageStack)) {
    echo '<table width="100%" border="0" cellpadding="0" cellspacing="0"><tr><td class="item"><table border="0" cellspacing="2" cellpadding="2" width="100%">';
    foreach ($hordeMessageStack as $message) {
        switch ($message['type']) {
        case HORDE_ERROR:
            echo '<tr><td class="control">' . Horde::img('alerts/error.gif', 'alt="' . _("Error") . '"', $registry->getGraphicsPath("horde")) . '&nbsp;&nbsp;<b>' . $message['message'] . '</b></td></tr>';
            break;
            
        case HORDE_SUCCESS:
            echo '<tr><td class="control">' . Horde::img('alerts/success.gif', 'alt="' . _("Success") . '"', $registry->getGraphicsPath("horde")) . '&nbsp;&nbsp;<b>' . $message['message'] . '</b></td></tr>';
            break;
            
        case HORDE_WARNING:
            echo '<tr><td class="control">' . Horde::img('alerts/warning.gif', 'alt="' . _("Warning") . '"', $registry->getGraphicsPath("horde")) . '&nbsp;&nbsp;<b>' . $message['message'] . '</b></td></tr>';
            break;
            
        case HORDE_MESSAGE:
        default:
            echo '<tr><td class="control">' . Horde::img('alerts/message.gif', 'alt="' . _("Message") . '"', $registry->getGraphicsPath("horde")) . '&nbsp;&nbsp;<b>' . $message['message'] . '</b></td></tr>';
            break;
            
        }
    }
    echo '</table></td></tr></table><br />';
}
?>
