<?php
/*
 * $Horde: imp/search.php,v 2.71.2.2 2002/01/02 17:05:33 jan Exp $
 *
 * Copyright 1999-2002 Charles J. Hagenbuch <chuck@horde.org>
 * Copyright 1999-2002 Jon Parise <jon@horde.org>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

define('IMP_BASE', dirname(__FILE__));
require_once IMP_BASE . '/lib/base.php';

if (($reason = IMP::authenticate(OP_HALFOPEN, true)) !== true) {
    header('Location: ' . Horde::applicationUrl(IMP::logoutUrl('login.php', $reason), true));
    exit;
}

if ($conf['compress_pages']) {
    include_once 'HTTP/Compress.php';
    HTTP_Compress::start();
}

$title = _("Message Search");
require $registry->getTemplatePath() . '/common-header.inc';
require IMP_BASE . '/menu.php';
require IMP_BASE . '/status.php';

$newcol = 1;
$numcolumns = 1;
$search_folders = '';
$mailboxes = IMP::flist();
$total = count($mailboxes);
foreach ($mailboxes as $mbox) {
    $newcol++;
    $search_folders .= '<input type="checkbox" name="search_folders[]" ';
    $search_folders .= 'value="' . $mbox['val'] . '"';
    if ($mbox['label'] == 'INBOX') {
        $search_folders .= ' checked="checked"';
    }
    $search_folders .= ' />' . $mbox['label'] . "<br />\n";
    
    if (($newcol > ceil($total / 3)) && ($numcolumns != 3)) {
        $newcol = 1;
        $numcolumns++;
        $search_folders .= "</td>\n";
        $search_folders .= '<td class="control" valign="top" align="left">';
    }
}

require $registry->getTemplatePath() . '/search/javascript.inc';
require $registry->getTemplatePath() . '/search/main.inc';

$registry->shutdown();

require $registry->getTemplatePath() . '/common-footer.inc';

if ($conf['compress_pages']) {
    HTTP_Compress::output();
}
?>
