#!/usr/bin/perl
#
#    $Horde: imp/scripts/imp2turba.pl,v 1.2.2.2 2001/12/24 17:23:38 chuck Exp $
#
#    File:      imp2turba.pl
#    Author:    Micah Anderson - micah@riseup.net
#    Version:   1.0
#
#    Date:      8/7/01
#    Purpose:   This script converts an old imp addressbook database contents
#               to the newer turba addressbook format, it was written for
#               mysql, but could be easily ported to other databases
#
#    Usage:     Modify the variables at the beginning of the script
#               so that your database user/password, location and imp
#               database and turba database are correct. Then simply run
#               ./convert.pl, if you have made the script executable, or
#               perl ./convert.pl
#
#    Date:	5/12/01
#    tuning for imp2.2.7 to turba 1.0 by Christophe Guilloux - rootix@bootix.net
 
 use DBI;
  
  our $location       = 'localhost';
  our $port_num       = '3306';
  our $username       = '';
  our $password       = '';
   
  our $IMP_DATABASE   = 'horde';
  our $IMP_TABLE      = 'imp_addr';
  our $TURBA_DATABASE = 'horde2';
  our $TURBA_TABLE    = 'turba_objects';
  our $domain	      = 'example.com';
    
  our $dbi_options = {RaiseError => 1, ChopBlanks => 1, AutoCommit => 1};
     
  $db_imphandle = DBI->connect
                       ("DBI:mysql:$IMP_DATABASE:$location:port_num",
                         $username, $password, $dbi_options )
                         || die ("Connection error: $DBI::errstr");
									     
  $db_turbahandle = DBI->connect
                       ("DBI:mysql:$TURBA_DATABASE",
                         $username, $password, $dbi_options )
                         || die ("Connection error: $DBI::errstr");
								       
  $imp_statement = $db_imphandle->prepare("SELECT * FROM $IMP_TABLE");
  $imp_statement->execute();
													  
  while (my ($owner, $address, $nickname, $fullname) =
         $imp_statement->fetchrow_array())
											    
  {
													      
    @chars     = ( "A" .. "Z", "a" .. "z", 0 .. 9, qw(! @ $ % ^ & *) );
    $unique_key = join("", @chars[ map { rand @chars } ( 1 .. 31 ) ]);
														     
# Remove the @domain.com part from the $owner, doesn't work in Turba
    $owner =~ s/\@.*$//;
    $owner .= "\@$domain";
															 
# Quote the strings appropriately for the database
    my $quoted_key = $db_imphandle->quote($unique_key);
    my $quoted_owner = $db_imphandle->quote($owner);
    my $quoted_fullname = $db_imphandle->quote($fullname);
    my $quoted_address = $db_imphandle->quote($address);
    my $quoted_nickname = $db_imphandle->quote($nickname);
				      
    $turba_statement = "INSERT INTO $TURBA_TABLE VALUES
                        ($quoted_key, $quoted_owner, $quoted_fullname,
                        $quoted_nickname,$quoted_address, '','','','','','','','','')";
																							        
    $turba_statement = $db_turbahandle->prepare($turba_statement)
       || die "prepare: $$stmt: $DBI::errstr";
    $turba_statement->execute || die "execute: $$stmt: $DBI::errstr";
    $turba_statement->finish();
															        
 }
																										  
 $imp_statement->finish();
 $turba_statement->finish();
 $db_imphandle->disconnect;
 $db_turbahandle->disconnect;
