<?php
/*
 * $Horde: imp/mailbox.php,v 2.296.2.13 2002/01/02 17:05:29 jan Exp $
 *
 * Copyright 1999-2002 Charles J. Hagenbuch <chuck@horde.org>
 * Copyright 1999-2002 Jon Parise <jon@horde.org>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

function runSearch (&$sorted) {
    global $imp, $folders, $prefs;
    
    $sorted = array();
    if (empty($imp['searchquery']) || empty($imp['searchfolders'])) {
        return array();
    }
    
    for ($i = 0; $i < count($imp['searchfolders']); $i++) {
        if (strstr($imp['protocol'], 'pop3')) {
            $stream = $imp['stream'];
        } else {
            $stream = @imap_open(IMP::serverString() . $imp['searchfolders'][$i],
                                 $imp['user'], Secret::read(Secret::getKey('imp'), $imp['pass']), OP_READONLY);
        }
        
        if ($stream) {
            $results = imap_sort($stream, $prefs->getValue('sortby'),
                                 $prefs->getValue('sortdir'), SE_UID, $imp['searchquery']);
            if (is_array($results)) {
                for ($j = 0; $j < count($results); $j++) {
                    $sorted[] = $results[$j];
                    $folders[] = $imp['searchfolders'][$i];
                }
            }
            if (!strstr($imp['protocol'], 'pop3')) {
                imap_close($stream);
            }
        }
    }
    
    if (isset($folders)) {
        $imp['messagefolders'] = implode(':', $folders);
        return implode(':', $sorted);
    } else {
        return false;
    }
}

function stylize($string, $styles)
{
    if (!is_array($styles)) return $string;

    foreach ($styles as $style) {
        if (!empty($style)) {
            $string = '<' . $style . '>' . $string . '</' . $style . '>';
        }
    }
    
    return $string;
}

$set = false;
if (isset($new_lang)) {
    $language = $new_lang;
    $set = true;
}

define('IMP_BASE', dirname(__FILE__));
require_once IMP_BASE . '/lib/base.php';
require_once IMP_BASE . '/lib/Message.php';
require_once HORDE_BASE . '/lib/MIME.php';
require_once HORDE_BASE . '/lib/MIME/Part.php';
require_once HORDE_BASE . '/lib/MIME/Viewer.php';
require_once HORDE_BASE . '/config/mime_drivers.php';
require_once HORDE_BASE . '/config/mime_mapping.php';
require_once HORDE_BASE . '/config/html.php';
require_once IMP_BASE . '/config/html.php';
require_once IMP_BASE . '/config/mime_drivers.php';
require_once IMP_BASE . '/lib/Identity/IMP.php';

/* Initialize $actionID to a resonable value if it hasn't already been set. */
$actionID = Horde::getFormData('actionID', NO_ACTION);

if (($reason = IMP::authenticate(null, true)) !== true) {
    header('Location: ' . Horde::applicationUrl(IMP::logoutUrl('login.php', $reason), true));
    exit;
}

if (($actionID == IMP_LOGIN) || ($actionID == LOGIN_COMPOSE)) {
    if (isset($new_lang)) {
        $language = $new_lang;
    }
    
    if ($actionID == LOGIN_COMPOSE) {
        if ($prefs->getValue('compose_popup')) {
            $open_compose_window = true;
        } else {
            header('Location: ' . Horde::applicationUrl('compose.php'));
        }
    }
}

/* Get form data and make sure it's the type that we're expecting. */
$targetMbox = Horde::getFormData('targetMbox');
$indices = Horde::getFormData('indices');
if (!is_array($indices)) {
    $indices = array($indices);
}

/* If this is a login, run login tasks now. */
if ($actionID == IMP_LOGIN || !empty($imp['_login'])) {
    $imp['_login'] = null;

    /* Get UNIX timestamp of the last time the user logged in. */
    $last_login = $prefs->getValue('last_login');

    /* Display user's last login time if requested. */
    /* Optional UNIX date style: "D M j H:i:s T Y" */
    if ($prefs->getValue('show_last_login')) {
        if (empty($last_login)) {
            Horde::raiseMessage(_("Last login: Never"), HORDE_MESSAGE);
        } else {
            Horde::raiseMessage(sprintf(_("Last login: %s"), strftime(_("%A, %B %e, %Y, %I:%M:%S %p %Z"), $last_login)), HORDE_MESSAGE);
        }
    }

    /* Do maintenance operations. */
    include_once IMP_BASE . '/lib/Maintenance/imp.php';
    $maint = new Maintenance_IMP();
    $maint->runMaintenance();

    /* If the user wants to run filters on login, make sure they get run. */
    if ($prefs->getValue('filter_on_login') && $imp['mailbox'] == 'INBOX') {
        $actionID = FILTER;
    }

    /* Store the current login timestamp now. */
    if (empty($last_login)) {
        $prefs->add('last_login');
    }
    $prefs->setValue('last_login', time());
}

/* Set the current time zone. */
if ($prefs->getValue('timezone') != '') {
    putenv('TZ=' . $prefs->getValue('timezone'));
}

/* Initialize the user's identities */
$identity = new Identity_IMP();

/* Run through the action handlers */
switch ($actionID) {
 case NO_ACTION:
     break;
     
 case IMP_BLACKLIST:
     $filters = @unserialize($prefs->getValue('filters'));
     foreach ($indices as $msgnum) {
         $h = @imap_header($imp['stream'], imap_msgno($imp['stream'], $msgnum));
         if (isset($h->from[0])) {
             $ob = $h->from[0];
             $addr = Mime::trimEmailAddress(imap_rfc822_write_address($ob->mailbox, $ob->host, ''));
             $filters[] = array('fields' => array('from'), 'text' => chop(trim($addr)), 'action' => 'delete');
         }
     }
     $prefs->setValue('filters', serialize($filters));
     $prefs->store();
     header('Location: ' . Horde::applicationUrl('filters.php'));
     break;
     
 case MESSAGE_MISSING:
     Horde::raiseMessage(_("There was an error viewing the requested message."), HORDE_ERROR);
     break;
    
 case DELETE_MESSAGES:
     if (!empty($indices)) {
         IMP_Message::delete($indices);
     }
     break;
        
 case UNDELETE_MESSAGES:
     if (!empty($indices)) {
         IMP_Message::undelete($indices);
     }
     break;
        
 case MOVE_MESSAGES:
     if (!empty($indices) && !empty($targetMbox)) {
         IMP_Message::copy($targetMbox, $indices, MOVE_MESSAGES);
     }
     break;
        
 case COPY_MESSAGES:
     if (!empty($indices) && !empty($targetMbox)) {
         IMP_Message::copy($targetMbox, $indices, COPY_MESSAGES);
     }
     break;
        
 case FLAG_MESSAGES:
     if (!empty($indices) && !empty($HTTP_POST_VARS['flag'])) {
         if ($HTTP_POST_VARS['flag'][0] == '0') {
             $HTTP_POST_VARS['flag'] = '\\' . substr($HTTP_POST_VARS['flag'], 1);
             $set = false;
         } else {
             $HTTP_POST_VARS['flag'] = '\\' . $HTTP_POST_VARS['flag'];
             $set = true;
         }
         IMP_Message::flag($HTTP_POST_VARS['flag'], $indices, $set);
     }
     break;
        
 case HIDE_DELETED:
     $prefs->setValue('delhide', !$prefs->getValue('delhide'));
     break;
        
 case EXPUNGE_MAILBOX:
     if ($imp['mailbox'] == '**search') {
         for ($i = 0; $i < count($imp['searchfolders']); $i++) {
             if (strstr($imp['protocol'], 'pop3')) {
                 $stream = $imp['stream'];
             } else {
                 $stream = @imap_open(IMP::serverString() . $imp['searchfolders'][$i],
                                      $imp['user'], Secret::read(Secret::getKey('imp'), $imp['pass']));
             }
             if (!(@imap_expunge($stream))) {
                 Horde::raiseMessage(sprintf(_("There was a problem expunging %s. This is what the server said"), IMP::displayFolder($imp['searchfolders'][$i])) .
                                     ': <i>' . imap_last_error() . '</i>', HORDE_ERROR);
             }
             if (!strstr($imp['protocol'], 'pop3')) {
                 imap_close($stream);
             }
         }
     } else {
         if (!(@imap_expunge($imp['stream']))) {
             Horde::raiseMessage(_("There was a problem expunging the mailbox. This is what the server said") .
                                 ': <i>' . imap_last_error() . '</i>', HORDE_ERROR);
         }
     }
     break;
     
 case SEARCH:
     /* Create the search query with the given data. */
     $query = '';
     switch ($HTTP_POST_VARS['search_seen']) {
     case 0:
         $query .= ' SEEN';
         break;
     case 1:
         $query .= ' UNSEEN';
         break;
     default:
         break;
     }
     
     switch ($HTTP_POST_VARS['search_answered']) {
     case 0:
         $query .= ' ANSWERED';
         break;
     case 1:
         $query .= ' UNANSWERED';
         break;
     default:
         break;
     }
     
     switch ($HTTP_POST_VARS['search_flagged']) {
     case 0:
         $query .= ' FLAGGED';
         break;
     case 1:
         $query .= ' UNFLAGGED';
         break;
     default:
         break;
     }
     
     switch ($HTTP_POST_VARS['search_deleted']) {
     case 0:
         $query .= ' DELETED';
         break;
     case 1:
         $query .= ' UNDELETED';
         break;
     default:
         break;
     }
     
     if (!empty($HTTP_POST_VARS['search_from']))
         $query .= ' FROM "' . Horde::getFormData('search_from') . '"';
        
     if (!empty($HTTP_POST_VARS['search_to']))
         $query .= ' TO "' . Horde::getFormData('search_to') . '"';
        
     if (!empty($HTTP_POST_VARS['search_cc']))
         $query .= ' CC "' . Horde::getFormData('search_cc') . '"';
        
     if (!empty($HTTP_POST_VARS['search_subject']))
         $query .= ' SUBJECT "' . Horde::getFormData('search_subject') . '"';
     
     if (!empty($HTTP_POST_VARS['search_body']))
         $query .= ' BODY "' . Horde::getFormData('search_body') . '"';

     if (!empty($HTTP_POST_VARS['search_on_month']) &&
         !empty($HTTP_POST_VARS['search_on_day']) &&
         !empty($HTTP_POST_VARS['search_on_year']) &&
         preg_match('/^\d{4}$/', $HTTP_POST_VARS['search_on_year'])) {
         $query .= ' ON "' . date('r', mktime(0, 0, 0, $HTTP_POST_VARS['search_on_month'], $HTTP_POST_VARS['search_on_day'], $HTTP_POST_VARS['search_on_year'])) . '"';
     }

     if (!empty($HTTP_POST_VARS['search_before_month']) &&
         !empty($HTTP_POST_VARS['search_before_day']) &&
         !empty($HTTP_POST_VARS['search_before_year']) &&
         preg_match('/^\d{4}$/', $HTTP_POST_VARS['search_before_year'])) {
         $query .= ' BEFORE "' . date('r', mktime(0, 0, 0, $HTTP_POST_VARS['search_before_month'], $HTTP_POST_VARS['search_before_day'], $HTTP_POST_VARS['search_before_year'])) . '"';
     }

     if (!empty($HTTP_POST_VARS['search_since_month']) &&
         !empty($HTTP_POST_VARS['search_since_day']) &&
         !empty($HTTP_POST_VARS['search_since_year']) &&
         preg_match('/^\d{4}$/', $HTTP_POST_VARS['search_since_year'])) {
         $query .= ' SINCE "' . date('r', mktime(0, 0, 0, $HTTP_POST_VARS['search_since_month'], $HTTP_POST_VARS['search_since_day'], $HTTP_POST_VARS['search_since_year'])) . '"';
     }

     $imp['searchquery'] = trim($query);
     $imp['searchfolders'] = $HTTP_POST_VARS['search_folders'];
     break;

 case FILTER:
     $filters = @unserialize($prefs->getValue('filters'));
     if (is_array($filters) && count($filters) && !strstr($imp['protocol'], 'pop3')) {
         include_once IMP_BASE . '/lib/Folder.php';
         $baseQuery = 'UNDELETED ';
         for ($i = 0; $i < count($filters); $i++) {
             for ($j = 0; $j < count($filters[$i]['fields']); $j++) {
                 $query = $baseQuery . strtoupper($filters[$i]['fields'][$j]) . ' "' . $filters[$i]['text'] . '"';
                 $indices = imap_search($imp['stream'], $query, SE_UID);
                 if (isset($indices) && is_array($indices)) {
                     if ($filters[$i]['action'] == 'delete') {
                         if ($prefs->getValue('show_filter_msg')) {
                             $overview = imap_fetch_overview($imp['stream'], implode(',', $indices), FT_UID);
                             foreach ($overview as $message) {
                                 if ($prefs->getValue('use_trash')) {
                                     Horde::raiseMessage(_(sprintf("Filter Activity: The message \"%s\" from \"%s\" has been moved to your Trash folder.", MIME::decode($message->subject), MIME::decode($message->from))), HORDE_MESSAGE);
                                 }
                                 else {
                                     Horde::raiseMessage(_(sprintf("Filter Activity: The message \"%s\" from \"%s\" has been deleted.", MIME::decode($message->subject), MIME::decode($message->from))), HORDE_MESSAGE);
                                 }
                             }
                         }
                         IMP_Message::delete($indices);
                     }
                     else {
                         if (IMP_Folder::exists($imp['stream'], $filters[$i]['folder'])) {
                             if ($prefs->getValue('show_filter_msg')) {
                                 $overview = imap_fetch_overview($imp['stream'], implode(',', $indices), FT_UID);
                                 foreach ($overview as $message) {
                                     Horde::raiseMessage(_(sprintf("Filter Activity: The message \"%s\" from \"%s\" has been moved to the folder \"%s\".", MIME::decode($message->subject), $message->from, $filters[$i]['folder'])), HORDE_MESSAGE);
                                 }
                             }
                             IMP_Message::copy($filters[$i]['folder'], $indices, MOVE_MESSAGES);
                         } else {
                             Horde::raiseMessage(_(sprintf("%s %d: %s: ", "problem with filter rule", $i + 1, "folder does not exist")) . IMP::displayFolder($filters[$i]['folder']), HORDE_WARNING);
                         }
                     }
                 }
             }
         }
     }
     break;
}

if ($conf['user']['allow_folders']) {
    $options = IMP::flistSelect(_("Messages to"), true, array($imp['mailbox']));
}

if ($imp['mailbox'] == '**search') {
    $imp['msgl'] = runSearch($sorted);
    $imp['msgcount'] = count($sorted);
} else {
    if ($prefs->getValue('delhide')) {
        $msgs = imap_search($imp['stream'], 'UNDELETED');
        $imp['msgcount'] = ($msgs !== false) ? count($msgs) : 0;
    } else {
        $check = imap_check($imp['stream']);
        $imp['msgcount'] = (is_object($check) && isset($check->Nmsgs)) ? $check->Nmsgs : 0;
    }

    if ($imp['msgcount'] != 0) {
        if ($prefs->getValue('delhide')) {
            $sorted = imap_sort($imp['stream'], $prefs->getValue('sortby'),
                                $prefs->getValue('sortdir'), SE_UID, 'UNDELETED');
        } else {
            $sorted = imap_sort($imp['stream'], $prefs->getValue('sortby'),
                                $prefs->getValue('sortdir'), SE_UID);
        }
    } else {
        $sorted = array();
    }
}

/* Paging logic. This should be cleaned up if at all possible. */
if ($imp['msgcount'] > $prefs->getValue('max_msgs')) {
    
    $page_count = ceil($imp['msgcount'] / (($prefs->getValue('max_msgs') > 0) ? $prefs->getValue('max_msgs') : 20));
    
    /* Determine which page to display */
    if (isset($HTTP_GET_VARS['page']) && !strcspn($HTTP_GET_VARS['page'], '0123456789')) {
        /* This will be sanity checked later. */
        $page = $HTTP_GET_VARS['page'];
        
    } elseif (isset($HTTP_POST_VARS['page']) && !strcspn($HTTP_POST_VARS['page'], '0123456789')) {
    /* This will be sanity checked later. */
    $page = $HTTP_POST_VARS['page'];
    
    } elseif (!empty($HTTP_GET_VARS['start'])) {
        /* messages set this when returning to a mailbox */
        $page = ceil($HTTP_GET_VARS['start'] / $prefs->getValue('max_msgs'));
        
    } elseif ($imp['mailbox'] != '**search') {
        /* Use imap_sort to find the first unread message */
        if ($prefs->getValue('delhide')) {
            $search = 'UNSEEN UNDELETED';
        } else {
            $search = 'UNSEEN';
        }
        $new = imap_sort($imp['stream'], $prefs->getValue('sortby'),
                         $prefs->getValue('sortdir'), SE_UID, $search);
        if (!empty($new)) {
            $msg_keys = array_flip($sorted);
            $first_new = $msg_keys[$new[0]] + 1;
            $page = ceil($first_new / $prefs->getValue('max_msgs'));
        } else {
            $page = $prefs->getValue('sortdir') ? 1 : $page_count;
        }
    } else {
        $page = $prefs->getValue('sortdir') ? 1 : $page_count;
    }
    
    /* make sure we're not past the end or before the beginning. */
    if ($page > $page_count) {
        $page = $page_count;
    } elseif ($page < 1) {
        $page = 1;
    }
    
    $begin = (($page - 1) * $prefs->getValue('max_msgs')) + 1;
    $end = $begin + $prefs->getValue('max_msgs') - 1;
    if ($end > $imp['msgcount']) {
        $end = $imp['msgcount'];
    }
    
    if ($page == 1) {
        if ($browser->hasFeature('images')) {
            $pages_first = Horde::img('first-grey.gif', 'alt=""');
            $pages_prev = Horde::img('prev-grey.gif', 'alt=""');
        } else {
            $pages_first = '';
            $pages_prev  = '';
        }
    } else {
        $prev = $page - 1;
        $first_url = Horde::applicationUrl('mailbox.php?page=1');
        $prev_url  = Horde::applicationUrl("mailbox.php?page=$prev");
        if ($browser->hasFeature('images')) {
            $pages_first = Horde::link($first_url, _("First Page"), 'widget');
            $pages_first .= Horde::img('first.gif', 'alt="' . _("First Page") . '"');
            $pages_first .= '</a>';
            $pages_prev = Horde::link($prev_url, _("Previous Page"), 'widget');
            $pages_prev .= Horde::img('prev.gif', 'alt="' . _("Previous Page") . '"');
            $pages_prev .= '</a>';
        } else {
            $pages_first = Horde::link($first_url, _("First Page"), 'widget');
            $pages_first .= '&lt;&lt; [ ' . _("First Page") . ' ]</a>';
            $pages_prev = Horde::link($prev_url, _("Previous Page"), 'widget');
            $pages_prev .= '&lt; [ ' . _("Previous Page") . ' ]</a>';
        }
    }
    
    if ($page == $page_count) {
        if ($browser->hasFeature('images')) {
            $pages_last = Horde::img('last-grey.gif', 'alt=""');
            $pages_next = Horde::img('next-grey.gif', 'alt=""');
        } else {
            $pages_last = '';
            $pages_next = '';
        }
    } else {
        $next = $page + 1;
        $next_url = Horde::applicationUrl("mailbox.php?page=$next");
        $last_url = Horde::applicationUrl("mailbox.php?page=$page_count");
        
        if ($browser->hasFeature('images')) {
            $pages_next = Horde::link($next_url, _("Next Page"), 'widget');
            $pages_next .= Horde::img('next.gif', 'alt="' . _("Next Page") . '"');
            $pages_next .= '</a>';
            $pages_last = Horde::link($last_url, _("Last Page"), 'widget');
            $pages_last .= Horde::img('last.gif', 'alt="' . _("Last Page") . '"');
            $pages_last .= '</a>';
        } else {
            $pages_next = Horde::link($next_url, _("Next Page"), 'widget');
            $pages_next .= '[ ' . _("Next Page") . ' ] &gt;</a>';
            $pages_last = Horde::link($last_url, _("Last Page"), 'widget');
            $pages_last .= '[ ' . _("Last Page") . ' ] &gt;&gt;</a>';
        }
    }
} else {
    $begin = 1;
    $end = $imp['msgcount'];
    $page = 1;
}

if ($imp['mailbox'] == '**search') {
    $imp['offset'] = 0;
    $beginIndex = $begin - 1;
} else {
    $imp['msgl'] = implode(':', IMP_Message::range($sorted, $begin, $offset, $beginIndex, $num));
    $imp['offset'] = $offset;
}

if ($prefs->getValue('delhide')) {
    $deleted_prompt = _("Show Deleted");
} else {
    $deleted_prompt = _("Hide Deleted");
}

if ($end != 0) {
    $msg_count = sprintf(_("%d to %d of %d Messages"), $begin, $end, $imp['msgcount']);
} else {
    $msg_count = sprintf(_("%d of %d Messages"), $end, $imp['msgcount']);
}

/* If user wants the mailbox to be refreshed, set time here */
$refresh_time = $prefs->getValue('refresh_time');
$refresh_url = Horde::applicationUrl("mailbox.php?page=$page&uniq=".uniqid(rand()));

$title = $imp['label'];
if ($conf['compress_pages']) {
    include_once 'HTTP/Compress.php';
    HTTP_Compress::start();
}

require $registry->getTemplatePath() . '/common-header.inc';
if ($browser->hasFeature('javascript')) {
    include $registry->getTemplatePath() . '/mailbox/javascript.inc';
}
require IMP_BASE . '/menu.php';
require IMP_BASE . '/status.php';

if (!empty($conf['hooks']['quota']) && function_exists($conf['hooks']['quota'])) {
      $quota_info = call_user_func($conf['hooks']['quota'], $imp);
}

require $registry->getTemplatePath() . '/mailbox/header.inc';
$navform = 1;
require $registry->getTemplatePath() . '/mailbox/navbar.inc';
require $registry->getTemplatePath() . '/mailbox/actions.inc';
if ($imp['mailbox'] != '**search') {
    include $registry->getTemplatePath() . '/mailbox/message_headers.inc';
}

// Build the array of message information,
$sortedIds = array_flip($sorted);
$mailboxOverview = array();
for ($i = ($begin - 1), $j = $beginIndex, $msgs = array(), $extra = array(); $i < $end; $i++, $j++) {
    /* Make sure that the index is actually in the slice of messages
       we're looking at. If we're hiding deleted messages, for
       example, there may be gaps here. */
    if (isset($sorted[$i])) {
        if ($imp['mailbox'] === '**search') {
            if (($j === $beginIndex) || ($folders[$j - 1] !== $folders[$j])) {
                if (count($msgs) > 0) {
                    $overview = imap_fetch_overview($imp['stream'], implode(',', $msgs), FT_UID);
                    $msgs = array();
                    foreach ($overview as $header) {
                        $mailboxOverview[$sortedIds[$header->uid]]['header'] = $header;
                        $mailboxOverview[$sortedIds[$header->uid]]['folder'] = $folders[$j - 1];
                        $mailboxOverview[$sortedIds[$header->uid]]['arrayIndex'] = $extra[$header->uid]['arrayIndex'];
                        $mailboxOverview[$sortedIds[$header->uid]]['structure'] = $extra[$header->uid]['structure'];
                    }
                }
                
                if (!strstr($imp['protocol'], 'pop3')) {
                    imap_reopen($imp['stream'], IMP::serverString() . $folders[$j],
                                OP_READONLY);
                }
            }
        }
        
        $msgs[] = $sorted[$i];
        $extra[$sorted[$i]]['arrayIndex'] = $j;
        if ($conf['mailbox']['show_attachments']) {
            $extra[$sorted[$i]]['structure'] = @imap_fetchstructure($imp['stream'], $sorted[$i], FT_UID);
        } else {
            $extra[$sorted[$i]]['structure'] = null;
        }
    }
}
if (count($msgs) > 0) {
    $overview = imap_fetch_overview($imp['stream'], implode(',', $msgs), FT_UID);
    foreach ($overview as $header) {
        $mailboxOverview[$sortedIds[$header->uid]]['header'] = $header;
        $mailboxOverview[$sortedIds[$header->uid]]['arrayIndex'] = $extra[$header->uid]['arrayIndex'];
        $mailboxOverview[$sortedIds[$header->uid]]['structure'] = $extra[$header->uid]['structure'];
        if ($imp['mailbox'] === '**search') {
            $mailboxOverview[$sortedIds[$header->uid]]['folder'] = $folders[$j - 1];
        }
    }
}

// Get everything in the right sort order
ksort($mailboxOverview);

// Display message information.
$newmsgs = 0;
foreach ($mailboxOverview as $message) {
    if ($imp['mailbox'] == '**search') {
        if (!isset($lastFolder) || ($message['folder'] != $lastFolder)) {
            include $registry->getTemplatePath() . '/mailbox/searchfolder.inc';
            include $registry->getTemplatePath() . '/mailbox/message_headers.inc';
        }
        $lastFolder = $message['folder'];
    }
    
    /* initialize the header fields */
    $dat = '';
    $frm = '';
    $fullfrom = '';
    $to = '';
    $sub = '';
    $msg_size = '?';
    
    /* Now pull the IMAP header values into them, decoding them at
       the same time. */
    $h = $message['header'];
    
    /* formats the header date string nicely */
    if (isset($h->date) && ($udate = strtotime($h->date)) != -1) {
        if ((date('Y') != @date('Y', $udate)) ||
            (date('M') != @date('M', $udate)) ||
            (date('d') != @date('d', $udate))) {
            // not today, use the date
            $dat = @strftime($conf['mailbox']['date_format'], $udate);
        } else {
            // else it's today, use the time
            $dat = @strftime($conf['mailbox']['time_format'], $udate);
        }
    } else {
        $dat = '';
    }
    
    if (isset($h->from)) {
        $tmp = imap_rfc822_parse_adrlist($h->from, '');
        $tmp = $tmp[0];
        $fullfrom = '';
        
        if (isset($tmp->personal)) {
            $fullfrom = $frm = MIME::decode($tmp->personal);
        }
        
        if (isset($tmp->mailbox) && isset($tmp->host)) {
            if (empty($frm)) $frm = $tmp->mailbox . '@' . $tmp->host;
            $fullfrom .= $tmp->mailbox . '@' . $tmp->host;
        }
    }
    
    if ($identity->hasAddress($fullfrom)) {
        if (isset($h->to)) {
            $tmp = imap_rfc822_parse_adrlist($h->to, '');
            $tmp = $tmp[0];
            if (isset($tmp->personal)) {
                $to = MIME::decode($tmp->personal);
            }
            if (empty($to) && isset($tmp->mailbox) && isset($tmp->host)) {
                $to = $tmp->mailbox . '@' . $tmp->host;
            }
        } else {
            $to = _("Undisclosed Recipients");
        }
        $frm = _("To") . ': ' . $to;
    }
    
    if (isset($h->subject)) {
        $sub = MIME::decode($h->subject);
    }
    if (isset($h->size)) {
        $msg_size = ($h->size > 1024)
            ? sprintf('%.0fkb', $h->size / 1024)
            : $h->size;
    }
    if (strlen($frm) > $conf['mailbox']['max_from_chars']) {
        $frm = substr($frm, 0, $conf['mailbox']['max_from_chars']) . '...';
    }
    if (strlen($sub) > $conf['mailbox']['max_subj_chars']) {
        $sub = substr($sub, 0, $conf['mailbox']['max_subj_chars']) . '...';
    }
    
    /* set them to useful things for IMP if they ended up being empty */
    if ($dat == '') { $dat = '&nbsp;'; }
    if ($frm == '') { $frm = '&nbsp;'; }
    if ($sub == '') { $sub = '[' . _("No subject") . ']'; }
    
    /* filter the subject text, if requested */
    if ($prefs->getValue('filtering')) {
        include_once HORDE_BASE . '/lib/Text.php';
        $sub = Text::filter($sub, $conf['msg']['filtering']['words'],
                            $conf['msg']['filtering']['replacement']);
    }
    
    $attachment = false;
    if (isset($message['structure'])) {
        if (!empty($message['structure']->subtype)) {
            if (strtolower($message['structure']->subtype) == 'signed' ||
                strtolower($message['structure']->subtype) == 'encrypted') {
                $attachment = 'signed';
            } elseif (strtolower($message['structure']->subtype) == 'alternative') {
                $attachment = 'alternative';
            } elseif (isset($message['structure']->parts) &&
                      is_array($message['structure']->parts) &&
                      count($message['structure']->parts) > 0) {
                $attachment = 'attachment';
            } elseif ((!empty($message['structure']->type) &&
                       $message['structure']->type != TYPETEXT) ||
                      !empty($message['structure']->subtype) &&
                      strtolower($message['structure']->subtype) != 'plain') {
                $attachment = 'attachment';
            }
        }
    }
    
    if ($imp['mailbox'] == '**search') {
        $target = Horde::applicationUrl('message.php?mailbox=**search&msgmailbox=' .
                                        urlencode($message['folder']) . '&index=' . urlencode($h->uid) .
                                        '&array_index=' . $message['arrayIndex']);
    } else {
        $target = Horde::applicationUrl('message.php?index=' . urlencode($h->uid) .
                                        '&array_index=' . $message['arrayIndex']);
    }
    
    /* get all the flag information */
    $flagbits = 0;
    $style = array();
    $status = '';
    $bg = 'text';
    if (!strstr($imp['protocol'], 'pop3')) {
        if (!empty($h->to) && $identity->hasAddress($h->to)) {
            $status .= $conf['mailbox']['personal_flag'];
            $flagbits |= IMP_PERSONAL;
        }
        if ($h->recent) {
            $newmsgs++;
        }
        if (!$h->seen) {
            $flagbits |= IMP_UNSEEN;
            $status .= $conf['mailbox']['unseen_flag'];
            $style[] = $conf['mailbox']['unseen_style'];
            $bg = 'unseen';
        }
        if ($h->answered) {
            $flagbits |= IMP_ANSWERED;
            $status .= $conf['mailbox']['answered_flag'];
            $style[] = $conf['mailbox']['answered_style'];
            $bg = 'answered';
        }
        if ($h->draft) {
            $flagbits |= IMP_DRAFT;
            $status .= $conf['mailbox']['draft_flag'];
            $style[] = $conf['mailbox']['draft_style'];
            $target = IMP::composeLink(array(), array('actionID' => DRAFT, 'mailbox' => $imp['mailbox'], 'index' => $h->uid, 'bodypart' => 1));
        }
        if ($h->flagged) {
            $flagbits |= IMP_FLAGGED;
            $status .= $conf['mailbox']['important_flag'];
            $style[] = $conf['mailbox']['important_style'];
            $bg = 'important';
        }
        if ($h->deleted) {
            $flagbits |= IMP_DELETED;
            $status .= $conf['mailbox']['deleted_flag'];
            $style[] = $conf['mailbox']['deleted_style'];
            $bg = 'deleted';
        }
        $flags[] = $flagbits;
    } else {
        $flags[] = 0;
    }
    
    // apply styles
    $styledat = stylize($dat, $style);
    $stylefrm = stylize(htmlspecialchars($frm), $style);
    $stylesub = stylize(htmlspecialchars($sub), $style);
    
    // decide what to do in the from column (after we've possibly
    // applied styles to $from)
    if ($conf['mailbox']['from_link'] == 'message') {
        if ($imp['mailbox'] == '**search') {
            $from_uri = Horde::applicationUrl('message.php?mailbox=**search&msgmailbox=' .
                                              urlencode($message['folder']) . '&index=' . urlencode($h->uid) .
                                              '&array_index=' . $message['arrayIndex']);
        } else {
            $from_uri = Horde::applicationUrl('message.php?index=' . $h->uid . '&array_index=' . $message['arrayIndex']);
        }
        $from_link = Horde::link($from_uri, $frm) . $stylefrm . '</a>';
    } elseif ($conf['mailbox']['from_link'] == 'compose') {
        $compose_url = IMP::composeLink(array(), array('actionID' => MAILTO, 'mailbox' => $imp['mailbox'], 'index' => $h->uid));
        $from_link = Horde::link($compose_url, sprintf(_("Compose Message (%s)"), $frm)) . $stylefrm . '</a>';
    } else {
        $from_link = $stylefrm;
    }
    
    include $registry->getTemplatePath() . '/mailbox/message_summaries.inc';
}

if ($end == 0) {
    if ($imp['mailbox'] == '**search') {
        include $registry->getTemplatePath() . '/mailbox/message_headers.inc';
    }
    include $registry->getTemplatePath() . '/mailbox/empty_mailbox.inc';
}

require $registry->getTemplatePath() . '/mailbox/message_footers.inc';
if ($conf['mailbox']['show_legend']) {
    include $registry->getTemplatePath() . '/mailbox/legend.inc';
}
require $registry->getTemplatePath() . '/mailbox/actions.inc';
$navform = 2;
require $registry->getTemplatePath() . '/mailbox/navbar.inc';
require $registry->getTemplatePath() . '/mailbox/footer.inc';

if ($prefs->getValue('nav_popup') && ($newmsgs > 0) && (Horde::getFormData('newmail_popup') != 'no')) {
    include $registry->getTemplatePath() . '/mailbox/alert.inc';
}

$registry->shutdown();
if (!empty($open_compose_window)) {
    $registry->pcall('mail/composePopup', array());
}

require $registry->getTemplatePath() . '/common-footer.inc';

$prefs->store();

if ($conf['compress_pages']) {
    HTTP_Compress::output();
}

?>
