<?php
/*
 * $Horde: imp/login.php,v 2.128.2.5 2002/01/02 17:05:28 jan Exp $
 *
 * Copyright 1999-2002 Charles J. Hagenbuch <chuck@horde.org>
 * Copyright 1999-2002 Jon Parise <jon@horde.org>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

/**
 * Determines if the given mail server is the "preferred" mail server for
 * this web server.  This decision is based on the global 'SERVER_NAME'
 * and 'HTTP_HOST' server variables and the contents of the 'preferred'
 * either field in the server's definition.  The 'preferred' field may
 * take a single value or an array of multiple values.
 *
 * @param $server       A complete server entry from the $servers hash.
 *
 * @return  boolean     True if this entry is "preferred".
 */
function isPreferred($server, $key = null)
{
    global $HTTP_SERVER_VARS;
    static $urlServer;
    
    if (!isset($urlServer)) $urlServer = Horde::getFormData('server');
    if (!empty($urlServer)) {
        return $key == $urlServer;
    }
    
    if (!empty($server['preferred'])) {
        if (is_array($server['preferred'])) {
            foreach ($server['preferred'] as $preferred) {
                if ($preferred == $HTTP_SERVER_VARS['SERVER_NAME'] ||
                    $preferred == $HTTP_SERVER_VARS['HTTP_HOST']) {
                    return true;
                }
            }
        } elseif ($server['preferred'] == $HTTP_SERVER_VARS['SERVER_NAME'] ||
                  $server['preferred'] == $HTTP_SERVER_VARS['HTTP_HOST']) {
            return true;
        }
    }

    return false;
}

define('IMP_BASE', dirname(__FILE__));
require_once IMP_BASE . '/lib/base.php';

/* Additional configuration (dependent on the above code libraries) */
require IMP_BASE . '/config/servers.php';

/* Map the various values for $reason to more descriptive status messages. */
$reasons = array('login'   => '',
                 'session' => sprintf(_("Your %s session has expired. Please login again."), $registry->getName()),
                 'logout'  => sprintf(_("You have been logged out of %s. Thank you for using the system. If you wish to log in again, please use the form below."), $registry->getName()),
                 'failed'  => _("Login failed for some reason. Most likely your username or password was entered incorrectly."));

/* Default to 'login' if no $reason is set. */
$reason = Horde::getFormData('reason', 'login');
$actionID = Horde::getFormData('actionID', NO_ACTION);

if (isset($HTTP_SESSION_VARS['imp']) && is_array($HTTP_SESSION_VARS['imp'])) {
    if ($reason == 'logout') {
        $entry = sprintf('Logout for %s [%s] from {%s:%s}',
                         $HTTP_SESSION_VARS['imp']['user'],
                         $HTTP_SERVER_VARS['REMOTE_ADDR'], $HTTP_SESSION_VARS['imp']['server'],
                         $HTTP_SESSION_VARS['imp']['port']);
        Horde::logMessage($entry, __FILE__, __LINE__, LOG_NOTICE);
        
        $imp = &$HTTP_SESSION_VARS['imp'];
        if (isset($imp['user'])) {
            $prefs = &Prefs::factory($conf['prefs']['driver'],
                $registry->getApp(), $imp['uniquser'],
                Secret::read(Secret::getKey('imp'), $imp['pass']),
                $conf['prefs']['params']);
            $prefs->store();
            $prefs->cleanup(true);
        }
        $HTTP_SESSION_VARS['imp'] = null;
        session_unregister('imp');

        if ($registry->getMethod('auth/logout') == $registry->getApp()) {
            include_once HORDE_BASE . '/lib/Auth.php';
            Auth::clearAuth();
            session_destroy();
            @session_start();
        }
    } elseif ($reason == 'failed') {
        $HTTP_SESSION_VARS['imp'] = null;
        session_unregister('imp');

        if ($registry->getMethod('auth/logout') == $registry->getApp()) {
            include_once HORDE_BASE . '/lib/Auth.php';
            Auth::clearAuth();
        }
    } else {
        /* If there is an existing session, redirect the user to the mailbox. */
        if ($actionID == IMP_LOGIN) {
            header('Location: ' . Horde::applicationUrl('mailbox.php?actionID=' . IMP_LOGIN, true));
            exit;
        } elseif (($actionID == LOGIN_COMPOSE) || (isset($HTTP_GET_VARS['action']) && ($HTTP_GET_VARS['action'] == 'compose'))) {
            header('Location: ' . Horde::applicationUrl('mailbox.php?actionID=' . LOGIN_COMPOSE, true));
            exit;
        } else {
            header('Location: ' . Horde::applicationUrl('mailbox.php', true));
            exit;
        }
    }
}

/* Log session timeouts. */
if ($reason == 'session') {
    $entry = sprintf('Session timeout for client [%s]', $HTTP_SERVER_VARS['REMOTE_ADDR']);
    Horde::logMessage($entry, __FILE__, __LINE__, LOG_INFO);
}

/* Redirect the user on logout if redirection is enabled. */
if (($reason == 'logout') && $conf['user']['redirect_on_logout']) {
    header('Location: ' . $conf['user']['redirect_on_logout'] . '?reason=logout');
    exit;
}

/* Redirect the user if an alternate login page has been specified. */
if ((in_array($reason, array('login', 'failed', 'session', 'logout'))) && $conf['user']['alternate_login']) {
    header('Location: ' . $conf['user']['alternate_login'] . '?reason=' . $reason);
    exit;
}

/* Redirect the user on logout if controlling auth for Horde. */
if ($reason == 'logout' && Horde::getFormData('redirect_url')) {
    header('Location: ' . Horde::getFormData('redirect_url'));
    exit;
}

/* Initialize the password key. */
Secret::setKey('imp');

/* Set the actionID of the login form */
if ((isset($HTTP_GET_VARS['action']) && $HTTP_GET_VARS['action'] == 'compose') ||
    ($actionID == LOGIN_COMPOSE)) {
    $actionID = LOGIN_COMPOSE;
} else {
    $actionID = IMP_LOGIN;
}

/* Get the default preferences values. */
$prefs = &Prefs::factory('none', $registry->getApp());
$prefs->setDefaults(IMP_BASE . '/config/prefs.php');

/* Iterate through the servers in an attempt to locate a preferred
   server for this web server/virtualhost. If none are found, we
   default to the first entry in the $servers array that isn't a
   prompt (key begins with '_'). */
foreach ($servers as $key => $curServer) {
    if (!isset($server_key) && substr($key, 0, 1) != '_') {
        $server_key = $key;
    }
    if (isPreferred($curServer, $key)) {
        $server_key = $key;
        break;
    }
}

/* Grab some default values from the preferred or otherwise default
   server. */
$server_value = $servers[$server_key]['server'];
$protocol_value = $servers[$server_key]['protocol'];
$port_value = $servers[$server_key]['port'];
$folders_value = $servers[$server_key]['folders'];
$namespace_value = $servers[$server_key]['namespace'];
$maildomain_value = $servers[$server_key]['maildomain'];
$realm_value = $servers[$server_key]['realm'];

/* Build the <select> widget for the servers list. */
if ($conf['server']['server_list'] && !$conf['server']['server_list_hidden']) {
    $servers_list = '';

    foreach ($servers as $key => $curServer) {
        $sel = (isPreferred($curServer, $key)) ? ' selected="selected"' : '';
        $servers_list .= "<option value=\"$key\"$sel>";
        $servers_list .= $curServer['name'] . '</option>';
    }
}

/* Build the <select> widget containing the available languages. */
if (!$prefs->isLocked('language')) {
    $langs = '<select name="new_lang" onchange="selectLang()">';
    foreach ($nls['languages'] as $key => $val) {
        $sel = ($key == $language) ? ' selected="selected"' : '';
        $langs .= "<option value=\"$key\"$sel>$val</option>";
    }
    $langs .= '</select>';
}

$title = _("Welcome");
$js_onLoad = 'setFocus()';
include $registry->getTemplatePath() . '/common-header.inc';
include $registry->getTemplatePath() . '/login/login.inc';
if (@is_readable(IMP_BASE . '/config/motd.php')) {
    include IMP_BASE . '/config/motd.php';
}
include $registry->getTemplatePath() . '/common-footer.inc';

?>
