<?php
// $Horde: imp/lib/api.php,v 1.12.2.1 2001/11/18 15:45:42 chuck Exp $
/*
 * IMP external API interface.
 *
 * This file defines IMP's external API interface. Other applications
 * can interact with IMP through this API.
 */

// Find the base file paths for IMP
@define('IMP_BASE', dirname(__FILE__) . '/..');

// Include the necessary libraries.
require_once IMP_BASE . '/lib/base.php';

function impComposePopup()
{
    $GLOBALS['registry']->includeFiles('imp', 'mail/composePopup');
    return "<script language='JavaScript' type='text/javascript'>open_compose_win('');</script>";
}

function impSummary()
{
    global $prefs, $registry;
    
    $html  = '<table border="0" cellpadding="2" cellspacing="0" width="100%"><tr><td class="header">';
    $html .= Horde::link(Horde::url($registry->getInitialPage()), $registry->getName(), 'header') . $registry->getName() . '</a>';
    $html .= '</td></tr><tr><td class="text"><table border="0" cellpadding="0" cellspacing="0">';
    
    if (IMP::authenticate(OP_HALFOPEN, true) === true) {
        $folders = @unserialize($prefs->getValue('nav_poll'));
        if (!isset($folders) || !is_array($folders)) {
            $folders = array('INBOX' => 1);
        }
        ksort($folders);
        
        $serverstring = IMP::serverString();
        foreach ($folders as $folder => $true) {
            $sts = imap_status($GLOBALS['imp']['stream'], $serverstring . $folder, SA_UNSEEN);
            if ($sts) {
                $html .= '<tr><td class="text">';
                if (!empty($sts->unseen)) {
                    $html .= '<b>';
                }
                $html .= Horde::link(Horde::applicationUrl('mailbox.php?newmail_popup=no&mailbox=' . urlencode($folder)), IMP::displayFolder($folder)) . IMP::displayFolder($folder) . '</a>';
                if (!empty($sts->unseen)) {
                    $html .= '<b>';
                }
                $html .= '</td><td class="text">&nbsp;&nbsp;&nbsp;</td><td class="text">';
                $html .= !empty($sts->unseen) ? '<b>' . $sts->unseen . '</b>' : '0';
                $html .= '</td></tr>';
            }
        }
    } else {
        $html .= '<tr><td class="text">' . Horde::link(Horde::applicationUrl('index.php'), sprintf(_("Log in to %s"), $registry->applications['imp']['name'])) . sprintf(_("Log in to %s"), $registry->applications['imp']['name']) . '</a></td></tr>';
    }
    
    $html .= '</table></td></tr></table>';
    return $html;
}

?>
