<?php
// $Horde: imp/lib/Maintenance/Task/rename_sentmail_monthly.php,v 1.2.2.2 2001/12/03 15:58:01 chuck Exp $

/**
* Maintenance module that renames the sent-mail folder.
*
* @author  Michael Slusarz <slusarz@bigworm.colorado.edu>
* @version $Revision: 1.2.2.2 $
* @since   IMP 2.3.7
* @package horde.maintenance
*/
class Maintenance_Task_rename_sentmail_monthly extends Maintenance_Task {

    /**
     * Rename the old sent-mail folders.
     *
     * @access public
     *
     * @return boolean $status  Whether all sent-mail folders were renamed.
     *
     */
    function doMaintenance()
    {
        global $imp, $prefs;

        include_once IMP_BASE . '/lib/Folder.php';
        include_once IMP_BASE . '/lib/Identity/IMP.php';
        $identity = new Identity_IMP();
        $folder_list = $identity->getAllSentmailfolders();
        
        /* Get rid of duplicates */
        $folder_list = array_flip(array_flip($folder_list));

        $success = true;
        foreach ($folder_list as $sent_folder) {
            /* Display a message to the user and rename the folder.
               Only do this if sent-mail folder currently exists. */
            if (IMP_Folder::exists($imp['stream'], IMP::preambleString() . $sent_folder)) {
                $old_folder = Maintenance_Task_rename_sentmail_monthly::renameSentmailMonthlyName($sent_folder);
                Horde::raiseMessage(sprintf(_("%s folder being renamed at the start of the month."), $sent_folder), HORDE_MESSAGE);
                if (IMP_Folder::exists($imp['stream'], IMP::preambleString() . $old_folder)) {
                    Horde::raiseMessage(sprintf(_("%s already exists. Your %s folder was not renamed."), $old_folder, $sent_folder), HORDE_WARNING);
                    $success = false;
                } else {
                    if (IMP_Folder::rename($imp['stream'], IMP::preambleString() . $sent_folder, IMP::preambleString() . $old_folder, $prefs->getValue('subscribe'))) {
                        // Rebuild folder hash
                        IMP_Folder::exists($imp['stream'], IMP::preambleString() . $sent_folder, true);
                        if (!IMP_Folder::create($imp['stream'], IMP::preambleString() . $sent_folder, $prefs->getValue('subscribe'))) {
                            $success = false;
                        }
                    } else {
                        $success = false;
                    }
                }
            }

        }

        return $success;
    }

    /**
     * Return information for the maintenance function.
     *
     * @access public
     *
     * @return string $info  Description of what the operation is going to do
     *                       during this login.
     */
    function describeMaintenance()
    {
        include_once IMP_BASE . '/lib/Identity/IMP.php';
        $identity = new Identity_IMP();
        $folder_list = $identity->getAllSentmailfolders();

        /* Get rid of duplicates */
        $folder_list = array_flip(array_flip($folder_list));

        $new_folders = $old_folders = array();
        foreach ($folder_list as $folder) {
            if (!empty($folder)) {
                $old_folders[] = $folder;
                $new_folders[] = Maintenance_Task_rename_sentmail_monthly::renameSentmailMonthlyName($folder);
            }
        }

        return sprintf(_("The current folder(s) \"%s\" will be renamed to \"%s\"."), implode(', ', $old_folders), implode(', ', $new_folders));
    }

    /**
     * Determines the name the sent-mail folder will be renamed to.
     * Folder name: sent-mail-month-year
     *   month = 3 letter abbreviation
     *   year  = 4 digit year
     * The folder name needs to be in this specific format (as opposed to a
     *   user-defined one) to ensure that 'delete_sentmail_monthly' processing
     *   can accurately find all the old sent-mail folders.
     *
     * @access private
     *
     * @param string $folder     The name of the sent-mail folder to rename.
     *
     * @return string $new_name  New sent-mail folder name.
     */
    function renameSentmailMonthlyName($folder)
    {
        global $prefs;

        $last_login = $prefs->getValue('last_login');
        if (!isset($last_login) || $last_login == 0) {
            $last_login = mktime(0, 0, 0, date('m') - 1, date('d'));
        }
        return $folder . strtolower(strftime("-%b-%Y", $last_login));
    }

}
?>
