<?php
// $Horde: imp/lib/MIME/Viewer/text.php,v 1.7.2.2 2001/12/03 16:06:12 chuck Exp $

/**
 * The IMP_MIME_Viewer_text class renders out plain text with
 * URLs made into hyperlinks.
 *
 * @author  Anil Madhavapeddy <anil@recoil.org>
 * @version $Revision: 1.7.2.2 $
 * @since   Horde 1.3
 * @package horde.mime.viewer
 */

class IMP_MIME_Viewer_text extends MIME_Viewer {

    /**
     * Render out the currently set contents in HTML format. 
     * The $mime_part class variable has the information to render
     * out, encapsulated in a MIME_Part object.
     */
    function render(&$mime)
    {
        global $conf, $prefs;
        
        include_once HORDE_BASE . '/lib/Text.php';
        
        $text = $this->mime_part->getContents();
    
        $text = str_replace('</A>', '</a>', $text); // make sure that the original message doesn't contain any capital </A> tags, so we can assume we generated them
        $text = str_replace('<A', '<a', $text);     // ditto for open <A> tags
        $text = Text::linkUrls($text, true);
        $text = preg_replace('|([Mm][Aa][Ii][Ll][Tt][Oo]):(\s?)([^\s\?"<]*)(\??)([^\s"<]*[\w+#?/&=])?|e', "'\\1:\\2<A href=\"' . str_replace('&amp;', '&', IMP::composeLink('\\3\\4\\5')) . '\" onmouseover=\"status=\'' . htmlentities(addslashes(sprintf(_(\"Compose Message (%s)\"), '\\3'))) . '\'; return true;\" onmouseout=\"status=\'\';\">\\3\\4\\5</A>'", $text);
        $text = htmlspecialchars($text);
        $text = str_replace('&lt;A href=&quot;', '<a class="fixed" href="', $text);
        $text = str_replace('&quot; target=&quot;_blank&quot;&gt;', '" target="_blank">', $text);
        $text = str_replace('&quot; onmouseover=&quot;', '" onmouseover="', $text);
        $text = str_replace('&quot; onmouseout=&quot;', '" onmouseout="', $text);
        $text = str_replace('&quot;&gt;','">', $text);
        $text = str_replace('\');&quot;&gt;', '\');">', $text);
        $text = str_replace('&lt;/A&gt;', '</a>', $text); // only reconvert capital /A tags - the ones we generated
    
        // highlight quoted parts of an email
        $text = implode("\r\n", preg_replace('|^(\s*&gt;.+)$|', '<span class="quoted">\1</span>', explode("\r\n", $text)));

        // filter bad language
        if ($prefs->getValue('filtering')) {
            include_once HORDE_BASE . '/lib/Text.php';
            $text = Text::filter($text, $conf['msg']['filtering']['words'],
                $conf['msg']['filtering']['replacement']);
        }

        // wordwrap
        $text = str_replace("\t", '        ', $text);
        $text = str_replace('  ', ' &nbsp;', $text);
        $text = str_replace("\n ", "\n&nbsp;", $text);
        if ($text[0] == ' ') $text = '&nbsp;' . substr($text, 1);
        $text = nl2br($text);
        $text = '<p class="fixed">' . $text . '</p>';
        
        /* If the text is in a different character set, and we're not
           already in a new window, give the user a link to open it in
           a new window with the right character set. */
        if (strtolower($mime->charset) != strtolower($GLOBALS['registry']->getCharset()) &&
            strtolower($mime->charset) != 'us-ascii' &&
            !strstr($GLOBALS['HTTP_SERVER_VARS']['SCRIPT_NAME'], 'view.php')) {
            include_once HORDE_BASE . '/lib/SessionCache.php';
            
            $text = sprintf(_("<p><i>This message was written in a character set other than your own. If it is not displayed correctly, %sclick here</a> to open it in a new window.</i></p>\n"),
                            Horde::link('', sprintf(_("View %s"), $mime->description), null, null, "view('" . VIEW_ATTACH . "', '" . $mime->imap_id . "', '" . SessionCache::putObject($mime) . "'); return false;")) . $text;
        }

        return $text;
    }

    /**
     * Return text/html as the content-type 
     * @return string "text/html" constant
     */
    function getType() {
        return 'text/html';
    }
    
    function getCharset($mime) {
        return !empty($mime->charset) ? $mime->charset : $GLOBALS['registry']->getCharset();
    }
}
