<?php
// $Horde: imp/lib/MIME/Viewer/html.php,v 1.4.2.3 2002/01/02 04:02:20 jon Exp $

/**
 * The IMP_MIME_Viewer_html class renders out plain text with
 * URLs made into hyperlinks.
 *
 * @author  Anil Madhavapeddy <anil@recoil.org>
 * @version $Revision: 1.4.2.3 $
 * @since   Horde 1.3
 * @package horde.mime.viewer
 */

class IMP_MIME_Viewer_html extends MIME_Viewer {

    /**
     * Render out the currently set contents in HTML format. 
     * The $mime_part class variable has the information to render
     * out, encapsulated in a MIME_Part object.
     */
    function render(&$mime)
    {
        $data = $this->mime_part->getContents();
    
        /* These regular expressions attempt to make html safe for
         * viewing. THEY ARE NOT PERFECT. If you enable html viewing, you
         * are opening a security hole. With the current state of the web,
         * I believe that the best we can do is to make sure that people
         * _know_ html is a security hole, clean up what we can, and leave
         * it at that. */
    
        /* Deal with <base> tags in the HTML, since they will screw up our
           own relative paths. */
        if (($i = stristr($data, '<base ')) && ($i = stristr($i, 'http')) && ($j = strchr($i, '>'))) {
            $base = substr($i, 0, strlen($i) - strlen($j));
            $base = preg_replace('|(http.*://[^/]*/?).*|', '\1', $base);
            
            if ($base[strlen($base) - 1] != '/')
                $base .= '/';
        }

        /* Nuke non-printing characters. */
        $data = preg_replace('/(&#13;|&#9;|&#013|&#09;)/', '', $data);
    
        /* Get all attribute="javascript:foo()" tags. */
        $data = preg_replace('/=\s*([^>]*)(\w*)\s*s\s*(&#99;|&#099;|&#099|c)\s*r\s*i\s*p\s*t\s*:/i', '=\1cleaned', $data);

        /* Get all on<foo>="bar()" tags. */
        $data = preg_replace('/(\s+[Oo][Nn]\w+)=/', '\1Cleaned=', $data);
    
        /* Get all tags that might cause trouble - <script>, <embed>,
           etc. Meta refreshes and iframes, too. */
        $malicious = array('|<([^>]*)s\s*c\s*r\s*i\s*p\s*t|i',
               '|<([^>]*)embed|i',
               '|<([^>]*)meta|i',
               '|<([^>]*)j\sa\sv\sa|i',
               '|<([^>]*)object|i',
               '|<([^>]*)iframe|i',
               '|<([^>]*)style|i');
        $data = preg_replace($malicious, '<cleaned_tag', $data);
    
        /* A few other matches. */
        $data = preg_replace('|<([^>]*)&{.*}([^>]*)>|', '<&{;}\3>', $data);
        $data = preg_replace('|<([^>]*)mocha:([^>]*)>|i', '<cleaned\2>', $data);
    
        /* Attempt to fix paths that were relying on a <base> tag. */
        if (!empty($base)) {
            $data = preg_replace('|src="/|i', 'src="' . $base, $data);
            $data = preg_replace('|src=\'/|i', 'src=\'' . $base, $data);
            $data = preg_replace('|src=[^\'"]/|i', 'src=' . $base, $data);
            
            $data = preg_replace('|href= *"/|i', 'href="' . $base, $data);
            $data = preg_replace('|href= *\'/|i', 'href=\'' . $base, $data);
            $data = preg_replace('|href= *[^\'"]/|i', 'href=' . $base, $data);
        }
    
        /* Search for inlined images that we can display. */
        global $MimeID, $imp;
        if (isset($MimeID)) {
            foreach ($MimeID as $ref => $id) {
                if (strlen($id) > 0) {
                    if ($id[0] == '<') $id = substr($id, 1);
                    if ($id[strlen($id) - 1] == '>') $id = substr($id, 0, strlen($id)-1);
                    $data = str_replace("cid:$id", Horde::url('view.php?actionID=' . VIEW_ATTACH . '&index=' . $mime->index . '&mailbox=' . urlencode($imp['mailbox']) . '&id=' . $ref), $data);
                }
            }
        }
    
        /* Convert links to open in new windows. */
        $data = str_replace('<a', '<a target="_blank"', $data);
        $data = str_replace('<A', '<a target="_blank"', $data);
    
        return $data;
    }    

    /**
     * Return text/html as the content-type 
     * @return string "text/html" constant
     */
    function getType() {
        return 'text/html';
    }
}
