<?php
/*
 * $Horde: imp/identities.php,v 2.15.2.6 2002/01/02 17:05:26 jan Exp $
 *
 * Copyright 2001-2002 Jan Schneider <jan@ammma.de>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

define('IDENT_EDIT',   1);
define('IDENT_SAVE',   2);
define('IDENT_DELETE', 3);
define('IMP_BASE', dirname(__FILE__));
require_once IMP_BASE . '/lib/base.php';
require_once IMP_BASE . '/lib/Identity/IMP.php';

if (($reason = IMP::authenticate(OP_HALFOPEN, true)) !== true) {
    header('Location: ' . Horde::applicationUrl(IMP::logoutUrl('login.php', $reason), true));
    exit;
}

$identity = new Identity_IMP();

// redirect user if not allowed to change anything
if ($identity->isLocked()) {
    header('Location: ' . Horde::applicationUrl('prefs.php?group=personal', true));
    exit;
}

$actionID = Horde::getFormData('actionID', NO_ACTION);

// handle clients without javascript
if ($actionID == NO_ACTION) {
    if (isset($HTTP_POST_VARS['edit']))
        $actionID = IDENT_EDIT;
    elseif (isset($HTTP_POST_VARS['save']))
        $actionID = IDENT_SAVE;
    elseif (isset($HTTP_POST_VARS['delete']))
        $actionID = IDENT_DELETE;
    elseif (isset($HTTP_POST_VARS['back'])) {
        header('Location: ' . Horde::applicationUrl('prefs.php?group=personal', true));
        exit;
    }
}

if ($actionID == NO_ACTION && $prefs->isLocked('default_identity')) {
    $actionID = IDENT_EDIT;
    $HTTP_POST_VARS['identity'] = $identity->getDefault();
}

/* Run through the action handlers */
if (isset($actionID)) {
    switch ($actionID) {
        
    case NO_ACTION:
        break;
        
    case IDENT_EDIT:
        if ($HTTP_POST_VARS['identity'] !== '') {
            $to_edit = $HTTP_POST_VARS['identity'];
        }
        break;
        
    case IDENT_SAVE:
        $edit_identity = Horde::getFormData('edit_identity');
        if (!isset($edit_identity) || $edit_identity == '') {
            $edit_identity = $identity->add();
        }
        $old_default = $identity->getDefault();
        $identity->setDefault($edit_identity);
        
        $id = Horde::getFormData('id');
        if (isset($id) && !empty($id)) {
            $identity->setValue('id', $id);
        } else {
            $identity->setValue('id', _("Unnamed"));
            $id = _("Unnamed");
        }
        
        $identity->setValue('fullname', Horde::getFormData('fullname'));
        $identity->setValue('from_addr', Horde::getFormData('from_addr'));
        $identity->setValue('replyto_addr', Horde::getFormData('replyto_addr'));
        
        $identity->setValue('signature', Horde::getFormData('signature'));
        $identity->setValue('sig_dashes', Horde::getFormData('sig_dashes', 0));
        $identity->setValue('sig_first', Horde::getFormData('sig_first', 0));
        
        $identity->setValue('save_sent_mail', Horde::getFormData('save_sent_mail', 0));
        $sent_mail_folder = Horde::getFormData('sent_mail');
        $sent_mail_new = Horde::getFormData('sent_mail_new');
        if ($conf['user']['allow_folders'] && !$prefs->isLocked('sent_mail_folder')) {
            if (empty($sent_mail_folder) && !empty($sent_mail_new)) {
                $sent_mail_folder = $sent_mail_new;
                include_once IMP_BASE . '/lib/Folder.php';
                IMP_Folder::create($imp['stream'], IMP::preambleString() . $sent_mail_folder, $prefs->getValue('subscribe'));
            } elseif (substr($sent_mail_folder, 0, strlen(IMP::preambleString())) == IMP::preambleString()) {
                $sent_mail_folder = substr($sent_mail_folder, strlen(IMP::preambleString()));
            }
            $identity->setValue('sent_mail_folder', $sent_mail_folder);
        }
        
        $identity->setValue('private_key', Horde::getFormData('private_key'));
        $identity->setValue('private_key_type', Horde::getFormData('private_key_type'));
        
        $identity->setDefault($old_default);
        $identity->save();
        
        if ($prefs->isLocked('default_identity')) {
            $to_edit = $HTTP_POST_VARS['identity'];
        }
        
        Horde::raiseMessage(sprintf(_("The identity \"%s\" has been saved."), $id), HORDE_SUCCESS);
        break;

    case IDENT_DELETE:
        $to_delete = Horde::getFormData('identity');
        if ($to_delete != -1) {
            $deleted_identity = $identity->delete($to_delete);
            Horde::raiseMessage(sprintf(_("The identity \"%s\" has been deleted."), $deleted_identity[0]['id']), HORDE_SUCCESS);
        } else {
            Horde::raiseMessage(_("You must select an identity to be deleted."), HORDE_WARNING);
        }
        break;

    } // switch
} // isset($actionID)

$title = _("Identities");
$identities = $identity->getAll('id');

require $registry->getTemplatePath() . '/common-header.inc';
require IMP_BASE . '/menu.php';
require IMP_BASE . '/status.php';

require $registry->getTemplatePath() . '/identities/javascript.inc';
require $registry->getTemplatePath() . '/identities/manage.inc';

$registry->shutdown();

require $registry->getTemplatePath() . '/common-footer.inc';
?>
