<?php
/*
 * $Horde: imp/compose.php,v 2.369.2.11 2002/01/02 17:05:23 jan Exp $
 *
 * Copyright 1999-2002 Charles J. Hagenbuch <chuck@horde.org>
 * Copyright 1999-2002 Jon Parise <jon@horde.org>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

/**
 * Returns a To:, Cc: or Bcc: list build from a selection based on 'expand names'.
 */
function getAddressList($field)
{
    $to_list = Horde::getFormData($field . '_list');
    $to = Horde::getFormData($field . '_field');
    if (isset($to_list) && is_array($to_list) && is_array($to)) {
        $tmp = array();
        foreach ($to as $key => $address) {
            $address = format_addresses($address);
            $tmp[$key] = $address;
        }
        foreach ($to_list as $key => $address) {
            $address = format_addresses($address);
            if ($address != '') {
                $tmp[$key] = $address;
            }
        }
        $to_new = Horde::getFormData($field . '_new');
        if (!empty($to_new)) {
            $tmp[] = $to_new;
        }
        return implode(', ', $tmp);
    }
}

/**
 * Return an url for mailbox.php depending on what kind of start/page
 * information we have.
 */
function mailboxReturnURL()
{
    $url = 'mailbox.php?';
    
    if (($start = Horde::getFormData('start'))) {
        $url .= 'start=' . urlencode($start) . '&';
    }
    
    if (($page = Horde::getFormData('page'))) {
        $url .= 'page=' . urlencode($page) . '&';
    }
    
    return substr($url, 0, -1);
}

/*
 * TODO: write function description
 */
function findBody(&$attachments)
{
    foreach ($attachments as $mime) {
        if ($mime->type == TYPETEXT) {
            return IMP::getDecodedPart($mime);
        }
    }

    return '';
}

/**
 * Use the Registry to expand names and, if $full is true, generate a
 * full, rfc822-valid address list, returning error information for
 * any address that is either not valid or fails to expand.
 */
function expandAddresses($addrString, $full = false)
{
    if (!preg_match('|[^\s]|', $addrString)) {
        return '';
    }
    
    $addrString = preg_replace('/,\s+/', ',', $addrString);

    global $registry, $prefs;
    
    include_once 'Mail/RFC822.php';
    $parser = new Mail_RFC822(null, '@INVALID');
    
    $src = explode("\t", $prefs->getValue('search_sources'));
    if (count($src) == 1 && empty($src[0])) {
        $src = array();
    }
    
    $search_fields = array();
    $search_field_pref = $prefs->getValue('search_fields');
    if (!empty($search_field_pref)) {
        $field_arr = explode("\n", $prefs->getValue('search_fields'));
        foreach ($field_arr as $field) {
            $field = trim($field);
            if (!empty($field)) {
                $tmp = explode("\t", $field);
                if (count($tmp) > 1) {
                    $source = array_splice($tmp, 0, 1);
                    $search_fields[$source[0]] = $tmp;
                }
            }
        }
    }
    
    $arr = explode(',', $addrString);
    $results = $registry->call('contacts/search', array($arr, $src, $search_fields));
    if (PEAR::isError($results)) {
        return $results;
    }
    $i = 0;
    $error = false;
    $ambigous = false;
    $missing = array();
    foreach ($results as $res) {
        $tmp = $arr[$i];
        if ($parser->validateMailbox(MIME::encodeAddress($tmp, null, ''))) {
            // noop
        } elseif (count($res) == 1) {
            if ($full) {
                if (strpos($res[0]['email'], ',') !== false) {
                    $arr[$i] = $res[0]['name'] . ': ' . $res[0]['email'] . ';';
                } else {
                    list($mbox, $host) = explode('@', $res[0]['email']);
                    $arr[$i] = imap_rfc822_write_address($mbox, $host, $res[0]['name']);
                }
            } else {
                $arr[$i] = $res[0]['name'];
            }
        } elseif (count($res) > 1) {
            // Handle the multiple case - we return an array with all found addresses.
            $arr[$i] = array($arr[$i]);
            foreach ($res as $one_res) {
                if ($full) {
                    if (strpos($one_res['email'], ',') !== false) {
                        $arr[$i][] = $one_res['name'] . ': ' . $one_res['email'] . ';';
                    } else {
                        $mbox_host = explode('@', $one_res['email']);
                        if (isset($mbox_host[1])) {
                            $arr[$i][] = imap_rfc822_write_address($mbox_host[0], $mbox_host[1], $one_res['name']);
                        }
                    }
                } else {
                    $arr[$i][] = $one_res['name'];
                }
            }
            $ambigous = true;
        } else {
            // Handle the missing/invalid case - we should return error info
            // on each address that couldn't be expanded/validated.
            $error = true;
            if (!$ambigous) {
                $arr[$i] = new PEAR_Error(null, null, null, null, $arr[$i]);
                $missing[$i] = $arr[$i];
            }
        }
        $i++;
    }
    
    if ($ambigous) {
        foreach ($missing as $i => $addr) {
            $arr[$i] = $addr->getUserInfo();
        }
        return $arr;
    } elseif ($error) {
        return new PEAR_Error(_("Please resolve ambiguous or invalid addresses."), null, null, null, $res);
    } else {
        return implode(', ', $arr);
    }
}

function cleanExpandedAddressList($list)
{
    $results = array();
    if (is_array($list)) {
        foreach ($list as $entry) {
            if (is_object($entry)) {
                $results[] = $entry->getUserInfo();
            } else {
                $results[] = $entry;
            }
        }
    }
}

/*
 * Make sure a path is inside of the upload directory.
 */
function tempFilePath($file) {
    return Horde::getTempDir() . '/' . basename($file);
}

/*
 * Checks for non-standard address formats, such as separating with
 * spaces or semicolons.
 */
function format_addresses($address_string)
{
    /*
     * If there are angle brackets (<>), or a colon (group name
     * delimiter), assume the user knew what they were doing.
     */
    if ((strpos($address_string, '>') === false) &&
        (strpos($address_string, ':') === false)){
        $address_string = trim(strtr($address_string, ';,', '  '));
        $address_string = preg_replace('|\s+|', ', ', $address_string);
    }
    return $address_string;
}

/*
 * Encodes attachments for a message being sent or saved.
 */
function addMimeParts(&$message)
{
    global $HTTP_POST_VARS, $imp;
    
    if (isset($HTTP_POST_VARS['attachments_name']) && count($HTTP_POST_VARS['attachments_name']) > 0) {
        $index = Horde::getFormData('index');
        if (!empty($index)) {
            include_once HORDE_BASE . '/lib/MIME/Structure.php';
            $structure = imap_fetchstructure($imp['stream'], $index, FT_UID);
            $attachments = MIME_Structure::parse($structure, $index, $MimeID);
        }
        
        for ($i = 0; $i < count($HTTP_POST_VARS['attachments_name']); $i++) {
            /* Read it from the filesystem if it's a normal
               attachment, and then delete the temp file. */
            if (!preg_match('|.*-(.*).mime$|', $HTTP_POST_VARS['attachments_file'][$i], $regs)) {
                $filename = tempFilePath($HTTP_POST_VARS['attachments_file'][$i]);
                $fd = fopen($filename, 'rb');
                $contents = fread($fd, filesize($filename));
                fclose($fd);
                unlink($filename);
            } else {
                /* Fetch it from the mail message content if it's a
                 * forwarded attachment. */
                $ref = $regs[1];
                $fmime = $attachments[$ref];
                $contents = IMP::getDecodedPart($fmime);
            }
            
            include_once HORDE_BASE . '/lib/MIME/Message.php';
            $part = new MIME_Part();
            
            /* Some browsers do not send the mime type. */
            if (strcmp($HTTP_POST_VARS['attachments_type'][$i], '')) { 
                $part->setType($HTTP_POST_VARS['attachments_type'][$i]);
            } else {
                $part->setType('application/octet-stream');
            }
            
            $part->setName($HTTP_POST_VARS['attachments_name'][$i]);
            
            /* Base64-encode all attachments to preserve linebreaks,
               ensure transportability, etc. */
            $contents = chunk_split(base64_encode($contents));
            $part->setTransferEncoding('base64');
            $part->setContents($contents);
            $message->addPart($part);
        }
    }
}

/*
 * Adds the attachments to the message (in the case of a forward with
 * attachments).
 */
function attachFiles($structure, $ref)
{
    global $HTTP_POST_VARS;
    
    include_once HORDE_BASE . '/lib/MIME/Structure.php';
    $attachments = MIME_Structure::parse($structure, Horde::getFormData('index'), $MimeID);
    foreach ($attachments as $ref => $mime) {
        if ($ref != 1 || $mime->type != TYPETEXT) {
            if (!$mime->header) {
                $HTTP_POST_VARS['attachments_name'][] = $mime->name;
                $HTTP_POST_VARS['attachments_size'][] = $mime->bytes;
                $HTTP_POST_VARS['attachments_file'][] = Horde::getFormData('index') . '-' . $ref . '.mime';
                $HTTP_POST_VARS['attachments_type'][] = $mime->TYPE . '/' . $mime->subtype;
            }
        }
    }
}

define('IMP_BASE', dirname(__FILE__));

$session_control = 'netscape';
require_once IMP_BASE . '/lib/base.php';
require_once IMP_BASE . '/lib/version.php';
require_once IMP_BASE . '/lib/Folder.php';
require_once HORDE_BASE . '/lib/Menu.php';
require_once HORDE_BASE . '/lib/MIME.php';
require_once HORDE_BASE . '/lib/Text.php';
require_once IMP_BASE . '/lib/Identity/IMP.php';
require_once 'PEAR.php';

if (($reason = IMP::authenticate(null, true)) !== true) {
    if (Horde::getFormData('popup')) {
        echo '<script language="JavaScript" type="text/javascript">window.close()</script>';
    } else {
        header('Location: ' . Horde::applicationUrl(IMP::logoutUrl('login.php', $reason), true));
    }
    exit;
}

$get_sig = true;
$identity = new Identity_IMP();
$sent_mail_folder = $identity->getValue('sent_mail_folder', Horde::getFormData('identity'));
$actionID = Horde::getFormData('actionID', NO_ACTION);

/* Translate non-int values into the correct int. */
if (strcspn($actionID, '0123456789')) {
    $actionID = $actions[$actionID];
}

/* Set the current time zone. */
if ($prefs->getValue('timezone') != '') {
    putenv('TZ=' . $prefs->getValue('timezone'));
}

/* Run through the action handlers. */
switch ($actionID) {
 case NO_ACTION:
     $ACTION_TEXT = _("Message Composition");
     break;
    
 case COMPOSE:
     if (isset($HTTP_GET_VARS['to'])) {
         $to = MIME::decode($HTTP_GET_VARS['to']);
     }
     if (isset($HTTP_GET_VARS['subject'])) {
         $subject = MIME::decode($HTTP_GET_VARS['subject']);
     }
     $ACTION_TEXT = _("Compose a message");
     break;
    
 case MAILTO:
     if (!empty($HTTP_GET_VARS['index'])) {
         $h = @imap_header($imp['stream'], imap_msgno($imp['stream'], $HTTP_GET_VARS['index']));
         if (isset($mailto) && isset($h->$mailto)) {
             $to = MIME::decode($h->$mailto);
         } else if (!empty($h->reply_to)) {
             $to = IMP::addrArray2String($h->reply_to);
         } else if (isset($h->from)) {
             $to = IMP::addrArray2String($h->from);
         } else {
             $to = '';
         }
         $ACTION_TEXT = _("Compose a message");
     }
     break;
    
 case DRAFT:
     if (!empty($HTTP_GET_VARS['index'])) {
         $h = imap_header($imp['stream'], imap_msgno($imp['stream'], $HTTP_GET_VARS['index']));

         if (is_object($h)) {
             if (isset($h->from)) {
                 $from_tmp = IMP::addrArray2String($h->from);
                 $from_list = $identity->getAllFromAddresses();
                 $default = $identity->getDefault();
                 if (isset($from_list[$default]) && strstr(strtolower($from_tmp), strtolower($from_list[$default]))) {
                     $HTTP_GET_VARS['identity'] = $default;
                 } else {
                     foreach ($from_list as $id => $from_item) {
                         if (strstr(strtolower($from_tmp), strtolower($from_item))) {
                             $HTTP_GET_VARS['identity'] = $id;
                         }
                     }
                 }
             }
             if (isset($h->to)) {
                 $to = IMP::addrArray2String($h->to);
             }
             if (isset($h->cc)) {
                 $cc = IMP::addrArray2String($h->cc);
             }
             if (isset($h->bcc)) {
                 $bcc = IMP::addrArray2String($h->bcc);
             }
             if (isset($h->reply_to)) {
                 $reply_to = IMP::addrArray2String($h->reply_to);
             }
             if (isset($h->subject)) {
                 $subject = MIME::decode($h->subject);
             }
         }
         
         include_once HORDE_BASE . '/lib/MIME/Structure.php';
         $structure = @imap_fetchstructure($imp['stream'], $HTTP_GET_VARS['index'], FT_UID);
         $attachments = MIME_Structure::parse($structure, $HTTP_GET_VARS['index'], $MimeID);
         $msg = "\n" . findBody($attachments);
         if ($qprint_msg = imap_qprint($msg)) {
             $msg = $qprint_msg;
         }
         if (@count($structure->parts) > 1) {
             attachFiles($structure, '');
         }
         
         $ACTION_TEXT = _("Compose a message");
     }
     $get_sig = false;
     break;
     
 case EXPAND_ADDRESSES:
     $to  = expandAddresses(Horde::getFormData('to', getAddressList('to')), true);
     $cc  = expandAddresses(Horde::getFormData('cc', getAddressList('cc')), true);
     $bcc = expandAddresses(Horde::getFormData('bcc', getAddressList('bcc')), true);
     
     if (is_array($to) || is_array($cc) || is_array($bcc)) {
         Horde::raiseMessage(_("Please resolve ambiguous or invalid addresses."), HORDE_MESSAGE);
     }
     
     if (PEAR::isError($to)) {
         $to_errors = $to;
         $to = cleanExpandedAddressList($to_errors->getUserInfo());
         Horde::raiseMessage($to_errors->getMessage(), HORDE_MESSAGE);
     }
     if (PEAR::isError($cc)) {
         $cc_errors = $cc;
         $cc = cleanExpandedAddressList($cc_errors->getUserInfo());
         Horde::raiseMessage($cc_errors->getMessage(), HORDE_MESSAGE);
     }
     if (PEAR::isError($bcc)) {
         $bcc_errors = $bcc;
         $bcc = cleanExpandedAddressList($bcc_errors->getUserInfo());
         Horde::raiseMessage($bcc_errors->getMessage(), HORDE_MESSAGE);
     }
     
     $get_sig = false;
     break;
     
 case REPLY:
 case REPLY_ALL:
     if (!empty($HTTP_GET_VARS['index'])) {
         $h = imap_header($imp['stream'], imap_msgno($imp['stream'], $HTTP_GET_VARS['index']));
 
         /* Set the message_id and references headers. */
         if (isset($h->message_id)) {
             $HTTP_POST_VARS['in_reply_to'] = chop($h->message_id);
             if (isset($h->references)) {
                 $HTTP_POST_VARS['references'] = chop($h->references) . ' ' . $HTTP_POST_VARS['in_reply_to'];
             } else {
                 $HTTP_POST_VARS['references'] = $HTTP_POST_VARS['in_reply_to'];
             }
         } else {
             $HTTP_POST_VARS['in_reply_to'] = '';
             $HTTP_POST_VARS['references'] = '';
         }

         // Set headers.
         if ($actionID == REPLY) {
             if (isset($h->reply_to)) {
                 $to = IMP::addrArray2String($h->reply_to);
             } elseif (isset($h->from)) {
                 $to = IMP::addrArray2String($h->from);
             } else {
                 $to = '';
             }
         } else {
             // filter out our own address from the addresses we reply to
             $me = $identity->getAllFromAddresses();
             
             // build the to: header
             if (isset($h->reply_to)) {
                 $to_arr = $h->reply_to;
                 $to = $reply = IMP::addrArray2String($to_arr);
                 if (isset($h->from) && IMP::addrArray2String($h->from, $reply)) {
                     $to_arr = array_merge($to_arr, $h->from);
                     $to = IMP::addrArray2String($to_arr);
                 }
             } else if (isset($h->from)) {
                 $to = $reply = IMP::addrArray2String($h->from);
             } else {
                 $to = $reply = '';
             }
             
             // build the cc: header
             $cc_arr = array();
             if (isset($h->to) && ($reply != IMP::addrArray2String($h->to))) {
                 $cc_arr = $h->to;
                 if (isset($h->cc)) {
                     $cc_arr = array_merge($cc_arr, $h->cc);
                 }
             } else if (isset($h->cc)) {
                 $cc_arr = $h->cc;
             }
             $cc = IMP::addrArray2String($cc_arr, $me);
             
             // build the bcc: header
             if (isset($h->bcc)) {
                 $bcc = IMP::addrArray2String($h->bcc, $me);
             }
         }
        
         if (isset($h->from)) {
             $qfrom = IMP::addrArray2String($h->from);
         } else {
             $qfrom = '&lt;&gt;';
         }
        
         include_once HORDE_BASE . '/lib/MIME/Structure.php';
         $structure = imap_fetchstructure($imp['stream'], $HTTP_GET_VARS['index'], FT_UID);
         $attachments = MIME_Structure::parse($structure, $HTTP_GET_VARS['index'], $MimeID);
         
         $quote_str = "\n" . rtrim($prefs->getValue('quote_prefix')) . ' ';
         $msg = findBody($attachments);
         $wrap_width = $prefs->getValue('wrap_width') - strlen($quote_str);
         if ($wrap_width < 20) {
             $wrap_width = 20;
         }
         $msg = Text::wrap($msg, $wrap_width, $quote_str);
         $msg  = _("Quoting") . ' ' . $qfrom . ":\n$quote_str$msg";
         $msg .= "\n";
        
         if (isset($h->subject) && (strtolower(substr(MIME::decode($h->subject), 0, 3)) != 're:')) {
             $subject = 'Re: ' . MIME::decode($h->subject);
         } else if (isset($h->subject)) {
             $subject = MIME::decode($h->subject);
         } else {
             $subject = 'Re: ';
         }
         
         if ($actionID == REPLY) {
             $ACTION_TEXT = _("Reply:") . ' ' . $subject;
         } else {
             $ACTION_TEXT = _("Reply to All:") . ' ' . $subject;
         }
     }
     break;
    
 case FORWARD:
     if (!empty($HTTP_GET_VARS['index'])) {
         $h = imap_header($imp['stream'], imap_msgno($imp['stream'], $HTTP_GET_VARS['index']));
         if (isset($h->from[0])) {
             $message_source = IMP::addrObject2String($h->from[0]);
         } else {
             $message_source = '';
         }
        
         $msg  = "\n\n";
         $msg .= "\n----- "; 
         $msg .= sprintf(_("Forwarded message from %s"), $message_source);
         $msg .= " -----\n";
        
         if (isset($h->date) && $h->date) {
             $msg .= _("    Date: ") . MIME::decode($h->date);
             $msg .= "\n";
         }
         if (isset($h->from) && is_array($h->from)) {
             $msg .= _("    From: ") . IMP::addrArray2String($h->from);
             $msg .= "\n";
         }
         if (isset($h->reply_to) && is_array($h->reply_to)) {
             $msg .= _("Reply-To: ") . IMP::addrArray2String($h->reply_to);
             $msg .= "\n";
         }
         if (isset($h->subject) && $h->subject) {
             $msg .= _(" Subject: ") . MIME::decode($h->subject);
             $msg .= "\n";
         }
         if (isset($h->to) && is_array($h->to)) {
             $msg .= _("      To: ") . IMP::addrArray2String($h->to);
             $msg .= "\n";
         }
         
         include_once HORDE_BASE . '/lib/MIME/Structure.php';
         $structure = imap_fetchstructure($imp['stream'], $HTTP_GET_VARS['index'], FT_UID);
         $attachments = MIME_Structure::parse($structure, $HTTP_GET_VARS['index'], $MimeID);
         $msg .= "\n";
         $msg .= findBody($attachments);
         $msg .= "\n----- " . _("End forwarded message") . " -----\n";
         if ($qprint_msg = imap_qprint($msg)) {
             $msg = $qprint_msg;
         }
        
         if (isset($h->subject)) {
             $subject = _("Fwd:") . ' ' . MIME::decode($h->subject);
             $ACTION_TEXT = _("Forward:") . ' ' . MIME::decode($h->subject);
         } else {
             $subject = _("Fwd:");
             $ACTION_TEXT = _("Forward");
         }
         
         attachFiles($structure, '');
     }
     break;

 case BOUNCE_MESSAGE:
     if (!empty($HTTP_POST_VARS['index']) && ($f_to = Horde::getFormData('to'))) {
         $recipients = $f_to;
         
         $orig_headers = @imap_fetchheader($imp['stream'], $HTTP_POST_VARS['index'], FT_UID);
         $orig_headers = str_replace("\r", '', $orig_headers);
         $header_arr = explode("\n", $orig_headers);
         
         foreach ($header_arr as $header) {
             if (!empty($header) && $header != "\n") {
                 if (preg_match('|^([-\w]*): (.*)|', $header, $pieces)) {
                     if (isset($headers[$pieces[1]])) {
                         $headers[$pieces[1]] .= "\n" . $header;
                     } else {
                         $headers[$pieces[1]] = $pieces[2];
                     }
                     $last = $pieces[1];
                 } else {
                     $headers[$last] .= "\n" . $header;
                 }
             }
         }
        
         $headers['Resent-Date'] = date('r');
         $headers['Resent-From'] = $identity->getFromAddress();
         $headers['Resent-To'] = $f_to;
         $headers['Resent-Message-ID'] = '<' . uniqid(time() . '.') . '@' . $registry->getParam('server_name') . '>';
         IMP::addSiteHeaders($headers);
        
         $msg = @imap_body($imp['stream'], $HTTP_POST_VARS['index'], FT_UID);
        
         include_once 'Mail.php';
         if (!empty($imp['smtphost'])) {
             $conf['mailer']['params']['host'] = $imp['smtphost'];
         }
         $mailer = &Mail::factory($conf['mailer']['type'], $conf['mailer']['params']);
         $status = $mailer->send($recipients, $headers, $msg);
         if (!PEAR::isError($status)) {
             $entry = sprintf("%s Redirected message sent to %s from %s",
                              $HTTP_SERVER_VARS['REMOTE_ADDR'], $recipients, $imp['user']);
             Horde::logMessage($entry, __FILE__, __LINE__, LOG_INFO);
             
             if (($prefs->getValue('compose_popup') || Horde::getFormData('popup'))
                 && $browser->hasFeature('javascript')) {
                 echo '<script language="JavaScript" type="text/javascript">window.close();</script>';
             } else {
                 header('Location: ' . Horde::applicationUrl(mailboxReturnURL()));
             }
             exit;
         } else {
             Horde::logMessage($status->getMessage(), __FILE__, __LINE__, LOG_ERR);
         }
         $actionID = BOUNCE_COMPOSE;
         Horde::raiseMessage(_("Redirecting failed."));
     }
     break;
    
 case SEND_MESSAGE:
     $message = Horde::getFormData('message', '');
     $f_to = Horde::getFormData('to', getAddressList('to'));
     $f_cc = Horde::getFormData('cc', getAddressList('cc'));
     $f_bcc = Horde::getFormData('bcc', getAddressList('bcc'));
     
     if (empty($f_to) && empty($f_cc) && empty($f_bcc)) {
         $get_sig = false;
         Horde::raiseMessage(_("You must have at least one recipient."), HORDE_ERROR);
         break;
     } else {
         include_once HORDE_BASE . '/lib/MIME/Message.php';
         $mime = new MIME_Message($imp['maildomain']);
         
         $message = str_replace("\r\n", "\n", $message);
         $body = new MIME_Part('text/plain', $message);
         
         // Append trailer text to $body.
         if ($conf['msg']['append_trailer'] && @is_readable(IMP_BASE . '/config/trailer.txt')) {
             $trailer = "\n";
             $trailer .= implode(@file(IMP_BASE . '/config/trailer.txt'), '');
             $trailer = Text::expandEnvironment($trailer);
             $body->appendContents($trailer);
         }
         
         $mime->addPart($body);
         addMimeParts($mime);
         $msg = $mime->toString();
         
         $recipients = '';
         $from = $identity->getFromLine();
         $from_info = imap_rfc822_parse_adrlist($from, $imp['maildomain']);
         $barefrom = $from_info[0]->mailbox . '@' . $from_info[0]->host;
         
         // add a Received header for the hop from browser to server.
         $remote = (!empty($HTTP_SERVER_VARS['REMOTE_HOST'])) ? $HTTP_SERVER_VARS['REMOTE_HOST'] : $HTTP_SERVER_VARS['REMOTE_ADDR'];
         $headers['Received'] = 'from ' . $remote . ' (';
         if (!empty($HTTP_SERVER_VARS['REMOTE_IDENT'])) $headers['Received'] .= $HTTP_SERVER_VARS['REMOTE_IDENT'] . '@' . $remote;
         $headers['Received'] .= ' [' . $remote . '])';
         $headers['Received'] .= "\n\t" . 'as user ' . $imp['user'] . '@' . $imp['server'];
         $headers['Received'] .= ' by ' . $registry->getParam('server_name') . ' with HTTP;';
         $headers['Received'] .= "\n\t" . date('r');
         
         $headers['Message-ID'] = '<' . uniqid(time() . '.') . '@' . $registry->getParam('server_name') . '>';
         $headers['Date'] = date('r');
         
         if ($conf['compose']['allow_receipts'] &&
             !empty($HTTP_POST_VARS['request_return_receipt'])) {
             $headers['Disposition-Notification-To'] = $barefrom;
         }
         
         $headers['From'] = $from;
         
         $identity->setDefault(Horde::getFormData('identity'));
         $replyto = $identity->getValue('replyto_addr');
         if (!empty($replyto) && $replyto != $barefrom) {
             $headers['Reply-to'] = $replyto;
         }
         if (!empty($f_to)) {
             $f_to = format_addresses($f_to);
             $headers['To'] = $f_to;
             $recipients = $f_to;
         }
         if ($conf['compose']['allow_cc'] && !empty($f_cc)) {
             $f_cc = format_addresses($f_cc);
             $headers['Cc'] = $f_cc;
             $recipients = (empty($recipients)) ? $f_cc : "$recipients, " . $f_cc;
         }
         if ($conf['compose']['allow_bcc'] && !empty($f_bcc)) {
             $f_bcc = format_addresses($f_bcc);
             $recipients = (empty($recipients)) ? $f_bcc : "$recipients, " . $f_bcc;
         }
         $subject = Horde::getFormData('subject');
         if (!empty($subject)) {
             $headers['Subject'] = $subject;
         }
         if (($ref = Horde::getFormData('references'))) {
             $headers['References'] = $ref;
         }
         if (($irt = Horde::getFormData('in_reply_to'))) {
             $headers['In-Reply-To'] = $irt;
         }
         $headers = $mime->header($headers);
         $headers['User-Agent'] = IMP_NAME . ' ' . IMP_VERSION;
         IMP::addSiteHeaders($headers);
         
         include_once 'Mail.php';
         if (!empty($imp['smtphost'])) {
             $conf['mailer']['params']['host'] = $imp['smtphost'];
         }
         $mailer = &Mail::factory($conf['mailer']['type'], $conf['mailer']['params']);
         $status = $mailer->send(MIME::encodeAddress($recipients, null, $imp['maildomain']), $headers, $msg);
         if (!PEAR::isError($status)) {
             if (!empty($HTTP_POST_VARS['is_reply']) && isset($HTTP_POST_VARS['index'])) {
                 imap_setflag_full($imp['stream'], $HTTP_POST_VARS['index'], '\\ANSWERED', SE_UID);
             }

             $entry = sprintf("%s Message sent to %s from %s",
                              $HTTP_SERVER_VARS['REMOTE_ADDR'], $recipients, $imp['user']);
             Horde::logMessage($entry, __FILE__, __LINE__, LOG_INFO);
             
             if ($identity->saveSentmail()) {
                 /* Keep Bcc: headers on saved messages. */
                 if (!empty($f_bcc)) $headers['Bcc'] = $f_bcc;
                 
                 /* Loop through the envelop and add headers. */
                 reset($headers);
                 $fcc = '';
                 foreach ($headers as $key => $val) {
                     if ($key != 'recipients') {
                         $fcc .= $key . ': ' . $val . "\n";
                     }
                 }
                 $fcc .= "\n";
                 $fcc .= $msg;
                 
                 // Make absolutely sure there are no bare newlines.
                 $fcc = preg_replace("|([^\r])\n|", "\\1\r\n", $fcc);
                 $fcc = str_replace("\n\n", "\n\r\n", $fcc);
                 
                 IMP_Folder::create($imp['stream'], IMP::preambleString() . $identity->getSentmailFolder(), $prefs->getValue('subscribe'));
                 if (!@imap_append($imp['stream'], IMP::serverString() . imap_utf7_encode(IMP::preambleString() . $identity->getSentmailFolder()), $fcc, '\\Seen')) {
                     /* TODO: status(_("Message sent successfully, but not saved to") . $sent_mail_folder); */
                 }
             }
             
             if (($prefs->getValue('compose_popup') || Horde::getFormData('popup'))
                 && $browser->hasFeature('javascript')) {
                 echo '<script language="JavaScript" type="text/javascript">window.close();</script>';
             } else {
                 header('Location: ' . Horde::applicationUrl(mailboxReturnURL()));
             }
             exit;
         } else {
             Horde::logMessage($status->getMessage(), __FILE__, __LINE__, LOG_ERR);
         }
     }
     unset($msg);
     $get_sig = false;
     Horde::raiseMessage(_("There was an error sending your message"), HORDE_ERROR);
     break;

 case SAVE_DRAFT:
     $drafts_folder = $prefs->getValue('drafts_folder');
     if (!empty($drafts_folder)) {
         if (($message = Horde::getFormData('message'))) {
             $message = str_replace("\r\n", "\n", $message);
             
             include_once HORDE_BASE . '/lib/MIME/Message.php';
             $mime = new MIME_Message($imp['maildomain']);
             
             $body = new MIME_Part('text/plain', $message);
             $mime->addPart($body);
             addMimeParts($mime);
             $body = $mime->toString();
         } else {
             $body = '';
         }
         
         $from = $identity->getFromLine();
         
         $hdrs = '';
         if (!empty($from)) {
             $hdrs .= "From: $from\n";
         }
         if (($to = Horde::getFormData('to'))) {
             $hdrs .= "To: $to\n";
         }
         if (($cc = Horde::getFormData('cc'))) {
             $hdrs .= "Cc: $cc\n";
         }
         if (($bcc = Horde::getFormData('bcc'))) {
             $hdrs .= "Bcc: $bcc\n";
         }
         if (($sub = Horde::getFormData('subject'))) {
             $hdrs .= "Subject: $sub\n";
         }
         if (isset($mime)) {
             $env = $mime->header();
             foreach ($env as $key => $val) {
                 $hdrs .= $key . ': ' . $val . "\n";
             }
         }
         $hdrs .= "\n";
         
         $body = $hdrs . $body;
         
         // Make absolutely sure there are no bare newlines.
         $body = preg_replace("|([^\r])\n|", "\\1\r\n", $body);
         $body = str_replace("\n\n", "\n\r\n", $body);
         
         $append_flags = '\\Draft \\Seen';
         if (IMP_Folder::exists($imp['stream'], IMP::preambleString() . $drafts_folder) ||
             IMP_Folder::create($imp['stream'], IMP::preambleString() . $drafts_folder, $prefs->getValue('subscribe'))) {
             if (!@imap_append($imp['stream'], IMP::serverString() . imap_utf7_encode(IMP::preambleString() . $drafts_folder), $body, $append_flags)) {
                 Horde::raiseMessage(sprintf(_("Saving the draft failed. This is what the server said: %s"), imap_last_error()), HORDE_ERROR);
             } elseif ($prefs->getValue('close_draft')) {
                 if (($prefs->getValue('compose_popup') || Horde::getFormData('popup'))
                     && $browser->hasFeature('javascript')) {
                     echo '<script language="JavaScript" type="text/javascript">window.close();</script>';
                 } else {
                     header('Location: ' . Horde::applicationUrl(mailboxReturnURL()));
                 }
                 exit;
             } else {
                 $get_sig = false;
                 break;
             }
         }
     }
     $get_sig = false;
     Horde::raiseMessage(_("There was an error saving a draft."), HORDE_ERROR);
     break;
    
 case ADD_ATTACHMENT:
     if (!isset($HTTP_POST_FILES['file_upload']['size']) ||
         !isset($HTTP_POST_FILES['file_upload']['tmp_name']) ||
         !is_uploaded_file($HTTP_POST_FILES['file_upload']['tmp_name'])) {
         Horde::raiseMessage(sprintf(_("There was a problem with the file upload. The file may have been larger than the maximum allowed size (%d MB)."),
                                     ini_get('upload_max_filesize')), HORDE_ERROR);
     } elseif ($HTTP_POST_FILES['file_upload']['size'] > 0) {
         $attachment = Horde::getTempFile('impatt', false);
         $HTTP_POST_VARS['attachments_name'][] = $HTTP_POST_FILES['file_upload']['name'];
         $HTTP_POST_VARS['attachments_size'][] = $HTTP_POST_FILES['file_upload']['size'];
         $HTTP_POST_VARS['attachments_file'][] = $attachment;
         $HTTP_POST_VARS['attachments_type'][] = (isset($HTTP_POST_FILES['file_upload']['type'])) ? $HTTP_POST_FILES['file_upload']['type'] : '';
         move_uploaded_file($HTTP_POST_FILES['file_upload']['tmp_name'], $attachment);
         chmod($attachment, 0600);
         Horde::raiseMessage(_("Added an attachment."), HORDE_SUCCESS);
     } else {
         Horde::raiseMessage(_("There was a problem with the file upload. The file may have been larger than the maximum allowed size."), HORDE_ERROR);
     }
     
     $get_sig = false;
     break;

 case DELETE_ATTACHMENT:
     if (isset($HTTP_POST_VARS['delattachments'])) {
         for ($i = 0; $i < count($HTTP_POST_VARS['delattachments']); $i++) {
             for ($j = 0; $j < count($HTTP_POST_VARS['attachments_file']); $j++) {
                 if (strcmp($HTTP_POST_VARS['delattachments'][$i], $HTTP_POST_VARS['attachments_file'][$j]) == 0) {
                     if (!preg_match('|.mime$|', $HTTP_POST_VARS['attachments_file'][$j])) {
                         unlink(tempFilePath($HTTP_POST_VARS['attachments_file'][$j]));
                     }
                     array_splice($HTTP_POST_VARS['attachments_name'], $j, 1);
                     array_splice($HTTP_POST_VARS['attachments_size'], $j, 1);
                     array_splice($HTTP_POST_VARS['attachments_file'], $j, 1);
                     array_splice($HTTP_POST_VARS['attachments_type'], $j, 1);
                 }
             }
         }
     }

     Horde::raiseMessage(_("Deleted an attachment."), HORDE_SUCCESS);
     $get_sig = false;
     break;

 case BOUNCE_COMPOSE:
     $ACTION_TEXT = _("Redirect this message");
     break;
    
 case SPELL_CHECK_CANCEL:
     $msg = "\n" . Horde::getFormData('oldmsg');
     $get_sig = false;
     break;

 case SPELL_CHECK_DONE:
     $msg = "\n";
     $msg .= Horde::getFormData('newmsg');
     $msg .= Horde::getFormData('message');
     $get_sig = false;
     break;

 case SPELL_CHECK:
 case SPELL_CHECK_FORWARD:
     include IMP_BASE . '/spelling.php';
     break;

 default:
     $ACTION_TEXT = _("Compose a message");
     break;
}

if (!isset($ACTION_TEXT)) $ACTION_TEXT = _("Compose a message");

/* Set the 'save_sent_mail' checkbox for the form. */
$ssm_check = $identity->saveSentmail(Horde::getFormData('identity')) ? ' checked="checked"' : '';

$title = _("Message Composition");
require $registry->getTemplatePath() . '/common-header.inc';

if ($prefs->getValue('compose_popup') || Horde::getFormData('popup')) {
    $cancel_js = 'confirmCancel();';
    /* Include the JavaScript for the help system (if enabled). */
    if ($conf['user']['online_help'] && $browser->hasFeature('javascript')) {
        Help::javascript();
    }
} else {
    $cancel_js = 'window.location = \'' . Horde::applicationUrl(mailboxReturnURL()) . '\';';
    include IMP_BASE . '/menu.php';
}
require IMP_BASE . '/status.php';

$select_list = $identity->getSelectList();

if (Horde::getFormData('from') || $prefs->isLocked('default_identity')) {
    $from = $identity->getFromLine();
} else {
    $from_selected = Horde::getFormData('identity');
    if ($from_selected != '') {
        $identity->setDefault($from_selected);
    }
}

/* Grab any data that we were supplied with. */
if (empty($msg)) $msg = "\n" . Horde::getFormData('message', '');
if (empty($to)) $to = Horde::getFormData('to', getAddressList('to'));
if (empty($cc)) $cc = Horde::getFormData('cc', getAddressList('cc'));
if (empty($bcc)) $bcc = Horde::getFormData('bcc', getAddressList('bcc'));
if (empty($subject)) $subject = Horde::getFormData('subject');

$all_sigs = $identity->getAllSignatures();
$folders = IMP::flist(array('INBOX'));
foreach ($all_sigs as $ident => $sig) {
    if ($conf['user']['select_sentmail_folder']) {
        $i = 0;
        $select = null;
        foreach ($folders as $folder) {
            if ($folder['val'] == IMP::preambleString() . $identity->getValue('sent_mail_folder', $ident)) {
                $select = $i;
            }
            $i++;
        }
    } else {
        $select = $identity->getValue('sent_mail_folder', $ident);
    }
    $identities[$ident] = array($sig, 
                                $identity->getValue('sig_first', $ident),
                                $select,
                                $identity->getValue('save_sent_mail', $ident));
}
$sig = $identity->getSignature();
$sig_first = $identity->getValue('sig_first');

if ($get_sig) {
    if (isset($msg) && isset($sig)) {
        if ($sig_first) {
            $msg  = "\n" . $sig . $msg;
        } else {
            $msg .= "\n" . $sig;
        }
    }
}

if (isset($actionID) && ($actionID == BOUNCE_COMPOSE)) {
    include $registry->getTemplatePath() . '/compose/bounce.inc';
} else {
    if ($browser->hasFeature('javascript')) {
        include $registry->getTemplatePath() . '/compose/javascript.inc';
    }

    if (isset($actionID) &&
        ($actionID == SPELL_CHECK || $actionID == SPELL_CHECK_FORWARD)) {
        include $registry->getTemplatePath() . '/compose/spelling.inc';
    } else {
        $tabindex = 1;
        include $registry->getTemplatePath() . '/compose/compose.inc';
    }
}

$registry->shutdown();
require $registry->getTemplatePath() . '/common-footer.inc';
$prefs->store();

?>
