/* log.h
 * - Logging Function Headers
 *
 * Copyright (c) 1999 Jack Moffitt, Barath Raghavan, and Alexander Havng
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#ifndef __ICECAST_LOG_H
#define __ICECAST_LOG_H

void write_log(int whichlog, char *fmt, ...);
void write_clf (connection_t *clicon, source_t *source);
void xa_debug (int level, char *fmt, ...);
void my_perror(char *where);
void stats_write(server_info_t *info);
int open_log_file (char *name, int oldfd);
void open_log_files ();
int fd_write (int fd, const char *fmt, ...);
int fd_read_line (int fd, char *buff, const int len);
int fd_read_line_nb (int fd, char *buff, const int len);
int fd_close (int fd);
int fd_write_line (int fd, const char *fmt, ...);
int fd_write_bytes (int fd, const char *buff, const int len);
void stats_write_html (server_info_t *info);
int get_log_fd (int whichlog);
void write_log_not_me (int whichlog, connection_t *nothim, char *fmt, ...);
#endif
