/* admin.h
 * - Admin Function Headers
 *
 * Copyright (c) 1999 Jack Moffitt, Barath Raghavan, and Alexander Havng
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#ifndef __ICECAST_ADMIN_H
#define __ICECAST_ADMIN_H

admin_t *create_admin();
void admin_login(connection_t *con, char *line);
void *handle_admin(void *vcon);
void handle_remote_admin(connection_t *con);
void put_admin(connection_t *con);
void add_admin ();
void del_admin ();
void add_icecast_console ();
void describe_admin (const com_request_t *req, const connection_t *admcon);
void write_admin_prompt (const connection_t *admcon);
const char *admin2string (admin_t *adm, char *buf);
void initialize_readline ();
void uninitialize_readline ();
void put_http_admin (connection_t *con);
scheme_t admin_scheme (com_request_t *req);
int admin_write_raw (const com_request_t *req, const char *fmt, ...);
int admin_write (const com_request_t *req, const int met, const char *fmt, ...);
int admin_write_line (const com_request_t *req, const int met, const char *fmt, ...);
int admin_write_string (const com_request_t *req, const int message_type, const char *buff);
int http_write_string (const com_request_t *req, const int message_type, const char *buff);
#endif

