#include "hydra-mod.h"
#ifndef LIBDES
 void dummy() {
   printf("\n");
 }
#else
 #include "md4.h"
 #include <des.h>

/*
   SMB NTLM Password/HASH Checking Hydra Module
   Copyright (C) m0j0.j0j0
   m0j0.j0j0 / m0j0@foofus.net 
   09/30/2003

   Based on code from: SMB Auditing Tool
   [Copyright (C) Patrik Karlsson 2001]

   This code allows Hydra to directly test NTLM hashes against
   a Windows host via '-m HASH'. This may be useful for an 
   auditor who has aquired a sam._ or pwdump file and would 
   like to quickly determine which are valid entries. This 
   module can also be used to test SMB passwords against devices 
   that do not allow clear text LanMan passwords.

   See http://www.foofus.net/m0j0/passhash.html for further
   examples.

   Greets: Foofus, Phenfen & Fizzgig  
*/

extern char *HYDRA_EXIT;
char challenge[8];

static u_char Get7Bits(u_char *input, int startBit) {
  register unsigned int word;

  word  = (unsigned)input[startBit / 8] << 8;
  word |= (unsigned)input[startBit / 8 + 1];

  word >>= 15 - (startBit % 8 + 7);

  return word & 0xFE;
}

// Make the key
static void MakeKey(u_char *key, u_char *des_key) {
  des_key[0] = Get7Bits(key,  0);
  des_key[1] = Get7Bits(key,  7);
  des_key[2] = Get7Bits(key, 14);
  des_key[3] = Get7Bits(key, 21);
  des_key[4] = Get7Bits(key, 28);
  des_key[5] = Get7Bits(key, 35);
  des_key[6] = Get7Bits(key, 42);
  des_key[7] = Get7Bits(key, 49);

  des_set_odd_parity((des_cblock *)des_key);
}

// Do the DesEncryption
void DesEncrypt(u_char *clear, u_char *key, u_char *cipher) {
  des_cblock         des_key;
  des_key_schedule   key_schedule;

  MakeKey(key, des_key);
  des_set_key(&des_key, key_schedule);
  des_ecb_encrypt((des_cblock *)clear, (des_cblock *)cipher, key_schedule, 1);
}

/*
  HashNTLM
  Function: Create a NTLM hash from the challenge
  Variables:
        ntlmhash  = the hash created from this function
        pass      = users password
        challenge = the challenge recieved from the server
*/
void HashNTLM(u_char **ntlmhash, u_char *pass, u_char *challenge, char *miscptr) {
  MD4_CTX             md4Context;
  u_char              hash[16];                   // MD4_SIGNATURE_SIZE = 16
  u_char              unicodePassword[256 * 2];   // MAX_NT_PASSWORD = 256
  u_char              p21[21];
  u_char              ntlm_response[24];
  int                 i=0,j=0;
  int                 mdlen = strlen(pass) * 2 * 8;
  u_char              *p;
  
  /* Use NTLM Hash instead of password */
  if ((miscptr != NULL) && (strcmp(miscptr, "HASH") == 0)) { 
    // 1000:D42E35E1A1E4C22BD32E2170E4857C20:5E20780DD45857A68402938C7629D3B2:::
    p = pass;
    while ((*p != '\0') && (i < 2)) {
      if (*p == ':') i++;
      p++;
    }

    if (*p == '\0') {
      fprintf(stderr, "Error reading PWDUMP file.\n");
      exit(1);
    }

    char HexChar;
    int HexValue;
    for (i=0; i<16; i++) {
      HexValue = 0x0;
      for (j=0; j<2; j++) {
        HexChar = (char)p[2*i+j];

        if (HexChar > 0x39)
          HexChar = HexChar | 0x20;  /* convert upper case to lower */

        if (!(((HexChar >= 0x30) && (HexChar <= 0x39))||   /* 0 - 9 */
              ((HexChar >= 0x61) && (HexChar <= 0x66)))) {    /* a - f */
          //fprintf(stderr, "Error invalid char (%c) for hash.\n", HexChar);
          //exit(1);
          HexChar = 0x30;
        }

        HexChar -= 0x30;
        if (HexChar > 0x09)  /* HexChar is "a" - "f" */
          HexChar -= 0x27;

        HexValue = (HexValue << 4) | (char)HexChar;
      }
      hash[i] = (u_char)HexValue;
    }
  } else {
    /* Initialize the Unicode version of the secret (== password). */
    /* This implicitly supports 8-bit ISO8859/1 characters. */
    bzero(unicodePassword, sizeof(unicodePassword));
    for (i = 0; i < strlen(pass); i++)
      unicodePassword[i * 2] = (u_char)pass[i];

    MD4Init(&md4Context);
    MD4Update(&md4Context, unicodePassword, mdlen);
    MD4Final(hash, &md4Context);        /* Tell MD4 we're done */
  }

  memset(p21, '\0', 21);
  memcpy(p21, hash, 16);

  DesEncrypt(challenge, p21 +  0, ntlm_response + 0);
  DesEncrypt(challenge, p21 +  7, ntlm_response + 8);
  DesEncrypt(challenge, p21 + 14, ntlm_response + 16);
                                                                                                                                                
  memcpy(*ntlmhash, ntlm_response, 24);
}

/*
   NBS Session Request
   Function: Request a new session from the server
   Returns: TRUE on success else FALSE.
*/
int NBSSessionRequest(int s) {
  char nb_name[32];      // netbiosname
  char nb_local[32];     // netbios localredirector
  char rqbuf[7] = {0x81, 0x00, 0x00, 0x48, 0x20, 0x00, 0x20};
  char *buf;
  u_char rbuf[400];

  // convert computer name to netbios name
  memset(nb_name, 0, 32);
  memset(nb_local, 0, 32);
  memcpy(nb_name, "CKFDENECFDEFFCFGEFFCCACACACACACA", 32); // *SMBSERVER
  memcpy(nb_local, "EIFJEEFCEBCACACACACACACACACACACA", 32); // HYDRA

  buf = (char *) malloc(100);
  memset(buf, 0, 100);
  memcpy(buf, rqbuf, 5);
  memcpy(buf+5, nb_name, 32);
  memcpy(buf+37, rqbuf+5, 2);
  memcpy(buf+39, nb_local, 32);
  memcpy(buf+71, rqbuf+5, 1);

  hydra_send(s, buf, 72, 0);
  free(buf);

  memset(rbuf, 0, 400);
  hydra_recv(s, rbuf, sizeof(rbuf)); 

  if (rbuf[0] == 0x82)
    return 0;	    /* success */
  else
    return -1;     /* failed */
}


/*
   SMBNegProt
   Function: Negotiate protocol with server ...
       Actually a pseudo negotiation since the whole
       program counts on NTLM support :)

    The challenge is retrieved from the answer
    No error checking is performed i.e cross your fingers....
*/
int SMBNegProt(int s) {
  char buf[168] = {0x00, 0x00, 0x00, 0xa4, 0xff, 0x53, 0x4d, 0x42,
      0x72, 0x00, 0x00, 0x00, 0x00, 0x08, 0x01, 0x40,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x7d,
      0x00, 0x00, 0x01, 0x00, 0x00, 0x81, 0x00, 0x02,
      0x50, 0x43, 0x20, 0x4e, 0x45, 0x54, 0x57, 0x4f,
      0x52, 0x4b, 0x20, 0x50, 0x52, 0x4f, 0x47, 0x52,
      0x41, 0x4d, 0x20, 0x31, 0x2e, 0x30, 0x00, 0x02,
      0x4d, 0x49, 0x43, 0x52, 0x4f, 0x53, 0x4f, 0x46,
      0x54, 0x20, 0x4e, 0x45, 0x54, 0x57, 0x4f, 0x52,
      0x4b, 0x53, 0x20, 0x31, 0x2e, 0x30, 0x33, 0x00,
      0x02, 0x4d, 0x49, 0x43, 0x52, 0x4f, 0x53, 0x4f,
      0x46, 0x54, 0x20, 0x4e, 0x45, 0x54, 0x57, 0x4f,
      0x52, 0x4b, 0x53, 0x20, 0x33, 0x2e, 0x30, 0x00,
      0x02, 0x4c, 0x41, 0x4e, 0x4d, 0x41, 0x4e, 0x31,
      0x2e, 0x30, 0x00, 0x02, 0x4c, 0x4d, 0x31, 0x2e,
      0x32, 0x58, 0x30, 0x30, 0x32, 0x00, 0x02, 0x53,
      0x61, 0x6d, 0x62, 0x61, 0x00, 0x02, 0x4e, 0x54,
      0x20, 0x4c, 0x41, 0x4e, 0x4d, 0x41, 0x4e, 0x20,
      0x31, 0x2e, 0x30, 0x00, 0x02, 0x4e, 0x54, 0x20,
      0x4c, 0x4d, 0x20, 0x30, 0x2e, 0x31, 0x32, 0x00};

  char rbuf[400];
  memset(rbuf, 0, 400);

  hydra_send(s, buf, 168, 0);
  hydra_recv(s, rbuf, sizeof(rbuf)); 

  // retrieve the challenge
  memcpy(challenge, rbuf+73, sizeof(challenge));

  return 2;
}


/*
  SMBSessionSetup
  Function: Send username + response to the challenge from
            the server.
       Currently we're sendin ZEROES for the LMHASH since
       NT4/2000 doesn't seem to look at this if we got a
       valid NTLM hash.
  Returns: TRUE on success else FALSE.
*/
int SMBSessionSetup(int s, char *user, char *pass, char *miscptr) {
  char b[137] = {0x00, 0x00, 0x00, 0x85, 0xff, 0x53, 0x4d,
        0x42, 0x73, 0x00, 0x00, 0x00, 0x00, 0x08, 0x01,
        0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c,
        0x7d, 0x00, 0x00, 0x01, 0x00, 0x0d, 0xff, 0x00,
        0x00, 0x00, 0xff, 0xff, 0x02, 0x00, 0x3c, 0x7d,
        0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x18, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x50, 0x00, 0x00, 0x00,
        0x48, 0x00, 0xdf, 0x82, 0xb9, 0x2f, 0xda, 0xdb,
        0x43, 0x47, 0x09, 0xdb, 0x7f, 0xfc, 0xb0, 0xa8,
        0xf0, 0x46, 0xe2, 0xfe, 0x64, 0x6d, 0x67, 0x58,
        0xe0, 0xf9, 0xca, 0x9f, 0x5e, 0xdb, 0xe0, 0x15,
        0x80, 0xf8, 0x54, 0xe3, 0x6e, 0xe9, 0xf8, 0x88,
        0x80, 0x19, 0xb6, 0xf9, 0xae, 0xb7, 0xa6, 0x62,
        0x14, 0xfc, 0x54, 0x45, 0x53, 0x54, 0x00, 0x4d,
        0x59, 0x47, 0x52, 0x4f, 0x55, 0x50, 0x00, 0x55,
        0x6e, 0x69, 0x78, 0x00, 0x53, 0x61, 0x6d, 0x62,
        0x61, 0x00};

  u_char buf[512];
  u_char *NTLMhash;
  u_char LMhash[24];
  u_char workgroup[16];
  u_char rbuf[400];
  int userlen;

  NTLMhash   = (u_char *) malloc(24);

  memset(NTLMhash, 0, 24);
  memset(LMhash, 0, 24);
  memset(workgroup, 0, 16);
  memset(rbuf, 0, 400);

  HashNTLM(&NTLMhash, pass, challenge, miscptr);

  memset(buf, 0, 512);
  memcpy(buf, b, 89);
  memcpy(buf+65, LMhash, 24);
  memcpy(buf+89, NTLMhash, 24);

  userlen = strlen(user);

  memcpy(buf+113, user, userlen);
  memset(buf+(113+userlen), 0, 1);
  memcpy(buf+(114+userlen), workgroup, strlen(workgroup));
  memcpy(buf+(114+userlen+strlen(workgroup)), b+125, 12);

  // set the header length
  buf[3] = ( userlen + strlen(workgroup) + 0x7A ) % 256;
  buf[2] = ( userlen + strlen(workgroup) + 0x7A ) / 256;

  // set data length
  buf[63] = 0x1F + strlen(workgroup) + userlen;

  hydra_send(s, buf, 126+userlen+strlen(workgroup), 0);

  hydra_recv(s, rbuf, sizeof(rbuf));
  return rbuf[9];
}

int start_smbnt(int s, unsigned long int ip, int port, unsigned char options, char *miscptr, FILE *fp) {
  char *empty = "";
  char *login, *pass;

  if (strlen(login = hydra_get_next_login()) == 0) login = empty;
  if (strlen(pass = hydra_get_next_password()) == 0) pass = empty;

  int SMBerr = SMBSessionSetup(s, login, pass, miscptr);

  if ( 0x00 == SMBerr ) {                  // success
    hydra_report_found_host(port, ip, "smb", fp);
    hydra_completed_pair_found();
  }
  else if ( 0x24 == SMBerr ) {             // change password on next login [success]
    hydra_report_found_host(port, ip, "smb (must change password)", fp);
    hydra_completed_pair_found();
  }
  else if ( 0x72 == SMBerr ) {             // account disabled
    hydra_report_found_host(port, ip, "smb (account disabled)", fp);
    hydra_completed_pair();
  }
  else if ( 0x34 == SMBerr ) {             // account locked out
    fprintf(stderr, "[%d][smb] Account: %s is locked out\n", port, login); 
    hydra_completed_pair();
  }
  else {                                   // failed
    hydra_completed_pair();
  }

  hydra_disconnect(s);
  if (memcmp(hydra_get_next_pair(), &HYDRA_EXIT, sizeof(HYDRA_EXIT)) == 0)
    return 3;
  return 1;
}

void service_smbnt(unsigned long int ip, int sp, unsigned char options, char *miscptr, FILE *fp, int port) {
  int run = 1, next_run, sock = -1;
  int myport = PORT_SMB, mysslport = PORT_SMB_SSL;

  hydra_register_socket(sp);
  if (memcmp(hydra_get_next_pair(), &HYDRA_EXIT, sizeof(HYDRA_EXIT)) == 0)
    return;
  for(;;) {
    switch(run) {
      case 1: /* connect and service init function */
          if (sock >= 0)
            sock = hydra_disconnect(sock);
            usleep(300000);
          if ((options & OPTION_SSL) == 0) {
            if (port != 0) myport = port;
            sock = hydra_connect_tcp(ip, myport);
            port = myport;
          } else {
            if (port != 0) mysslport = port;
            sock = hydra_connect_ssl(ip, mysslport);
            port = mysslport;
          }
          if (sock < 0) {
            fprintf(stderr, "Error: Child with pid %d terminating, can not connect\n", (int)getpid());
            hydra_child_exit();
          }
          if ( NBSSessionRequest(sock) < 0 ) {
            fprintf(stderr, "Session Setup Failed: ");
            fprintf(stderr, "(Is the server service running?)\n");
            exit(-1);
          }
          next_run = SMBNegProt(sock);
          break;
      case 2: /* run the cracking function */
          next_run = start_smbnt(sock, ip, port, options, miscptr, fp);
          break;
      case 3: /* clean exit */
          if (sock >= 0) sock = hydra_disconnect(sock);
          hydra_child_exit();
          return;
      default: fprintf(stderr,"Caught unknown return code (%d), exiting!\n", run);
           hydra_child_exit();
           exit(-1);
    }
    run = next_run;
  }
}
#endif
