#include "hydra-mod.h"

#define MAX_CONNECT_RETRY 1
#define WAIT_BETWEEN_CONNECT_RETRY 3

int intern_socket, extern_socket;
char pair[260];
char HYDRA_EXIT[5] = "\x00\xff\x00\xff\x00";
char *HYDRA_EMPTY = "\x00\x00\x00\x00";
int fail = 0;
int alarm_went_off = 0;

void alarming() {
    fail++;
    alarm_went_off++;
// uh, I think it's not good for performance if we try to reconnect to a timeout system!
//    if (fail > MAX_CONNECT_RETRY) {
        fprintf(stderr, "Process %d: Can not connect [timeout], process exiting\n", getpid());
        if (debug) printf("DEBUG_CONNECT_TIMEOUT\n");
        hydra_child_exit();
//    } else {
//	if (verbose) fprintf(stderr, "Process %d: Can not connect [timeout], retrying (%d of %d retries)\n", getpid(), fail, MAX_CONNECT_RETRY);
//    }
}

void interrupt() {
    if (debug) printf("DEBUG_INTERRUPTED\n");
}

void hydra_child_exit() {
    write(intern_socket, "Q", 1);
    exit(-1);
}

void hydra_register_socket(int s) {
    intern_socket = s;
}

char *hydra_get_next_pair() {
    if (pair[0] == 0) {
        read(intern_socket, pair, sizeof(pair));
        if (memcmp(&HYDRA_EXIT, &pair, sizeof(HYDRA_EXIT)) == 0)
            return HYDRA_EXIT;
        if (pair[0] == 0)
            return HYDRA_EMPTY;
    }
    return pair;
}

char *hydra_get_next_login() {
    if (pair[0] == 0)
        return HYDRA_EMPTY;
    return pair;
}

char *hydra_get_next_password() {
    char *ptr = pair;
    while(*ptr != '\0') ptr++;
    ptr++;
    if (*ptr == 0)
        return HYDRA_EMPTY;
    return ptr;
}

void hydra_completed_pair() {
    pair[0] = 0;
    write(intern_socket, "N", 1);
}

void hydra_report_found(FILE *fp) {
    fprintf(fp, "Found! login: %s   password: %s\n",hydra_get_next_login(),hydra_get_next_password());
}

int hydra_connect_tcp(unsigned long int host, int port) {
    int s, ret = -1;
    struct sockaddr_in target;
    if ((s = socket(PF_INET, SOCK_STREAM, 6)) >= 0) {
          target.sin_port=htons(port);
          target.sin_family=AF_INET;
          memcpy(&target.sin_addr.s_addr,&host,4);
          signal(SIGALRM,alarming);
          do {
              if (fail > 0) sleep(WAIT_BETWEEN_CONNECT_RETRY);
              alarm_went_off = 0;
              alarm(waittime);
              ret = connect(s,(struct sockaddr*) &target, sizeof(target));
              alarm(0);
              if (ret < 0 && alarm_went_off == 0) {
                  fail++;
                  if (verbose && fail <= MAX_CONNECT_RETRY) fprintf(stderr, "Process %d: Can not connect [unreachable], retrying (%d of %d retries)\n", getpid(), fail, MAX_CONNECT_RETRY);
              }
          } while (ret < 0 && fail <= MAX_CONNECT_RETRY);
          if (ret < 0 && fail > MAX_CONNECT_RETRY) {
              if (debug) printf("DEBUG_CONNECT_UNREACHABLE\n");
// we wont quit here, thats up to the module to decide what to do
//              fprintf(stderr, "Process %d: Can not connect [unreachable], process exiting\n", getpid());
//              hydra_child_exit();
              extern_socket = -1;
              ret = -1;
              return ret;
          }
          ret = s;
          extern_socket = s;
          if (debug) printf("DEBUG_CONNECT_OK\n");
          fail = 0;
    }
    return ret;
}

int hydra_disconnect(int socket) {
    close(socket);
    if (debug) printf("DEBUG_DISCONNECT\n");
    return -1;
}

int hydra_data_ready_writing_timed(int socket, long sec, long usec) {
    fd_set fds;
    struct timeval tv;

    FD_ZERO(&fds);
    FD_SET(socket, &fds);
    tv.tv_sec = sec;
    tv.tv_usec = usec;

    return(select(socket + 1, &fds, NULL, NULL, &tv));
}

int hydra_data_ready_writing(int socket) {
    return(hydra_data_ready_writing_timed(socket, 30, 0));
}

int hydra_data_ready_timed(int socket, long sec, long usec) {
    fd_set fds;
    struct timeval tv;

    FD_ZERO(&fds);
    FD_SET(socket, &fds);
    tv.tv_sec = sec;
    tv.tv_usec = usec;

    return(select(socket + 1, &fds, NULL, NULL, &tv));
}

int hydra_data_ready(int socket) {
    return(hydra_data_ready_timed(socket, 0, 100));
}

char *hydra_receive_line(int socket) {
    char buf[300], *buff;
    int i = 0, j = 0, k;

    buff = malloc(sizeof(buf));
    memset(buff, 0, sizeof(buf));

    i = hydra_data_ready_timed(socket, (long) waittime, 0);
    if (i > 0) {
        if ((i = recv(socket, buff, sizeof(buf), 0)) < 0) {
            free(buff);
            return NULL;
        }
    }
    if (i <= 0) {
        if (debug) printf("DEBUG_RECV_BEGIN|%s|END\n", buff);
        free(buff);
        return NULL;
    } else {
        for(k = 0; k < i; k++)
            if (buff[k] == 0)
                buff[k] = 32;
    }

    j = 1;
    while(hydra_data_ready(socket) > 0 && j > 0) {
        j = recv(socket, buf, sizeof(buf), 0);
        if (j > 0)
            for(k = 0; k < j; k++)
                if (buff[k] == 0)
                    buff[k] = 32;
        buff=realloc(buff,i+j);
        memcpy(buff+i,&buf,j);
        i=i+j;
    }

    if (debug) printf("DEBUG_RECV_BEGIN|%s|END\n", buff);
    return buff;
}

int hydra_send(int socket, char *buf, int size, int options) {
    if (debug) printf("DEBUG_SEND_BEGIN|%s|END\n", buf);
//    if (hydra_data_ready_writing(socket)) < 1) return -1; // XXX maybe needed in the future
    return(send(socket, buf, size, options));
}

int make_to_lower(char *buf) {
    if (buf == NULL) return 1;
    while (buf[0] != 0) {
        buf[0]=tolower(buf[0]);
        buf++;
    }
    return 1;
}
