/* 
 * $smu-mark$ 
 * $name: hgetopt.c$ 
 * $author: Salvatore Sanfilippo <antirez@invece.org>$ 
 * $copyright: Copyright (C) 1999 by Salvatore Sanfilippo$ 
 * $license: This software is under GPL version 2 of license$ 
 * $date: Fri Nov  5 11:55:48 MET 1999$ 
 * $rev: 9$ 
 */ 

#include <stdlib.h> /* NULL macro */
#include <stdio.h>

char *hoptarg;	/* option argument or NULL */
int targethost = 0;

int require_arg (char *opt, char **optype)
{
	int index = 0;

	while(optype[index] != NULL)
	{
		if (!strcmp(opt, optype[index]+1))
		{
			if (optype[index][0] == ':')
				return 1;
			else
				return 0;
		}
		index++;
	}

	/* option not found, return val is indifferent */
	return 0;
}

char *hgetopt(char **argv, char **optype)
{
	static char **hargv = NULL;
	static int short_argchain = 0;
	static char *argchain_p;
	static char argchain_tmp[2];

	if (hargv == NULL)
		hargv = argv;

	/* a "short argument chains" is for example -SFA */
	if (short_argchain == 1)
	{
		argchain_p++;
		if (*argchain_p != '\0')
		{
			argchain_tmp[0] = *argchain_p;
			argchain_tmp[1] = '\0';

			if (require_arg(argchain_tmp, optype))
			{
				if ( *(argchain_p+1) == '\0' )
				{
					short_argchain = 0;
					if (*(hargv+1) != NULL)
					{
						hargv++;
						hoptarg = hargv[0];
					}
					else
					{
						hoptarg = NULL;
					}
				}
				else
				{
					hoptarg = NULL;
				}
			}
			return argchain_tmp;
		}
		else
		{
			short_argchain = 0;
		}
	}

	while(1)
	{
		char *r;

		targethost = 0;
		hoptarg = NULL;

		if (*hargv == NULL || *(hargv+1) == NULL)
			return NULL; /* EOF */

		r = (++hargv)[0];

		if (hargv[0][0] != '-')
			targethost = 1; /* it is not option not even argument */
		else
			r++; /* skip '-' */

		if (!targethost && *r != '-' && strlen(r) > 1)
		{
			short_argchain = 1;
			argchain_tmp[0] = *r;
			argchain_tmp[1] = '\0';
			argchain_p = r;
			return argchain_tmp;
		}

		if ( *(hargv+1) != NULL && (hargv+1)[0][0] != '-' && !targethost && require_arg(r, optype))
		{
			hargv++;
			hoptarg = hargv[0];
		}

		return r;
	}
	return NULL; /* prevent Warning */
}

/* TEST MAIN */
/*
int main(char *argc, char **argv)
{
	char *opt;

char *optype[]=
{
	":-count",	":c",
	":-interval",	":i",
	"=-numeric",	"=n",
	"=-quiet",	"=q",
	":-interface",	":I",
	"=-help",	"=h",
	"=-version",	"=v",
	":-destport",	":p",
	":-baseport",	":s",
	":-ttl",	":t",
	":-id",		":N",
	":-win",	":w",
	":-spoof",	":a",
	"=-fin",	"=F",
	"=-syn",	"=S",
	"=-rst",	"=R",
	"=-push",	"=P",
	"=-ack",	"=A",
	"=-urg",	"=U",
	"=-xmas",	"=X",
	"=-ymas",	"=Y",
	"=-frag",	"=f",
	"=-morefrag",	"=x",
	"=-dontfrag",	"=y",
	":-tcpoff",	":O",
	"=-rel",	"=r",
	":-data",	":d",
	"=-icmp",	"=1",
	"=-udp",	"=2",
	"=-bind",	"=z",
	"=-unbind",	"=Z",
	"=-debug",	"=D",
	"=-verbose",	"=V",
	"=-winid",	"=W",
	"=-keep",	"=k",
	":-file",	":E",
	"=-dump",	"=j",
	"=-print",	"=J",
	":-sign",	":e",
	":-listen",	":9",
	"=-safe",	"=B",
	"=-traceroute", "=T",
	":-tos",	":o",
	":-mtu",	":m",
	"=-seqnum",	"=Q",
	":-icmptype",	":C",
	":-icmpcode",	":K",
	"=-end",	"=u",
	"=-rroute",	"=G",
	":-icmp-ipver",
	":-icmp-iphlen",
	":-icmp-iplen",
	":-icmp-ipid",
	":-icmp-ipproto",
	":-tcpexitcode",
	NULL
};

	while ((opt = hgetopt(argv, optype)) != NULL)
	{
		if (targethost == 1)
		{
			printf("target host: %s\n", opt);
			continue;
		}

		printf("%s ", opt);
		if (hoptarg)
			printf("%s", hoptarg);
		printf("\n");
	}
	return 0;
}
*/
/* TEST MAIN */


