<?php
/**
 * $Horde: horde/admin/phpshell.php,v 1.24.10.4 2005/07/05 08:40:27 jan Exp $
 *
 * Copyright 1999-2005 Chuck Hagenbuch <chuck@horde.org>
 *
 * See the enclosed file COPYING for license information (LGPL). If you
 * did not receive this file, see http://www.fsf.org/copyleft/lgpl.html.
 */

define('HORDE_BASE', dirname(__FILE__) . '/..');
require_once HORDE_BASE . '/lib/base.php';
require_once 'Horde/Menu.php';
require_once 'Horde/Help.php';

if (!Auth::isAdmin()) {
    Horde::authenticationFailureRedirect();
}

$title = _("PHP Shell");
require HORDE_TEMPLATES . '/common-header.inc';
require HORDE_TEMPLATES . '/admin/common-header.inc';

$apps_tmp = $registry->listApps();
$apps = array();
foreach ($apps_tmp as $app) {
    $apps[$app] = $registry->get('name', $app);
}
asort($apps);
$application = Util::getFormData('app', 'horde');
?>
<form action="<?php echo $_SERVER['PHP_SELF'] ?>" method="post">
<?php Util::pformInput() ?>

<table width="100%" border="0" cellpadding="2" cellspacing="0"><tr><td class="header"><?php echo _("Application") ?></td></tr></table>
<select name="app">
<?php foreach ($apps as $app => $name): ?>
  <option value="<?php echo $app ?>"<?php if ($application == $app) echo ' selected="selected"' ?>><?php echo $name ?></option>
<?php endforeach; ?>
</select><br /><br />
<?php

if ($command = trim(Util::getFormData('php'))) {
    if (@file_exists($registry->get('fileroot', $application) . '/lib/base.php')) {
        include $registry->get('fileroot', $application) . '/lib/base.php';
    } else {
        $registry->pushApp($application);
    }

    require_once 'Horde/MIME/Viewer.php';
    require_once 'Horde/MIME/Viewer/source.php';
    $pretty = highlight_string('<?php ' . $command, true);
    $pretty = str_replace(array('&lt;?php ',
                                '<font color="#000000"><font color="#007700">&lt;?</font><font color="#0000BB">php </font>',
                                "\r\n",
                                "\r",
                                "\n",
                                '<br />'),
                          array('',
                                '',
                                '',
                                '',
                                '',
                                "\n"),
                          $pretty);
    $pretty = MIME_Viewer_Source::lineNumber(trim($pretty));

    echo '<table width="100%" border="0" cellpadding="2" cellspacing="0"><tr><td class="header">' . _("PHP Code") . '</td></tr></table><br />';
    echo $pretty;

    echo '<br /><table width="100%" border="0" cellpadding="2" cellspacing="0"><tr><td class="header">' . _("Results") . '</td></tr></table>';
    echo '<table cellpadding="4" border="0"><tr><td class="text"><pre>';
    eval($command);
    echo '</pre></td></tr></table><br />';
}
?>

<textarea class="fixed" name="php" rows="10" cols="60">
<?php if (!empty($command)) echo htmlspecialchars($command) ?></textarea>
<br />
<input type="submit" class="button" value="<?php echo _("Execute") ?>" />
<?php echo Help::link('admin', 'admin-phpshell') ?>

</form>
<?php

require HORDE_TEMPLATES . '/common-footer.inc';
