-- $Horde: horde/scripts/db/category.sql,v 1.2.2.6 2001/12/31 03:16:40 jon Exp $

CREATE TABLE horde_categories (
       category_id INT not null,
       group_uid VARCHAR(255) not null,
       user_uid VARCHAR(255),
       category_name VARCHAR(255) not null,
-- There is no portable way to do this apparently. If your db doesn't allow varchars
-- greater than 255 characters, then maybe it allows TEXT columns, so try the second
-- line.
       category_data VARCHAR(2048) null,
--     category_data TEXT null,
       category_serialized SMALLINT DEFAULT 0 not null,
       category_updated TIMESTAMP,
       PRIMARY KEY (category_id)
);

CREATE INDEX category_category_name_idx ON horde_categories (category_name);
CREATE INDEX category_group_idx ON horde_categories (group_uid);
CREATE INDEX category_user_idx ON horde_categories (user_uid);
CREATE INDEX category_serialized_idx ON horde_categories (category_serialized);

CREATE TABLE horde_categories_categories (
       category_id_parent INT not null,
       category_id_child INT not null,
       PRIMARY KEY (category_id_parent, category_id_child)
);

GRANT SELECT, INSERT, UPDATE, DELETE ON horde_categories TO horde;
GRANT SELECT, INSERT, UPDATE, DELETE ON horde_categories_categories TO horde;
