<?php
// $Horde: horde/lib/MIME/Viewer/zip.php,v 1.1.2.2 2001/12/23 20:19:08 chuck Exp $

/**
 * The MIME_Viewer_zip class renders out .zip files in HTML format by
 * executing zipinfo in query mode.
 *
 * @author  Chuck Hagenbuch <chuck@horde.org>
 * @version $Revision: 1.1.2.2 $
 * @since   Horde 2.0
 * @package horde.mime.viewer
 */
class MIME_Viewer_zip extends MIME_Viewer {

    /**
     * Render out the currently set contents using zipinfo. The
     * $mime_part class variable has the information to render out,
     * encapsulated in a MIME_Part object.
     *
     * @return string HTML pretty-print of the content
     */
    function render($params = null)
    {
        global $mime_drivers;

        $tmp_zip = Horde::getTempFile('hordezip');

        $fh = fopen($tmp_zip, 'w');
        fwrite($fh, $this->mime_part->getContents());
        fclose($fh);

        $pipe = popen($mime_drivers['horde']['zip']['location'] . " -m $tmp_zip 2>&1", 'r');
        $data = '<b>' . sprintf(_("Contents of '%s'"), $this->mime_part->name);
        $data .= '</b><br /><table><tr><td align="left"><pre>';

        $re = '';
        while (($rc = fgets($pipe, 8192))) {
            $re .= $rc;
        }

        pclose($pipe);

        $data .= htmlspecialchars($re);
        $data .= '</pre></td></tr></table>';

        return $data;
    }

    function getType()
    {
        return 'text/html';
    }

}
/*
    global $conf;
    
    $content = IMP::getPart($mime);
    
    $tmp_zip = Horde::getTempFile('imp_zip');
    _fileCleanup($tmp_zip);
    
    $fh = fopen($tmp_zip, 'w');
    fwrite($fh, imap_base64($content));
    fclose($fh);
    
    $pipe = popen($conf['utils']['unzip'] . " -m $tmp_zip  2>&1 |grep -v Archive", 'r');
    $data = '<b><u>Contents of ZIP file</u></b><br /><table><tr><td align=left><pre>';
    while (($rc=fgets($pipe,10)))
        $data.= $rc;
    pclose($pipe);
    $data .= '</pre></td></tr></table><br /><b><u>Details of ZIP file</u></b><br /><table><tr><td align="left"><pre>';
    $pipe = popen($conf['utils']['unzip'] . " -mvh $tmp_zip  2>&1 |grep -v Archive", 'r');
    while (($rc=fgets($pipe,10)))
        $data.= $rc;
    pclose($pipe);
    unlink($tmp_zip);
    $data .= '</pre></td></tr></table>';
    
    return $data;
*/
?>
