<?php
/*
 * $Horde: horde/admin/user.php,v 1.3.2.2 2002/01/02 17:05:15 jan Exp $
 *
 * Copyright 1999-2002 Chuck Hagenbuch <chuck@horde.org>
 *
 * See the enclosed file COPYING for license information (LGPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/lgpl.html.
 */

require_once '../lib/base.php';

if (!@is_array($conf['auth']['admins'])) {
    exit('there are no administrators. user administration is disabled.');
}

if (!Auth::getAuth() || !in_array(Auth::getAuth(), $conf['auth']['admins'])) {
    exit('forbidden.');
}

$auth = &Auth::factory($conf['auth']['driver'], $conf['auth']['params']);


// Process forms. Use $HTTP_POST_VARS instead of Horde::getFormData()
// for a lot of the data because we want to actively ignore GET data
// in some cases - adding/modifying users - as a security precaution.
switch (Horde::getFormData('form')) {
 case 'add':
     if (empty($HTTP_POST_VARS['user_name'])) {
         Horde::raiseMessage(_("You must specify the username to add."), HORDE_ERROR);
     } elseif (empty($HTTP_POST_VARS['user_pass_1']) || empty($HTTP_POST_VARS['user_pass_2'])) {
         Horde::raiseMessage(_("Passwords cannot be blank."), HORDE_ERROR);
     } elseif ($HTTP_POST_VARS['user_pass_1'] != $HTTP_POST_VARS['user_pass_2']) {
         Horde::raiseMessage(_("Passwords must match."), HORDE_ERROR);
     } else {
         if (PEAR::isError($auth->addUser(Horde::dispelMagicQuotes($HTTP_POST_VARS['user_name']),
                                          array('password' => Horde::dispelMagicQuotes($HTTP_POST_VARS['user_pass_1']))))) {
             Horde::raiseMessage(sprintf(_("There was a problem adding '%s' to the system."), Horde::dispelMagicQuotes($HTTP_POST_VARS['user_name'])), HORDE_ERROR);
         } else {
             Horde::raiseMessage(sprintf(_("Successfully added '%s' to the system."), Horde::dispelMagicQuotes($HTTP_POST_VARS['user_name'])), HORDE_SUCCESS);
         }
     }
     break;

 case 'remove':
     $f_user_name = Horde::getFormData('user_name');
     if (empty($f_user_name)) {
         Horde::raiseMessage(_("You must specify a username to remove."), HORDE_MESSAGE);
     } else {
         if (PEAR::isError($auth->removeUser($f_user_name))) {
             Horde::raiseMessage(sprintf(_("There was a problem removing '%s' from the system."), $f_user_name), HORDE_ERROR);
         } else {
             Horde::raiseMessage(sprintf(_("Successfully removed '%s' from the system."), $f_user_name), HORDE_SUCCESS);
         }
     }
     break;
     
}


$title = _("Horde User Administration");
require $registry->getTemplatePath() . '/common-header.inc';
require HORDE_BASE . '/status.php';

// Add users.
if ($auth->hasCapability('add')) {
    include $registry->getTemplatePath() . '/admin/user/add.inc';
} else {
    include $registry->getTemplatePath() . '/admin/user/noadd.inc';
}

// List users.
if ($auth->hasCapability('list')) {
    $users = $auth->listUsers();
    include $registry->getTemplatePath() . '/admin/user/list.inc';
} else {
    include $registry->getTemplatePath() . '/admin/user/nolist.inc';
}

require $registry->getTemplatePath() . '/common-footer.inc';

?>
